/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.jdbc;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.prestosql.plugin.jdbc.BooleanReadFunction;
import io.prestosql.plugin.jdbc.BooleanWriteFunction;
import io.prestosql.plugin.jdbc.DoubleReadFunction;
import io.prestosql.plugin.jdbc.DoubleWriteFunction;
import io.prestosql.plugin.jdbc.LongReadFunction;
import io.prestosql.plugin.jdbc.LongWriteFunction;
import io.prestosql.plugin.jdbc.ReadFunction;
import io.prestosql.plugin.jdbc.SliceReadFunction;
import io.prestosql.plugin.jdbc.SliceWriteFunction;
import io.prestosql.plugin.jdbc.WriteFunction;
import io.prestosql.spi.predicate.Domain;
import io.prestosql.spi.type.Type;
import java.util.Objects;
import java.util.function.UnaryOperator;

public final class ColumnMapping {
    public static final UnaryOperator<Domain> DISABLE_PUSHDOWN = domain -> Domain.all((Type)domain.getType());
    private final Type type;
    private final ReadFunction readFunction;
    private final WriteFunction writeFunction;
    private final UnaryOperator<Domain> pushdownConverter;

    public static ColumnMapping booleanMapping(Type prestoType, BooleanReadFunction readFunction, BooleanWriteFunction writeFunction) {
        return ColumnMapping.booleanMapping(prestoType, readFunction, writeFunction, UnaryOperator.identity());
    }

    public static ColumnMapping booleanMapping(Type prestoType, BooleanReadFunction readFunction, BooleanWriteFunction writeFunction, UnaryOperator<Domain> pushdownConverter) {
        return new ColumnMapping(prestoType, readFunction, writeFunction, pushdownConverter);
    }

    public static ColumnMapping longMapping(Type prestoType, LongReadFunction readFunction, LongWriteFunction writeFunction) {
        return ColumnMapping.longMapping(prestoType, readFunction, writeFunction, UnaryOperator.identity());
    }

    public static ColumnMapping longMapping(Type prestoType, LongReadFunction readFunction, LongWriteFunction writeFunction, UnaryOperator<Domain> pushdownConverter) {
        return new ColumnMapping(prestoType, readFunction, writeFunction, pushdownConverter);
    }

    public static ColumnMapping doubleMapping(Type prestoType, DoubleReadFunction readFunction, DoubleWriteFunction writeFunction) {
        return ColumnMapping.doubleMapping(prestoType, readFunction, writeFunction, UnaryOperator.identity());
    }

    public static ColumnMapping doubleMapping(Type prestoType, DoubleReadFunction readFunction, DoubleWriteFunction writeFunction, UnaryOperator<Domain> pushdownConverter) {
        return new ColumnMapping(prestoType, readFunction, writeFunction, pushdownConverter);
    }

    public static ColumnMapping sliceMapping(Type prestoType, SliceReadFunction readFunction, SliceWriteFunction writeFunction) {
        return ColumnMapping.sliceMapping(prestoType, readFunction, writeFunction, UnaryOperator.identity());
    }

    public static ColumnMapping sliceMapping(Type prestoType, SliceReadFunction readFunction, SliceWriteFunction writeFunction, UnaryOperator<Domain> pushdownConverter) {
        return new ColumnMapping(prestoType, readFunction, writeFunction, pushdownConverter);
    }

    private ColumnMapping(Type type, ReadFunction readFunction, WriteFunction writeFunction, UnaryOperator<Domain> pushdownConverter) {
        this.type = Objects.requireNonNull(type, "type is null");
        this.readFunction = Objects.requireNonNull(readFunction, "readFunction is null");
        this.writeFunction = Objects.requireNonNull(writeFunction, "writeFunction is null");
        Preconditions.checkArgument((type.getJavaType() == readFunction.getJavaType() ? 1 : 0) != 0, (String)"Presto type %s is not compatible with read function %s returning %s", (Object)type, (Object)readFunction, readFunction.getJavaType());
        Preconditions.checkArgument((type.getJavaType() == writeFunction.getJavaType() ? 1 : 0) != 0, (String)"Presto type %s is not compatible with write function %s accepting %s", (Object)type, (Object)writeFunction, writeFunction.getJavaType());
        this.pushdownConverter = Objects.requireNonNull(pushdownConverter, "pushdownConverter is null");
    }

    public Type getType() {
        return this.type;
    }

    public ReadFunction getReadFunction() {
        return this.readFunction;
    }

    public WriteFunction getWriteFunction() {
        return this.writeFunction;
    }

    public UnaryOperator<Domain> getPushdownConverter() {
        return this.pushdownConverter;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("type", (Object)this.type).toString();
    }
}

