/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.jdbc;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import io.prestosql.plugin.jdbc.JdbcTypeHandle;
import io.prestosql.spi.connector.ColumnHandle;
import io.prestosql.spi.connector.ColumnMetadata;
import io.prestosql.spi.type.Type;
import java.util.Objects;

public final class JdbcColumnHandle
implements ColumnHandle {
    private final String columnName;
    private final JdbcTypeHandle jdbcTypeHandle;
    private final Type columnType;

    @JsonCreator
    public JdbcColumnHandle(@JsonProperty(value="columnName") String columnName, @JsonProperty(value="jdbcTypeHandle") JdbcTypeHandle jdbcTypeHandle, @JsonProperty(value="columnType") Type columnType) {
        this.columnName = Objects.requireNonNull(columnName, "columnName is null");
        this.jdbcTypeHandle = Objects.requireNonNull(jdbcTypeHandle, "jdbcTypeHandle is null");
        this.columnType = Objects.requireNonNull(columnType, "columnType is null");
    }

    @JsonProperty
    public String getColumnName() {
        return this.columnName;
    }

    @JsonProperty
    public JdbcTypeHandle getJdbcTypeHandle() {
        return this.jdbcTypeHandle;
    }

    @JsonProperty
    public Type getColumnType() {
        return this.columnType;
    }

    public ColumnMetadata getColumnMetadata() {
        return new ColumnMetadata(this.columnName, this.columnType);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        JdbcColumnHandle o = (JdbcColumnHandle)obj;
        return Objects.equals(this.columnName, o.columnName);
    }

    public int hashCode() {
        return Objects.hash(this.columnName);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("columnName", (Object)this.columnName).add("jdbcTypeHandle", (Object)this.jdbcTypeHandle).add("columnType", (Object)this.columnType).toString();
    }
}

