/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.jdbc;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import io.prestosql.spi.HostAddress;
import io.prestosql.spi.connector.ColumnHandle;
import io.prestosql.spi.connector.ConnectorSplit;
import io.prestosql.spi.predicate.TupleDomain;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

public class JdbcSplit
implements ConnectorSplit {
    private final String catalogName;
    private final String schemaName;
    private final String tableName;
    private final TupleDomain<ColumnHandle> tupleDomain;
    private final Optional<String> additionalPredicate;

    @JsonCreator
    public JdbcSplit(@JsonProperty(value="catalogName") @Nullable String catalogName, @JsonProperty(value="schemaName") @Nullable String schemaName, @JsonProperty(value="tableName") String tableName, @JsonProperty(value="tupleDomain") TupleDomain<ColumnHandle> tupleDomain, @JsonProperty(value="additionalPredicate") Optional<String> additionalPredicate) {
        this.catalogName = catalogName;
        this.schemaName = schemaName;
        this.tableName = Objects.requireNonNull(tableName, "table name is null");
        this.tupleDomain = Objects.requireNonNull(tupleDomain, "tupleDomain is null");
        this.additionalPredicate = Objects.requireNonNull(additionalPredicate, "additionalPredicate is null");
    }

    @JsonProperty
    @Nullable
    public String getCatalogName() {
        return this.catalogName;
    }

    @JsonProperty
    @Nullable
    public String getSchemaName() {
        return this.schemaName;
    }

    @JsonProperty
    public String getTableName() {
        return this.tableName;
    }

    @JsonProperty
    public TupleDomain<ColumnHandle> getTupleDomain() {
        return this.tupleDomain;
    }

    @JsonProperty
    public Optional<String> getAdditionalPredicate() {
        return this.additionalPredicate;
    }

    public boolean isRemotelyAccessible() {
        return true;
    }

    public List<HostAddress> getAddresses() {
        return ImmutableList.of();
    }

    public Object getInfo() {
        return this;
    }
}

