/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.jdbc;

import io.prestosql.plugin.jdbc.JdbcClient;
import io.prestosql.plugin.jdbc.JdbcIdentity;
import io.prestosql.plugin.jdbc.JdbcTableLayoutHandle;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.connector.ConnectorSplitManager;
import io.prestosql.spi.connector.ConnectorSplitSource;
import io.prestosql.spi.connector.ConnectorTableLayoutHandle;
import io.prestosql.spi.connector.ConnectorTransactionHandle;
import java.util.Objects;
import javax.inject.Inject;

public class JdbcSplitManager
implements ConnectorSplitManager {
    private final JdbcClient jdbcClient;

    @Inject
    public JdbcSplitManager(JdbcClient jdbcClient) {
        this.jdbcClient = Objects.requireNonNull(jdbcClient, "client is null");
    }

    public ConnectorSplitSource getSplits(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorTableLayoutHandle layout, ConnectorSplitManager.SplitSchedulingStrategy splitSchedulingStrategy) {
        JdbcTableLayoutHandle layoutHandle = (JdbcTableLayoutHandle)layout;
        return this.jdbcClient.getSplits(JdbcIdentity.from(session), layoutHandle);
    }
}

