/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.sqlserver;

import io.airlift.tpch.TpchTable;
import io.prestosql.plugin.sqlserver.SqlServerQueryRunner;
import io.prestosql.plugin.sqlserver.TestingSqlServer;
import io.prestosql.tests.AbstractTestIntegrationSmokeTest;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

@Test
public class TestSqlServerIntegrationSmokeTest
extends AbstractTestIntegrationSmokeTest {
    private final TestingSqlServer sqlServer;

    public TestSqlServerIntegrationSmokeTest() {
        this(new TestingSqlServer());
    }

    public TestSqlServerIntegrationSmokeTest(TestingSqlServer testingSqlServer) {
        super(() -> SqlServerQueryRunner.createSqlServerQueryRunner(testingSqlServer, TpchTable.ORDERS));
        this.sqlServer = testingSqlServer;
    }

    @AfterClass(alwaysRun=true)
    public final void destroy() {
        this.sqlServer.close();
    }

    @Test
    public void testView() {
        this.sqlServer.execute("CREATE VIEW test_view AS SELECT * FROM orders");
        Assert.assertTrue((boolean)this.getQueryRunner().tableExists(this.getSession(), "test_view"));
        this.assertQuery("SELECT orderkey FROM test_view", "SELECT orderkey FROM orders");
        this.sqlServer.execute("DROP VIEW IF EXISTS test_view");
    }

    @Test
    public void testDecimalPredicatePushdown() throws Exception {
        try (AutoCloseable ignoreTable = this.withTable("test_decimal_pushdown", "(short_decimal decimal(9, 3), long_decimal decimal(30, 10))");){
            this.sqlServer.execute("INSERT INTO test_decimal_pushdown VALUES (123.321, 123456789.987654321)");
            this.assertQuery("SELECT * FROM test_decimal_pushdown WHERE short_decimal = 123.321", "VALUES (123.321, 123456789.987654321)");
            this.assertQuery("SELECT * FROM test_decimal_pushdown WHERE long_decimal = 123456789.987654321", "VALUES (123.321, 123456789.987654321)");
        }
    }

    private AutoCloseable withTable(String tableName, String tableDefinition) {
        this.sqlServer.execute(String.format("CREATE TABLE %s %s", tableName, tableDefinition));
        return () -> this.sqlServer.execute("DROP TABLE " + tableName);
    }
}

