/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.sqlserver;

import com.google.common.collect.ImmutableMap;
import io.prestosql.testing.docker.DockerContainer;
import java.io.Closeable;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.Statement;
import java.util.Map;

public final class TestingSqlServer
implements Closeable {
    private static final int SQL_SERVER_PORT = 1433;
    public static final String USER = "sa";
    public static final String PASSWORD = "SQLServerPass1";
    private final DockerContainer dockerContainer = DockerContainer.forImage((String)"microsoft/mssql-server-linux:2017-CU13").setPorts(new int[]{1433}).setEnvironment((Map)ImmutableMap.of((Object)"ACCEPT_EULA", (Object)"Y", (Object)"SA_PASSWORD", (Object)"SQLServerPass1")).setHealthCheck(portProvider -> TestingSqlServer.execute(portProvider, "SELECT 1")).start();

    public void execute(String sql) {
        TestingSqlServer.execute(arg_0 -> ((DockerContainer)this.dockerContainer).getHostPort(arg_0), sql);
    }

    private static void execute(DockerContainer.HostPortProvider hostPortProvider, String sql) {
        String jdbcUrl = TestingSqlServer.getJdbcUrl(hostPortProvider.getHostPort(1433));
        try (Connection conn = DriverManager.getConnection(jdbcUrl, USER, PASSWORD);
             Statement stmt = conn.createStatement();){
            stmt.execute(sql);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to execute statement: " + sql, e);
        }
    }

    public String getJdbcUrl() {
        return TestingSqlServer.getJdbcUrl(this.dockerContainer.getHostPort(1433));
    }

    private static String getJdbcUrl(int port) {
        return String.format("jdbc:sqlserver://localhost:%s", port);
    }

    @Override
    public void close() {
        this.dockerContainer.close();
    }
}

