/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.jdbc;

import io.airlift.configuration.Config;
import io.prestosql.plugin.jdbc.credential.CredentialProviderType;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;

public class BaseJdbcAuthenticationConfig {
    private String userCredentialName;
    private String passwordCredentialName;
    private CredentialProviderType credentialProviderType = CredentialProviderType.INLINE;

    @Nullable
    public String getUserCredentialName() {
        return this.userCredentialName;
    }

    @Config(value="user-credential-name")
    public BaseJdbcAuthenticationConfig setUserCredentialName(String userCredentialName) {
        this.userCredentialName = userCredentialName;
        return this;
    }

    @Nullable
    public String getPasswordCredentialName() {
        return this.passwordCredentialName;
    }

    @Config(value="password-credential-name")
    public BaseJdbcAuthenticationConfig setPasswordCredentialName(String passwordCredentialName) {
        this.passwordCredentialName = passwordCredentialName;
        return this;
    }

    @NotNull
    public CredentialProviderType getCredentialProviderType() {
        return this.credentialProviderType;
    }

    @Config(value="credential-provider.type")
    public BaseJdbcAuthenticationConfig setCredentialProviderType(CredentialProviderType credentialProviderType) {
        this.credentialProviderType = Objects.requireNonNull(credentialProviderType, "credentialProviderType is null");
        return this;
    }
}

