/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.jdbc.credential;

import io.prestosql.plugin.jdbc.JdbcIdentity;
import io.prestosql.plugin.jdbc.credential.CredentialConfig;
import io.prestosql.plugin.jdbc.credential.CredentialProvider;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;

public class ConfigFileBasedCredentialProvider
implements CredentialProvider {
    private final Optional<String> connectionUser;
    private final Optional<String> connectionPassword;

    @Inject
    public ConfigFileBasedCredentialProvider(CredentialConfig credentialsConfig) {
        Objects.requireNonNull(credentialsConfig, "credentialsConfig is null");
        this.connectionUser = credentialsConfig.getConnectionUser();
        this.connectionPassword = credentialsConfig.getConnectionPassword();
    }

    @Override
    public Optional<String> getConnectionUser(Optional<JdbcIdentity> jdbcIdentity) {
        return this.connectionUser;
    }

    @Override
    public Optional<String> getConnectionPassword(Optional<JdbcIdentity> jdbcIdentity) {
        return this.connectionPassword;
    }
}

