/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.jdbc.credential;

import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Scopes;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.airlift.configuration.ConditionalModule;
import io.airlift.configuration.ConfigBinder;
import io.airlift.configuration.ConfigurationFactory;
import io.airlift.configuration.ConfigurationLoader;
import io.prestosql.plugin.jdbc.BaseJdbcAuthenticationConfig;
import io.prestosql.plugin.jdbc.credential.ConfigFileBasedCredentialProvider;
import io.prestosql.plugin.jdbc.credential.CredentialConfig;
import io.prestosql.plugin.jdbc.credential.CredentialProvider;
import io.prestosql.plugin.jdbc.credential.CredentialProviderType;
import io.prestosql.plugin.jdbc.credential.ExtraCredentialProvider;
import io.prestosql.plugin.jdbc.credential.ForExtraCredentialProvider;
import io.prestosql.plugin.jdbc.credential.file.ConfigFileBasedCredentialProviderConfig;
import io.prestosql.plugin.jdbc.credential.keystore.KeyStoreBasedCredentialProviderConfig;
import io.prestosql.plugin.jdbc.credential.keystore.KeyStoreUtils;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableEntryException;
import java.security.cert.CertificateException;
import java.security.spec.InvalidKeySpecException;
import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Provider;

public class CredentialProviderModule
extends AbstractConfigurationAwareModule {
    protected void setup(Binder binder) {
        ConfigBinder.configBinder((Binder)binder).bindConfig(BaseJdbcAuthenticationConfig.class);
        this.bindCredentialProviderModule(CredentialProviderType.INLINE, internalBinder -> {
            ConfigBinder.configBinder((Binder)internalBinder).bindConfig(CredentialConfig.class);
            internalBinder.bind(CredentialProvider.class).annotatedWith(ForExtraCredentialProvider.class).to(ConfigFileBasedCredentialProvider.class).in(Scopes.SINGLETON);
        });
        this.bindCredentialProviderModule(CredentialProviderType.FILE, internalBinder -> {
            ConfigBinder.configBinder((Binder)binder).bindConfig(ConfigFileBasedCredentialProviderConfig.class);
            internalBinder.bind(CredentialProvider.class).annotatedWith(ForExtraCredentialProvider.class).toProvider(ConfigFileBasedCredentialProviderFactory.class).in(Scopes.SINGLETON);
        });
        this.bindCredentialProviderModule(CredentialProviderType.KEYSTORE, internalBinder -> {
            ConfigBinder.configBinder((Binder)binder).bindConfig(KeyStoreBasedCredentialProviderConfig.class);
            internalBinder.bind(CredentialProvider.class).annotatedWith(ForExtraCredentialProvider.class).toProvider(KeyStoreBasedCredentialProviderFactory.class);
        });
        binder.bind(CredentialProvider.class).to(ExtraCredentialProvider.class).in(Scopes.SINGLETON);
    }

    private void bindCredentialProviderModule(CredentialProviderType name, Module module) {
        this.install(ConditionalModule.installModuleIf(BaseJdbcAuthenticationConfig.class, config -> name.equals((Object)config.getCredentialProviderType()), (Module)module));
    }

    private static class KeyStoreBasedCredentialProviderFactory
    implements Provider<CredentialProvider> {
        private final CredentialConfig credentialsConfig;

        @Inject
        public KeyStoreBasedCredentialProviderFactory(KeyStoreBasedCredentialProviderConfig config) throws IOException, CertificateException, NoSuchAlgorithmException, KeyStoreException, InvalidKeySpecException, UnrecoverableEntryException {
            Objects.requireNonNull(config, "config is null");
            KeyStore keyStore = KeyStoreUtils.loadKeyStore(config.getKeyStoreType(), config.getKeyStoreFilePath(), config.getKeyStorePassword());
            this.credentialsConfig = new CredentialConfig().setConnectionUser(KeyStoreUtils.readEntity(keyStore, config.getUserCredentialName(), config.getPasswordForUserCredentialName())).setConnectionPassword(KeyStoreUtils.readEntity(keyStore, config.getPasswordCredentialName(), config.getPasswordForPasswordCredentialName()));
        }

        public CredentialProvider get() {
            return new ConfigFileBasedCredentialProvider(this.credentialsConfig);
        }
    }

    private static class ConfigFileBasedCredentialProviderFactory
    implements Provider<CredentialProvider> {
        private final CredentialConfig credentialsConfig;

        @Inject
        public ConfigFileBasedCredentialProviderFactory(ConfigFileBasedCredentialProviderConfig config) throws IOException {
            Objects.requireNonNull(config, "config is null");
            Map properties = ConfigurationLoader.loadPropertiesFrom((String)config.getCredentialFile());
            this.credentialsConfig = (CredentialConfig)new ConfigurationFactory(properties).build(CredentialConfig.class);
        }

        public CredentialProvider get() {
            return new ConfigFileBasedCredentialProvider(this.credentialsConfig);
        }
    }
}

