/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.jdbc.jmx;

import io.prestosql.plugin.jdbc.ColumnMapping;
import io.prestosql.plugin.jdbc.ForwardingJdbcClient;
import io.prestosql.plugin.jdbc.JdbcClient;
import io.prestosql.plugin.jdbc.JdbcColumnHandle;
import io.prestosql.plugin.jdbc.JdbcIdentity;
import io.prestosql.plugin.jdbc.JdbcOutputTableHandle;
import io.prestosql.plugin.jdbc.JdbcSplit;
import io.prestosql.plugin.jdbc.JdbcTableHandle;
import io.prestosql.plugin.jdbc.JdbcTypeHandle;
import io.prestosql.plugin.jdbc.WriteMapping;
import io.prestosql.plugin.jdbc.jmx.JdbcApiStats;
import io.prestosql.spi.connector.ColumnHandle;
import io.prestosql.spi.connector.ColumnMetadata;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.connector.ConnectorSplitSource;
import io.prestosql.spi.connector.ConnectorTableMetadata;
import io.prestosql.spi.connector.SchemaTableName;
import io.prestosql.spi.predicate.TupleDomain;
import io.prestosql.spi.statistics.TableStatistics;
import io.prestosql.spi.type.Type;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.weakref.jmx.Flatten;
import org.weakref.jmx.Managed;
import org.weakref.jmx.Nested;

public class StatisticsAwareJdbcClient
extends ForwardingJdbcClient {
    private final JdbcClientStats stats = new JdbcClientStats();
    private final JdbcClient delegate;

    public StatisticsAwareJdbcClient(JdbcClient delegate) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
    }

    @Override
    protected JdbcClient getDelegate() {
        return this.delegate;
    }

    @Managed
    @Flatten
    public JdbcClientStats getStats() {
        return this.stats;
    }

    @Override
    public boolean schemaExists(JdbcIdentity identity, String schema) {
        return this.stats.schemaExists.wrap(() -> this.getDelegate().schemaExists(identity, schema));
    }

    @Override
    public Set<String> getSchemaNames(JdbcIdentity identity) {
        return this.stats.getSchemaNames.wrap(() -> this.getDelegate().getSchemaNames(identity));
    }

    @Override
    public List<SchemaTableName> getTableNames(JdbcIdentity identity, Optional<String> schema) {
        return this.stats.getTableNames.wrap(() -> this.getDelegate().getTableNames(identity, schema));
    }

    @Override
    public Optional<JdbcTableHandle> getTableHandle(JdbcIdentity identity, SchemaTableName schemaTableName) {
        return this.stats.getTableHandle.wrap(() -> this.getDelegate().getTableHandle(identity, schemaTableName));
    }

    @Override
    public List<JdbcColumnHandle> getColumns(ConnectorSession session, JdbcTableHandle tableHandle) {
        return this.stats.getColumns.wrap(() -> this.getDelegate().getColumns(session, tableHandle));
    }

    @Override
    public Optional<ColumnMapping> toPrestoType(ConnectorSession session, Connection connection, JdbcTypeHandle typeHandle) {
        return this.stats.toPrestoType.wrap(() -> this.getDelegate().toPrestoType(session, connection, typeHandle));
    }

    @Override
    public WriteMapping toWriteMapping(ConnectorSession session, Type type) {
        return this.stats.toWriteMapping.wrap(() -> this.getDelegate().toWriteMapping(session, type));
    }

    @Override
    public ConnectorSplitSource getSplits(JdbcIdentity identity, JdbcTableHandle layoutHandle) {
        return this.stats.getSplits.wrap(() -> this.getDelegate().getSplits(identity, layoutHandle));
    }

    @Override
    public Connection getConnection(JdbcIdentity identity, JdbcSplit split) throws SQLException {
        return this.stats.getConnectionWithSplit.wrap(() -> this.getDelegate().getConnection(identity, split));
    }

    @Override
    public void abortReadConnection(Connection connection) throws SQLException {
        this.stats.abortReadConnection.wrap(() -> this.getDelegate().abortReadConnection(connection));
    }

    @Override
    public PreparedStatement buildSql(ConnectorSession session, Connection connection, JdbcSplit split, JdbcTableHandle tableHandle, List<JdbcColumnHandle> columnHandles) throws SQLException {
        return this.stats.buildSql.wrap(() -> this.getDelegate().buildSql(session, connection, split, tableHandle, columnHandles));
    }

    @Override
    public void addColumn(ConnectorSession session, JdbcTableHandle handle, ColumnMetadata column) {
        this.stats.addColumn.wrap(() -> this.getDelegate().addColumn(session, handle, column));
    }

    @Override
    public void dropColumn(JdbcIdentity identity, JdbcTableHandle handle, JdbcColumnHandle column) {
        this.stats.dropColumn.wrap(() -> this.getDelegate().dropColumn(identity, handle, column));
    }

    @Override
    public void renameColumn(JdbcIdentity identity, JdbcTableHandle handle, JdbcColumnHandle jdbcColumn, String newColumnName) {
        this.stats.renameColumn.wrap(() -> this.getDelegate().renameColumn(identity, handle, jdbcColumn, newColumnName));
    }

    @Override
    public void renameTable(JdbcIdentity identity, JdbcTableHandle handle, SchemaTableName newTableName) {
        this.stats.renameTable.wrap(() -> this.getDelegate().renameTable(identity, handle, newTableName));
    }

    @Override
    public void createTable(ConnectorSession session, ConnectorTableMetadata tableMetadata) {
        this.stats.createTable.wrap(() -> this.getDelegate().createTable(session, tableMetadata));
    }

    @Override
    public JdbcOutputTableHandle beginCreateTable(ConnectorSession session, ConnectorTableMetadata tableMetadata) {
        return this.stats.beginCreateTable.wrap(() -> this.getDelegate().beginCreateTable(session, tableMetadata));
    }

    @Override
    public void commitCreateTable(JdbcIdentity identity, JdbcOutputTableHandle handle) {
        this.stats.commitCreateTable.wrap(() -> this.getDelegate().commitCreateTable(identity, handle));
    }

    @Override
    public JdbcOutputTableHandle beginInsertTable(ConnectorSession session, JdbcTableHandle tableHandle) {
        return this.stats.beginInsertTable.wrap(() -> this.getDelegate().beginInsertTable(session, tableHandle));
    }

    @Override
    public void finishInsertTable(JdbcIdentity identity, JdbcOutputTableHandle handle) {
        this.stats.finishInsertTable.wrap(() -> this.getDelegate().finishInsertTable(identity, handle));
    }

    @Override
    public void dropTable(JdbcIdentity identity, JdbcTableHandle jdbcTableHandle) {
        this.stats.dropTable.wrap(() -> this.getDelegate().dropTable(identity, jdbcTableHandle));
    }

    @Override
    public void rollbackCreateTable(JdbcIdentity identity, JdbcOutputTableHandle handle) {
        this.stats.rollbackCreateTable.wrap(() -> this.getDelegate().rollbackCreateTable(identity, handle));
    }

    @Override
    public String buildInsertSql(JdbcOutputTableHandle handle) {
        return this.stats.buildInsertSql.wrap(() -> this.getDelegate().buildInsertSql(handle));
    }

    @Override
    public Connection getConnection(JdbcIdentity identity, JdbcOutputTableHandle handle) throws SQLException {
        return this.stats.getConnectionWithHandle.wrap(() -> this.getDelegate().getConnection(identity, handle));
    }

    @Override
    public PreparedStatement getPreparedStatement(Connection connection, String sql) throws SQLException {
        return this.stats.getPreparedStatement.wrap(() -> this.getDelegate().getPreparedStatement(connection, sql));
    }

    @Override
    public TableStatistics getTableStatistics(ConnectorSession session, JdbcTableHandle handle, TupleDomain<ColumnHandle> tupleDomain) {
        return this.stats.getTableStatistics.wrap(() -> this.getDelegate().getTableStatistics(session, handle, tupleDomain));
    }

    public static final class JdbcClientStats {
        private final JdbcApiStats schemaExists = new JdbcApiStats();
        private final JdbcApiStats getSchemaNames = new JdbcApiStats();
        private final JdbcApiStats getTableNames = new JdbcApiStats();
        private final JdbcApiStats getTableHandle = new JdbcApiStats();
        private final JdbcApiStats getColumns = new JdbcApiStats();
        private final JdbcApiStats toPrestoType = new JdbcApiStats();
        private final JdbcApiStats toWriteMapping = new JdbcApiStats();
        private final JdbcApiStats getSplits = new JdbcApiStats();
        private final JdbcApiStats getConnectionWithSplit = new JdbcApiStats();
        private final JdbcApiStats getConnectionWithHandle = new JdbcApiStats();
        private final JdbcApiStats abortReadConnection = new JdbcApiStats();
        private final JdbcApiStats buildSql = new JdbcApiStats();
        private final JdbcApiStats beginCreateTable = new JdbcApiStats();
        private final JdbcApiStats commitCreateTable = new JdbcApiStats();
        private final JdbcApiStats beginInsertTable = new JdbcApiStats();
        private final JdbcApiStats finishInsertTable = new JdbcApiStats();
        private final JdbcApiStats dropTable = new JdbcApiStats();
        private final JdbcApiStats rollbackCreateTable = new JdbcApiStats();
        private final JdbcApiStats buildInsertSql = new JdbcApiStats();
        private final JdbcApiStats getPreparedStatement = new JdbcApiStats();
        private final JdbcApiStats getTableStatistics = new JdbcApiStats();
        private final JdbcApiStats addColumn = new JdbcApiStats();
        private final JdbcApiStats dropColumn = new JdbcApiStats();
        private final JdbcApiStats renameColumn = new JdbcApiStats();
        private final JdbcApiStats renameTable = new JdbcApiStats();
        private final JdbcApiStats createTable = new JdbcApiStats();

        @Managed
        @Nested
        public JdbcApiStats getSchemaExists() {
            return this.schemaExists;
        }

        @Managed
        @Nested
        public JdbcApiStats getGetSchemaNames() {
            return this.getSchemaNames;
        }

        @Managed
        @Nested
        public JdbcApiStats getGetTableNames() {
            return this.getTableNames;
        }

        @Managed
        @Nested
        public JdbcApiStats getGetTableHandle() {
            return this.getTableHandle;
        }

        @Managed
        @Nested
        public JdbcApiStats getGetColumns() {
            return this.getColumns;
        }

        @Managed
        @Nested
        public JdbcApiStats getToPrestoType() {
            return this.toPrestoType;
        }

        @Managed
        @Nested
        public JdbcApiStats getToWriteMapping() {
            return this.toWriteMapping;
        }

        @Managed
        @Nested
        public JdbcApiStats getGetSplits() {
            return this.getSplits;
        }

        @Managed
        @Nested
        public JdbcApiStats getGetConnectionWithSplit() {
            return this.getConnectionWithSplit;
        }

        @Managed
        @Nested
        public JdbcApiStats getGetConnectionWithHandle() {
            return this.getConnectionWithHandle;
        }

        @Managed
        @Nested
        public JdbcApiStats getAbortReadConnection() {
            return this.abortReadConnection;
        }

        @Managed
        @Nested
        public JdbcApiStats getBuildSql() {
            return this.buildSql;
        }

        @Managed
        @Nested
        public JdbcApiStats getBeginCreateTable() {
            return this.beginCreateTable;
        }

        @Managed
        @Nested
        public JdbcApiStats getCommitCreateTable() {
            return this.commitCreateTable;
        }

        @Managed
        @Nested
        public JdbcApiStats getBeginInsertTable() {
            return this.beginInsertTable;
        }

        @Managed
        @Nested
        public JdbcApiStats getFinishInsertTable() {
            return this.finishInsertTable;
        }

        @Managed
        @Nested
        public JdbcApiStats getDropTable() {
            return this.dropTable;
        }

        @Managed
        @Nested
        public JdbcApiStats getRollbackCreateTable() {
            return this.rollbackCreateTable;
        }

        @Managed
        @Nested
        public JdbcApiStats getBuildInsertSql() {
            return this.buildInsertSql;
        }

        @Managed
        @Nested
        public JdbcApiStats getGetPreparedStatement() {
            return this.getPreparedStatement;
        }

        @Managed
        @Nested
        public JdbcApiStats getGetTableStatistics() {
            return this.getTableStatistics;
        }

        @Managed
        @Nested
        public JdbcApiStats getAddColumn() {
            return this.addColumn;
        }

        @Managed
        @Nested
        public JdbcApiStats getDropColumn() {
            return this.dropColumn;
        }

        @Managed
        @Nested
        public JdbcApiStats getRenameColumn() {
            return this.renameColumn;
        }

        @Managed
        @Nested
        public JdbcApiStats getRenameTable() {
            return this.renameTable;
        }

        @Managed
        @Nested
        public JdbcApiStats getCreateTable() {
            return this.createTable;
        }
    }
}

