/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.security.AccessController;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.validation.ValidationException;
import org.apache.bval.cdi.BValExtension;
import org.apache.bval.jsr.ParticipantFactory$newInstance$$Ljava_lang_Class$_ACTION;
import org.apache.bval.jsr.util.ToUnmodifiable;
import org.apache.bval.util.Validate;
import org.apache.commons.weaver.privilizer.Privileged;
import org.apache.commons.weaver.privilizer.Privilized;

@Privilized(value="DYNAMIC")
class ParticipantFactory
implements Closeable {
    private static final Logger log;
    private static final String META_INF_SERVICES = "META-INF/services/";
    private final Collection<BValExtension.Releasable<?>> releasables = new CopyOnWriteArrayList();
    private final List<ClassLoader> loaders;

    ParticipantFactory(ClassLoader ... loaders) {
        this.loaders = Arrays.asList(loaders).stream().filter(Objects::nonNull).collect(ToUnmodifiable.list());
        Validate.validState(!this.loaders.isEmpty(), "no classloaders available", new Object[0]);
    }

    @Override
    public void close() throws IOException {
        for (BValExtension.Releasable<?> releasable : this.releasables) {
            releasable.release();
        }
        this.releasables.clear();
    }

    <T> T create(String classname) {
        return this.newInstance(this.loadClass(classname));
    }

    <T> Set<T> loadServices(Class<T> type) {
        Validate.notNull(type);
        LinkedHashSet<URL> resources = new LinkedHashSet<URL>();
        String resourceName = META_INF_SERVICES + type.getName();
        for (ClassLoader loader : this.loaders) {
            try {
                Enumeration<URL> urls = loader.getResources(resourceName);
                while (urls.hasMoreElements()) {
                    resources.add(urls.nextElement());
                }
            }
            catch (IOException e) {
                log.log(Level.SEVERE, "Error searching for resource(s) " + resourceName, e);
            }
        }
        return resources.stream().map(this::read).flatMap(Collection::stream).map(this::create).collect(ToUnmodifiable.set());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Set<String> read(URL url) {
        try (BufferedReader r = new BufferedReader(new InputStreamReader(url.openStream()));){
            Set<String> set = r.lines().map(String::trim).filter(line -> line.charAt(0) != '#').collect(Collectors.toSet());
            return set;
        }
        catch (IOException e) {
            log.log(Level.SEVERE, "Unable to read resource " + url, e);
            return Collections.emptySet();
        }
    }

    private <T> Class<T> loadClass(String className) {
        for (ClassLoader loader : this.loaders) {
            try {
                return Class.forName(className, true, loader);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        throw new ValidationException("Unable to load class " + className);
    }

    @Privileged
    private <T> T newInstance(Class<T> clazz) {
        if (!(System.getSecurityManager() != null)) {
            return this.__privileged_newInstance(clazz);
        }
        return AccessController.doPrivileged(new ParticipantFactory$newInstance$$Ljava_lang_Class$_ACTION(this, clazz));
    }

    static /* synthetic */ Object __privileged_access$0(ParticipantFactory participantFactory, Class clazz) {
        return participantFactory.__privileged_newInstance(clazz);
    }

    private <T> T __privileged_newInstance(Class<T> cls) {
        try {
            BValExtension.Releasable<T> releasable = BValExtension.inject(cls);
            this.releasables.add(releasable);
            return releasable.getInstance();
        }
        catch (Exception | NoClassDefFoundError releasable) {
            try {
                return cls.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new ValidationException(e.getMessage(), (Throwable)e);
            }
        }
    }

    private static void __privileged_clinit0() {
        log = Logger.getLogger(ParticipantFactory.class.getName());
    }

    static {
        ParticipantFactory.__privileged_clinit0();
    }
}

