/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.jdbc;

import com.google.common.base.Preconditions;
import com.google.common.base.VerifyException;
import io.airlift.log.Logger;
import io.airlift.slice.Slice;
import io.prestosql.plugin.jdbc.BlockReadFunction;
import io.prestosql.plugin.jdbc.BooleanReadFunction;
import io.prestosql.plugin.jdbc.ColumnMapping;
import io.prestosql.plugin.jdbc.DoubleReadFunction;
import io.prestosql.plugin.jdbc.JdbcClient;
import io.prestosql.plugin.jdbc.JdbcColumnHandle;
import io.prestosql.plugin.jdbc.JdbcErrorCode;
import io.prestosql.plugin.jdbc.JdbcIdentity;
import io.prestosql.plugin.jdbc.JdbcSplit;
import io.prestosql.plugin.jdbc.JdbcTableHandle;
import io.prestosql.plugin.jdbc.LongReadFunction;
import io.prestosql.plugin.jdbc.ReadFunction;
import io.prestosql.plugin.jdbc.SliceReadFunction;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.connector.RecordCursor;
import io.prestosql.spi.type.Type;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Objects;

public class JdbcRecordCursor
implements RecordCursor {
    private static final Logger log = Logger.get(JdbcRecordCursor.class);
    private final JdbcColumnHandle[] columnHandles;
    private final BooleanReadFunction[] booleanReadFunctions;
    private final DoubleReadFunction[] doubleReadFunctions;
    private final LongReadFunction[] longReadFunctions;
    private final SliceReadFunction[] sliceReadFunctions;
    private final BlockReadFunction[] blockReadFunctions;
    private final JdbcClient jdbcClient;
    private final Connection connection;
    private final PreparedStatement statement;
    private final ResultSet resultSet;
    private boolean closed;

    public JdbcRecordCursor(JdbcClient jdbcClient, ConnectorSession session, JdbcSplit split, JdbcTableHandle table, List<JdbcColumnHandle> columnHandles) {
        this.jdbcClient = Objects.requireNonNull(jdbcClient, "jdbcClient is null");
        this.columnHandles = columnHandles.toArray(new JdbcColumnHandle[0]);
        this.booleanReadFunctions = new BooleanReadFunction[columnHandles.size()];
        this.doubleReadFunctions = new DoubleReadFunction[columnHandles.size()];
        this.longReadFunctions = new LongReadFunction[columnHandles.size()];
        this.sliceReadFunctions = new SliceReadFunction[columnHandles.size()];
        this.blockReadFunctions = new BlockReadFunction[columnHandles.size()];
        try {
            this.connection = jdbcClient.getConnection(JdbcIdentity.from(session), split);
            for (int i = 0; i < this.columnHandles.length; ++i) {
                ColumnMapping columnMapping = jdbcClient.toPrestoType(session, this.connection, columnHandles.get(i).getJdbcTypeHandle()).orElseThrow(() -> new VerifyException("Unsupported column type"));
                Class javaType = columnMapping.getType().getJavaType();
                ReadFunction readFunction = columnMapping.getReadFunction();
                if (javaType == Boolean.TYPE) {
                    this.booleanReadFunctions[i] = (BooleanReadFunction)readFunction;
                    continue;
                }
                if (javaType == Double.TYPE) {
                    this.doubleReadFunctions[i] = (DoubleReadFunction)readFunction;
                    continue;
                }
                if (javaType == Long.TYPE) {
                    this.longReadFunctions[i] = (LongReadFunction)readFunction;
                    continue;
                }
                if (javaType == Slice.class) {
                    this.sliceReadFunctions[i] = (SliceReadFunction)readFunction;
                    continue;
                }
                if (javaType == Block.class) {
                    this.blockReadFunctions[i] = (BlockReadFunction)readFunction;
                    continue;
                }
                throw new IllegalStateException(String.format("Unsupported java type %s", javaType));
            }
            this.statement = jdbcClient.buildSql(session, this.connection, split, table, columnHandles);
            log.debug("Executing: %s", new Object[]{this.statement.toString()});
            this.resultSet = this.statement.executeQuery();
        }
        catch (RuntimeException | SQLException e) {
            throw this.handleSqlException(e);
        }
    }

    public long getReadTimeNanos() {
        return 0L;
    }

    public long getCompletedBytes() {
        return 0L;
    }

    public Type getType(int field) {
        return this.columnHandles[field].getColumnType();
    }

    public boolean advanceNextPosition() {
        if (this.closed) {
            return false;
        }
        try {
            return this.resultSet.next();
        }
        catch (RuntimeException | SQLException e) {
            throw this.handleSqlException(e);
        }
    }

    public boolean getBoolean(int field) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"cursor is closed");
        try {
            return this.booleanReadFunctions[field].readBoolean(this.resultSet, field + 1);
        }
        catch (RuntimeException | SQLException e) {
            throw this.handleSqlException(e);
        }
    }

    public long getLong(int field) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"cursor is closed");
        try {
            return this.longReadFunctions[field].readLong(this.resultSet, field + 1);
        }
        catch (RuntimeException | SQLException e) {
            throw this.handleSqlException(e);
        }
    }

    public double getDouble(int field) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"cursor is closed");
        try {
            return this.doubleReadFunctions[field].readDouble(this.resultSet, field + 1);
        }
        catch (RuntimeException | SQLException e) {
            throw this.handleSqlException(e);
        }
    }

    public Slice getSlice(int field) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"cursor is closed");
        try {
            return this.sliceReadFunctions[field].readSlice(this.resultSet, field + 1);
        }
        catch (RuntimeException | SQLException e) {
            throw this.handleSqlException(e);
        }
    }

    public Object getObject(int field) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"cursor is closed");
        try {
            return this.blockReadFunctions[field].readBlock(this.resultSet, field + 1);
        }
        catch (RuntimeException | SQLException e) {
            throw this.handleSqlException(e);
        }
    }

    public boolean isNull(int field) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"cursor is closed");
        Preconditions.checkArgument((field < this.columnHandles.length ? 1 : 0) != 0, (Object)"Invalid field index");
        try {
            this.resultSet.getObject(field + 1);
            return this.resultSet.wasNull();
        }
        catch (RuntimeException | SQLException e) {
            throw this.handleSqlException(e);
        }
    }

    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        try (Connection connection = this.connection;
             PreparedStatement statement = this.statement;
             ResultSet resultSet = this.resultSet;){
            if (connection != null) {
                this.jdbcClient.abortReadConnection(connection);
            }
        }
        catch (RuntimeException | SQLException exception) {
            // empty catch block
        }
    }

    private RuntimeException handleSqlException(Exception e) {
        block2: {
            try {
                this.close();
            }
            catch (Exception closeException) {
                if (e == closeException) break block2;
                e.addSuppressed(closeException);
            }
        }
        return new PrestoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
    }
}

