/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.jdbc;

import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Shorts;
import com.google.common.primitives.SignedBytes;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.prestosql.plugin.jdbc.BooleanWriteFunction;
import io.prestosql.plugin.jdbc.ColumnMapping;
import io.prestosql.plugin.jdbc.DoubleWriteFunction;
import io.prestosql.plugin.jdbc.JdbcTypeHandle;
import io.prestosql.plugin.jdbc.LongReadFunction;
import io.prestosql.plugin.jdbc.LongWriteFunction;
import io.prestosql.plugin.jdbc.SliceReadFunction;
import io.prestosql.plugin.jdbc.SliceWriteFunction;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.BooleanType;
import io.prestosql.spi.type.CharType;
import io.prestosql.spi.type.DateType;
import io.prestosql.spi.type.DecimalType;
import io.prestosql.spi.type.Decimals;
import io.prestosql.spi.type.DoubleType;
import io.prestosql.spi.type.IntegerType;
import io.prestosql.spi.type.RealType;
import io.prestosql.spi.type.SmallintType;
import io.prestosql.spi.type.TimeType;
import io.prestosql.spi.type.TimestampType;
import io.prestosql.spi.type.TinyintType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarbinaryType;
import io.prestosql.spi.type.VarcharType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.joda.time.DateTimeZone;
import org.joda.time.chrono.ISOChronology;

public final class StandardColumnMappings {
    private static final ISOChronology UTC_CHRONOLOGY = ISOChronology.getInstanceUTC();

    private StandardColumnMappings() {
    }

    public static ColumnMapping booleanColumnMapping() {
        return ColumnMapping.booleanMapping((Type)BooleanType.BOOLEAN, ResultSet::getBoolean, StandardColumnMappings.booleanWriteFunction());
    }

    public static BooleanWriteFunction booleanWriteFunction() {
        return PreparedStatement::setBoolean;
    }

    public static ColumnMapping tinyintColumnMapping() {
        return ColumnMapping.longMapping((Type)TinyintType.TINYINT, ResultSet::getByte, StandardColumnMappings.tinyintWriteFunction());
    }

    public static LongWriteFunction tinyintWriteFunction() {
        return (statement, index, value) -> statement.setByte(index, SignedBytes.checkedCast((long)value));
    }

    public static ColumnMapping smallintColumnMapping() {
        return ColumnMapping.longMapping((Type)SmallintType.SMALLINT, ResultSet::getShort, StandardColumnMappings.smallintWriteFunction());
    }

    public static LongWriteFunction smallintWriteFunction() {
        return (statement, index, value) -> statement.setShort(index, Shorts.checkedCast((long)value));
    }

    public static ColumnMapping integerColumnMapping() {
        return ColumnMapping.longMapping((Type)IntegerType.INTEGER, ResultSet::getInt, StandardColumnMappings.integerWriteFunction());
    }

    public static LongWriteFunction integerWriteFunction() {
        return (statement, index, value) -> statement.setInt(index, Math.toIntExact(value));
    }

    public static ColumnMapping bigintColumnMapping() {
        return ColumnMapping.longMapping((Type)BigintType.BIGINT, ResultSet::getLong, StandardColumnMappings.bigintWriteFunction());
    }

    public static LongWriteFunction bigintWriteFunction() {
        return PreparedStatement::setLong;
    }

    public static ColumnMapping realColumnMapping() {
        return ColumnMapping.longMapping((Type)RealType.REAL, (resultSet, columnIndex) -> Float.floatToRawIntBits(resultSet.getFloat(columnIndex)), StandardColumnMappings.realWriteFunction());
    }

    public static LongWriteFunction realWriteFunction() {
        return (statement, index, value) -> statement.setFloat(index, Float.intBitsToFloat(Math.toIntExact(value)));
    }

    public static ColumnMapping doubleColumnMapping() {
        return ColumnMapping.doubleMapping((Type)DoubleType.DOUBLE, ResultSet::getDouble, StandardColumnMappings.doubleWriteFunction());
    }

    public static DoubleWriteFunction doubleWriteFunction() {
        return PreparedStatement::setDouble;
    }

    public static ColumnMapping decimalColumnMapping(DecimalType decimalType) {
        int scale = decimalType.getScale();
        if (decimalType.isShort()) {
            return ColumnMapping.longMapping((Type)decimalType, (resultSet, columnIndex) -> Decimals.encodeShortScaledValue((BigDecimal)resultSet.getBigDecimal(columnIndex), (int)scale), StandardColumnMappings.shortDecimalWriteFunction(decimalType));
        }
        return ColumnMapping.sliceMapping((Type)decimalType, (resultSet, columnIndex) -> Decimals.encodeScaledValue((BigDecimal)resultSet.getBigDecimal(columnIndex), (int)scale), StandardColumnMappings.longDecimalWriteFunction(decimalType));
    }

    public static LongWriteFunction shortDecimalWriteFunction(DecimalType decimalType) {
        Objects.requireNonNull(decimalType, "decimalType is null");
        Preconditions.checkArgument((boolean)decimalType.isShort());
        return (statement, index, value) -> {
            BigInteger unscaledValue = BigInteger.valueOf(value);
            BigDecimal bigDecimal = new BigDecimal(unscaledValue, decimalType.getScale(), new MathContext(decimalType.getPrecision()));
            statement.setBigDecimal(index, bigDecimal);
        };
    }

    public static SliceWriteFunction longDecimalWriteFunction(DecimalType decimalType) {
        Objects.requireNonNull(decimalType, "decimalType is null");
        Preconditions.checkArgument((!decimalType.isShort() ? 1 : 0) != 0);
        return (statement, index, value) -> {
            BigInteger unscaledValue = Decimals.decodeUnscaledValue((Slice)value);
            BigDecimal bigDecimal = new BigDecimal(unscaledValue, decimalType.getScale(), new MathContext(decimalType.getPrecision()));
            statement.setBigDecimal(index, bigDecimal);
        };
    }

    public static ColumnMapping charColumnMapping(CharType charType) {
        Objects.requireNonNull(charType, "charType is null");
        return ColumnMapping.sliceMapping((Type)charType, (resultSet, columnIndex) -> Slices.utf8Slice((String)CharMatcher.is((char)' ').trimTrailingFrom((CharSequence)resultSet.getString(columnIndex))), StandardColumnMappings.charWriteFunction());
    }

    public static SliceWriteFunction charWriteFunction() {
        return (statement, index, value) -> statement.setString(index, value.toStringUtf8());
    }

    public static ColumnMapping varcharColumnMapping(VarcharType varcharType) {
        return ColumnMapping.sliceMapping((Type)varcharType, StandardColumnMappings.varcharReadFunction(), StandardColumnMappings.varcharWriteFunction());
    }

    public static SliceReadFunction varcharReadFunction() {
        return (resultSet, columnIndex) -> Slices.utf8Slice((String)resultSet.getString(columnIndex));
    }

    public static SliceWriteFunction varcharWriteFunction() {
        return (statement, index, value) -> statement.setString(index, value.toStringUtf8());
    }

    public static ColumnMapping varbinaryColumnMapping() {
        return ColumnMapping.sliceMapping((Type)VarbinaryType.VARBINARY, (resultSet, columnIndex) -> Slices.wrappedBuffer((byte[])resultSet.getBytes(columnIndex)), StandardColumnMappings.varbinaryWriteFunction(), ColumnMapping.DISABLE_PUSHDOWN);
    }

    public static SliceWriteFunction varbinaryWriteFunction() {
        return (statement, index, value) -> statement.setBytes(index, value.getBytes());
    }

    public static ColumnMapping dateColumnMapping() {
        return ColumnMapping.longMapping((Type)DateType.DATE, (resultSet, columnIndex) -> {
            long localMillis = resultSet.getDate(columnIndex).getTime();
            long utcMillis = ISOChronology.getInstance().getZone().getMillisKeepLocal(DateTimeZone.UTC, localMillis);
            return TimeUnit.MILLISECONDS.toDays(utcMillis);
        }, StandardColumnMappings.dateWriteFunction());
    }

    public static LongWriteFunction dateWriteFunction() {
        return (statement, index, value) -> {
            long millis = TimeUnit.DAYS.toMillis(value);
            statement.setDate(index, new Date(DateTimeZone.UTC.getMillisKeepLocal(DateTimeZone.getDefault(), millis)));
        };
    }

    public static ColumnMapping timeColumnMapping() {
        return ColumnMapping.longMapping((Type)TimeType.TIME, (resultSet, columnIndex) -> {
            Time time = resultSet.getTime(columnIndex);
            return UTC_CHRONOLOGY.millisOfDay().get(time.getTime());
        }, StandardColumnMappings.timeWriteFunction());
    }

    public static LongWriteFunction timeWriteFunction() {
        return (statement, index, value) -> statement.setTime(index, new Time(value));
    }

    @Deprecated
    public static ColumnMapping timestampColumnMappingUsingSqlTimestamp(ConnectorSession session) {
        if (session.isLegacyTimestamp()) {
            ZoneId sessionZone = ZoneId.of(session.getTimeZoneKey().getId());
            return ColumnMapping.longMapping((Type)TimestampType.TIMESTAMP, (resultSet, columnIndex) -> {
                Timestamp timestamp = resultSet.getTimestamp(columnIndex);
                return StandardColumnMappings.toPrestoLegacyTimestamp(timestamp.toLocalDateTime(), sessionZone);
            }, StandardColumnMappings.timestampWriteFunctionUsingSqlTimestamp(session));
        }
        return ColumnMapping.longMapping((Type)TimestampType.TIMESTAMP, (resultSet, columnIndex) -> {
            Timestamp timestamp = resultSet.getTimestamp(columnIndex);
            return StandardColumnMappings.toPrestoTimestamp(timestamp.toLocalDateTime());
        }, StandardColumnMappings.timestampWriteFunctionUsingSqlTimestamp(session));
    }

    public static ColumnMapping timestampColumnMapping(ConnectorSession session) {
        return ColumnMapping.longMapping((Type)TimestampType.TIMESTAMP, StandardColumnMappings.timestampReadFunction(session), StandardColumnMappings.timestampWriteFunction(session));
    }

    public static LongReadFunction timestampReadFunction(ConnectorSession session) {
        if (session.isLegacyTimestamp()) {
            ZoneId sessionZone = ZoneId.of(session.getTimeZoneKey().getId());
            return (resultSet, columnIndex) -> StandardColumnMappings.toPrestoLegacyTimestamp(resultSet.getObject(columnIndex, LocalDateTime.class), sessionZone);
        }
        return (resultSet, columnIndex) -> StandardColumnMappings.toPrestoTimestamp(resultSet.getObject(columnIndex, LocalDateTime.class));
    }

    @Deprecated
    public static LongWriteFunction timestampWriteFunctionUsingSqlTimestamp(ConnectorSession connectorSession) {
        if (connectorSession.isLegacyTimestamp()) {
            ZoneId sessionZone = ZoneId.of(connectorSession.getTimeZoneKey().getId());
            return (statement, index, value) -> statement.setTimestamp(index, Timestamp.valueOf(StandardColumnMappings.fromPrestoLegacyTimestamp(value, sessionZone)));
        }
        return (statement, index, value) -> statement.setTimestamp(index, Timestamp.valueOf(StandardColumnMappings.fromPrestoTimestamp(value)));
    }

    public static LongWriteFunction timestampWriteFunction(ConnectorSession session) {
        if (session.isLegacyTimestamp()) {
            ZoneId sessionZone = ZoneId.of(session.getTimeZoneKey().getId());
            return (statement, index, value) -> statement.setObject(index, StandardColumnMappings.fromPrestoLegacyTimestamp(value, sessionZone));
        }
        return (statement, index, value) -> statement.setObject(index, StandardColumnMappings.fromPrestoTimestamp(value));
    }

    @Deprecated
    public static long toPrestoLegacyTimestamp(LocalDateTime localDateTime, ZoneId sessionZone) {
        return localDateTime.atZone(sessionZone).toInstant().toEpochMilli();
    }

    public static long toPrestoTimestamp(LocalDateTime localDateTime) {
        return localDateTime.atZone(ZoneOffset.UTC).toInstant().toEpochMilli();
    }

    @Deprecated
    public static LocalDateTime fromPrestoLegacyTimestamp(long value, ZoneId sessionZone) {
        return Instant.ofEpochMilli(value).atZone(sessionZone).toLocalDateTime();
    }

    public static LocalDateTime fromPrestoTimestamp(long value) {
        return Instant.ofEpochMilli(value).atZone(ZoneOffset.UTC).toLocalDateTime();
    }

    public static Optional<ColumnMapping> jdbcTypeToPrestoType(ConnectorSession session, JdbcTypeHandle type) {
        int columnSize = type.getColumnSize();
        switch (type.getJdbcType()) {
            case -7: 
            case 16: {
                return Optional.of(StandardColumnMappings.booleanColumnMapping());
            }
            case -6: {
                return Optional.of(StandardColumnMappings.tinyintColumnMapping());
            }
            case 5: {
                return Optional.of(StandardColumnMappings.smallintColumnMapping());
            }
            case 4: {
                return Optional.of(StandardColumnMappings.integerColumnMapping());
            }
            case -5: {
                return Optional.of(StandardColumnMappings.bigintColumnMapping());
            }
            case 7: {
                return Optional.of(StandardColumnMappings.realColumnMapping());
            }
            case 6: 
            case 8: {
                return Optional.of(StandardColumnMappings.doubleColumnMapping());
            }
            case 2: 
            case 3: {
                int decimalDigits = type.getDecimalDigits();
                int precision = columnSize + Math.max(-decimalDigits, 0);
                if (precision > 38) {
                    return Optional.empty();
                }
                return Optional.of(StandardColumnMappings.decimalColumnMapping(DecimalType.createDecimalType((int)precision, (int)Math.max(decimalDigits, 0))));
            }
            case -15: 
            case 1: {
                int charLength = Math.min(columnSize, 65536);
                return Optional.of(StandardColumnMappings.charColumnMapping(CharType.createCharType((long)charLength)));
            }
            case -16: 
            case -9: 
            case -1: 
            case 12: {
                if (columnSize > 0x7FFFFFFE) {
                    return Optional.of(StandardColumnMappings.varcharColumnMapping(VarcharType.createUnboundedVarcharType()));
                }
                return Optional.of(StandardColumnMappings.varcharColumnMapping(VarcharType.createVarcharType((int)columnSize)));
            }
            case -4: 
            case -3: 
            case -2: {
                return Optional.of(StandardColumnMappings.varbinaryColumnMapping());
            }
            case 91: {
                return Optional.of(StandardColumnMappings.dateColumnMapping());
            }
            case 92: {
                return Optional.of(StandardColumnMappings.timeColumnMapping());
            }
            case 93: {
                return Optional.of(StandardColumnMappings.timestampColumnMappingUsingSqlTimestamp(session));
            }
        }
        return Optional.empty();
    }
}

