/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.jdbc.credential.keystore;

import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableEntryException;
import java.security.cert.CertificateException;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;

public class KeyStoreUtils {
    private KeyStoreUtils() {
    }

    public static KeyStore loadKeyStore(String keyStoreType, String keyStorePath, String keyStorePassword) throws KeyStoreException, IOException, CertificateException, NoSuchAlgorithmException {
        KeyStore keyStore = KeyStore.getInstance(keyStoreType);
        keyStore.load(new FileInputStream(keyStorePath), keyStorePassword.toCharArray());
        return keyStore;
    }

    public static String readEntity(KeyStore keyStore, String entityAlias, String entityPassword) throws UnrecoverableEntryException, NoSuchAlgorithmException, KeyStoreException, InvalidKeySpecException {
        KeyStore.SecretKeyEntry secretKeyEntry = (KeyStore.SecretKeyEntry)keyStore.getEntry(entityAlias, new KeyStore.PasswordProtection(entityPassword.toCharArray()));
        SecretKeyFactory factory = SecretKeyFactory.getInstance("PBE");
        PBEKeySpec keySpec = (PBEKeySpec)factory.getKeySpec(secretKeyEntry.getSecretKey(), PBEKeySpec.class);
        return new String(keySpec.getPassword());
    }
}

