/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.bootstrap;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedMap;
import com.google.inject.Binder;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Stage;
import io.airlift.bootstrap.ColumnPrinter;
import io.airlift.bootstrap.LifeCycleManager;
import io.airlift.bootstrap.LifeCycleModule;
import io.airlift.bootstrap.LoggingWriter;
import io.airlift.configuration.ConfigurationFactory;
import io.airlift.configuration.ConfigurationInspector;
import io.airlift.configuration.ConfigurationLoader;
import io.airlift.configuration.ConfigurationModule;
import io.airlift.configuration.ValidationErrorModule;
import io.airlift.configuration.WarningsMonitor;
import io.airlift.log.Logger;
import io.airlift.log.Logging;
import io.airlift.log.LoggingConfiguration;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UncheckedIOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class Bootstrap {
    private final Logger log = Logger.get((String)"Bootstrap");
    private final List<Module> modules;
    private Map<String, String> requiredConfigurationProperties;
    private Map<String, String> optionalConfigurationProperties;
    private boolean initializeLogging = true;
    private boolean quiet;
    private boolean strictConfig;
    private boolean requireExplicitBindings = true;
    private boolean initialized;

    public Bootstrap(Module ... modules) {
        this((Iterable<? extends Module>)ImmutableList.copyOf((Object[])modules));
    }

    public Bootstrap(Iterable<? extends Module> modules) {
        this.modules = ImmutableList.copyOf(modules);
    }

    @Beta
    public Bootstrap setRequiredConfigurationProperty(String key, String value) {
        if (this.requiredConfigurationProperties == null) {
            this.requiredConfigurationProperties = new TreeMap<String, String>();
        }
        this.requiredConfigurationProperties.put(key, value);
        return this;
    }

    @Beta
    public Bootstrap setRequiredConfigurationProperties(Map<String, String> requiredConfigurationProperties) {
        if (this.requiredConfigurationProperties == null) {
            this.requiredConfigurationProperties = new TreeMap<String, String>();
        }
        this.requiredConfigurationProperties.putAll(requiredConfigurationProperties);
        return this;
    }

    @Beta
    public Bootstrap setOptionalConfigurationProperty(String key, String value) {
        if (this.optionalConfigurationProperties == null) {
            this.optionalConfigurationProperties = new TreeMap<String, String>();
        }
        this.optionalConfigurationProperties.put(key, value);
        return this;
    }

    @Beta
    public Bootstrap setOptionalConfigurationProperties(Map<String, String> optionalConfigurationProperties) {
        if (this.optionalConfigurationProperties == null) {
            this.optionalConfigurationProperties = new TreeMap<String, String>();
        }
        this.optionalConfigurationProperties.putAll(optionalConfigurationProperties);
        return this;
    }

    @Beta
    public Bootstrap doNotInitializeLogging() {
        this.initializeLogging = false;
        return this;
    }

    public Bootstrap quiet() {
        this.quiet = true;
        return this;
    }

    public Bootstrap strictConfig() {
        this.strictConfig = true;
        return this;
    }

    public Bootstrap requireExplicitBindings(boolean requireExplicitBindings) {
        this.requireExplicitBindings = requireExplicitBindings;
        return this;
    }

    public Injector initialize() {
        Map requiredProperties;
        Preconditions.checkState((!this.initialized ? 1 : 0) != 0, (Object)"Already initialized");
        this.initialized = true;
        Logging logging = null;
        if (this.initializeLogging) {
            logging = Logging.initialize();
        }
        Thread.currentThread().setUncaughtExceptionHandler((thread, throwable) -> this.log.error(throwable, "Uncaught exception in thread %s", new Object[]{thread.getName()}));
        if (this.requiredConfigurationProperties == null) {
            this.log.info("Loading configuration");
            requiredProperties = Collections.emptyMap();
            String configFile = System.getProperty("config");
            if (configFile != null) {
                try {
                    requiredProperties = ConfigurationLoader.loadPropertiesFrom((String)configFile);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
        } else {
            requiredProperties = this.requiredConfigurationProperties;
        }
        ImmutableSortedMap properties = new TreeMap();
        if (this.optionalConfigurationProperties != null) {
            properties.putAll(this.optionalConfigurationProperties);
        }
        properties.putAll(requiredProperties);
        properties.putAll(ConfigurationLoader.getSystemProperties());
        properties = ImmutableSortedMap.copyOf(properties);
        ConfigurationFactory configurationFactory = new ConfigurationFactory((Map)properties, arg_0 -> ((Logger)this.log).warn(arg_0));
        if (logging != null) {
            this.log.info("Initializing logging");
            LoggingConfiguration configuration = (LoggingConfiguration)configurationFactory.build(LoggingConfiguration.class);
            logging.configure(configuration);
        }
        configurationFactory.registerConfigurationClasses(this.modules);
        List messages = configurationFactory.validateRegisteredConfigurationProvider();
        TreeMap<String, String> unusedProperties = new TreeMap<String, String>(requiredProperties);
        unusedProperties.keySet().removeAll(configurationFactory.getUsedProperties());
        if (!this.quiet) {
            this.logConfiguration(configurationFactory, unusedProperties);
        }
        ImmutableList.Builder moduleList = ImmutableList.builder();
        moduleList.add((Object)new LifeCycleModule());
        moduleList.add((Object)new ConfigurationModule(configurationFactory));
        if (!messages.isEmpty()) {
            moduleList.add((Object)new ValidationErrorModule(messages));
        }
        moduleList.add(binder -> binder.bind(WarningsMonitor.class).toInstance(arg_0 -> ((Logger)this.log).warn(arg_0)));
        moduleList.add(Binder::disableCircularProxies);
        if (this.requireExplicitBindings) {
            moduleList.add(Binder::requireExplicitBindings);
        }
        if (this.strictConfig) {
            moduleList.add(binder -> {
                for (Map.Entry unusedProperty : unusedProperties.entrySet()) {
                    binder.addError("Configuration property '%s' was not used", new Object[]{unusedProperty.getKey()});
                }
            });
        }
        moduleList.addAll(this.modules);
        Injector injector = Guice.createInjector((Stage)Stage.PRODUCTION, (Iterable)moduleList.build());
        LifeCycleManager lifeCycleManager = (LifeCycleManager)injector.getInstance(LifeCycleManager.class);
        if (lifeCycleManager.size() > 0) {
            lifeCycleManager.start();
        }
        return injector;
    }

    private void logConfiguration(ConfigurationFactory configurationFactory, Map<String, String> unusedProperties) {
        ColumnPrinter columnPrinter = Bootstrap.makePrinterForConfiguration(configurationFactory);
        try (PrintWriter out = new PrintWriter(new LoggingWriter(this.log));){
            columnPrinter.print(out);
        }
        if (!unusedProperties.isEmpty()) {
            this.log.warn("UNUSED PROPERTIES");
            for (String unusedProperty : unusedProperties.keySet()) {
                this.log.warn("%s", new Object[]{unusedProperty});
            }
            this.log.warn("");
        }
    }

    private static ColumnPrinter makePrinterForConfiguration(ConfigurationFactory configurationFactory) {
        ConfigurationInspector configurationInspector = new ConfigurationInspector();
        ColumnPrinter columnPrinter = new ColumnPrinter("PROPERTY", "DEFAULT", "RUNTIME", "DESCRIPTION");
        for (ConfigurationInspector.ConfigRecord record : configurationInspector.inspect(configurationFactory)) {
            for (ConfigurationInspector.ConfigAttribute attribute : record.getAttributes()) {
                columnPrinter.addValues(attribute.getPropertyName(), attribute.getDefaultValue(), attribute.getCurrentValue(), attribute.getDescription());
            }
        }
        return columnPrinter;
    }
}

