/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.sqlserver;

import com.google.common.collect.ImmutableMap;
import io.prestosql.plugin.sqlserver.SqlServerQueryRunner;
import io.prestosql.plugin.sqlserver.TestingSqlServer;
import io.prestosql.testing.AbstractTestDistributedQueries;
import io.prestosql.testing.QueryRunner;
import io.prestosql.testing.sql.TestTable;
import io.prestosql.tpch.TpchTable;
import java.util.Map;
import java.util.Optional;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

@Test
public class TestSqlServerDistributedQueries
extends AbstractTestDistributedQueries {
    private TestingSqlServer sqlServer;

    protected QueryRunner createQueryRunner() throws Exception {
        this.sqlServer = new TestingSqlServer();
        this.sqlServer.start();
        return SqlServerQueryRunner.createSqlServerQueryRunner(this.sqlServer, (Map<String, String>)ImmutableMap.of(), (Map<String, String>)ImmutableMap.builder().put((Object)"metadata.cache-ttl", (Object)"10m").put((Object)"metadata.cache-missing", (Object)"true").build(), TpchTable.getTables());
    }

    @AfterClass(alwaysRun=true)
    public final void destroy() {
        this.sqlServer.close();
        this.sqlServer = null;
    }

    protected boolean supportsDelete() {
        return false;
    }

    protected boolean supportsViews() {
        return false;
    }

    protected boolean supportsArrays() {
        return false;
    }

    protected boolean supportsCommentOnTable() {
        return false;
    }

    protected boolean supportsCommentOnColumn() {
        return false;
    }

    protected TestTable createTableWithDefaultColumns() {
        return new TestTable(this.sqlServer::execute, "table", "(col_required BIGINT NOT NULL,col_nullable BIGINT,col_default BIGINT DEFAULT 43,col_nonnull_default BIGINT NOT NULL DEFAULT 42,col_required2 BIGINT NOT NULL)");
    }

    protected Optional<AbstractTestDistributedQueries.DataMappingTestSetup> filterDataMappingSmokeTestData(AbstractTestDistributedQueries.DataMappingTestSetup dataMappingTestSetup) {
        String typeName = dataMappingTestSetup.getPrestoTypeName();
        if (typeName.equals("time") || typeName.equals("timestamp") || typeName.equals("timestamp(3) with time zone")) {
            return Optional.of(dataMappingTestSetup.asUnsupported());
        }
        if (typeName.equals("varbinary")) {
            return Optional.empty();
        }
        return Optional.of(dataMappingTestSetup);
    }
}

