/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.sqlserver;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.prestosql.Session;
import io.prestosql.plugin.sqlserver.DataCompression;
import io.prestosql.plugin.sqlserver.SqlServerQueryRunner;
import io.prestosql.plugin.sqlserver.TestingSqlServer;
import io.prestosql.sql.planner.plan.AggregationNode;
import io.prestosql.sql.planner.plan.ProjectNode;
import io.prestosql.sql.query.QueryAssertions;
import io.prestosql.testing.AbstractTestIntegrationSmokeTest;
import io.prestosql.testing.QueryRunner;
import io.prestosql.testing.sql.TestTable;
import io.prestosql.tpch.TpchTable;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test
public class TestSqlServerIntegrationSmokeTest
extends AbstractTestIntegrationSmokeTest {
    protected TestingSqlServer sqlServer;

    protected QueryRunner createQueryRunner() throws Exception {
        this.sqlServer = new TestingSqlServer();
        this.sqlServer.start();
        return SqlServerQueryRunner.createSqlServerQueryRunner(this.sqlServer, (Map<String, String>)ImmutableMap.of(), (Map<String, String>)ImmutableMap.of(), ImmutableList.of((Object)TpchTable.CUSTOMER, (Object)TpchTable.NATION, (Object)TpchTable.ORDERS, (Object)TpchTable.REGION));
    }

    @AfterClass(alwaysRun=true)
    public final void destroy() {
        this.sqlServer.close();
    }

    @Test
    public void testInsert() {
        this.sqlServer.execute("CREATE TABLE test_insert (x bigint, y varchar(100))");
        this.assertUpdate("INSERT INTO test_insert VALUES (123, 'test')", 1L);
        this.assertQuery("SELECT * FROM test_insert", "SELECT 123 x, 'test' y");
        this.assertUpdate("DROP TABLE test_insert");
    }

    @Test
    public void testInsertInPresenceOfNotSupportedColumn() {
        this.sqlServer.execute("CREATE TABLE test_insert_not_supported_column_present(x bigint, y sql_variant, z varchar(10))");
        this.assertQuery("SELECT column_name FROM information_schema.columns WHERE table_name = 'test_insert_not_supported_column_present'", "VALUES 'x', 'z'");
        this.assertUpdate("INSERT INTO test_insert_not_supported_column_present (x, z) VALUES (123, 'test')", 1L);
        this.assertQuery("SELECT x, z FROM test_insert_not_supported_column_present", "SELECT 123, 'test'");
        this.assertUpdate("DROP TABLE test_insert_not_supported_column_present");
    }

    @Test
    public void testView() {
        this.sqlServer.execute("CREATE VIEW test_view AS SELECT * FROM orders");
        Assert.assertTrue((boolean)this.getQueryRunner().tableExists(this.getSession(), "test_view"));
        this.assertQuery("SELECT orderkey FROM test_view", "SELECT orderkey FROM orders");
        this.sqlServer.execute("DROP VIEW IF EXISTS test_view");
    }

    @Test
    public void testAggregationPushdown() throws Exception {
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT regionkey, min(nationkey) FROM nation GROUP BY regionkey"))).isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT count(*) FROM orders"))).isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT count(nationkey) FROM nation"))).isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT min(totalprice) FROM orders"))).isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT regionkey, max(nationkey) FROM nation GROUP BY regionkey"))).isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT regionkey, sum(nationkey) FROM nation GROUP BY regionkey"))).isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT regionkey, avg(nationkey) FROM nation GROUP BY regionkey"))).isFullyPushedDown();
        try (AutoCloseable ignoreTable = this.withTable("test_aggregation_pushdown", "(short_decimal decimal(9, 3), long_decimal decimal(30, 10), varchar_column varchar(10))");){
            this.sqlServer.execute("INSERT INTO test_aggregation_pushdown VALUES (100.000, 100000000.000000000, 'ala')");
            this.sqlServer.execute("INSERT INTO test_aggregation_pushdown VALUES (123.321, 123456789.987654321, 'kot')");
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT min(short_decimal), min(long_decimal) FROM test_aggregation_pushdown"))).isFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT max(short_decimal), max(long_decimal) FROM test_aggregation_pushdown"))).isFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT sum(short_decimal), sum(long_decimal) FROM test_aggregation_pushdown"))).isFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT avg(short_decimal), avg(long_decimal) FROM test_aggregation_pushdown"))).isFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT min(short_decimal), min(long_decimal) FROM test_aggregation_pushdown WHERE short_decimal < 110 AND long_decimal < 124"))).isFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT min(long_decimal) FROM test_aggregation_pushdown WHERE short_decimal < 110"))).isFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT short_decimal, min(long_decimal) FROM test_aggregation_pushdown GROUP BY short_decimal"))).isFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT short_decimal, min(long_decimal) FROM test_aggregation_pushdown WHERE short_decimal < 110 AND long_decimal < 124 GROUP BY short_decimal"))).isFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT short_decimal, min(long_decimal) FROM test_aggregation_pushdown WHERE short_decimal < 110 GROUP BY short_decimal"))).isFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT short_decimal, min(long_decimal) FROM test_aggregation_pushdown WHERE long_decimal < 124 GROUP BY short_decimal"))).isFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT short_decimal, min(long_decimal) FROM test_aggregation_pushdown WHERE varchar_column = 'ala' GROUP BY short_decimal"))).isFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT min(varchar_column) FROM test_aggregation_pushdown"))).isFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT short_decimal, min(varchar_column) FROM test_aggregation_pushdown GROUP BY short_decimal"))).isFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT min(varchar_column) FROM test_aggregation_pushdown WHERE varchar_column ='ala'"))).isFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT min(DISTINCT short_decimal) FROM test_aggregation_pushdown"))).isNotFullyPushedDown(AggregationNode.class);
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT DISTINCT short_decimal, min(long_decimal) FROM test_aggregation_pushdown GROUP BY short_decimal"))).isNotFullyPushedDown(ProjectNode.class);
        }
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT array_agg(nationkey) FROM nation"))).isNotFullyPushedDown(AggregationNode.class);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT histogram(regionkey) FROM nation"))).isNotFullyPushedDown(AggregationNode.class);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT multimap_agg(regionkey, nationkey) FROM nation"))).isNotFullyPushedDown(AggregationNode.class);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT approx_set(nationkey) FROM nation"))).isNotFullyPushedDown(AggregationNode.class);
    }

    @Test
    public void testStddevPushdown() {
        try (TestTable testTable = new TestTable(this.sqlServer::execute, (String)this.getSession().getSchema().orElseThrow() + ".test_stddev_pushdown", "(t_double DOUBLE PRECISION)");){
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT stddev_pop(t_double) FROM " + testTable.getName()))).isFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT stddev(t_double) FROM " + testTable.getName()))).isFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT stddev_samp(t_double) FROM " + testTable.getName()))).isFullyPushedDown();
            this.sqlServer.execute("INSERT INTO " + testTable.getName() + " (t_double) VALUES (1)");
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT stddev_pop(t_double) FROM " + testTable.getName()))).isFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT stddev(t_double) FROM " + testTable.getName()))).isFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT stddev_samp(t_double) FROM " + testTable.getName()))).isFullyPushedDown();
            this.sqlServer.execute("INSERT INTO " + testTable.getName() + " (t_double) VALUES (3)");
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT stddev_pop(t_double) FROM " + testTable.getName()))).isFullyPushedDown();
            this.sqlServer.execute("INSERT INTO " + testTable.getName() + " (t_double) VALUES (5)");
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT stddev(t_double) FROM " + testTable.getName()))).isFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT stddev_samp(t_double) FROM " + testTable.getName()))).isFullyPushedDown();
        }
        testTable = new TestTable(this.sqlServer::execute, (String)this.getSession().getSchema().orElseThrow() + ".test_stddev_pushdown", "(t_double DOUBLE PRECISION)");
        try {
            this.sqlServer.execute("INSERT INTO " + testTable.getName() + " (t_double) VALUES (1)");
            this.sqlServer.execute("INSERT INTO " + testTable.getName() + " (t_double) VALUES (2)");
            this.sqlServer.execute("INSERT INTO " + testTable.getName() + " (t_double) VALUES (4)");
            this.sqlServer.execute("INSERT INTO " + testTable.getName() + " (t_double) VALUES (5)");
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT stddev_pop(t_double) FROM " + testTable.getName()))).isFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT stddev(t_double) FROM " + testTable.getName()))).isFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT stddev_samp(t_double) FROM " + testTable.getName()))).isFullyPushedDown();
        }
        finally {
            testTable.close();
        }
    }

    @Test
    public void testVariancePushdown() {
        try (TestTable testTable = new TestTable(this.sqlServer::execute, (String)this.getSession().getSchema().orElseThrow() + ".test_variance_pushdown", "(t_double DOUBLE PRECISION)");){
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT var_pop(t_double) FROM " + testTable.getName()))).isFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT variance(t_double) FROM " + testTable.getName()))).isFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT var_samp(t_double) FROM " + testTable.getName()))).isFullyPushedDown();
            this.sqlServer.execute("INSERT INTO " + testTable.getName() + " (t_double) VALUES (1)");
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT var_pop(t_double) FROM " + testTable.getName()))).isFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT variance(t_double) FROM " + testTable.getName()))).isFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT var_samp(t_double) FROM " + testTable.getName()))).isFullyPushedDown();
            this.sqlServer.execute("INSERT INTO " + testTable.getName() + " (t_double) VALUES (3)");
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT var_pop(t_double) FROM " + testTable.getName()))).isFullyPushedDown();
            this.sqlServer.execute("INSERT INTO " + testTable.getName() + " (t_double) VALUES (5)");
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT variance(t_double) FROM " + testTable.getName()))).isFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT var_samp(t_double) FROM " + testTable.getName()))).isFullyPushedDown();
        }
        testTable = new TestTable(this.sqlServer::execute, (String)this.getSession().getSchema().orElseThrow() + ".test_variance_pushdown", "(t_double DOUBLE PRECISION)");
        try {
            this.sqlServer.execute("INSERT INTO " + testTable.getName() + " (t_double) VALUES (1)");
            this.sqlServer.execute("INSERT INTO " + testTable.getName() + " (t_double) VALUES (2)");
            this.sqlServer.execute("INSERT INTO " + testTable.getName() + " (t_double) VALUES (3)");
            this.sqlServer.execute("INSERT INTO " + testTable.getName() + " (t_double) VALUES (4)");
            this.sqlServer.execute("INSERT INTO " + testTable.getName() + " (t_double) VALUES (5)");
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT var_pop(t_double) FROM " + testTable.getName()))).isFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT variance(t_double) FROM " + testTable.getName()))).isFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT var_samp(t_double) FROM " + testTable.getName()))).isFullyPushedDown();
        }
        finally {
            testTable.close();
        }
    }

    @Test
    public void testColumnComment() throws Exception {
        try (AutoCloseable ignoreTable = this.withTable("test_column_comment", "(col1 bigint, col2 bigint, col3 bigint)");){
            this.sqlServer.execute("EXEC sp_addextendedproperty  'MS_Description', 'test comment',  'Schema', 'dbo',  'Table', 'test_column_comment',  'Column', 'col1'");
            this.assertQuery("SELECT column_name, comment FROM information_schema.columns WHERE table_schema = 'dbo' AND table_name = 'test_column_comment'", "VALUES ('col1', null), ('col2', null), ('col3', null)");
        }
    }

    @Test
    public void testDecimalPredicatePushdown() throws Exception {
        try (AutoCloseable ignoreTable = this.withTable("test_decimal_pushdown", "(short_decimal decimal(9, 3), long_decimal decimal(30, 10))");){
            this.sqlServer.execute("INSERT INTO test_decimal_pushdown VALUES (123.321, 123456789.987654321)");
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_decimal_pushdown WHERE short_decimal <= 124"))).matches("VALUES (CAST(123.321 AS decimal(9,3)), CAST(123456789.987654321 AS decimal(30, 10)))").isFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_decimal_pushdown WHERE short_decimal <= 124"))).matches("VALUES (CAST(123.321 AS decimal(9,3)), CAST(123456789.987654321 AS decimal(30, 10)))").isFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_decimal_pushdown WHERE long_decimal <= 123456790"))).matches("VALUES (CAST(123.321 AS decimal(9,3)), CAST(123456789.987654321 AS decimal(30, 10)))").isFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_decimal_pushdown WHERE short_decimal <= 123.321"))).matches("VALUES (CAST(123.321 AS decimal(9,3)), CAST(123456789.987654321 AS decimal(30, 10)))").isFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_decimal_pushdown WHERE long_decimal <= 123456789.987654321"))).matches("VALUES (CAST(123.321 AS decimal(9,3)), CAST(123456789.987654321 AS decimal(30, 10)))").isFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_decimal_pushdown WHERE short_decimal = 123.321"))).matches("VALUES (CAST(123.321 AS decimal(9,3)), CAST(123456789.987654321 AS decimal(30, 10)))").isFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_decimal_pushdown WHERE long_decimal = 123456789.987654321"))).matches("VALUES (CAST(123.321 AS decimal(9,3)), CAST(123456789.987654321 AS decimal(30, 10)))").isFullyPushedDown();
        }
    }

    @Test
    public void testLimitPushdown() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT name FROM nation LIMIT 30"))).isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT name FROM nation WHERE regionkey = 3 LIMIT 5"))).isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT name FROM nation WHERE name < 'EEE' LIMIT 5"))).isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT max(regionkey) FROM nation LIMIT 5"))).isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT regionkey, max(name) FROM nation GROUP BY regionkey LIMIT 5"))).isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT DISTINCT regionkey FROM nation LIMIT 5"))).isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT regionkey, count(*) FROM nation WHERE nationkey < 5 GROUP BY regionkey LIMIT 3"))).isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT regionkey, count(*) FROM nation WHERE name < 'EGYPT' GROUP BY regionkey LIMIT 3"))).isFullyPushedDown();
    }

    @Test
    public void testTooLargeDomainCompactionThreshold() {
        this.assertQueryFails(Session.builder((Session)this.getSession()).setCatalogSessionProperty("sqlserver", "domain_compaction_threshold", "10000").build(), "SELECT * from nation", "Domain compaction threshold \\(10000\\) cannot exceed 500");
    }

    @Test
    public void testNativeLargeIn() {
        this.sqlServer.execute("SELECT count(*) FROM dbo.orders WHERE " + this.getLongInClause(0, 10000));
    }

    @Test
    public void testNativeMultipleInClauses() {
        String longInClauses = IntStream.range(0, 10).mapToObj(value -> this.getLongInClause(value * 1000, 1000)).collect(Collectors.joining(" OR "));
        this.sqlServer.execute("SELECT count(*) FROM dbo.orders WHERE " + longInClauses);
    }

    @Test
    public void testShowCreateTable() {
        Assertions.assertThat((String)((String)this.computeActual("SHOW CREATE TABLE orders").getOnlyValue())).matches((CharSequence)"CREATE TABLE \\w+\\.\\w+\\.orders \\Q(\n   orderkey bigint,\n   custkey bigint,\n   orderstatus varchar(1),\n   totalprice double,\n   orderdate date,\n   orderpriority varchar(15),\n   clerk varchar(15),\n   shippriority integer,\n   comment varchar(79)\n)\nWITH (\n   data_compression = 'NONE'\n)");
    }

    @Test(dataProvider="dataCompression")
    public void testCreateWithDataCompression(DataCompression dataCompression) {
        String tableName = "test_create_with_compression_" + TestTable.randomTableSuffix();
        String createQuery = String.format("CREATE TABLE sqlserver.dbo.%s (\n   a bigint,\n   b bigint\n)\nWITH (\n   data_compression = '%s'\n)", tableName, dataCompression);
        this.assertUpdate(createQuery);
        Assert.assertEquals((Object)this.getQueryRunner().execute("SHOW CREATE TABLE " + tableName).getOnlyValue(), (Object)createQuery);
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @DataProvider
    public Object[][] dataCompression() {
        return new Object[][]{{DataCompression.NONE}, {DataCompression.ROW}, {DataCompression.PAGE}};
    }

    @Test
    public void testShowCreateForPartitionedTablesWithDataCompression() {
        this.sqlServer.execute("CREATE PARTITION FUNCTION pfSales (DATE)\nAS RANGE LEFT FOR VALUES \n('2013-01-01', '2014-01-01', '2015-01-01')");
        this.sqlServer.execute("CREATE PARTITION SCHEME psSales\nAS PARTITION pfSales \nALL TO ([Primary])");
        this.sqlServer.execute("CREATE TABLE partitionedSales (\n   SalesDate DATE,\n   Quantity INT\n) ON psSales(SalesDate) WITH (DATA_COMPRESSION = PAGE)");
        Assertions.assertThat((String)((String)this.computeActual("SHOW CREATE TABLE partitionedSales").getOnlyValue())).matches((CharSequence)"CREATE TABLE \\w+\\.\\w+\\.partitionedsales \\Q(\n   salesdate date,\n   quantity integer\n)");
    }

    private String getLongInClause(int start, int length) {
        String longValues = IntStream.range(start, start + length).mapToObj(Integer::toString).collect(Collectors.joining(", "));
        return "orderkey IN (" + longValues + ")";
    }

    private AutoCloseable withTable(String tableName, String tableDefinition) {
        this.sqlServer.execute(String.format("CREATE TABLE %s %s", tableName, tableDefinition));
        return () -> this.sqlServer.execute("DROP TABLE " + tableName);
    }
}

