/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.sqlserver;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.prestosql.Session;
import io.prestosql.plugin.sqlserver.SqlServerQueryRunner;
import io.prestosql.plugin.sqlserver.TestingSqlServer;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarbinaryType;
import io.prestosql.testing.AbstractTestQueryFramework;
import io.prestosql.testing.QueryRunner;
import io.prestosql.testing.datatype.CreateAsSelectDataSetup;
import io.prestosql.testing.datatype.DataSetup;
import io.prestosql.testing.datatype.SqlDataTypeTest;
import io.prestosql.testing.sql.PrestoSqlExecutor;
import io.prestosql.testing.sql.SqlExecutor;
import java.util.Map;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

public class TestSqlServerTypeMapping
extends AbstractTestQueryFramework {
    private TestingSqlServer sqlServer;

    protected QueryRunner createQueryRunner() throws Exception {
        this.sqlServer = new TestingSqlServer();
        this.sqlServer.start();
        return SqlServerQueryRunner.createSqlServerQueryRunner(this.sqlServer, (Map<String, String>)ImmutableMap.of(), (Map<String, String>)ImmutableMap.of(), ImmutableList.of());
    }

    @AfterClass(alwaysRun=true)
    public final void destroy() {
        this.sqlServer.close();
    }

    @Test
    public void testVarbinary() {
        SqlDataTypeTest.create().addRoundTrip("varbinary", "NULL", (Type)VarbinaryType.VARBINARY, "CAST(NULL AS varbinary)").addRoundTrip("varbinary", "X''", (Type)VarbinaryType.VARBINARY, "X''").addRoundTrip("varbinary", "X'68656C6C6F'", (Type)VarbinaryType.VARBINARY, "to_utf8('hello')").addRoundTrip("varbinary", "X'5069C4996B6E6120C582C4856B61207720E69DB1E4BAACE983BD'", (Type)VarbinaryType.VARBINARY, "to_utf8('Pi\u0119kna \u0142\u0105ka w \u6771\u4eac\u90fd')").addRoundTrip("varbinary", "X'4261672066756C6C206F6620F09F92B0'", (Type)VarbinaryType.VARBINARY, "to_utf8('Bag full of \ud83d\udcb0')").addRoundTrip("varbinary", "X'0001020304050607080DF9367AA7000000'", (Type)VarbinaryType.VARBINARY, "X'0001020304050607080DF9367AA7000000'").addRoundTrip("varbinary", "X'000000000000'", (Type)VarbinaryType.VARBINARY, "X'000000000000'").execute(this.getQueryRunner(), this.prestoCreateAsSelect("test_varbinary"));
    }

    private DataSetup prestoCreateAsSelect(String tableNamePrefix) {
        return this.prestoCreateAsSelect(this.getSession(), tableNamePrefix);
    }

    private DataSetup prestoCreateAsSelect(Session session, String tableNamePrefix) {
        return new CreateAsSelectDataSetup((SqlExecutor)new PrestoSqlExecutor(this.getQueryRunner(), session), tableNamePrefix);
    }
}

