/*
 * Decompiled with CFR 0.152.
 */
package io.progix.dropwizard.patch;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.progix.dropwizard.patch.BasicJsonPatchDeserializer;
import io.progix.dropwizard.patch.JsonPatchValue;
import io.progix.dropwizard.patch.JsonPath;
import io.progix.dropwizard.patch.exception.PatchOperationNotSupportedException;
import io.progix.dropwizard.patch.operations.AddOperation;
import io.progix.dropwizard.patch.operations.CopyOperation;
import io.progix.dropwizard.patch.operations.MoveOperation;
import io.progix.dropwizard.patch.operations.RemoveOperation;
import io.progix.dropwizard.patch.operations.ReplaceOperation;
import io.progix.dropwizard.patch.operations.TestOperation;
import io.progix.jackson.JsonPatchOperation;
import io.progix.jackson.JsonPatchOperationType;
import io.progix.jackson.exceptions.JsonPatchTestFailedException;
import java.util.HashSet;
import java.util.List;

@JsonDeserialize(using=BasicJsonPatchDeserializer.class)
public class BasicJsonPatch {
    private List<JsonPatchOperation> operations;
    @JsonIgnore
    private AddOperation addOperation;
    @JsonIgnore
    private RemoveOperation removeOperation;
    @JsonIgnore
    private ReplaceOperation replaceOperation;
    @JsonIgnore
    private MoveOperation moveOperation;
    @JsonIgnore
    private CopyOperation copyOperation;
    @JsonIgnore
    private TestOperation testOperation;

    public BasicJsonPatch(List<JsonPatchOperation> operations) {
        this.operations = operations;
    }

    public List<JsonPatchOperation> getOperations() {
        return this.operations;
    }

    public void apply() throws JsonPatchTestFailedException {
        HashSet<JsonPatchOperationType> unsupportedOperationTypes = new HashSet<JsonPatchOperationType>();
        block8: for (JsonPatchOperation operation : this.operations) {
            JsonPath path = new JsonPath(operation.getPath());
            switch (operation.getOperation()) {
                case ADD: {
                    if (this.addOperation == null) {
                        unsupportedOperationTypes.add(JsonPatchOperationType.ADD);
                        break;
                    }
                    this.addOperation.add(path, new JsonPatchValue(operation.getValue()));
                    break;
                }
                case COPY: {
                    if (this.copyOperation == null) {
                        unsupportedOperationTypes.add(JsonPatchOperationType.COPY);
                        break;
                    }
                    this.copyOperation.copy(new JsonPath(operation.getFrom()), new JsonPath(operation.getPath()));
                    break;
                }
                case MOVE: {
                    if (this.moveOperation == null) {
                        unsupportedOperationTypes.add(JsonPatchOperationType.MOVE);
                        break;
                    }
                    this.moveOperation.move(new JsonPath(operation.getFrom()), new JsonPath(operation.getPath()));
                    break;
                }
                case REMOVE: {
                    if (this.removeOperation == null) {
                        unsupportedOperationTypes.add(JsonPatchOperationType.REMOVE);
                        break;
                    }
                    this.removeOperation.remove(new JsonPath(operation.getPath()));
                    break;
                }
                case REPLACE: {
                    if (this.replaceOperation == null) {
                        unsupportedOperationTypes.add(JsonPatchOperationType.REPLACE);
                        break;
                    }
                    this.replaceOperation.replace(new JsonPath(operation.getPath()), new JsonPatchValue(operation.getValue()));
                    break;
                }
                case TEST: {
                    if (this.testOperation == null) {
                        unsupportedOperationTypes.add(JsonPatchOperationType.TEST);
                        break;
                    }
                    boolean success = this.testOperation.test(new JsonPath(operation.getPath()), new JsonPatchValue(operation.getValue()));
                    if (success) continue block8;
                    throw new JsonPatchTestFailedException(operation.getPath(), operation.getValue(), "A test failed.");
                }
            }
        }
        if (!unsupportedOperationTypes.isEmpty()) {
            throw new PatchOperationNotSupportedException(unsupportedOperationTypes);
        }
    }

    public void setAdd(AddOperation handler) {
        this.addOperation = handler;
    }

    public void setRemove(RemoveOperation handler) {
        this.removeOperation = handler;
    }

    public void setReplace(ReplaceOperation handler) {
        this.replaceOperation = handler;
    }

    public void setMove(MoveOperation handler) {
        this.moveOperation = handler;
    }

    public void setCopy(CopyOperation handler) {
        this.copyOperation = handler;
    }

    public void setTest(TestOperation handler) {
        this.testOperation = handler;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BasicJsonPatch that = (BasicJsonPatch)o;
        return this.operations.equals(that.operations);
    }

    public int hashCode() {
        return this.operations.hashCode();
    }

    public String toString() {
        return "JsonPatch{operations=" + this.operations + '}';
    }
}

