/*
 * Decompiled with CFR 0.152.
 */
package io.progix.dropwizard.patch;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.progix.dropwizard.patch.ContextualJsonPatchDeserializer;
import io.progix.dropwizard.patch.JsonPatchValue;
import io.progix.dropwizard.patch.JsonPath;
import io.progix.dropwizard.patch.PatchUtil;
import io.progix.dropwizard.patch.exception.PatchOperationNotSupportedException;
import io.progix.dropwizard.patch.operations.contextual.ContextualAddOperation;
import io.progix.dropwizard.patch.operations.contextual.ContextualCopyOperation;
import io.progix.dropwizard.patch.operations.contextual.ContextualMoveOperation;
import io.progix.dropwizard.patch.operations.contextual.ContextualRemoveOperation;
import io.progix.dropwizard.patch.operations.contextual.ContextualReplaceOperation;
import io.progix.dropwizard.patch.operations.contextual.ContextualTestOperation;
import io.progix.jackson.JsonPatchOperation;
import io.progix.jackson.JsonPatchOperationType;
import io.progix.jackson.exceptions.JsonPatchTestFailedException;
import java.util.HashSet;
import java.util.List;

@JsonDeserialize(using=ContextualJsonPatchDeserializer.class)
public class ContextualJsonPatch<T> {
    protected List<JsonPatchOperation> operations;
    @JsonIgnore
    protected ContextualAddOperation<T> addOperation;
    @JsonIgnore
    protected ContextualRemoveOperation<T> removeOperation;
    @JsonIgnore
    protected ContextualReplaceOperation<T> replaceOperation;
    @JsonIgnore
    protected ContextualMoveOperation<T> moveOperation;
    @JsonIgnore
    protected ContextualCopyOperation<T> copyOperation;
    @JsonIgnore
    protected ContextualTestOperation<T> testOperation;

    public ContextualJsonPatch(List<JsonPatchOperation> operations) {
        this.operations = operations;
    }

    public List<JsonPatchOperation> getOperations() {
        return this.operations;
    }

    public T apply(T context) throws JsonPatchTestFailedException {
        T copiedContext = PatchUtil.copy(context);
        HashSet<JsonPatchOperationType> unsupportedOperationTypes = new HashSet<JsonPatchOperationType>();
        block8: for (JsonPatchOperation operation : this.operations) {
            JsonPath path = new JsonPath(operation.getPath());
            switch (operation.getOperation()) {
                case ADD: {
                    if (this.addOperation == null) {
                        unsupportedOperationTypes.add(JsonPatchOperationType.ADD);
                        break;
                    }
                    this.addOperation.add(copiedContext, path, new JsonPatchValue(operation.getValue()));
                    break;
                }
                case COPY: {
                    if (this.copyOperation == null) {
                        unsupportedOperationTypes.add(JsonPatchOperationType.COPY);
                        break;
                    }
                    this.copyOperation.copy(copiedContext, new JsonPath(operation.getFrom()), path);
                    break;
                }
                case MOVE: {
                    if (this.moveOperation == null) {
                        unsupportedOperationTypes.add(JsonPatchOperationType.MOVE);
                        break;
                    }
                    this.moveOperation.move(copiedContext, new JsonPath(operation.getFrom()), path);
                    break;
                }
                case REMOVE: {
                    if (this.removeOperation == null) {
                        unsupportedOperationTypes.add(JsonPatchOperationType.REMOVE);
                        break;
                    }
                    this.removeOperation.remove(copiedContext, path);
                    break;
                }
                case REPLACE: {
                    if (this.replaceOperation == null) {
                        unsupportedOperationTypes.add(JsonPatchOperationType.REPLACE);
                        break;
                    }
                    this.replaceOperation.replace(copiedContext, path, new JsonPatchValue(operation.getValue()));
                    break;
                }
                case TEST: {
                    if (this.testOperation == null) {
                        unsupportedOperationTypes.add(JsonPatchOperationType.TEST);
                        break;
                    }
                    boolean success = this.testOperation.test(copiedContext, path, new JsonPatchValue(operation.getValue()));
                    if (success) continue block8;
                    throw new JsonPatchTestFailedException(operation.getPath(), operation.getValue(), "A test failed");
                }
            }
        }
        if (!unsupportedOperationTypes.isEmpty()) {
            throw new PatchOperationNotSupportedException(unsupportedOperationTypes);
        }
        return copiedContext;
    }

    public void setAdd(ContextualAddOperation<T> handler) {
        this.addOperation = handler;
    }

    public void setRemove(ContextualRemoveOperation<T> handler) {
        this.removeOperation = handler;
    }

    public void setReplace(ContextualReplaceOperation<T> handler) {
        this.replaceOperation = handler;
    }

    public void setMove(ContextualMoveOperation<T> handler) {
        this.moveOperation = handler;
    }

    public void setCopy(ContextualCopyOperation<T> handler) {
        this.copyOperation = handler;
    }

    public void setTest(ContextualTestOperation<T> handler) {
        this.testOperation = handler;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContextualJsonPatch that = (ContextualJsonPatch)o;
        return this.operations.equals(that.operations);
    }

    public int hashCode() {
        return this.operations.hashCode();
    }

    public String toString() {
        return "JsonPatch{operations=" + this.operations + '}';
    }
}

