/*
 * Decompiled with CFR 0.152.
 */
package io.progix.dropwizard.patch;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.JsonPointer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.dropwizard.jackson.Jackson;
import io.progix.dropwizard.patch.ContextualJsonPatch;
import io.progix.dropwizard.patch.JsonPatchValue;
import io.progix.dropwizard.patch.JsonPath;
import io.progix.dropwizard.patch.PatchUtil;
import io.progix.jackson.JsonPatch;
import io.progix.jackson.JsonPatchOperation;
import io.progix.jackson.exceptions.JsonPatchTestFailedException;
import java.util.List;

public class DefaultJsonPatch<T>
extends ContextualJsonPatch<T> {
    @JsonIgnore
    private final ObjectMapper mapper;
    @JsonIgnore
    private final Class<? extends T> typeClass;

    public DefaultJsonPatch(List<JsonPatchOperation> operations, Class<? extends T> typeClass) {
        super(operations);
        this.typeClass = typeClass;
        this.mapper = Jackson.newObjectMapper();
    }

    @Override
    public T apply(T context) throws JsonPatchTestFailedException {
        Object copiedContext = PatchUtil.copy(context);
        block8: for (JsonPatchOperation instruction : this.operations) {
            switch (instruction.getOperation()) {
                case ADD: {
                    if (this.addOperation == null) {
                        JsonNode node = (JsonNode)this.mapper.convertValue(copiedContext, JsonNode.class);
                        node = JsonPatch.add((JsonPointer)instruction.getPath(), (JsonNode)instruction.getValue(), (JsonNode)node);
                        copiedContext = this.mapper.convertValue((Object)node, this.typeClass);
                        break;
                    }
                    this.addOperation.add(copiedContext, new JsonPath(instruction.getPath()), new JsonPatchValue(instruction.getValue()));
                    break;
                }
                case COPY: {
                    if (this.copyOperation == null) {
                        JsonNode node = (JsonNode)this.mapper.convertValue(copiedContext, JsonNode.class);
                        node = JsonPatch.copy((JsonPointer)instruction.getPath(), (JsonPointer)instruction.getFrom(), (JsonNode)node);
                        copiedContext = this.mapper.convertValue((Object)node, this.typeClass);
                        break;
                    }
                    this.copyOperation.copy(copiedContext, new JsonPath(instruction.getFrom()), new JsonPath(instruction.getPath()));
                    break;
                }
                case MOVE: {
                    if (this.moveOperation == null) {
                        JsonNode node = (JsonNode)this.mapper.convertValue(copiedContext, JsonNode.class);
                        node = JsonPatch.move((JsonPointer)instruction.getPath(), (JsonPointer)instruction.getFrom(), (JsonNode)node);
                        copiedContext = this.mapper.convertValue((Object)node, this.typeClass);
                        break;
                    }
                    this.moveOperation.move(copiedContext, new JsonPath(instruction.getFrom()), new JsonPath(instruction.getPath()));
                    break;
                }
                case REMOVE: {
                    if (this.removeOperation == null) {
                        JsonNode node = (JsonNode)this.mapper.convertValue(copiedContext, JsonNode.class);
                        node = JsonPatch.remove((JsonPointer)instruction.getPath(), (JsonNode)node);
                        copiedContext = this.mapper.convertValue((Object)node, this.typeClass);
                        break;
                    }
                    this.removeOperation.remove(copiedContext, new JsonPath(instruction.getPath()));
                    break;
                }
                case REPLACE: {
                    if (this.replaceOperation == null) {
                        JsonNode node = (JsonNode)this.mapper.convertValue(copiedContext, JsonNode.class);
                        node = JsonPatch.replace((JsonPointer)instruction.getPath(), (JsonNode)instruction.getValue(), (JsonNode)node);
                        copiedContext = this.mapper.convertValue((Object)node, this.typeClass);
                        break;
                    }
                    this.replaceOperation.replace(copiedContext, new JsonPath(instruction.getPath()), new JsonPatchValue(instruction.getValue()));
                    break;
                }
                case TEST: {
                    if (this.testOperation == null) {
                        JsonNode node = (JsonNode)this.mapper.convertValue(copiedContext, JsonNode.class);
                        JsonPatch.test((JsonPointer)instruction.getPath(), (JsonNode)instruction.getValue(), (JsonNode)node);
                        break;
                    }
                    boolean success = this.testOperation.test(copiedContext, new JsonPath(instruction.getPath()), new JsonPatchValue(instruction.getValue()));
                    if (success) continue block8;
                    throw new JsonPatchTestFailedException(instruction.getPath(), instruction.getValue(), "A test failed.");
                }
            }
        }
        return copiedContext;
    }
}

