/*
 * Decompiled with CFR 0.152.
 */
package io.progix.dropwizard.patch;

import com.fasterxml.jackson.databind.JsonNode;
import io.dropwizard.jackson.Jackson;
import java.util.ArrayList;
import java.util.List;

public class JsonPatchValue {
    private JsonNode value;

    JsonPatchValue(JsonNode value) {
        this.value = value;
    }

    public <T> List<T> many(Class<T> clazz) {
        ArrayList<Object> mappedValues = new ArrayList<Object>();
        if (this.value.isArray()) {
            for (JsonNode valueElement : this.value) {
                if (valueElement == null) {
                    mappedValues.add(null);
                }
                mappedValues.add(Jackson.newObjectMapper().convertValue((Object)valueElement, clazz));
            }
        } else {
            mappedValues.add(Jackson.newObjectMapper().convertValue((Object)this.value, clazz));
        }
        return mappedValues;
    }

    public <T> T one(Class<T> clazz) {
        if (this.value.isArray()) {
            throw new UnsupportedOperationException("Cannot convert a list of values into one. See many(Class");
        }
        return (T)Jackson.newObjectMapper().convertValue((Object)this.value, clazz);
    }

    public JsonNode getNode() {
        return this.value;
    }
}

