/*
 * Decompiled with CFR 0.152.
 */
package io.progix.dropwizard.patch;

import com.fasterxml.jackson.core.JsonPointer;
import io.progix.dropwizard.patch.JsonPathElement;
import io.progix.dropwizard.patch.JsonPathProperty;
import java.util.ArrayList;
import java.util.List;

public class JsonPath {
    private List<JsonPathProperty> properties;
    private List<JsonPathElement> elements;
    private String pathString;
    private JsonPointer jsonPointer;
    private int size;

    public JsonPath(JsonPointer pointer) {
        this.jsonPointer = pointer;
        this.properties = new ArrayList<JsonPathProperty>();
        this.elements = new ArrayList<JsonPathElement>();
        this.pathString = "";
        while (pointer != null) {
            if (pointer.getMatchingProperty() != null && !pointer.getMatchingProperty().isEmpty()) {
                ++this.size;
            }
            if (pointer.mayMatchProperty() && !pointer.mayMatchElement() && !pointer.getMatchingProperty().isEmpty() && !pointer.getMatchingProperty().equals("-")) {
                this.properties.add(new JsonPathProperty(pointer.getMatchingProperty()));
                this.pathString = this.pathString + "/" + pointer.getMatchingProperty();
            } else if (pointer.getMatchingProperty().equals("-")) {
                this.elements.add(new JsonPathElement(true));
                this.pathString = this.pathString + pointer.getMatchingProperty() + "/";
            } else {
                this.properties.add(new JsonPathProperty());
            }
            if (pointer.mayMatchElement()) {
                this.elements.add(new JsonPathElement(pointer.getMatchingIndex()));
                this.pathString = this.pathString + "/" + pointer.getMatchingIndex();
            } else {
                this.elements.add(new JsonPathElement());
            }
            pointer = pointer.tail();
        }
    }

    public List<JsonPathProperty> getProperties() {
        return this.properties;
    }

    public List<JsonPathElement> getElements() {
        return this.elements;
    }

    public int size() {
        return this.size;
    }

    public boolean is(String path) {
        if (path.charAt(0) != '/') {
            throw new IllegalArgumentException("Paths must start with a '/'");
        }
        String[] tokens = (path = path.substring(1, path.length())).split("/");
        if (!this.endsAt(tokens.length - 1)) {
            return false;
        }
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (this.property(i).exists()) {
                if (token.equals("#")) {
                    return false;
                }
                if (token.equals("~#")) {
                    token = "#";
                }
                if (token.equals(this.property(i).val())) continue;
                return false;
            }
            if (this.element(i).exists()) {
                if (!token.equals("#") && (!token.equals("-") || !this.element(i).isEndOfArray()) && !String.valueOf(this.element(i).val()).equals(token)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public boolean endsAt(int index) {
        int next = index + 1;
        return (this.property(index).exists() || this.element(index).exists()) && !this.property(next).exists() && !this.element(next).exists();
    }

    public JsonPathProperty property(int index) {
        if (index >= this.properties.size()) {
            return new JsonPathProperty();
        }
        return this.properties.get(index);
    }

    public JsonPathElement element(int index) {
        if (index >= this.elements.size()) {
            return new JsonPathElement();
        }
        return this.elements.get(index);
    }

    public String toString() {
        return this.pathString;
    }

    public JsonPointer getJsonPointer() {
        return this.jsonPointer;
    }
}

