/*
 * Decompiled with CFR 0.152.
 */
package io.projectglow.bgen;

import java.util.HashMap;
import org.apache.commons.math3.util.CombinatoricsUtils;
import scala.Tuple2;
import scala.runtime.BoxesRunTime;

public final class BgenConverterUtils$ {
    public static BgenConverterUtils$ MODULE$;
    private HashMap<Tuple2<Object, Object>, Object> ploidyMap;
    private HashMap<Tuple2<Object, Object>, Object> genotypesMap;

    static {
        new BgenConverterUtils$();
    }

    public HashMap<Tuple2<Object, Object>, Object> ploidyMap() {
        return this.ploidyMap;
    }

    public void ploidyMap_$eq(HashMap<Tuple2<Object, Object>, Object> x$1) {
        this.ploidyMap = x$1;
    }

    public HashMap<Tuple2<Object, Object>, Object> genotypesMap() {
        return this.genotypesMap;
    }

    public void genotypesMap_$eq(HashMap<Tuple2<Object, Object>, Object> x$1) {
        this.genotypesMap = x$1;
    }

    public int getPloidy(int numGenotypes, int numAlleles, int maxPloidy) {
        int n;
        if (this.ploidyMap().containsKey(new Tuple2.mcII.sp(numGenotypes, numAlleles))) {
            n = BoxesRunTime.unboxToInt((Object)this.ploidyMap().get(new Tuple2.mcII.sp(numGenotypes, numAlleles)));
        } else {
            int possibleNumGenotypes = 0;
            int possiblePloidy = 0;
            while (possibleNumGenotypes < numGenotypes && possiblePloidy < maxPloidy) {
                possibleNumGenotypes = (int)CombinatoricsUtils.binomialCoefficient((int)(++possiblePloidy + numAlleles - 1), (int)(numAlleles - 1));
                this.ploidyMap().put((Tuple2<Object, Object>)new Tuple2.mcII.sp(possibleNumGenotypes, numAlleles), BoxesRunTime.boxToInteger((int)possiblePloidy));
            }
            if (numGenotypes != possibleNumGenotypes) {
                throw new IllegalStateException(new StringBuilder(64).append("Ploidy cannot be inferred: unphased, ").append(numAlleles).append(" alleles, ").append(maxPloidy).append(" maximum ploidy, ").append(new StringBuilder(15).append(numGenotypes).append(" probabilities.").toString()).toString());
            }
            n = possiblePloidy;
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    public int getNumGenotypes(int ploidy, int numAlleles) {
        int n;
        if (this.genotypesMap().containsKey(new Tuple2.mcII.sp(ploidy, numAlleles))) {
            n = BoxesRunTime.unboxToInt((Object)this.genotypesMap().get(new Tuple2.mcII.sp(ploidy, numAlleles)));
        } else {
            void var3_3;
            int numGts = (int)CombinatoricsUtils.binomialCoefficient((int)(ploidy + numAlleles - 1), (int)(numAlleles - 1));
            this.genotypesMap().put((Tuple2<Object, Object>)new Tuple2.mcII.sp(ploidy, numAlleles), BoxesRunTime.boxToInteger((int)numGts));
            n = var3_3;
        }
        return n;
    }

    private BgenConverterUtils$() {
        MODULE$ = this;
        this.ploidyMap = new HashMap();
        this.genotypesMap = new HashMap();
    }
}

