/*
 * Decompiled with CFR 0.152.
 */
package io.projectglow.bgen;

import com.google.common.util.concurrent.Striped;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import io.projectglow.common.BgenOptions$;
import io.projectglow.common.WithUtils$;
import io.projectglow.common.logging.HlsEventRecorder;
import io.projectglow.common.logging.HlsTagValues$;
import io.projectglow.common.logging.HlsUsageLogging;
import io.projectglow.common.logging.MetricDefinition;
import io.projectglow.common.logging.TagDefinition;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.concurrent.locks.Lock;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxesRunTime;

public final class BgenFileFormat$
implements HlsEventRecorder,
scala.Serializable {
    public static BgenFileFormat$ MODULE$;
    private final String BGEN_SUFFIX;
    private final String INDEX_SUFFIX;
    private final String NEXT_IDX_QUERY;
    private final Striped<Lock> idxLock;
    private Logger logger;
    private volatile boolean bitmap$0;

    static {
        new BgenFileFormat$();
    }

    @Override
    public void recordHlsEvent(String tag, Map<String, Object> options) {
        HlsEventRecorder.recordHlsEvent$(this, tag, options);
    }

    @Override
    public Map<String, Object> recordHlsEvent$default$2() {
        return HlsEventRecorder.recordHlsEvent$default$2$(this);
    }

    @Override
    public void recordHlsUsage(MetricDefinition metric, Map<TagDefinition, String> tags, String blob) {
        HlsUsageLogging.recordHlsUsage$(this, metric, tags, blob);
    }

    @Override
    public Map<TagDefinition, String> recordHlsUsage$default$2() {
        return HlsUsageLogging.recordHlsUsage$default$2$(this);
    }

    @Override
    public String recordHlsUsage$default$3() {
        return HlsUsageLogging.recordHlsUsage$default$3$(this);
    }

    @Override
    public String hlsJsonBuilder(Map<String, Object> options) {
        return HlsUsageLogging.hlsJsonBuilder$(this, options);
    }

    private Logger logger$lzycompute() {
        BgenFileFormat$ bgenFileFormat$ = this;
        synchronized (bgenFileFormat$) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    public String BGEN_SUFFIX() {
        return this.BGEN_SUFFIX;
    }

    public String INDEX_SUFFIX() {
        return this.INDEX_SUFFIX;
    }

    public String NEXT_IDX_QUERY() {
        return this.NEXT_IDX_QUERY;
    }

    public Striped<Lock> idxLock() {
        return this.idxLock;
    }

    public void logBgenRead(boolean useIndex) {
        this.recordHlsEvent(HlsTagValues$.MODULE$.EVENT_BGEN_READ(), (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BgenOptions$.MODULE$.USE_INDEX_KEY()), (Object)BoxesRunTime.boxToBoolean((boolean)useIndex))}))));
    }

    public Option<Seq<String>> getSampleIds(Map<String, String> options, Configuration hadoopConf) {
        Option samplePathOpt = options.get((Object)BgenOptions$.MODULE$.SAMPLE_FILE_PATH_OPTION_KEY());
        if (samplePathOpt.isEmpty()) {
            return None$.MODULE$;
        }
        String samplePath = (String)samplePathOpt.get();
        Path path = new Path(samplePath);
        FileSystem hadoopFs = path.getFileSystem(hadoopConf);
        FSDataInputStream stream = hadoopFs.open(path);
        InputStreamReader streamReader = new InputStreamReader((InputStream)stream);
        BufferedReader bufferedReader = new BufferedReader(streamReader);
        String sampleCol = (String)options.getOrElse((Object)BgenOptions$.MODULE$.SAMPLE_ID_COLUMN_OPTION_KEY(), (Function0 & Serializable & scala.Serializable)() -> BgenOptions$.MODULE$.SAMPLE_ID_COLUMN_OPTION_DEFAULT_VALUE());
        int sampleColIdx = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])bufferedReader.readLine().split(" "))).indexOf((Object)sampleCol);
        bufferedReader.readLine();
        return (Option)WithUtils$.MODULE$.withCloseable(stream, (Function1 & Serializable & scala.Serializable)s -> {
            if (sampleColIdx == -1) {
                throw new IllegalArgumentException(new StringBuilder(21).append("No column named ").append(sampleCol).append(" in ").append(samplePath).append(".").toString());
            }
            List sampleLines = ((TraversableOnce)JavaConverters$.MODULE$.asScalaIteratorConverter(bufferedReader.lines().iterator()).asScala()).toList();
            List sampleIds = (List)sampleLines.map((Function1 & Serializable & scala.Serializable)line -> {
                if (line.split(" ").length <= sampleColIdx) {
                    throw new IllegalArgumentException(new StringBuilder(43).append("Malformed line in ").append(samplePath).append(": fewer than ").append(sampleColIdx + 1).append(" columns in ").append((String)line).toString());
                }
                return line.split(" ")[sampleColIdx];
            }, List$.MODULE$.canBuildFrom());
            return new Some((Object)sampleIds);
        });
    }

    private Object readResolve() {
        return MODULE$;
    }

    private BgenFileFormat$() {
        MODULE$ = this;
        LazyLogging.$init$((LazyLogging)this);
        HlsUsageLogging.$init$(this);
        HlsEventRecorder.$init$(this);
        this.BGEN_SUFFIX = ".bgen";
        this.INDEX_SUFFIX = ".bgi";
        this.NEXT_IDX_QUERY = new StringOps(Predef$.MODULE$.augmentString("\n      |SELECT MIN(file_start_position) from Variant\n      |WHERE file_start_position > :pos\n    ")).stripMargin();
        this.idxLock = Striped.lock((int)100);
    }
}

