/*
 * Decompiled with CFR 0.152.
 */
package io.projectglow.bgen;

import com.google.common.io.LittleEndianDataInputStream;
import com.google.common.util.concurrent.Striped;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import io.projectglow.bgen.BgenFileFormat$;
import io.projectglow.bgen.BgenFileIterator;
import io.projectglow.bgen.BgenHeaderReader;
import io.projectglow.bgen.BgenMetadata;
import io.projectglow.bgen.BgenRowToInternalRowConverter;
import io.projectglow.bgen.BgenSchemaInferrer$;
import io.projectglow.common.BgenOptions$;
import io.projectglow.common.BgenRow;
import io.projectglow.common.GlowLogging;
import io.projectglow.common.WithUtils$;
import io.projectglow.sql.util.SerializableConfiguration;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.file.Paths;
import java.util.concurrent.locks.Lock;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;
import org.apache.spark.TaskContext$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.execution.datasources.FileFormat;
import org.apache.spark.sql.execution.datasources.OutputWriterFactory;
import org.apache.spark.sql.execution.datasources.PartitionedFile;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.sources.DataSourceRegister;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import org.skife.jdbi.v2.DBI;
import org.skife.jdbi.v2.Query;
import org.skife.jdbi.v2.tweak.ResultSetMapper;
import org.skife.jdbi.v2.util.LongMapper;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\tMb\u0001B\f\u0019\u0001}AQ!\u0012\u0001\u0005\u0002\u0019CQ!\u0013\u0001\u0005B)CQA\u0016\u0001\u0005B]Caa \u0001\u0005B\u0005\u0005\u0001bBA\u0011\u0001\u0011\u0005\u00131\u0005\u0005\b\u0003s\u0001A\u0011IA\u001e\u0011\u001d\t)\t\u0001C\u0005\u0003\u000fCq!a*\u0001\t\u0013\tIkB\u0004\u00020bA\t!!-\u0007\r]A\u0002\u0012AAZ\u0011\u0019)%\u0002\"\u0001\u0002B\"I\u00111\u0019\u0006C\u0002\u0013\u0005\u0011Q\u0019\u0005\t\u0003+T\u0001\u0015!\u0003\u0002H\"I\u0011q\u001b\u0006C\u0002\u0013\u0005\u0011Q\u0019\u0005\t\u00033T\u0001\u0015!\u0003\u0002H\"I\u00111\u001c\u0006C\u0002\u0013\u0005\u0011Q\u001c\u0005\b\u0003?T\u0001\u0015!\u0003L\u0011%\t\tO\u0003b\u0001\n\u0003\t\u0019\u000f\u0003\u0005\u0003\u0010)\u0001\u000b\u0011BAs\u0011\u001d\u0011\tB\u0003C\u0001\u0005'AqA!\b\u000b\t\u0003\u0011y\u0002C\u0005\u0003*)\t\t\u0011\"\u0003\u0003,\tq!iZ3o\r&dWMR8s[\u0006$(BA\r\u001b\u0003\u0011\u0011w-\u001a8\u000b\u0005ma\u0012a\u00039s_*,7\r^4m_^T\u0011!H\u0001\u0003S>\u001c\u0001a\u0005\u0004\u0001A\u00192Dh\u0010\t\u0003C\u0011j\u0011A\t\u0006\u0002G\u0005)1oY1mC&\u0011QE\t\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\u001d\"T\"\u0001\u0015\u000b\u0005%R\u0013a\u00033bi\u0006\u001cx.\u001e:dKNT!a\u000b\u0017\u0002\u0013\u0015DXmY;uS>t'BA\u0017/\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003_A\nQa\u001d9be.T!!\r\u001a\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0019\u0014aA8sO&\u0011Q\u0007\u000b\u0002\u000b\r&dWMR8s[\u0006$\bCA\u001c;\u001b\u0005A$BA\u001d-\u0003\u001d\u0019x.\u001e:dKNL!a\u000f\u001d\u0003%\u0011\u000bG/Y*pkJ\u001cWMU3hSN$XM\u001d\t\u0003CuJ!A\u0010\u0012\u0003\u0019M+'/[1mSj\f'\r\\3\u0011\u0005\u0001\u001bU\"A!\u000b\u0005\tS\u0012AB2p[6|g.\u0003\u0002E\u0003\nYq\t\\8x\u0019><w-\u001b8h\u0003\u0019a\u0014N\\5u}Q\tq\t\u0005\u0002I\u00015\t\u0001$A\u0005tQ>\u0014HOT1nKR\t1\n\u0005\u0002M':\u0011Q*\u0015\t\u0003\u001d\nj\u0011a\u0014\u0006\u0003!z\ta\u0001\u0010:p_Rt\u0014B\u0001*#\u0003\u0019\u0001&/\u001a3fM&\u0011A+\u0016\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005I\u0013\u0013aC5oM\u0016\u00148k\u00195f[\u0006$B\u0001W1hYB\u0019\u0011%W.\n\u0005i\u0013#AB(qi&|g\u000e\u0005\u0002]?6\tQL\u0003\u0002_Y\u0005)A/\u001f9fg&\u0011\u0001-\u0018\u0002\u000b'R\u0014Xo\u0019;UsB,\u0007\"\u00022\u0004\u0001\u0004\u0019\u0017\u0001D:qCJ\\7+Z:tS>t\u0007C\u00013f\u001b\u0005a\u0013B\u00014-\u00051\u0019\u0006/\u0019:l'\u0016\u001c8/[8o\u0011\u0015A7\u00011\u0001j\u0003\u001dy\u0007\u000f^5p]N\u0004B\u0001\u00146L\u0017&\u00111.\u0016\u0002\u0004\u001b\u0006\u0004\b\"B7\u0004\u0001\u0004q\u0017!\u00024jY\u0016\u001c\bcA8uo:\u0011\u0001O\u001d\b\u0003\u001dFL\u0011aI\u0005\u0003g\n\nq\u0001]1dW\u0006<W-\u0003\u0002vm\n\u00191+Z9\u000b\u0005M\u0014\u0003C\u0001=~\u001b\u0005I(B\u0001>|\u0003\t17O\u0003\u0002}a\u00051\u0001.\u00193p_BL!A`=\u0003\u0015\u0019KG.Z*uCR,8/\u0001\u0007qe\u0016\u0004\u0018M]3Xe&$X\r\u0006\u0006\u0002\u0004\u0005%\u00111BA\u000e\u0003;\u00012aJA\u0003\u0013\r\t9\u0001\u000b\u0002\u0014\u001fV$\b/\u001e;Xe&$XM\u001d$bGR|'/\u001f\u0005\u0006E\u0012\u0001\ra\u0019\u0005\b\u0003\u001b!\u0001\u0019AA\b\u0003\rQwN\u0019\t\u0005\u0003#\t9\"\u0004\u0002\u0002\u0014)\u0019\u0011QC>\u0002\u00135\f\u0007O]3ek\u000e,\u0017\u0002BA\r\u0003'\u00111AS8c\u0011\u0015AG\u00011\u0001j\u0011\u0019\ty\u0002\u0002a\u00017\u0006QA-\u0019;b'\u000eDW-\\1\u0002\u0017%\u001c8\u000b\u001d7ji\u0006\u0014G.\u001a\u000b\t\u0003K\tY#!\f\u00020A\u0019\u0011%a\n\n\u0007\u0005%\"EA\u0004C_>dW-\u00198\t\u000b\t,\u0001\u0019A2\t\u000b!,\u0001\u0019A5\t\u000f\u0005ER\u00011\u0001\u00024\u0005!\u0001/\u0019;i!\rA\u0018QG\u0005\u0004\u0003oI(\u0001\u0002)bi\"\f1BY;jY\u0012\u0014V-\u00193feR\u0001\u0012QHA.\u0003;\ny&a\u0019\u0002h\u0005M\u0014Q\u000f\t\bC\u0005}\u00121IA%\u0013\r\t\tE\t\u0002\n\rVt7\r^5p]F\u00022aJA#\u0013\r\t9\u0005\u000b\u0002\u0010!\u0006\u0014H/\u001b;j_:,GMR5mKB)q.a\u0013\u0002P%\u0019\u0011Q\n<\u0003\u0011%#XM]1u_J\u0004B!!\u0015\u0002X5\u0011\u00111\u000b\u0006\u0004\u0003+b\u0013\u0001C2bi\u0006d\u0017p\u001d;\n\t\u0005e\u00131\u000b\u0002\f\u0013:$XM\u001d8bYJ{w\u000fC\u00030\r\u0001\u00071\r\u0003\u0004\u0002 \u0019\u0001\ra\u0017\u0005\u0007\u0003C2\u0001\u0019A.\u0002\u001fA\f'\u000f^5uS>t7k\u00195f[\u0006Da!!\u001a\u0007\u0001\u0004Y\u0016A\u0004:fcVL'/\u001a3TG\",W.\u0019\u0005\b\u0003S2\u0001\u0019AA6\u0003\u001d1\u0017\u000e\u001c;feN\u0004Ba\u001c;\u0002nA\u0019q'a\u001c\n\u0007\u0005E\u0004H\u0001\u0004GS2$XM\u001d\u0005\u0006Q\u001a\u0001\r!\u001b\u0005\b\u0003o2\u0001\u0019AA=\u0003)A\u0017\rZ8pa\u000e{gN\u001a\t\u0005\u0003w\n\t)\u0004\u0002\u0002~)\u0019\u0011qP>\u0002\t\r|gNZ\u0005\u0005\u0003\u0007\u000biHA\u0007D_:4\u0017nZ;sCRLwN\\\u0001\u0011]\u0016DHOV1sS\u0006tG/\u00138eKb$\"\"!#\u0002\u0012\u0006m\u0015qTAR!\u0011\t\u0013,a#\u0011\u0007\u0005\ni)C\u0002\u0002\u0010\n\u0012A\u0001T8oO\"9\u00111S\u0004A\u0002\u0005U\u0015\u0001\u00035bI>|\u0007OR:\u0011\u0007a\f9*C\u0002\u0002\u001af\u0014!BR5mKNK8\u000f^3n\u0011\u001d\tij\u0002a\u0001\u0003\u0007\nAAZ5mK\"9\u0011\u0011U\u0004A\u0002\u0005\u0015\u0012\u0001C;tK&sG-\u001a=\t\u000f\u0005\u0015v\u00011\u0001\u0002&\u0005y\u0011n\u001a8pe\u0016,\u0005\u0010^3og&|g.\u0001\fe_^tGn\\1e\u0013\u0012D\u0018J\u001a(fG\u0016\u001c8/\u0019:z)\u0015Y\u00151VAW\u0011\u001d\t\u0019\n\u0003a\u0001\u0003+Cq!!\r\t\u0001\u0004\t\u0019$\u0001\bCO\u0016tg)\u001b7f\r>\u0014X.\u0019;\u0011\u0005!S1#\u0002\u0006!\u0003kc\u0004\u0003BA\\\u0003{k!!!/\u000b\u0007\u0005m\u0016)A\u0004m_\u001e<\u0017N\\4\n\t\u0005}\u0016\u0011\u0018\u0002\u0011\u00112\u001cXI^3oiJ+7m\u001c:eKJ$\"!!-\u0002\u0017\t;UIT0T+\u001a3\u0015\nW\u000b\u0003\u0003\u000f\u0004B!!3\u0002T6\u0011\u00111\u001a\u0006\u0005\u0003\u001b\fy-\u0001\u0003mC:<'BAAi\u0003\u0011Q\u0017M^1\n\u0007Q\u000bY-\u0001\u0007C\u000f\u0016sulU+G\r&C\u0006%\u0001\u0007J\u001d\u0012+\u0005lX*V\r\u001aK\u0005,A\u0007J\u001d\u0012+\u0005lX*V\r\u001aK\u0005\fI\u0001\u000f\u001d\u0016CFkX%E1~\u000bV+\u0012*Z+\u0005Y\u0015a\u0004(F1R{\u0016\n\u0012-`#V+%+\u0017\u0011\u0002\u000f%$\u0007\u0010T8dWV\u0011\u0011Q\u001d\t\u0007\u0003O\fY0a@\u000e\u0005\u0005%(\u0002BAv\u0003[\f!bY8oGV\u0014(/\u001a8u\u0015\u0011\ty/!=\u0002\tU$\u0018\u000e\u001c\u0006\u0004\u0005\u0006M(\u0002BA{\u0003o\faaZ8pO2,'BAA}\u0003\r\u0019w.\\\u0005\u0005\u0003{\fIOA\u0004TiJL\u0007/\u001a3\u0011\t\t\u0005!1B\u0007\u0003\u0005\u0007QAA!\u0002\u0003\b\u0005)An\\2lg*!\u00111\u001eB\u0005\u0015\u0011\ty/a4\n\t\t5!1\u0001\u0002\u0005\u0019>\u001c7.\u0001\u0005jIbdunY6!\u0003-awn\u001a\"hK:\u0014V-\u00193\u0015\t\tU!1\u0004\t\u0004C\t]\u0011b\u0001B\rE\t!QK\\5u\u0011\u001d\t\t\u000b\u0006a\u0001\u0003K\tAbZ3u'\u0006l\u0007\u000f\\3JIN$bA!\t\u0003&\t\u001d\u0002\u0003B\u0011Z\u0005G\u00012a\u001c;L\u0011\u0015AW\u00031\u0001j\u0011\u001d\t9(\u0006a\u0001\u0003s\n1B]3bIJ+7o\u001c7wKR\u0011!Q\u0006\t\u0005\u0003\u0013\u0014y#\u0003\u0003\u00032\u0005-'AB(cU\u0016\u001cG\u000f")
public class BgenFileFormat
implements FileFormat,
DataSourceRegister,
scala.Serializable,
GlowLogging {
    private Logger logger;
    private volatile boolean bitmap$0;

    public static Option<Seq<String>> getSampleIds(Map<String, String> map, Configuration configuration) {
        return BgenFileFormat$.MODULE$.getSampleIds(map, configuration);
    }

    public static void logBgenRead(boolean bl) {
        BgenFileFormat$.MODULE$.logBgenRead(bl);
    }

    public static Striped<Lock> idxLock() {
        return BgenFileFormat$.MODULE$.idxLock();
    }

    public static String NEXT_IDX_QUERY() {
        return BgenFileFormat$.MODULE$.NEXT_IDX_QUERY();
    }

    public static String INDEX_SUFFIX() {
        return BgenFileFormat$.MODULE$.INDEX_SUFFIX();
    }

    public static String BGEN_SUFFIX() {
        return BgenFileFormat$.MODULE$.BGEN_SUFFIX();
    }

    public static Map<String, Object> recordHlsEvent$default$2() {
        return BgenFileFormat$.MODULE$.recordHlsEvent$default$2();
    }

    public static void recordHlsEvent(String string, Map<String, Object> map) {
        BgenFileFormat$.MODULE$.recordHlsEvent(string, map);
    }

    public boolean supportBatch(SparkSession sparkSession, StructType dataSchema) {
        return FileFormat.supportBatch$((FileFormat)this, (SparkSession)sparkSession, (StructType)dataSchema);
    }

    public Option<Seq<String>> vectorTypes(StructType requiredSchema, StructType partitionSchema, SQLConf sqlConf) {
        return FileFormat.vectorTypes$((FileFormat)this, (StructType)requiredSchema, (StructType)partitionSchema, (SQLConf)sqlConf);
    }

    public Function1<PartitionedFile, Iterator<InternalRow>> buildReaderWithPartitionValues(SparkSession sparkSession, StructType dataSchema, StructType partitionSchema, StructType requiredSchema, Seq<Filter> filters, Map<String, String> options, Configuration hadoopConf) {
        return FileFormat.buildReaderWithPartitionValues$((FileFormat)this, (SparkSession)sparkSession, (StructType)dataSchema, (StructType)partitionSchema, (StructType)requiredSchema, filters, options, (Configuration)hadoopConf);
    }

    public boolean supportDataType(DataType dataType) {
        return FileFormat.supportDataType$((FileFormat)this, (DataType)dataType);
    }

    private Logger logger$lzycompute() {
        BgenFileFormat bgenFileFormat = this;
        synchronized (bgenFileFormat) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    public String shortName() {
        return "bgen";
    }

    public Option<StructType> inferSchema(SparkSession sparkSession, Map<String, String> options, Seq<FileStatus> files) {
        return Option$.MODULE$.apply((Object)BgenSchemaInferrer$.MODULE$.inferSchema(sparkSession, files, options));
    }

    public OutputWriterFactory prepareWrite(SparkSession sparkSession, Job job, Map<String, String> options, StructType dataSchema) {
        throw new UnsupportedOperationException("BGEN data source does not support writing sharded BGENs; use bigbgen.");
    }

    public boolean isSplitable(SparkSession sparkSession, Map<String, String> options, Path path) {
        return true;
    }

    public Function1<PartitionedFile, Iterator<InternalRow>> buildReader(SparkSession spark, StructType dataSchema, StructType partitionSchema, StructType requiredSchema, Seq<Filter> filters, Map<String, String> options, Configuration hadoopConf) {
        boolean useIndex = options.get((Object)BgenOptions$.MODULE$.USE_INDEX_KEY()).forall((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)BgenFileFormat.$anonfun$buildReader$1(x$1)));
        boolean ignoreExtension = options.get((Object)BgenOptions$.MODULE$.IGNORE_EXTENSION_KEY()).exists((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)BgenFileFormat.$anonfun$buildReader$2(x$2)));
        Option<Seq<String>> sampleIdsOpt = BgenFileFormat$.MODULE$.getSampleIds(options, hadoopConf);
        double hardCallsThreshold = new StringOps(Predef$.MODULE$.augmentString((String)options.getOrElse((Object)BgenOptions$.MODULE$.HARD_CALL_THRESHOLD_KEY(), (Function0 & Serializable & scala.Serializable)() -> BgenOptions$.MODULE$.HARD_CALL_THRESHOLD_VALUE()))).toDouble();
        BgenFileFormat$.MODULE$.logBgenRead(useIndex);
        SerializableConfiguration serializableConf = new SerializableConfiguration(hadoopConf);
        return (Function1 & Serializable & scala.Serializable)file -> {
            Iterator iterator;
            Path path = new Path(file.filePath());
            FileSystem hadoopFs = path.getFileSystem(serializableConf.value());
            Option<Object> option = this.nextVariantIndex(hadoopFs, (PartitionedFile)file, useIndex, ignoreExtension);
            if (None$.MODULE$.equals(option)) {
                iterator = package$.MODULE$.Iterator().empty();
            } else if (option instanceof Some) {
                BoxedUnit boxedUnit;
                Some some = (Some)option;
                long pos = BoxesRunTime.unboxToLong((Object)some.value());
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info("Next variant index is {}", new Object[]{BoxesRunTime.boxToLong((long)pos)});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                FSDataInputStream stream = hadoopFs.open(path);
                LittleEndianDataInputStream littleEndianStream = new LittleEndianDataInputStream((InputStream)stream);
                Option$.MODULE$.apply((Object)TaskContext$.MODULE$.get()).foreach((Function1 & Serializable & scala.Serializable)tc -> tc.addTaskCompletionListener((Function1 & Serializable & scala.Serializable)x$3 -> {
                    stream.close();
                    return BoxedUnit.UNIT;
                }));
                BgenMetadata header = new BgenHeaderReader(littleEndianStream).readHeader(sampleIdsOpt);
                long startPos = Math.max(pos, header.firstVariantOffset());
                stream.seek(startPos);
                BgenRowToInternalRowConverter rowConverter = new BgenRowToInternalRowConverter(requiredSchema, hardCallsThreshold);
                BgenFileIterator iter = new BgenFileIterator(header, littleEndianStream, stream, file.start(), file.start() + file.length());
                iter.init();
                iterator = iter.map((Function1 & Serializable & scala.Serializable)bgenRow -> rowConverter.convertRow((BgenRow)bgenRow));
            } else {
                throw new MatchError(option);
            }
            return iterator;
        };
    }

    private Option<Object> nextVariantIndex(FileSystem hadoopFs, PartitionedFile file, boolean useIndex, boolean ignoreExtension) {
        Some some;
        if (!file.filePath().endsWith(BgenFileFormat$.MODULE$.BGEN_SUFFIX()) && !ignoreExtension) {
            return None$.MODULE$;
        }
        Path indexFile = new Path(new StringBuilder(0).append(file.filePath()).append(BgenFileFormat$.MODULE$.INDEX_SUFFIX()).toString());
        if (hadoopFs.exists(indexFile) && useIndex) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Found index file {} for BGEN file {}", new Object[]{indexFile, file.filePath()});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            String localIdxPath = this.downloadIdxIfNecessary(hadoopFs, indexFile);
            DBI dbi = new DBI(new StringBuilder(12).append("jdbc:sqlite:").append(localIdxPath).toString());
            some = (Option)WithUtils$.MODULE$.withCloseable(dbi.open(), (Function1 & Serializable & scala.Serializable)handle -> {
                Query query = ((Query)handle.createQuery(BgenFileFormat$.MODULE$.NEXT_IDX_QUERY()).bind("pos", file.start())).map((ResultSetMapper)LongMapper.FIRST);
                return Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)Predef$.MODULE$.Long2long((Long)query.first())));
            });
        } else {
            some = new Some((Object)BoxesRunTime.boxToLong((long)0L));
        }
        return some;
    }

    private String downloadIdxIfNecessary(FileSystem hadoopFs, Path path) {
        File localDir = Paths.get(System.getProperty("java.io.tmpdir"), new String[0]).resolve("bgen_indices").toFile();
        localDir.mkdirs();
        String localPath = new StringBuilder(1).append(localDir).append("/").append(new StringOps(Predef$.MODULE$.augmentString(path.getName())).replaceAllLiterally("/", "__")).toString();
        WithUtils$.MODULE$.withLock((Lock)BgenFileFormat$.MODULE$.idxLock().get((Object)path), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            block0: {
                if (new File(localPath).exists()) break block0;
                hadoopFs.copyToLocalFile(path, new Path(new StringBuilder(5).append("file:").append(localPath).toString()));
            }
        });
        return localPath;
    }

    public static final /* synthetic */ boolean $anonfun$buildReader$1(String x$1) {
        return new StringOps(Predef$.MODULE$.augmentString(x$1)).toBoolean();
    }

    public static final /* synthetic */ boolean $anonfun$buildReader$2(String x$2) {
        return new StringOps(Predef$.MODULE$.augmentString(x$2)).toBoolean();
    }

    public BgenFileFormat() {
        FileFormat.$init$((FileFormat)this);
        LazyLogging.$init$((LazyLogging)this);
    }
}

