/*
 * Decompiled with CFR 0.152.
 */
package io.projectglow.bgen;

import com.google.common.io.LittleEndianDataInputStream;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import io.projectglow.bgen.BgenFileIterator$;
import io.projectglow.bgen.BgenGenotypeReader;
import io.projectglow.bgen.BgenGenotypeReader$;
import io.projectglow.bgen.BgenMetadata;
import io.projectglow.common.BgenGenotype;
import io.projectglow.common.BgenRow;
import io.projectglow.common.GlowLogging;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.InputStream;
import java.io.Serializable;
import org.apache.commons.math3.util.CombinatoricsUtils;
import org.apache.hadoop.fs.FSDataInputStream;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.BufferedIterator;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Traversable;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001dg!\u0002\u000e\u001c\u0001u\t\u0003\u0002\u0003 \u0001\u0005\u0003\u0005\u000b\u0011B \t\u0011\r\u0003!\u0011!Q\u0001\n\u0011C\u0001B\u0014\u0001\u0003\u0002\u0003\u0006Ia\u0014\u0005\t7\u0002\u0011\t\u0011)A\u00059\"Aq\f\u0001B\u0001B\u0003%A\fC\u0003a\u0001\u0011\u0005\u0011\rC\u0004i\u0001\t\u0007I\u0011B5\t\r5\u0004\u0001\u0015!\u0003k\u0011\u0015q\u0007\u0001\"\u0001p\u0011\u0015\u0019\b\u0001\"\u0001u\u0011\u0015A\b\u0001\"\u0001z\u0011\u0015Q\b\u0001\"\u0003p\u0011\u0015Y\b\u0001\"\u0003}\u0011\u001d\t)\u0004\u0001C\u0005\u0003oAq!!\u0018\u0001\t\u0013\ty\u0006C\u0004\u0002l\u0001!I!!\u001c\t\u000f\u0005]\u0004\u0001\"\u0003\u0002z!1\u00111\u0013\u0001\u0005\n=Dq!!&\u0001\t\u0013\t9\nC\u0005\u0002\u001e\u0002\t\n\u0011\"\u0003\u0002 \u001eA\u0011QW\u000e\t\u0002u\t9LB\u0004\u001b7!\u0005Q$!/\t\r\u00014B\u0011AA^\u0011\u001d\tiL\u0006C\u0001\u0003\u007fC\u0011\"!2\u0017#\u0003%\t!a(\u0003!\t;WM\u001c$jY\u0016LE/\u001a:bi>\u0014(B\u0001\u000f\u001e\u0003\u0011\u0011w-\u001a8\u000b\u0005yy\u0012a\u00039s_*,7\r^4m_^T\u0011\u0001I\u0001\u0003S>\u001cB\u0001\u0001\u0012)wA\u00111EJ\u0007\u0002I)\tQ%A\u0003tG\u0006d\u0017-\u0003\u0002(I\t1\u0011I\\=SK\u001a\u00042!\u000b\u001a6\u001d\tQ\u0003G\u0004\u0002,_5\tAF\u0003\u0002.]\u00051AH]8piz\u001a\u0001!C\u0001&\u0013\t\tD%A\u0004qC\u000e\\\u0017mZ3\n\u0005M\"$\u0001C%uKJ\fGo\u001c:\u000b\u0005E\"\u0003C\u0001\u001c:\u001b\u00059$B\u0001\u001d\u001e\u0003\u0019\u0019w.\\7p]&\u0011!h\u000e\u0002\b\u0005\u001e,gNU8x!\t1D(\u0003\u0002>o\tYq\t\\8x\u0019><w-\u001b8h\u0003!iW\r^1eCR\f\u0007C\u0001!B\u001b\u0005Y\u0012B\u0001\"\u001c\u00051\u0011u-\u001a8NKR\fG-\u0019;b\u0003\u0019\u0019HO]3b[B\u0011Q\tT\u0007\u0002\r*\u0011\u0001e\u0012\u0006\u0003q!S!!\u0013&\u0002\r\u001d|wn\u001a7f\u0015\u0005Y\u0015aA2p[&\u0011QJ\u0012\u0002\u001c\u0019&$H\u000f\\3F]\u0012L\u0017M\u001c#bi\u0006Le\u000e];u'R\u0014X-Y7\u0002!UtG-\u001a:ms&twm\u0015;sK\u0006l\u0007C\u0001)Z\u001b\u0005\t&B\u0001*T\u0003\t17O\u0003\u0002U+\u00061\u0001.\u00193p_BT!AV,\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005A\u0016aA8sO&\u0011!,\u0015\u0002\u0012\rN#\u0015\r^1J]B,Ho\u0015;sK\u0006l\u0017AB7j]B{7\u000f\u0005\u0002$;&\u0011a\f\n\u0002\u0005\u0019>tw-\u0001\u0004nCb\u0004vn]\u0001\u0007y%t\u0017\u000e\u001e \u0015\r\t\u001cG-\u001a4h!\t\u0001\u0005\u0001C\u0003?\r\u0001\u0007q\bC\u0003D\r\u0001\u0007A\tC\u0003O\r\u0001\u0007q\nC\u0003\\\r\u0001\u0007A\fC\u0003`\r\u0001\u0007A,\u0001\bhK:|G/\u001f9f%\u0016\fG-\u001a:\u0016\u0003)\u0004\"\u0001Q6\n\u00051\\\"A\u0005\"hK:<UM\\8usB,'+Z1eKJ\fqbZ3o_RL\b/\u001a*fC\u0012,'\u000fI\u0001\u0005S:LG\u000fF\u0001q!\t\u0019\u0013/\u0003\u0002sI\t!QK\\5u\u0003\u001dA\u0017m\u001d(fqR$\u0012!\u001e\t\u0003GYL!a\u001e\u0013\u0003\u000f\t{w\u000e\\3b]\u0006!a.\u001a=u)\u0005)\u0014\u0001E:lSB4\u0016M]5b]R\u0014En\\2l\u00035\u0011X-\u00193HK:|G/\u001f9fgR9Q0a\u0002\u0002\u0012\u0005U\u0001\u0003B\u0015\u007f\u0003\u0003I!a \u001b\u0003\u0007M+\u0017\u000fE\u00027\u0003\u0007I1!!\u00028\u00051\u0011u-\u001a8HK:|G/\u001f9f\u0011\u001d\tI!\u0004a\u0001\u0003\u0017\t1C\\!mY\u0016dWm\u001d$s_64\u0016M]5b]R\u00042aIA\u0007\u0013\r\ty\u0001\n\u0002\u0004\u0013:$\bBBA\n\u001b\u0001\u0007A)\u0001\bhK:|G/\u001f9f'R\u0014X-Y7\t\u000f\u0005]Q\u00021\u0001\u0002\u001a\u0005I1/Y7qY\u0016LEm\u001d\t\u0006G\u0005m\u0011qD\u0005\u0004\u0003;!#AB(qi&|g\u000eE\u0003$\u0003C\t)#C\u0002\u0002$\u0011\u0012Q!\u0011:sCf\u0004B!a\n\u000209!\u0011\u0011FA\u0016!\tYC%C\u0002\u0002.\u0011\na\u0001\u0015:fI\u00164\u0017\u0002BA\u0019\u0003g\u0011aa\u0015;sS:<'bAA\u0017I\u0005\u0019\"/Z1e!\"\f7/\u001a3HK:|G/\u001f9fgRa\u0011\u0011HA\u001e\u0003\u001b\n\t&a\u0016\u0002\\A)1%!\t\u0002\u0002!9\u0011Q\b\bA\u0002\u0005}\u0012A\u00039s_\n\u001cFO]3b[B!\u0011\u0011IA%\u001b\t\t\u0019EC\u0002!\u0003\u000bR!!a\u0012\u0002\t)\fg/Y\u0005\u0005\u0003\u0017\n\u0019EA\u0005ECR\f\u0017J\u001c9vi\"9\u0011q\n\bA\u0002\u0005-\u0011\u0001\u00038BY2,G.Z:\t\u000f\u0005Mc\u00021\u0001\u0002V\u0005q\u0001\u000f\\8jIf\u0014\u0015pU1na2,\u0007\u0003B\u0015\u007f\u0003\u0017Aq!!\u0017\u000f\u0001\u0004\tY!\u0001\ncSR\u001c\b+\u001a:Qe>\u0014\u0017MY5mSRL\bbBA\f\u001d\u0001\u0007\u0011\u0011D\u0001\u0016e\u0016\fG-\u00168qQ\u0006\u001cX\rZ$f]>$\u0018\u0010]3t)1\tI$!\u0019\u0002d\u0005\u0015\u0014qMA5\u0011\u001d\tid\u0004a\u0001\u0003\u007fAq!a\u0014\u0010\u0001\u0004\tY\u0001C\u0004\u0002T=\u0001\r!!\u0016\t\u000f\u0005es\u00021\u0001\u0002\f!9\u0011qC\bA\u0002\u0005e\u0011a\u0004:fC\u0012\u0004&o\u001c2bE&d\u0017\u000e^=\u0015\u000bq\u000by'a\u001d\t\u000f\u0005E\u0004\u00031\u0001\u0002@\u0005Y\u0011N\u001c9viN#(/Z1n\u0011\u001d\t)\b\u0005a\u0001\u0003\u0017\tAAY5ug\u0006\u0001rO]5uKB\u0013xNY1cS2LG/\u001f\u000b\na\u0006m\u0014qPAB\u0003\u000fCa!! \u0012\u0001\u0004a\u0016!\u00019\t\r\u0005\u0005\u0015\u00031\u0001]\u0003\u001d!\u0017N^5t_JDq!!\"\u0012\u0001\u0004\tY!A\u0002jIbDq!!#\u0012\u0001\u0004\tY)A\u0005pkR\u0004X\u000f^!seB)1%!\t\u0002\u000eB\u00191%a$\n\u0007\u0005EEE\u0001\u0004E_V\u0014G.Z\u0001\bG2,\u0017M\\;q\u0003)\u00198.\u001b9TiJLgn\u001a\u000b\u0004a\u0006e\u0005\u0002CAN'A\u0005\t\u0019A;\u0002\u00171,gn\u001a;i\u0003NLe\u000e^\u0001\u0015g.L\u0007o\u0015;sS:<G\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005\u0005&fA;\u0002$.\u0012\u0011Q\u0015\t\u0005\u0003O\u000b\t,\u0004\u0002\u0002**!\u00111VAW\u0003%)hn\u00195fG.,GMC\u0002\u00020\u0012\n!\"\u00198o_R\fG/[8o\u0013\u0011\t\u0019,!+\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\tCO\u0016tg)\u001b7f\u0013R,'/\u0019;peB\u0011\u0001IF\n\u0003-\t\"\"!a.\u0002\u001dI,\u0017\rZ+U\rb\u001aFO]5oOR1\u0011QEAa\u0003\u0007Daa\u0011\rA\u0002\u0005}\u0002\u0002CAN1A\u0005\t\u0019A;\u00021I,\u0017\rZ+U\rb\u001aFO]5oO\u0012\"WMZ1vYR$#\u0007")
public class BgenFileIterator
implements Iterator<BgenRow>,
GlowLogging {
    private final BgenMetadata metadata;
    private final LittleEndianDataInputStream stream;
    private final FSDataInputStream underlyingStream;
    private final long minPos;
    private final long maxPos;
    private final BgenGenotypeReader genotypeReader;
    private Logger logger;
    private volatile boolean bitmap$0;

    public static boolean readUTF8String$default$2() {
        return BgenFileIterator$.MODULE$.readUTF8String$default$2();
    }

    public static String readUTF8String(DataInput dataInput, boolean bl) {
        return BgenFileIterator$.MODULE$.readUTF8String(dataInput, bl);
    }

    public Iterator<BgenRow> seq() {
        return Iterator.seq$((Iterator)this);
    }

    public boolean isEmpty() {
        return Iterator.isEmpty$((Iterator)this);
    }

    public boolean isTraversableAgain() {
        return Iterator.isTraversableAgain$((Iterator)this);
    }

    public boolean hasDefiniteSize() {
        return Iterator.hasDefiniteSize$((Iterator)this);
    }

    public Iterator<BgenRow> take(int n) {
        return Iterator.take$((Iterator)this, (int)n);
    }

    public Iterator<BgenRow> drop(int n) {
        return Iterator.drop$((Iterator)this, (int)n);
    }

    public Iterator<BgenRow> slice(int from, int until) {
        return Iterator.slice$((Iterator)this, (int)from, (int)until);
    }

    public Iterator<BgenRow> sliceIterator(int from, int until) {
        return Iterator.sliceIterator$((Iterator)this, (int)from, (int)until);
    }

    public <B> Iterator<B> map(Function1<BgenRow, B> f) {
        return Iterator.map$((Iterator)this, f);
    }

    public <B> Iterator<B> $plus$plus(Function0<GenTraversableOnce<B>> that) {
        return Iterator.$plus$plus$((Iterator)this, that);
    }

    public <B> Iterator<B> flatMap(Function1<BgenRow, GenTraversableOnce<B>> f) {
        return Iterator.flatMap$((Iterator)this, f);
    }

    public Iterator<BgenRow> filter(Function1<BgenRow, Object> p) {
        return Iterator.filter$((Iterator)this, p);
    }

    public <B> boolean corresponds(GenTraversableOnce<B> that, Function2<BgenRow, B, Object> p) {
        return Iterator.corresponds$((Iterator)this, that, p);
    }

    public Iterator<BgenRow> withFilter(Function1<BgenRow, Object> p) {
        return Iterator.withFilter$((Iterator)this, p);
    }

    public Iterator<BgenRow> filterNot(Function1<BgenRow, Object> p) {
        return Iterator.filterNot$((Iterator)this, p);
    }

    public <B> Iterator<B> collect(PartialFunction<BgenRow, B> pf) {
        return Iterator.collect$((Iterator)this, pf);
    }

    public <B> Iterator<B> scanLeft(B z, Function2<B, BgenRow, B> op) {
        return Iterator.scanLeft$((Iterator)this, z, op);
    }

    public <B> Iterator<B> scanRight(B z, Function2<BgenRow, B, B> op) {
        return Iterator.scanRight$((Iterator)this, z, op);
    }

    public Iterator<BgenRow> takeWhile(Function1<BgenRow, Object> p) {
        return Iterator.takeWhile$((Iterator)this, p);
    }

    public Tuple2<Iterator<BgenRow>, Iterator<BgenRow>> partition(Function1<BgenRow, Object> p) {
        return Iterator.partition$((Iterator)this, p);
    }

    public Tuple2<Iterator<BgenRow>, Iterator<BgenRow>> span(Function1<BgenRow, Object> p) {
        return Iterator.span$((Iterator)this, p);
    }

    public Iterator<BgenRow> dropWhile(Function1<BgenRow, Object> p) {
        return Iterator.dropWhile$((Iterator)this, p);
    }

    public <B> Iterator<Tuple2<BgenRow, B>> zip(Iterator<B> that) {
        return Iterator.zip$((Iterator)this, that);
    }

    public <A1> Iterator<A1> padTo(int len, A1 elem) {
        return Iterator.padTo$((Iterator)this, (int)len, elem);
    }

    public Iterator<Tuple2<BgenRow, Object>> zipWithIndex() {
        return Iterator.zipWithIndex$((Iterator)this);
    }

    public <B, A1, B1> Iterator<Tuple2<A1, B1>> zipAll(Iterator<B> that, A1 thisElem, B1 thatElem) {
        return Iterator.zipAll$((Iterator)this, that, thisElem, thatElem);
    }

    public <U> void foreach(Function1<BgenRow, U> f) {
        Iterator.foreach$((Iterator)this, f);
    }

    public boolean forall(Function1<BgenRow, Object> p) {
        return Iterator.forall$((Iterator)this, p);
    }

    public boolean exists(Function1<BgenRow, Object> p) {
        return Iterator.exists$((Iterator)this, p);
    }

    public boolean contains(Object elem) {
        return Iterator.contains$((Iterator)this, (Object)elem);
    }

    public Option<BgenRow> find(Function1<BgenRow, Object> p) {
        return Iterator.find$((Iterator)this, p);
    }

    public int indexWhere(Function1<BgenRow, Object> p) {
        return Iterator.indexWhere$((Iterator)this, p);
    }

    public int indexWhere(Function1<BgenRow, Object> p, int from) {
        return Iterator.indexWhere$((Iterator)this, p, (int)from);
    }

    public <B> int indexOf(B elem) {
        return Iterator.indexOf$((Iterator)this, elem);
    }

    public <B> int indexOf(B elem, int from) {
        return Iterator.indexOf$((Iterator)this, elem, (int)from);
    }

    public BufferedIterator<BgenRow> buffered() {
        return Iterator.buffered$((Iterator)this);
    }

    public <B> Iterator.GroupedIterator<B> grouped(int size) {
        return Iterator.grouped$((Iterator)this, (int)size);
    }

    public <B> Iterator.GroupedIterator<B> sliding(int size, int step) {
        return Iterator.sliding$((Iterator)this, (int)size, (int)step);
    }

    public <B> int sliding$default$2() {
        return Iterator.sliding$default$2$((Iterator)this);
    }

    public int length() {
        return Iterator.length$((Iterator)this);
    }

    public Tuple2<Iterator<BgenRow>, Iterator<BgenRow>> duplicate() {
        return Iterator.duplicate$((Iterator)this);
    }

    public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
        return Iterator.patch$((Iterator)this, (int)from, patchElems, (int)replaced);
    }

    public <B> void copyToArray(Object xs, int start, int len) {
        Iterator.copyToArray$((Iterator)this, (Object)xs, (int)start, (int)len);
    }

    public boolean sameElements(Iterator<?> that) {
        return Iterator.sameElements$((Iterator)this, that);
    }

    public Traversable<BgenRow> toTraversable() {
        return Iterator.toTraversable$((Iterator)this);
    }

    public Iterator<BgenRow> toIterator() {
        return Iterator.toIterator$((Iterator)this);
    }

    public Stream<BgenRow> toStream() {
        return Iterator.toStream$((Iterator)this);
    }

    public String toString() {
        return Iterator.toString$((Iterator)this);
    }

    public List<BgenRow> reversed() {
        return TraversableOnce.reversed$((TraversableOnce)this);
    }

    public int size() {
        return TraversableOnce.size$((TraversableOnce)this);
    }

    public boolean nonEmpty() {
        return TraversableOnce.nonEmpty$((TraversableOnce)this);
    }

    public int count(Function1<BgenRow, Object> p) {
        return TraversableOnce.count$((TraversableOnce)this, p);
    }

    public <B> Option<B> collectFirst(PartialFunction<BgenRow, B> pf) {
        return TraversableOnce.collectFirst$((TraversableOnce)this, pf);
    }

    public <B> B $div$colon(B z, Function2<B, BgenRow, B> op) {
        return (B)TraversableOnce.$div$colon$((TraversableOnce)this, z, op);
    }

    public <B> B $colon$bslash(B z, Function2<BgenRow, B, B> op) {
        return (B)TraversableOnce.$colon$bslash$((TraversableOnce)this, z, op);
    }

    public <B> B foldLeft(B z, Function2<B, BgenRow, B> op) {
        return (B)TraversableOnce.foldLeft$((TraversableOnce)this, z, op);
    }

    public <B> B foldRight(B z, Function2<BgenRow, B, B> op) {
        return (B)TraversableOnce.foldRight$((TraversableOnce)this, z, op);
    }

    public <B> B reduceLeft(Function2<B, BgenRow, B> op) {
        return (B)TraversableOnce.reduceLeft$((TraversableOnce)this, op);
    }

    public <B> B reduceRight(Function2<BgenRow, B, B> op) {
        return (B)TraversableOnce.reduceRight$((TraversableOnce)this, op);
    }

    public <B> Option<B> reduceLeftOption(Function2<B, BgenRow, B> op) {
        return TraversableOnce.reduceLeftOption$((TraversableOnce)this, op);
    }

    public <B> Option<B> reduceRightOption(Function2<BgenRow, B, B> op) {
        return TraversableOnce.reduceRightOption$((TraversableOnce)this, op);
    }

    public <A1> A1 reduce(Function2<A1, A1, A1> op) {
        return (A1)TraversableOnce.reduce$((TraversableOnce)this, op);
    }

    public <A1> Option<A1> reduceOption(Function2<A1, A1, A1> op) {
        return TraversableOnce.reduceOption$((TraversableOnce)this, op);
    }

    public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
        return (A1)TraversableOnce.fold$((TraversableOnce)this, z, op);
    }

    public <B> B aggregate(Function0<B> z, Function2<B, BgenRow, B> seqop, Function2<B, B, B> combop) {
        return (B)TraversableOnce.aggregate$((TraversableOnce)this, z, seqop, combop);
    }

    public <B> B sum(Numeric<B> num) {
        return (B)TraversableOnce.sum$((TraversableOnce)this, num);
    }

    public <B> B product(Numeric<B> num) {
        return (B)TraversableOnce.product$((TraversableOnce)this, num);
    }

    public Object min(Ordering cmp) {
        return TraversableOnce.min$((TraversableOnce)this, (Ordering)cmp);
    }

    public Object max(Ordering cmp) {
        return TraversableOnce.max$((TraversableOnce)this, (Ordering)cmp);
    }

    public Object maxBy(Function1 f, Ordering cmp) {
        return TraversableOnce.maxBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
    }

    public Object minBy(Function1 f, Ordering cmp) {
        return TraversableOnce.minBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
    }

    public <B> void copyToBuffer(Buffer<B> dest) {
        TraversableOnce.copyToBuffer$((TraversableOnce)this, dest);
    }

    public <B> void copyToArray(Object xs, int start) {
        TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs, (int)start);
    }

    public <B> void copyToArray(Object xs) {
        TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs);
    }

    public <B> Object toArray(ClassTag<B> evidence$1) {
        return TraversableOnce.toArray$((TraversableOnce)this, evidence$1);
    }

    public List<BgenRow> toList() {
        return TraversableOnce.toList$((TraversableOnce)this);
    }

    public Iterable<BgenRow> toIterable() {
        return TraversableOnce.toIterable$((TraversableOnce)this);
    }

    public Seq<BgenRow> toSeq() {
        return TraversableOnce.toSeq$((TraversableOnce)this);
    }

    public IndexedSeq<BgenRow> toIndexedSeq() {
        return TraversableOnce.toIndexedSeq$((TraversableOnce)this);
    }

    public <B> Buffer<B> toBuffer() {
        return TraversableOnce.toBuffer$((TraversableOnce)this);
    }

    public <B> Set<B> toSet() {
        return TraversableOnce.toSet$((TraversableOnce)this);
    }

    public Vector<BgenRow> toVector() {
        return TraversableOnce.toVector$((TraversableOnce)this);
    }

    public <Col> Col to(CanBuildFrom<Nothing$, BgenRow, Col> cbf) {
        return (Col)TraversableOnce.to$((TraversableOnce)this, cbf);
    }

    public <T, U> Map<T, U> toMap(Predef.$less$colon$less<BgenRow, Tuple2<T, U>> ev) {
        return TraversableOnce.toMap$((TraversableOnce)this, ev);
    }

    public String mkString(String start, String sep, String end) {
        return TraversableOnce.mkString$((TraversableOnce)this, (String)start, (String)sep, (String)end);
    }

    public String mkString(String sep) {
        return TraversableOnce.mkString$((TraversableOnce)this, (String)sep);
    }

    public String mkString() {
        return TraversableOnce.mkString$((TraversableOnce)this);
    }

    public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
        return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
    }

    public StringBuilder addString(StringBuilder b, String sep) {
        return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)sep);
    }

    public StringBuilder addString(StringBuilder b) {
        return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b);
    }

    public int sizeHintIfCheap() {
        return GenTraversableOnce.sizeHintIfCheap$((GenTraversableOnce)this);
    }

    private Logger logger$lzycompute() {
        BgenFileIterator bgenFileIterator = this;
        synchronized (bgenFileIterator) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    private BgenGenotypeReader genotypeReader() {
        return this.genotypeReader;
    }

    public void init() {
        while (this.underlyingStream.getPos() < this.minPos) {
            this.skipVariantBlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    public boolean hasNext() {
        void var1_1;
        block0: {
            boolean ret;
            boolean bl = ret = this.underlyingStream.getPos() < this.maxPos;
            if (ret) break block0;
            this.cleanup();
        }
        return (boolean)var1_1;
    }

    public BgenRow next() {
        String variantId = BgenFileIterator$.MODULE$.readUTF8String((DataInput)this.stream, BgenFileIterator$.MODULE$.readUTF8String$default$2());
        String rsid = BgenFileIterator$.MODULE$.readUTF8String((DataInput)this.stream, BgenFileIterator$.MODULE$.readUTF8String$default$2());
        String contigName = BgenFileIterator$.MODULE$.readUTF8String((DataInput)this.stream, BgenFileIterator$.MODULE$.readUTF8String$default$2());
        long start = Integer.toUnsignedLong(this.stream.readInt()) - 1L;
        int nAlleles = this.stream.readUnsignedShort();
        IndexedSeq alleles = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), nAlleles).map((Function1 & Serializable & scala.Serializable)x$1 -> BgenFileIterator$.MODULE$.readUTF8String((DataInput)this.stream, true), IndexedSeq$.MODULE$.canBuildFrom());
        byte[] genotypeBytes = this.genotypeReader().readGenotypeBlock((DataInput)this.stream);
        DataInputStream rawGenotypeStream = new DataInputStream(new ByteArrayInputStream(genotypeBytes));
        LittleEndianDataInputStream genotypeStream = new LittleEndianDataInputStream((InputStream)rawGenotypeStream);
        Seq<BgenGenotype> genotypes = this.readGenotypes(nAlleles, genotypeStream, this.metadata.sampleIds());
        return new BgenRow(contigName, start, start + (long)((String)alleles.head()).length(), (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{variantId, rsid}))), (String)alleles.head(), (Seq<String>)((Seq)alleles.tail()), genotypes);
    }

    private void skipVariantBlock() {
        this.skipString(this.skipString$default$1());
        this.skipString(this.skipString$default$1());
        this.skipString(this.skipString$default$1());
        this.stream.readInt();
        int nAlleles = this.stream.readUnsignedShort();
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), nAlleles).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$2 -> this.skipString(true));
        long probabilityBlockSize = Integer.toUnsignedLong(this.stream.readInt());
        this.stream.skip(probabilityBlockSize);
    }

    private Seq<BgenGenotype> readGenotypes(int nAllelesFromVariant, LittleEndianDataInputStream genotypeStream, Option<String[]> sampleIds) {
        BoxedUnit boxedUnit;
        int nSamples = genotypeStream.readInt();
        int nAlleles = genotypeStream.readUnsignedShort();
        if (nAlleles != nAllelesFromVariant) {
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn(new java.lang.StringBuilder(75).append("Number of alleles in genotype block did not match variant identifier block ").append(new java.lang.StringBuilder(40).append("(").append(nAlleles).append(" vs ").append(nAllelesFromVariant).append("). Using value from genotype block.").toString()).toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        int minPloidy = genotypeStream.readUnsignedByte();
        int maxPloidy = genotypeStream.readUnsignedByte();
        int[] ploidyWithMissingnessBySample = new int[nSamples];
        for (int i = 0; i < nSamples; ++i) {
            ploidyWithMissingnessBySample[i] = genotypeStream.readUnsignedByte();
        }
        int phasedByte = genotypeStream.readUnsignedByte();
        boolean phased = phasedByte == 1;
        int bitsPerProbability = genotypeStream.readUnsignedByte();
        return phased ? Predef$.MODULE$.wrapRefArray((Object[])this.readPhasedGenotypes((DataInput)genotypeStream, nAlleles, (Seq<Object>)Predef$.MODULE$.wrapIntArray(ploidyWithMissingnessBySample), bitsPerProbability, sampleIds)) : Predef$.MODULE$.wrapRefArray((Object[])this.readUnphasedGenotypes((DataInput)genotypeStream, nAlleles, (Seq<Object>)Predef$.MODULE$.wrapIntArray(ploidyWithMissingnessBySample), bitsPerProbability, sampleIds));
    }

    private BgenGenotype[] readPhasedGenotypes(DataInput probStream, int nAlleles, Seq<Object> ploidyBySample, int bitsPerProbability, Option<String[]> sampleIds) {
        BgenGenotype[] output = new BgenGenotype[ploidyBySample.size()];
        int divisor = (1 << bitsPerProbability) - 1;
        int j = 0;
        int k = 0;
        for (int i = 0; i < ploidyBySample.length(); ++i) {
            int ploidyWithMissingness = BoxesRunTime.unboxToInt((Object)ploidyBySample.apply(i));
            int ploidy = ploidyWithMissingness & 0x3F;
            int numValues = ploidy * nAlleles;
            double[] probabilityBuffer = new double[ploidyWithMissingness > 63 ? 0 : numValues];
            for (j = 0; j < ploidy; ++j) {
                long sum = 0L;
                for (k = 0; k < nAlleles - 1; ++k) {
                    long nextInt = this.readProbability(probStream, bitsPerProbability);
                    sum += nextInt;
                    this.writeProbability(nextInt, divisor, j * nAlleles + k, probabilityBuffer);
                }
                this.writeProbability((long)divisor - sum, divisor, j * nAlleles + k, probabilityBuffer);
            }
            None$ sampleId = sampleIds.isDefined() ? Option$.MODULE$.apply((Object)((String[])sampleIds.get())[i]) : None$.MODULE$;
            output[i] = new BgenGenotype((Option<String>)sampleId, (Option<Object>)Option$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)true)), (Option<Object>)Option$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)ploidy)), (Seq<Object>)Predef$.MODULE$.wrapDoubleArray(probabilityBuffer));
        }
        return output;
    }

    private BgenGenotype[] readUnphasedGenotypes(DataInput probStream, int nAlleles, Seq<Object> ploidyBySample, int bitsPerProbability, Option<String[]> sampleIds) {
        BgenGenotype[] output = new BgenGenotype[ploidyBySample.size()];
        long divisor = (1L << bitsPerProbability) - 1L;
        for (int i = 0; i < ploidyBySample.length(); ++i) {
            int j;
            int ploidyWithMissingness = BoxesRunTime.unboxToInt((Object)ploidyBySample.apply(i));
            int ploidy = ploidyWithMissingness & 0x3F;
            int nCombs = (int)CombinatoricsUtils.binomialCoefficient((int)(ploidy + nAlleles - 1), (int)ploidy);
            double[] probabilityBuffer = new double[ploidyWithMissingness > 63 ? 0 : nCombs];
            long sum = 0L;
            for (j = 0; j < nCombs - 1; ++j) {
                long nextInt = this.readProbability(probStream, bitsPerProbability);
                sum += nextInt;
                this.writeProbability(nextInt, divisor, j, probabilityBuffer);
            }
            this.writeProbability(divisor - sum, divisor, j, probabilityBuffer);
            None$ sampleId = sampleIds.isDefined() ? Option$.MODULE$.apply((Object)((String[])sampleIds.get())[i]) : None$.MODULE$;
            output[i] = new BgenGenotype((Option<String>)sampleId, (Option<Object>)Option$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)false)), (Option<Object>)Option$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)ploidy)), (Seq<Object>)Predef$.MODULE$.wrapDoubleArray(probabilityBuffer));
        }
        return output;
    }

    private long readProbability(DataInput inputStream, int bits) {
        long l;
        int n = bits;
        switch (n) {
            case 8: {
                l = inputStream.readUnsignedByte();
                break;
            }
            case 16: {
                l = inputStream.readUnsignedShort();
                break;
            }
            case 32: {
                l = Integer.toUnsignedLong(inputStream.readInt());
                break;
            }
            default: {
                throw new IllegalArgumentException("Only probabilities of 8, 16, or 32 bits are accepted");
            }
        }
        return l;
    }

    private void writeProbability(long p, long divisor, int idx, double[] outputArr) {
        if (outputArr.length == 0) {
            return;
        }
        outputArr[idx] = (double)p / (double)divisor;
    }

    private void cleanup() {
        this.underlyingStream.close();
    }

    private void skipString(boolean lengthAsInt) {
        int len = lengthAsInt ? this.stream.readInt() : this.stream.readUnsignedShort();
        this.stream.skipBytes(len);
    }

    private boolean skipString$default$1() {
        return false;
    }

    public BgenFileIterator(BgenMetadata metadata, LittleEndianDataInputStream stream, FSDataInputStream underlyingStream, long minPos, long maxPos) {
        this.metadata = metadata;
        this.stream = stream;
        this.underlyingStream = underlyingStream;
        this.minPos = minPos;
        this.maxPos = maxPos;
        GenTraversableOnce.$init$((GenTraversableOnce)this);
        TraversableOnce.$init$((TraversableOnce)this);
        Iterator.$init$((Iterator)this);
        LazyLogging.$init$((LazyLogging)this);
        this.genotypeReader = BgenGenotypeReader$.MODULE$.fromCompressionType(metadata.compressionType());
    }
}

