/*
 * Decompiled with CFR 0.152.
 */
package io.projectglow.bgen;

import com.google.common.io.CountingOutputStream;
import com.google.common.io.LittleEndianDataOutputStream;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import io.projectglow.bgen.BgenHeaderWriter;
import io.projectglow.bgen.BgenRecordWriter$;
import io.projectglow.bgen.GenotypeCharacteristics;
import io.projectglow.bgen.InternalRowToBgenRowConverter;
import io.projectglow.bgen.ProbabilityBlockSize;
import io.projectglow.common.BgenGenotype;
import io.projectglow.common.BgenRow;
import io.projectglow.common.GlowLogging;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\t-b\u0001B\u0015+\u0001EB\u0001B\u0010\u0001\u0003\u0002\u0003\u0006Ia\u0010\u0005\t\r\u0002\u0011\t\u0011)A\u0005\u000f\"AQ\u000b\u0001B\u0001B\u0003%a\u000b\u0003\u0005Z\u0001\t\u0005\t\u0015!\u0003[\u0011!i\u0006A!A!\u0002\u0013q\u0006\u0002C1\u0001\u0005\u0003\u0005\u000b\u0011\u00020\t\u0011\t\u0004!\u0011!Q\u0001\nyC\u0001b\u0019\u0001\u0003\u0002\u0003\u0006IA\u0016\u0005\u0006I\u0002!\t!\u001a\u0005\ba\u0002\u0011\r\u0011\"\u0001r\u0011\u0019)\b\u0001)A\u0005e\"9a\u000f\u0001b\u0001\n\u00039\bbBA\u0003\u0001\u0001\u0006I\u0001\u001f\u0005\n\u0003\u000f\u0001!\u0019!C\u0001\u0003\u0013A\u0001\"a\u0006\u0001A\u0003%\u00111\u0002\u0005\n\u00033\u0001!\u0019!C\u0001\u00037A\u0001\"!\u000e\u0001A\u0003%\u0011Q\u0004\u0005\n\u0003o\u0001!\u0019!C\u0001\u0003sAq!a\u000f\u0001A\u0003%a\fC\u0005\u0002>\u0001\u0001\r\u0011\"\u0001\u0002@!I\u0011\u0011\t\u0001A\u0002\u0013\u0005\u00111\t\u0005\b\u0003\u0013\u0002\u0001\u0015)\u0003W\u0011\u001d\tY\u0005\u0001C\u0005\u0003\u007fAq!!\u0014\u0001\t\u0013\ty\u0005C\u0004\u0002\u0004\u0002!I!!\"\t\u000f\u0005\u001d\u0005\u0001\"\u0003\u0002\n\"9\u0011Q\u0013\u0001\u0005\u0002\u0005]\u0005bBAW\u0001\u0011\u0005\u0011q\u0016\u0005\b\u0003g\u0003A\u0011AA[\u0011\u001d\t)\r\u0001C\u0001\u0003\u000b;q!a2+\u0011\u0003\tIM\u0002\u0004*U!\u0005\u00111\u001a\u0005\u0007I\u0002\"\t!!4\t\u000f\u0005=\u0007\u0005\"\u0001\u0002R\"9\u0011q\u001c\u0011\u0005\u0002\u0005\u0005\bbBAyA\u0011\u0005\u00111\u001f\u0005\b\u0003s\u0004C\u0011AA~\u0011\u001d\u0011\t\u0001\tC\u0001\u0005\u0007AqAa\u0004!\t\u0003\u0011\t\u0002C\u0004\u0003\u0018\u0001\"\tA!\u0007\u0003!\t;WM\u001c*fG>\u0014Hm\u0016:ji\u0016\u0014(BA\u0016-\u0003\u0011\u0011w-\u001a8\u000b\u00055r\u0013a\u00039s_*,7\r^4m_^T\u0011aL\u0001\u0003S>\u001c\u0001aE\u0002\u0001ea\u0002\"a\r\u001c\u000e\u0003QR\u0011!N\u0001\u0006g\u000e\fG.Y\u0005\u0003oQ\u0012a!\u00118z%\u00164\u0007CA\u001d=\u001b\u0005Q$BA\u001e-\u0003\u0019\u0019w.\\7p]&\u0011QH\u000f\u0002\f\u000f2|w\u000fT8hO&tw-\u0001\u0007pkR\u0004X\u000f^*ue\u0016\fW\u000e\u0005\u0002A\t6\t\u0011I\u0003\u00020\u0005*\t1)\u0001\u0003kCZ\f\u0017BA#B\u00051yU\u000f\u001e9viN#(/Z1n\u0003\u0019\u00198\r[3nCB\u0011\u0001jU\u0007\u0002\u0013*\u0011!jS\u0001\u0006if\u0004Xm\u001d\u0006\u0003\u00196\u000b1a]9m\u0015\tqu*A\u0003ta\u0006\u00148N\u0003\u0002Q#\u00061\u0011\r]1dQ\u0016T\u0011AU\u0001\u0004_J<\u0017B\u0001+J\u0005)\u0019FO];diRK\b/Z\u0001\foJLG/\u001a%fC\u0012,'\u000f\u0005\u00024/&\u0011\u0001\f\u000e\u0002\b\u0005>|G.Z1o\u0003-qW/\u001c,be&\fg\u000e^:\u0011\u0005MZ\u0016B\u0001/5\u0005\u0011auN\\4\u0002\u0017\tLGo\u001d)feB\u0013xN\u0019\t\u0003g}K!\u0001\u0019\u001b\u0003\u0007%sG/A\u0005nCb\u0004Fn\\5es\u0006iA-\u001a4bk2$\b\u000b\\8jIf\fa\u0002Z3gCVdG\u000f\u00155bg&tw-\u0001\u0004=S:LGO\u0010\u000b\nM\"L'n\u001b7n]>\u0004\"a\u001a\u0001\u000e\u0003)BQAP\u0005A\u0002}BQAR\u0005A\u0002\u001dCQ!V\u0005A\u0002YCQ!W\u0005A\u0002iCQ!X\u0005A\u0002yCQ!Y\u0005A\u0002yCQAY\u0005A\u0002yCQaY\u0005A\u0002Y\u000b\u0011bY8om\u0016\u0014H/\u001a:\u0016\u0003I\u0004\"aZ:\n\u0005QT#!H%oi\u0016\u0014h.\u00197S_^$vNQ4f]J{woQ8om\u0016\u0014H/\u001a:\u0002\u0015\r|gN^3si\u0016\u0014\b%\u0001\u0004tiJ,\u0017-\\\u000b\u0002qB\u0019\u00110!\u0001\u000e\u0003iT!aL>\u000b\u0005mb(BA?\u007f\u0003\u00199wn\\4mK*\tq0A\u0002d_6L1!a\u0001{\u0005qa\u0015\u000e\u001e;mK\u0016sG-[1o\t\u0006$\u0018mT;uaV$8\u000b\u001e:fC6\fqa\u001d;sK\u0006l\u0007%A\tqe>\u0014\u0017MY5mSRLxK]5uKJ,\"!a\u0003\u0011\u000fM\niA\u0017=\u0002\u0012%\u0019\u0011q\u0002\u001b\u0003\u0013\u0019+hn\u0019;j_:\u0014\u0004cA\u001a\u0002\u0014%\u0019\u0011Q\u0003\u001b\u0003\tUs\u0017\u000e^\u0001\u0013aJ|'-\u00192jY&$\u0018p\u0016:ji\u0016\u0014\b%\u0001\tqe>\u0014'\t\\8dWNK'0Z'baV\u0011\u0011Q\u0004\t\t\u0003?\t)#!\u000b\u000205\u0011\u0011\u0011\u0005\u0006\u0004\u0003G\u0011\u0015\u0001B;uS2LA!a\n\u0002\"\t9\u0001*Y:i\u001b\u0006\u0004\bcA4\u0002,%\u0019\u0011Q\u0006\u0016\u0003/\u001d+gn\u001c;za\u0016\u001c\u0005.\u0019:bGR,'/[:uS\u000e\u001c\bcA4\u00022%\u0019\u00111\u0007\u0016\u0003)A\u0013xNY1cS2LG/\u001f\"m_\u000e\\7+\u001b>f\u0003E\u0001(o\u001c2CY>\u001c7nU5{K6\u000b\u0007\u000fI\u0001\tEV4gmU5{KV\ta,A\u0005ck\u001a47+\u001b>fA\u0005!\u0002.Z1eKJD\u0015m\u001d\"fK:<&/\u001b;uK:,\u0012AV\u0001\u0019Q\u0016\fG-\u001a:ICN\u0014U-\u001a8Xe&$H/\u001a8`I\u0015\fH\u0003BA\t\u0003\u000bB\u0001\"a\u0012\u0016\u0003\u0003\u0005\rAV\u0001\u0004q\u0012\n\u0014!\u00065fC\u0012,'\u000fS1t\u0005\u0016,gn\u0016:jiR,g\u000eI\u0001\u0012g\"|W\u000f\u001c3Xe&$X\rS3bI\u0016\u0014\u0018\u0001E7bs\n,wK]5uK\"+\u0017\rZ3s)\u0011\t\t\"!\u0015\t\u000f\u0005M\u0003\u00041\u0001\u0002V\u0005I1/Y7qY\u0016LEm\u001d\t\u0007\u0003/\n9'!\u001c\u000f\t\u0005e\u00131\r\b\u0005\u00037\n\t'\u0004\u0002\u0002^)\u0019\u0011q\f\u0019\u0002\rq\u0012xn\u001c;?\u0013\u0005)\u0014bAA3i\u00059\u0001/Y2lC\u001e,\u0017\u0002BA5\u0003W\u00121aU3r\u0015\r\t)\u0007\u000e\t\u0006g\u0005=\u00141O\u0005\u0004\u0003c\"$AB(qi&|g\u000e\u0005\u0003\u0002v\u0005ud\u0002BA<\u0003s\u00022!a\u00175\u0013\r\tY\bN\u0001\u0007!J,G-\u001a4\n\t\u0005}\u0014\u0011\u0011\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005mD'\u0001\u000fnCf\u0014Wm\u0016:ji\u0016DU-\u00193fe\u001a{'/R7qif4\u0015\u000e\\3\u0015\u0005\u0005E\u0011\u0001H<sSR,g+\u0019:jC:$\u0018\nZ3oi&4\u00170\u001b8h\u00052|7m\u001b\u000b\u0005\u0003#\tY\tC\u0004\u0002\u000ej\u0001\r!a$\u0002\u0007I|w\u000fE\u0002:\u0003#K1!a%;\u0005\u001d\u0011u-\u001a8S_^\fAeZ3u\u0007>l\u0007O]3tg\u0016$w)\u001a8pif\u0004X\r\u0015:pE\u0006\u0014\u0017\u000e\\5us\u0012\u000bG/\u0019\u000b\u0005\u00033\u000bY\u000b\u0005\u00044\u00037s\u0016qT\u0005\u0004\u0003;#$A\u0002+va2,'\u0007E\u00034\u0003C\u000b)+C\u0002\u0002$R\u0012Q!\u0011:sCf\u00042aMAT\u0013\r\tI\u000b\u000e\u0002\u0005\u0005f$X\rC\u0004\u0002\u000en\u0001\r!a$\u0002-]\u0014\u0018\u000e^3HK:|G/\u001f9f\t\u0006$\u0018M\u00117pG.$B!!\u0005\u00022\"9\u0011Q\u0012\u000fA\u0002\u0005=\u0015!B<sSR,G\u0003BA\t\u0003oCq!!$\u001e\u0001\u0004\tI\f\u0005\u0003\u0002<\u0006\u0005WBAA_\u0015\r\tylS\u0001\tG\u0006$\u0018\r\\=ti&!\u00111YA_\u0005-Ie\u000e^3s]\u0006d'k\\<\u0002\u000b\rdwn]3\u0002!\t;WM\u001c*fG>\u0014Hm\u0016:ji\u0016\u0014\bCA4!'\t\u0001#\u0007\u0006\u0002\u0002J\u00061Q.\u001b8NCb$b!a5\u0002V\u0006m\u0007#B\u001a\u0002\u001czs\u0006bBAlE\u0001\u0007\u0011\u0011\\\u0001\u0002CB)\u0011qKA4=\"1\u0011Q\u001c\u0012A\u0002y\u000bq\u0001Z3gCVdG/A\txe&$X-\u00168tS\u001etW\r\u001a\"zi\u0016$b!!\u0005\u0002d\u0006\u001d\bBBAsG\u0001\u0007!,A\u0001m\u0011\u001d\tIo\ta\u0001\u0003W\faa\\;uaV$\bc\u0001!\u0002n&\u0019\u0011q^!\u0003\u0015\u0011\u000bG/Y(viB,H/\u0001\nxe&$X-\u00168tS\u001etW\rZ*i_J$HCBA\t\u0003k\f9\u0010\u0003\u0004\u0002f\u0012\u0002\rA\u0017\u0005\b\u0003S$\u0003\u0019AAv\u0003A9(/\u001b;f+:\u001c\u0018n\u001a8fI&sG\u000f\u0006\u0004\u0002\u0012\u0005u\u0018q \u0005\u0007\u0003K,\u0003\u0019\u0001.\t\u000f\u0005%X\u00051\u0001\u0002l\u0006yqO]5uKV#f\tO*ue&tw\r\u0006\u0005\u0002\u0012\t\u0015!\u0011\u0002B\u0007\u0011\u001d\u00119A\na\u0001\u0003g\n\u0011a\u001d\u0005\u0007\u0005\u00171\u0003\u0019\u0001,\u0002\u00171,gn\u001a;i\u0003NLe\u000e\u001e\u0005\b\u0003S4\u0003\u0019AAv\u0003]9W\r\u001e)s_\n\f'-\u001b7jif\u0014En\\2l'&TX\r\u0006\u0003\u00020\tM\u0001b\u0002B\u000bO\u0001\u0007\u0011\u0011F\u0001\u0003O\u000e\f\u0011dY1mGVd\u0017\r^3J]R\u0004&o\u001c2bE&d\u0017\u000e^5fgR1!1\u0004B\u000f\u0005?\u0001R!a\u0016\u0002hiCQ!\u0018\u0015A\u0002yCqA!\t)\u0001\u0004\u0011\u0019#A\u0007qe>\u0014\u0017MY5mSRLWm\u001d\t\u0007\u0003/\n9G!\n\u0011\u0007M\u00129#C\u0002\u0003*Q\u0012a\u0001R8vE2,\u0007")
public class BgenRecordWriter
implements GlowLogging {
    private final OutputStream outputStream;
    private final boolean writeHeader;
    private final long numVariants;
    private final int bitsPerProb;
    private final int defaultPloidy;
    private final boolean defaultPhasing;
    private final InternalRowToBgenRowConverter converter;
    private final LittleEndianDataOutputStream stream;
    private final Function2<Object, LittleEndianDataOutputStream, BoxedUnit> probabilityWriter;
    private final HashMap<GenotypeCharacteristics, ProbabilityBlockSize> probBlockSizeMap;
    private final int buffSize;
    private boolean headerHasBeenWritten;
    private Logger logger;
    private volatile boolean bitmap$0;

    public static Seq<Object> calculateIntProbabilities(int n, Seq<Object> seq) {
        return BgenRecordWriter$.MODULE$.calculateIntProbabilities(n, seq);
    }

    public static ProbabilityBlockSize getProbabilityBlockSize(GenotypeCharacteristics genotypeCharacteristics) {
        return BgenRecordWriter$.MODULE$.getProbabilityBlockSize(genotypeCharacteristics);
    }

    public static void writeUTF8String(String string, boolean bl, DataOutput dataOutput) {
        BgenRecordWriter$.MODULE$.writeUTF8String(string, bl, dataOutput);
    }

    public static void writeUnsignedInt(long l, DataOutput dataOutput) {
        BgenRecordWriter$.MODULE$.writeUnsignedInt(l, dataOutput);
    }

    public static void writeUnsignedShort(long l, DataOutput dataOutput) {
        BgenRecordWriter$.MODULE$.writeUnsignedShort(l, dataOutput);
    }

    public static void writeUnsignedByte(long l, DataOutput dataOutput) {
        BgenRecordWriter$.MODULE$.writeUnsignedByte(l, dataOutput);
    }

    public static Tuple2<Object, Object> minMax(Seq<Object> seq, int n) {
        return BgenRecordWriter$.MODULE$.minMax(seq, n);
    }

    private Logger logger$lzycompute() {
        BgenRecordWriter bgenRecordWriter = this;
        synchronized (bgenRecordWriter) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    public InternalRowToBgenRowConverter converter() {
        return this.converter;
    }

    public LittleEndianDataOutputStream stream() {
        return this.stream;
    }

    public Function2<Object, LittleEndianDataOutputStream, BoxedUnit> probabilityWriter() {
        return this.probabilityWriter;
    }

    public HashMap<GenotypeCharacteristics, ProbabilityBlockSize> probBlockSizeMap() {
        return this.probBlockSizeMap;
    }

    public int buffSize() {
        return this.buffSize;
    }

    public boolean headerHasBeenWritten() {
        return this.headerHasBeenWritten;
    }

    public void headerHasBeenWritten_$eq(boolean x$1) {
        this.headerHasBeenWritten = x$1;
    }

    private boolean shouldWriteHeader() {
        return this.writeHeader && !this.headerHasBeenWritten();
    }

    private void maybeWriteHeader(Seq<Option<String>> sampleIds) {
        block0: {
            if (!this.shouldWriteHeader()) break block0;
            BgenHeaderWriter headerWriter = new BgenHeaderWriter(this.stream(), this.numVariants, sampleIds);
            headerWriter.writeHeader();
            this.headerHasBeenWritten_$eq(true);
        }
    }

    private void maybeWriteHeaderForEmptyFile() {
        block2: {
            BoxedUnit boxedUnit;
            if (!this.shouldWriteHeader()) break block2;
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Writing header for empty file");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BgenHeaderWriter headerWriter = new BgenHeaderWriter(this.stream(), this.numVariants, (Seq<Option<String>>)Nil$.MODULE$);
            headerWriter.writeHeader();
            this.headerHasBeenWritten_$eq(true);
        }
    }

    private void writeVariantIdentifyingBlock(BgenRow row) {
        BgenRecordWriter$.MODULE$.writeUTF8String((String)row.names().headOption().getOrElse((Function0 & Serializable & scala.Serializable)() -> ""), false, (DataOutput)this.stream());
        BgenRecordWriter$.MODULE$.writeUTF8String((String)((Option)row.names().lift().apply((Object)BoxesRunTime.boxToInteger((int)1))).getOrElse((Function0 & Serializable & scala.Serializable)() -> ""), false, (DataOutput)this.stream());
        BgenRecordWriter$.MODULE$.writeUTF8String(row.contigName(), false, (DataOutput)this.stream());
        BgenRecordWriter$.MODULE$.writeUnsignedInt((int)row.start() + 1, (DataOutput)this.stream());
        BgenRecordWriter$.MODULE$.writeUnsignedShort(1 + row.alternateAlleles().length(), (DataOutput)this.stream());
        BgenRecordWriter$.MODULE$.writeUTF8String(row.referenceAllele(), true, (DataOutput)this.stream());
        row.alternateAlleles().foreach((Function1 & Serializable & scala.Serializable)aa -> {
            BgenRecordWriter$.MODULE$.writeUTF8String(aa, true, (DataOutput)this.stream());
            return BoxedUnit.UNIT;
        });
    }

    public Tuple2<Object, byte[]> getCompressedGenotypeProbabilityData(BgenRow row) {
        int gtIdx;
        ByteArrayOutputStream baos = new ByteArrayOutputStream(this.buffSize());
        DeflaterOutputStream dos = new DeflaterOutputStream((OutputStream)baos, new Deflater(), this.buffSize());
        CountingOutputStream cos = new CountingOutputStream((OutputStream)dos);
        BufferedOutputStream bos = new BufferedOutputStream((OutputStream)cos, this.buffSize());
        LittleEndianDataOutputStream ledos = new LittleEndianDataOutputStream((OutputStream)bos);
        BgenRecordWriter$.MODULE$.writeUnsignedInt(row.genotypes().length(), (DataOutput)ledos);
        int numAlleles = row.alternateAlleles().length() + 1;
        BgenRecordWriter$.MODULE$.writeUnsignedShort(numAlleles, (DataOutput)ledos);
        Tuple2<Object, Object> tuple2 = BgenRecordWriter$.MODULE$.minMax((Seq<Object>)((Seq)row.genotypes().map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)BgenRecordWriter.$anonfun$getCompressedGenotypeProbabilityData$1(x$1)), Seq$.MODULE$.canBuildFrom())), this.defaultPloidy);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        int minPloidy = tuple2._1$mcI$sp();
        int maxPloidy = tuple2._2$mcI$sp();
        Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(minPloidy, maxPloidy);
        Tuple2.mcII.sp sp3 = sp2;
        int minPloidy2 = sp3._1$mcI$sp();
        int maxPloidy2 = sp3._2$mcI$sp();
        ledos.writeByte(minPloidy2);
        ledos.writeByte(maxPloidy2);
        for (gtIdx = 0; gtIdx < row.genotypes().length(); ++gtIdx) {
            BgenGenotype gt = (BgenGenotype)row.genotypes().apply(gtIdx);
            int missingness = gt.posteriorProbabilities().isEmpty() ? 1 : 0;
            ledos.writeByte(BoxesRunTime.unboxToInt((Object)gt.ploidy().get()) + (missingness << 6));
        }
        boolean phased = row.genotypes().nonEmpty() ? BoxesRunTime.unboxToBoolean((Object)((BgenGenotype)row.genotypes().head()).phased().get()) : this.defaultPhasing;
        int phasedByte = phased ? 1 : 0;
        ledos.writeByte(phasedByte);
        ledos.writeByte(this.bitsPerProb);
        for (gtIdx = 0; gtIdx < row.genotypes().length(); ++gtIdx) {
            ProbabilityBlockSize probabilityBlockSize;
            BgenGenotype gt = (BgenGenotype)row.genotypes().apply(gtIdx);
            GenotypeCharacteristics gc = new GenotypeCharacteristics(numAlleles, phased, BoxesRunTime.unboxToInt((Object)gt.ploidy().get()));
            if (this.probBlockSizeMap().containsKey(gc)) {
                probabilityBlockSize = this.probBlockSizeMap().get(gc);
            } else {
                ProbabilityBlockSize probBlockSizeValue = BgenRecordWriter$.MODULE$.getProbabilityBlockSize(gc);
                this.probBlockSizeMap().put(gc, probBlockSizeValue);
                probabilityBlockSize = probBlockSizeValue;
            }
            ProbabilityBlockSize probBlockSize = probabilityBlockSize;
            Seq xList = gt.posteriorProbabilities().isEmpty() ? new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps((long[])Array$.MODULE$.fill(probBlockSize.probabilitiesPerBlock() * probBlockSize.numBlocks(), (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L, ClassTag$.MODULE$.Long()))).toSeq() : BgenRecordWriter$.MODULE$.calculateIntProbabilities(this.bitsPerProb, gt.posteriorProbabilities());
            int bpi = 0;
            for (int bi = 0; bi < probBlockSize.numBlocks(); ++bi) {
                while (bpi < probBlockSize.probabilitiesPerBlock() - 1) {
                    this.probabilityWriter().apply(xList.apply(bi * probBlockSize.probabilitiesPerBlock() + bpi), (Object)ledos);
                    ++bpi;
                }
                bpi = 0;
            }
        }
        ledos.close();
        cos.close();
        bos.close();
        dos.close();
        baos.close();
        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)((int)cos.getCount())), (Object)baos.toByteArray());
    }

    public void writeGenotypeDataBlock(BgenRow row) {
        Tuple2<Object, byte[]> tuple2 = this.getCompressedGenotypeProbabilityData(row);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        int uncompressedLength = tuple2._1$mcI$sp();
        byte[] compressedGdp = (byte[])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)uncompressedLength), (Object)compressedGdp);
        Tuple2 tuple23 = tuple22;
        int uncompressedLength2 = tuple23._1$mcI$sp();
        byte[] compressedGdp2 = (byte[])tuple23._2();
        BgenRecordWriter$.MODULE$.writeUnsignedInt(4 + compressedGdp2.length, (DataOutput)this.stream());
        BgenRecordWriter$.MODULE$.writeUnsignedInt(uncompressedLength2, (DataOutput)this.stream());
        this.stream().write(compressedGdp2);
    }

    public void write(InternalRow row) {
        BgenRow bgenRow = this.converter().convert(row);
        this.maybeWriteHeader((Seq<Option<String>>)((Seq)bgenRow.genotypes().map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.sampleId(), Seq$.MODULE$.canBuildFrom())));
        this.writeVariantIdentifyingBlock(bgenRow);
        this.writeGenotypeDataBlock(bgenRow);
    }

    public void close() {
        this.maybeWriteHeaderForEmptyFile();
        this.stream().close();
        this.outputStream.close();
    }

    public static final /* synthetic */ int $anonfun$getCompressedGenotypeProbabilityData$1(BgenGenotype x$1) {
        return BoxesRunTime.unboxToInt((Object)x$1.ploidy().get());
    }

    public BgenRecordWriter(OutputStream outputStream, StructType schema, boolean writeHeader, long numVariants, int bitsPerProb, int maxPloidy, int defaultPloidy, boolean defaultPhasing) {
        Function2 & Serializable & scala.Serializable intersect;
        this.outputStream = outputStream;
        this.writeHeader = writeHeader;
        this.numVariants = numVariants;
        this.bitsPerProb = bitsPerProb;
        this.defaultPloidy = defaultPloidy;
        this.defaultPhasing = defaultPhasing;
        LazyLogging.$init$((LazyLogging)this);
        this.converter = new InternalRowToBgenRowConverter(schema, maxPloidy, defaultPloidy, defaultPhasing);
        this.stream = new LittleEndianDataOutputStream(outputStream);
        int n = bitsPerProb;
        switch (n) {
            case 8: {
                intersect = (Function2 & Serializable & scala.Serializable)(prob, ledos) -> {
                    BgenRecordWriter$.MODULE$.writeUnsignedByte(BoxesRunTime.unboxToLong((Object)prob), (DataOutput)ledos);
                    return BoxedUnit.UNIT;
                };
                break;
            }
            case 16: {
                intersect = (Function2 & Serializable & scala.Serializable)(prob, ledos) -> {
                    BgenRecordWriter$.MODULE$.writeUnsignedShort(BoxesRunTime.unboxToLong((Object)prob), (DataOutput)ledos);
                    return BoxedUnit.UNIT;
                };
                break;
            }
            case 32: {
                intersect = (Function2 & Serializable & scala.Serializable)(prob, ledos) -> {
                    BgenRecordWriter$.MODULE$.writeUnsignedInt(BoxesRunTime.unboxToLong((Object)prob), (DataOutput)ledos);
                    return BoxedUnit.UNIT;
                };
                break;
            }
            default: {
                throw new IllegalArgumentException("Only probabilities of 8, 16, or 32 bits are accepted");
            }
        }
        this.probabilityWriter = intersect;
        this.probBlockSizeMap = new HashMap();
        this.buffSize = 8192;
        this.headerHasBeenWritten = false;
    }
}

