/*
 * Decompiled with CFR 0.152.
 */
package io.projectglow.bgen;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import io.projectglow.bgen.BgenRecordWriter;
import io.projectglow.bgen.BigBgenOptions;
import io.projectglow.common.BgenOptions$;
import io.projectglow.common.logging.HlsEventRecorder;
import io.projectglow.common.logging.HlsTagValues$;
import io.projectglow.common.logging.HlsUsageLogging;
import io.projectglow.common.logging.MetricDefinition;
import io.projectglow.common.logging.TagDefinition;
import java.io.ByteArrayOutputStream;
import java.io.Serializable;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLUtils$;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class BigBgenDatasource$
implements HlsEventRecorder {
    public static BigBgenDatasource$ MODULE$;
    private Logger logger;
    private volatile boolean bitmap$0;

    static {
        new BigBgenDatasource$();
    }

    @Override
    public void recordHlsEvent(String tag, Map<String, Object> options) {
        HlsEventRecorder.recordHlsEvent$(this, tag, options);
    }

    @Override
    public Map<String, Object> recordHlsEvent$default$2() {
        return HlsEventRecorder.recordHlsEvent$default$2$(this);
    }

    @Override
    public void recordHlsUsage(MetricDefinition metric, Map<TagDefinition, String> tags, String blob) {
        HlsUsageLogging.recordHlsUsage$(this, metric, tags, blob);
    }

    @Override
    public Map<TagDefinition, String> recordHlsUsage$default$2() {
        return HlsUsageLogging.recordHlsUsage$default$2$(this);
    }

    @Override
    public String recordHlsUsage$default$3() {
        return HlsUsageLogging.recordHlsUsage$default$3$(this);
    }

    @Override
    public String hlsJsonBuilder(Map<String, Object> options) {
        return HlsUsageLogging.hlsJsonBuilder$(this, options);
    }

    private Logger logger$lzycompute() {
        BigBgenDatasource$ bigBgenDatasource$ = this;
        synchronized (bigBgenDatasource$) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    private BigBgenOptions parseOptions(Map<String, String> options) {
        int bitsPerProb = new StringOps(Predef$.MODULE$.augmentString((String)options.getOrElse((Object)BgenOptions$.MODULE$.BITS_PER_PROB_KEY(), (Function0 & Serializable & scala.Serializable)() -> BgenOptions$.MODULE$.BITS_PER_PROB_DEFAULT_VALUE()))).toInt();
        int maxPloidy = new StringOps(Predef$.MODULE$.augmentString((String)options.getOrElse((Object)BgenOptions$.MODULE$.MAX_PLOIDY_KEY(), (Function0 & Serializable & scala.Serializable)() -> BgenOptions$.MODULE$.MAX_PLOIDY_VALUE()))).toInt();
        int defaultPloidy = new StringOps(Predef$.MODULE$.augmentString((String)options.getOrElse((Object)BgenOptions$.MODULE$.DEFAULT_PLOIDY_KEY(), (Function0 & Serializable & scala.Serializable)() -> BgenOptions$.MODULE$.DEFAULT_PLOIDY_VALUE()))).toInt();
        boolean defaultPhasing = new StringOps(Predef$.MODULE$.augmentString((String)options.getOrElse((Object)BgenOptions$.MODULE$.DEFAULT_PHASING_KEY(), (Function0 & Serializable & scala.Serializable)() -> BgenOptions$.MODULE$.DEFAULT_PHASING_VALUE()))).toBoolean();
        return new BigBgenOptions(bitsPerProb, maxPloidy, defaultPloidy, defaultPhasing);
    }

    private void logBgenWrite(BigBgenOptions parsedOptions) {
        Map logOptions = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BgenOptions$.MODULE$.BITS_PER_PROB_KEY()), (Object)BoxesRunTime.boxToInteger((int)parsedOptions.bitsPerProb())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BgenOptions$.MODULE$.MAX_PLOIDY_KEY()), (Object)BoxesRunTime.boxToInteger((int)parsedOptions.maxPloidy())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BgenOptions$.MODULE$.DEFAULT_PLOIDY_KEY()), (Object)BoxesRunTime.boxToInteger((int)parsedOptions.defaultPloidy())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BgenOptions$.MODULE$.DEFAULT_PHASING_KEY()), (Object)BoxesRunTime.boxToBoolean((boolean)parsedOptions.defaultPhasing()))}));
        this.recordHlsEvent(HlsTagValues$.MODULE$.EVENT_BGEN_WRITE(), (Map<String, Object>)logOptions);
    }

    public RDD<byte[]> serializeDataFrame(Map<String, String> options, Dataset<Row> data) {
        RDD<InternalRow> rDD;
        BigBgenOptions parsedOptions = this.parseOptions(options);
        this.logBgenWrite(parsedOptions);
        StructType dSchema = data.schema();
        long numVariants = data.count();
        RDD<InternalRow> rawRdd = data.queryExecution().toRdd();
        if (rawRdd.getNumPartitions() == 0) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn("Writing BGEN header only as the input DataFrame has zero partitions.");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            rDD = SQLUtils$.MODULE$.createEmptyRDD(data.sparkSession(), SQLUtils$.MODULE$.createEmptyRDD$default$2());
        } else {
            rDD = rawRdd;
        }
        RDD<InternalRow> inputRdd = rDD;
        return inputRdd.mapPartitionsWithIndex((Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> BigBgenDatasource$.$anonfun$serializeDataFrame$1(dSchema, numVariants, parsedOptions, BoxesRunTime.unboxToInt((Object)x0$1), x1$1), inputRdd.mapPartitionsWithIndex$default$2(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)));
    }

    public static final /* synthetic */ Iterator $anonfun$serializeDataFrame$1(StructType dSchema$1, long numVariants$1, BigBgenOptions parsedOptions$1, int x0$1, Iterator x1$1) {
        Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)x0$1), (Object)x1$1);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int idx = tuple2._1$mcI$sp();
        Iterator it = (Iterator)tuple2._2();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        boolean writeHeader = idx == 0;
        BgenRecordWriter writer = new BgenRecordWriter(baos, dSchema$1, writeHeader, numVariants$1, parsedOptions$1.bitsPerProb(), parsedOptions$1.maxPloidy(), parsedOptions$1.defaultPloidy(), parsedOptions$1.defaultPhasing());
        it.foreach((Function1 & Serializable & scala.Serializable)row -> {
            writer.write(row);
            return BoxedUnit.UNIT;
        });
        writer.close();
        Iterator iterator = package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new byte[][]{baos.toByteArray()}));
        return iterator;
    }

    private BigBgenDatasource$() {
        MODULE$ = this;
        LazyLogging.$init$((LazyLogging)this);
        HlsUsageLogging.$init$(this);
        HlsEventRecorder.$init$(this);
    }
}

