/*
 * Decompiled with CFR 0.152.
 */
package io.projectglow.plink;

import com.google.common.io.LittleEndianDataInputStream;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import com.univocity.parsers.common.record.Record;
import com.univocity.parsers.csv.CsvParser;
import io.projectglow.common.CommonOptions$;
import io.projectglow.common.PlinkOptions$;
import io.projectglow.common.VariantSchemas$;
import io.projectglow.common.logging.HlsEventRecorder;
import io.projectglow.common.logging.HlsTagValues$;
import io.projectglow.common.logging.HlsUsageLogging;
import io.projectglow.common.logging.MetricDefinition;
import io.projectglow.common.logging.TagDefinition;
import java.io.InputStream;
import java.io.Serializable;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.csv.CSVOptions;
import org.apache.spark.sql.catalyst.csv.UnivocityParser;
import org.apache.spark.sql.catalyst.expressions.Add;
import org.apache.spark.sql.catalyst.expressions.BoundReference;
import org.apache.spark.sql.catalyst.expressions.CreateArray$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Length;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.MutableProjection;
import org.apache.spark.sql.catalyst.expressions.Subtract;
import org.apache.spark.sql.catalyst.expressions.codegen.GenerateMutableProjection$;
import org.apache.spark.sql.catalyst.util.FailFastMode$;
import org.apache.spark.sql.execution.datasources.csv.CSVUtils$;
import org.apache.spark.sql.execution.datasources.csv.UnivocityParserUtils$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;

public final class PlinkFileFormat$
implements HlsEventRecorder,
scala.Serializable {
    public static PlinkFileFormat$ MODULE$;
    private final String FAM_FILE_EXTENSION;
    private final String BIM_FILE_EXTENSION;
    private final String CSV_DELIMITER_KEY;
    private final int BLOCKS_PER_BYTE;
    private final Seq<Object> MAGIC_BYTES;
    private final int NUM_MAGIC_BYTES;
    private Logger logger;
    private volatile boolean bitmap$0;

    static {
        new PlinkFileFormat$();
    }

    @Override
    public void recordHlsEvent(String tag, Map<String, Object> options) {
        HlsEventRecorder.recordHlsEvent$(this, tag, options);
    }

    @Override
    public Map<String, Object> recordHlsEvent$default$2() {
        return HlsEventRecorder.recordHlsEvent$default$2$(this);
    }

    @Override
    public void recordHlsUsage(MetricDefinition metric, Map<TagDefinition, String> tags, String blob) {
        HlsUsageLogging.recordHlsUsage$(this, metric, tags, blob);
    }

    @Override
    public Map<TagDefinition, String> recordHlsUsage$default$2() {
        return HlsUsageLogging.recordHlsUsage$default$2$(this);
    }

    @Override
    public String recordHlsUsage$default$3() {
        return HlsUsageLogging.recordHlsUsage$default$3$(this);
    }

    @Override
    public String hlsJsonBuilder(Map<String, Object> options) {
        return HlsUsageLogging.hlsJsonBuilder$(this, options);
    }

    private Logger logger$lzycompute() {
        PlinkFileFormat$ plinkFileFormat$ = this;
        synchronized (plinkFileFormat$) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    public String FAM_FILE_EXTENSION() {
        return this.FAM_FILE_EXTENSION;
    }

    public String BIM_FILE_EXTENSION() {
        return this.BIM_FILE_EXTENSION;
    }

    public String CSV_DELIMITER_KEY() {
        return this.CSV_DELIMITER_KEY;
    }

    public int BLOCKS_PER_BYTE() {
        return this.BLOCKS_PER_BYTE;
    }

    public Seq<Object> MAGIC_BYTES() {
        return this.MAGIC_BYTES;
    }

    public int NUM_MAGIC_BYTES() {
        return this.NUM_MAGIC_BYTES;
    }

    public void logPlinkRead(Map<String, String> options) {
        Map logOptions = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)CommonOptions$.MODULE$.INCLUDE_SAMPLE_IDS()), (Object)BoxesRunTime.boxToBoolean((boolean)options.get((Object)CommonOptions$.MODULE$.INCLUDE_SAMPLE_IDS()).forall((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)PlinkFileFormat$.$anonfun$logPlinkRead$1(x$4))))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)PlinkOptions$.MODULE$.MERGE_FID_IID()), (Object)BoxesRunTime.boxToBoolean((boolean)options.get((Object)CommonOptions$.MODULE$.INCLUDE_SAMPLE_IDS()).forall((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)PlinkFileFormat$.$anonfun$logPlinkRead$2(x$5)))))}));
        this.recordHlsEvent(HlsTagValues$.MODULE$.EVENT_PLINK_READ(), (Map<String, Object>)logOptions);
    }

    public String getPrefixPath(String bedPath) {
        return (String)new StringOps(Predef$.MODULE$.augmentString(bedPath)).dropRight(4);
    }

    public UTF8String[] getSampleIds(String bedPath, Map<String, String> options, Configuration hadoopConf) {
        UTF8String[] uTF8StringArray;
        boolean bl;
        String famDelimiterOption = (String)options.getOrElse((Object)PlinkOptions$.MODULE$.FAM_DELIMITER_KEY(), (Function0 & Serializable & scala.Serializable)() -> PlinkOptions$.MODULE$.DEFAULT_FAM_DELIMITER_VALUE());
        CSVOptions parsedOptions = new CSVOptions((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.CSV_DELIMITER_KEY()), (Object)famDelimiterOption)})), SQLConf$.MODULE$.get().csvColumnPruning(), SQLConf$.MODULE$.get().sessionLocalTimeZone());
        try {
            bl = new StringOps(Predef$.MODULE$.augmentString((String)options.getOrElse((Object)PlinkOptions$.MODULE$.MERGE_FID_IID(), (Function0 & Serializable & scala.Serializable)() -> "true"))).toBoolean();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalArgumentException(new StringBuilder(44).append("Value for ").append(PlinkOptions$.MODULE$.MERGE_FID_IID()).append(" must be [true, false]. Provided: ").append(options.apply((Object)PlinkOptions$.MODULE$.MERGE_FID_IID())).toString());
        }
        boolean mergeFidIid = bl;
        String prefixPath = this.getPrefixPath(bedPath);
        Path famPath = new Path(new StringBuilder(0).append(prefixPath).append(this.FAM_FILE_EXTENSION()).toString());
        FileSystem hadoopFs = famPath.getFileSystem(hadoopConf);
        FSDataInputStream stream = hadoopFs.open(famPath);
        Iterator lines = (Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter((java.util.Iterator)IOUtils.lineIterator((InputStream)stream, (String)"UTF-8")).asScala();
        Iterator filteredLines = CSVUtils$.MODULE$.filterCommentAndEmpty(lines, parsedOptions);
        CsvParser parser = new CsvParser(parsedOptions.asParserSettings());
        try {
            uTF8StringArray = (UTF8String[])filteredLines.map((Function1 & Serializable & scala.Serializable)l -> {
                String string;
                Record sampleLine = parser.parseRecord(l);
                Predef$.MODULE$.require(sampleLine.getValues().length == 6, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(71).append("Failed while parsing FAM file ").append(famPath).append(": does not have 6 columns delimited by '").append(famDelimiterOption).append("'").toString());
                String individualId = sampleLine.getString(1);
                if (mergeFidIid) {
                    String familyId = sampleLine.getString(0);
                    string = new StringBuilder(1).append(familyId).append("_").append(individualId).toString();
                } else {
                    string = individualId;
                }
                String sampleId = string;
                return UTF8String.fromString((String)sampleId);
            }).toArray(ClassTag$.MODULE$.apply(UTF8String.class));
        }
        finally {
            stream.close();
        }
        return uTF8StringArray;
    }

    public InternalRow[] getVariants(String bedPath, int firstVariant, int numVariants, Map<String, String> options, Configuration hadoopConf) {
        InternalRow[] internalRowArray;
        String bimDelimiterOption = (String)options.getOrElse((Object)PlinkOptions$.MODULE$.BIM_DELIMITER_KEY(), (Function0 & Serializable & scala.Serializable)() -> PlinkOptions$.MODULE$.DEFAULT_BIM_DELIMITER_VALUE());
        CSVOptions parsedOptions = new CSVOptions((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.CSV_DELIMITER_KEY()), (Object)bimDelimiterOption), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"mode"), (Object)FailFastMode$.MODULE$.name())})), SQLConf$.MODULE$.get().csvColumnPruning(), SQLConf$.MODULE$.get().sessionLocalTimeZone());
        String prefixPath = this.getPrefixPath(bedPath);
        Path bimPath = new Path(new StringBuilder(0).append(prefixPath).append(this.BIM_FILE_EXTENSION()).toString());
        FileSystem hadoopFs = bimPath.getFileSystem(hadoopConf);
        FSDataInputStream stream = hadoopFs.open(bimPath);
        Iterator lines = (Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter((java.util.Iterator)IOUtils.lineIterator((InputStream)stream, (String)"UTF-8")).asScala();
        Iterator filteredLines = CSVUtils$.MODULE$.filterCommentAndEmpty(lines, parsedOptions).slice(firstVariant, firstVariant + numVariants);
        UnivocityParser univocityParser = new UnivocityParser(VariantSchemas$.MODULE$.bimSchema(), VariantSchemas$.MODULE$.bimSchema(), parsedOptions);
        try {
            try {
                Iterator<InternalRow> variantIterator = UnivocityParserUtils$.MODULE$.parseIterator((Iterator<String>)filteredLines, univocityParser, VariantSchemas$.MODULE$.bimSchema());
                internalRowArray = (InternalRow[])variantIterator.map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.copy()).toArray(ClassTag$.MODULE$.apply(InternalRow.class));
            }
            catch (Exception e) {
                throw new IllegalArgumentException(new StringBuilder(32).append("Failed while parsing BIM file ").append(bimPath).append(": ").append(e.getMessage()).toString());
            }
        }
        finally {
            stream.close();
        }
        return internalRowArray;
    }

    public int getBlockSize(int numSamples) {
        return (int)package$.MODULE$.ceil((double)numSamples / (double)this.BLOCKS_PER_BYTE());
    }

    public int getFirstVariantIdx(long partitionedFileStart, int blockSize) {
        return package$.MODULE$.max(0, (int)package$.MODULE$.ceil(((double)partitionedFileStart - (double)this.NUM_MAGIC_BYTES()) / (double)blockSize));
    }

    public long getVariantStart(int variantIdx, int blockSize) {
        return (long)this.NUM_MAGIC_BYTES() + (long)blockSize * (long)variantIdx;
    }

    public int getNumVariants(long partitionedFileStart, long partitionedFileLength, long firstVariantStart, int blockSize) {
        long actualLength = partitionedFileLength - (firstVariantStart - partitionedFileStart);
        return (int)package$.MODULE$.ceil((double)actualLength / (double)blockSize);
    }

    public void verifyBed(LittleEndianDataInputStream stream) {
        Seq magicNumber;
        LazyRef hexString$lzy = new LazyRef();
        Seq seq = magicNumber = (Seq)this.MAGIC_BYTES().map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToByte((byte)stream.readByte()), Seq$.MODULE$.canBuildFrom());
        Seq<Object> seq2 = this.MAGIC_BYTES();
        Predef$.MODULE$.require(!(seq != null ? !seq.equals(seq2) : seq2 != null), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(55).append("Magic bytes were not ").append(this.hexString$1(hexString$lzy)).append("; this is not a variant-major BED.").toString());
    }

    public MutableProjection makeMutableProjection(StructType schema) {
        Seq expressions = (Seq)schema.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Object object;
            StructField structField = x0$1;
            StructField structField2 = VariantSchemas$.MODULE$.contigNameField();
            StructField structField3 = structField;
            if (!(structField2 != null ? !structField2.equals(structField3) : structField3 != null)) {
                object = MODULE$.makeBimBoundReference(VariantSchemas$.MODULE$.contigNameField());
            } else {
                StructField structField4 = VariantSchemas$.MODULE$.namesField();
                StructField structField5 = structField;
                if (!(structField4 != null ? !structField4.equals(structField5) : structField5 != null)) {
                    object = CreateArray$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new BoundReference[]{MODULE$.makeBimBoundReference(VariantSchemas$.MODULE$.variantIdField())})));
                } else {
                    StructField structField6 = VariantSchemas$.MODULE$.positionField();
                    StructField structField7 = structField;
                    if (!(structField6 != null ? !structField6.equals(structField7) : structField7 != null)) {
                        object = MODULE$.makeBimBoundReference(VariantSchemas$.MODULE$.positionField());
                    } else {
                        StructField structField8 = VariantSchemas$.MODULE$.startField();
                        StructField structField9 = structField;
                        if (!(structField8 != null ? !structField8.equals(structField9) : structField9 != null)) {
                            object = new Subtract((Expression)MODULE$.makeBimBoundReference(VariantSchemas$.MODULE$.startField()), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1)));
                        } else {
                            StructField structField10 = VariantSchemas$.MODULE$.endField();
                            StructField structField11 = structField;
                            if (!(structField10 != null ? !structField10.equals(structField11) : structField11 != null)) {
                                object = new Add((Expression)new Subtract((Expression)MODULE$.makeBimBoundReference(VariantSchemas$.MODULE$.startField()), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1))), (Expression)new Length((Expression)MODULE$.makeBimBoundReference(VariantSchemas$.MODULE$.alleleTwoField())));
                            } else {
                                StructField structField12 = VariantSchemas$.MODULE$.refAlleleField();
                                StructField structField13 = structField;
                                if (!(structField12 != null ? !structField12.equals(structField13) : structField13 != null)) {
                                    object = MODULE$.makeBimBoundReference(VariantSchemas$.MODULE$.alleleTwoField());
                                } else {
                                    StructField structField14 = VariantSchemas$.MODULE$.alternateAllelesField();
                                    StructField structField15 = structField;
                                    object = !(structField14 != null ? !structField14.equals(structField15) : structField15 != null) ? CreateArray$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new BoundReference[]{MODULE$.makeBimBoundReference(VariantSchemas$.MODULE$.alleleOneField())}))) : new Literal(null, structField.dataType());
                                }
                            }
                        }
                    }
                }
            }
            return object;
        }, Seq$.MODULE$.canBuildFrom());
        return (MutableProjection)GenerateMutableProjection$.MODULE$.generate((Object)expressions);
    }

    public BoundReference makeBimBoundReference(StructField f) {
        int idx = VariantSchemas$.MODULE$.bimSchema().indexOf((Object)f);
        return new BoundReference(idx, f.dataType(), f.nullable());
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ byte $anonfun$MAGIC_BYTES$1(int x$3) {
        return (byte)x$3;
    }

    public static final /* synthetic */ boolean $anonfun$logPlinkRead$1(String x$4) {
        return new StringOps(Predef$.MODULE$.augmentString(x$4)).toBoolean();
    }

    public static final /* synthetic */ boolean $anonfun$logPlinkRead$2(String x$5) {
        return new StringOps(Predef$.MODULE$.augmentString(x$5)).toBoolean();
    }

    public static final /* synthetic */ String $anonfun$verifyBed$2(byte b) {
        return String.format("%04x", BoxesRunTime.boxToByte((byte)b));
    }

    private final /* synthetic */ String hexString$lzycompute$1(LazyRef hexString$lzy$1) {
        String string;
        LazyRef lazyRef = hexString$lzy$1;
        synchronized (lazyRef) {
            string = hexString$lzy$1.initialized() ? (String)hexString$lzy$1.value() : (String)hexString$lzy$1.initialize((Object)((TraversableOnce)this.MAGIC_BYTES().map((Function1 & Serializable & scala.Serializable)b -> PlinkFileFormat$.$anonfun$verifyBed$2(BoxesRunTime.unboxToByte((Object)b)), Seq$.MODULE$.canBuildFrom())).mkString(","));
        }
        return string;
    }

    private final String hexString$1(LazyRef hexString$lzy$1) {
        return hexString$lzy$1.initialized() ? (String)hexString$lzy$1.value() : this.hexString$lzycompute$1(hexString$lzy$1);
    }

    private PlinkFileFormat$() {
        MODULE$ = this;
        LazyLogging.$init$((LazyLogging)this);
        HlsUsageLogging.$init$(this);
        HlsEventRecorder.$init$(this);
        this.FAM_FILE_EXTENSION = ".fam";
        this.BIM_FILE_EXTENSION = ".bim";
        this.CSV_DELIMITER_KEY = "delimiter";
        this.BLOCKS_PER_BYTE = 4;
        this.MAGIC_BYTES = (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{108, 27, 1}))).map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToByte((byte)PlinkFileFormat$.$anonfun$MAGIC_BYTES$1(BoxesRunTime.unboxToInt((Object)x$3))), Seq$.MODULE$.canBuildFrom());
        this.NUM_MAGIC_BYTES = this.MAGIC_BYTES().size();
    }
}

