/*
 * Decompiled with CFR 0.152.
 */
package io.projectglow.sql.expressions;

import breeze.generic.UFunc;
import breeze.linalg.DenseMatrix$;
import breeze.linalg.DenseVector;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import io.projectglow.common.GlowLogging;
import io.projectglow.sql.expressions.CovariateQRContext;
import io.projectglow.sql.expressions.RegressionStats;
import org.apache.commons.math3.distribution.TDistribution;
import org.apache.commons.math3.util.FastMath;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.InternalRow$;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.runtime.BoxesRunTime;

public final class LinearRegressionGwas$
implements GlowLogging {
    public static LinearRegressionGwas$ MODULE$;
    private Logger logger;
    private volatile boolean bitmap$0;

    static {
        new LinearRegressionGwas$();
    }

    private Logger logger$lzycompute() {
        LinearRegressionGwas$ linearRegressionGwas$ = this;
        synchronized (linearRegressionGwas$) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    public RegressionStats runRegression(DenseVector<Object> genotypes, DenseVector<Object> phenotypes, CovariateQRContext covariateQRContext) {
        Predef$.MODULE$.require(genotypes.length() == phenotypes.length(), (Function0 & java.io.Serializable & Serializable)() -> "Number of samples differs between genotype and phenotype arrays");
        Predef$.MODULE$.require(covariateQRContext.covQt().cols() == genotypes.length(), (Function0 & java.io.Serializable & Serializable)() -> "Number of samples differs between genotype array and covariate matrix");
        DenseVector qtx = (DenseVector)covariateQRContext.covQt().$times(genotypes, (UFunc.UImpl2)DenseMatrix$.MODULE$.implOpMulMatrix_DMD_DVD_eq_DVD());
        DenseVector qty = (DenseVector)covariateQRContext.covQt().$times(phenotypes, (UFunc.UImpl2)DenseMatrix$.MODULE$.implOpMulMatrix_DMD_DVD_eq_DVD());
        double xdoty = BoxesRunTime.unboxToDouble((Object)phenotypes.dot(genotypes, (UFunc.UImpl2)DenseVector.canDotD$.MODULE$)) - BoxesRunTime.unboxToDouble((Object)qty.dot((Object)qtx, (UFunc.UImpl2)DenseVector.canDotD$.MODULE$));
        double xdotx = BoxesRunTime.unboxToDouble((Object)genotypes.dot(genotypes, (UFunc.UImpl2)DenseVector.canDotD$.MODULE$)) - BoxesRunTime.unboxToDouble((Object)qtx.dot((Object)qtx, (UFunc.UImpl2)DenseVector.canDotD$.MODULE$));
        double ydoty = BoxesRunTime.unboxToDouble((Object)phenotypes.dot(phenotypes, (UFunc.UImpl2)DenseVector.canDotD$.MODULE$)) - BoxesRunTime.unboxToDouble((Object)qty.dot((Object)qty, (UFunc.UImpl2)DenseVector.canDotD$.MODULE$));
        double beta = xdoty / xdotx;
        double standardError = FastMath.sqrt((double)((ydoty / xdotx - beta * beta) / (double)covariateQRContext.degreesOfFreedom()));
        double t = beta / standardError;
        TDistribution tDist = new TDistribution((double)covariateQRContext.degreesOfFreedom());
        double pvalue = (double)2 * tDist.cumulativeProbability(-Math.abs(t));
        return new RegressionStats(beta, standardError, pvalue);
    }

    public InternalRow linearRegressionGwas(DenseVector<Object> genotypes, DenseVector<Object> phenotypes, CovariateQRContext covariateQR) {
        RegressionStats regressionStats = this.runRegression(genotypes, phenotypes, covariateQR);
        return InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)regressionStats.beta()), BoxesRunTime.boxToDouble((double)regressionStats.standardError()), BoxesRunTime.boxToDouble((double)regressionStats.pValue())}));
    }

    private LinearRegressionGwas$() {
        MODULE$ = this;
        LazyLogging.$init$((LazyLogging)this);
    }
}

