/*
 * Decompiled with CFR 0.152.
 */
package io.projectglow.sql.expressions;

import breeze.generic.UFunc;
import breeze.generic.UFunc$;
import breeze.linalg.$times$;
import breeze.linalg.BroadcastedColumns$;
import breeze.linalg.Broadcaster$;
import breeze.linalg.DenseMatrix;
import breeze.linalg.DenseMatrix$;
import breeze.linalg.DenseVector;
import breeze.linalg.DenseVector$;
import breeze.linalg.ImmutableNumericOps;
import breeze.linalg.LU;
import breeze.linalg.MatrixSingularException;
import breeze.linalg.NotConvergedException;
import breeze.linalg.NumericOps;
import breeze.linalg.diag$;
import breeze.linalg.inv$;
import breeze.linalg.mapActiveValues$;
import breeze.linalg.max$;
import breeze.linalg.package;
import breeze.linalg.sum$;
import breeze.numerics.package;
import breeze.storage.Zero;
import com.google.common.annotations.VisibleForTesting;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import io.projectglow.common.GlowLogging;
import io.projectglow.sql.expressions.FirthTest$;
import io.projectglow.sql.expressions.LikelihoodRatioTest$;
import io.projectglow.sql.expressions.LogitTest;
import io.projectglow.sql.expressions.NewtonIterationsState;
import io.projectglow.sql.expressions.NewtonResult;
import java.io.Serializable;
import org.apache.commons.math3.distribution.ChiSquaredDistribution;
import org.apache.commons.math3.distribution.NormalDistribution;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.catalyst.util.ArrayData$;
import org.apache.spark.sql.catalyst.util.CaseInsensitiveMap$;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayOps;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

public final class LogisticRegressionGwas$
implements GlowLogging {
    public static LogisticRegressionGwas$ MODULE$;
    private final Map<String, LogitTest> logitTests;
    private final double zScore;
    private Logger logger;
    private volatile boolean bitmap$0;

    static {
        new LogisticRegressionGwas$();
    }

    private Logger logger$lzycompute() {
        LogisticRegressionGwas$ logisticRegressionGwas$ = this;
        synchronized (logisticRegressionGwas$) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    public Map<String, LogitTest> logitTests() {
        return this.logitTests;
    }

    public double zScore() {
        return this.zScore;
    }

    @VisibleForTesting
    public NewtonResult newtonIterations(DenseMatrix<Object> X, DenseVector<Object> y, Option<DenseVector<Object>> offsetOption, DenseMatrix<Object> hessianPlaceHolder, NewtonIterationsState args, int maxIter, double tolerance) {
        int iter = 1;
        boolean converged = false;
        boolean exploded = false;
        DenseVector deltaB = DenseVector$.MODULE$.zeros$mDc$sp(X.cols(), ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$);
        while (!converged && !exploded && iter <= maxIter) {
            Object object;
            try {
                DenseVector denseVector;
                deltaB.$colon$eq(args.fisher().$bslash(args.score(), (UFunc.UImpl2)DenseMatrix$.MODULE$.implOpSolveMatrixBy_DMD_DVD_eq_DVD()), DenseVector$.MODULE$.dv_dv_UpdateOp_Double_OpSet());
                if (Predef$.MODULE$.double2Double(deltaB.apply$mcD$sp(0)).isNaN()) {
                    exploded = true;
                    object = BoxedUnit.UNIT;
                    continue;
                }
                if (BoxesRunTime.unboxToDouble((Object)max$.MODULE$.apply(package.abs$.MODULE$.apply((Object)deltaB, package.abs$.MODULE$.fromLowOrderCanMapActiveValues(DenseVector$.MODULE$.scalarOf(), (UFunc.UImpl)package.abs$.absDoubleImpl$.MODULE$, mapActiveValues$.MODULE$.implFromCanMapValues(DenseVector$.MODULE$.canMapValues$mDDc$sp(ClassTag$.MODULE$.Double())))), max$.MODULE$.reduce_Double(DenseVector$.MODULE$.canIterateValues()))) < tolerance) {
                    converged = true;
                    object = BoxedUnit.UNIT;
                    continue;
                }
                ++iter;
                args.b().$plus$eq((Object)deltaB, DenseVector$.MODULE$.canAddIntoD());
                Option<DenseVector<Object>> option = offsetOption;
                if (option instanceof Some) {
                    Some some = (Some)option;
                    DenseVector offset = (DenseVector)some.value();
                    denseVector = (DenseVector)offset.$plus(X.$times(args.b(), (UFunc.UImpl2)DenseMatrix$.MODULE$.implOpMulMatrix_DMD_DVD_eq_DVD()), DenseVector$.MODULE$.canAddD());
                } else if (None$.MODULE$.equals(option)) {
                    denseVector = (DenseVector)X.$times(args.b(), (UFunc.UImpl2)DenseMatrix$.MODULE$.implOpMulMatrix_DMD_DVD_eq_DVD());
                } else {
                    throw new MatchError(option);
                }
                DenseVector eta = denseVector;
                args.mu().$colon$eq(package.sigmoid$.MODULE$.apply((Object)eta, package.sigmoid$.MODULE$.fromLowOrderCanMapValues(DenseVector$.MODULE$.scalarOf(), (UFunc.UImpl)package.sigmoid$.sigmoidImplDouble$.MODULE$, DenseVector$.MODULE$.canMapValues$mDDc$sp(ClassTag$.MODULE$.Double()))), DenseVector$.MODULE$.dv_dv_UpdateOp_Double_OpSet());
                args.score().$colon$eq(((ImmutableNumericOps)X.t(DenseMatrix$.MODULE$.canTranspose())).$times(y.$minus(args.mu(), DenseVector$.MODULE$.canSubD()), (UFunc.UImpl2)DenseMatrix$.MODULE$.implOpMulMatrix_DMD_DVD_eq_DVD()), DenseVector$.MODULE$.dv_dv_UpdateOp_Double_OpSet());
                hessianPlaceHolder.$colon$eq(X, DenseMatrix$.MODULE$.dm_dm_UpdateOp_Double_OpSet());
                ((NumericOps)hessianPlaceHolder.apply((Object)package$.MODULE$.$colon$colon(), (Object)$times$.MODULE$, Broadcaster$.MODULE$.canBroadcastColumns(DenseMatrix$.MODULE$.handholdCanMapRows()))).$colon$times$eq(args.mu().$times$colon$times(new package.InjectNumericOps(breeze.linalg.package$.MODULE$.InjectNumericOps((Object)BoxesRunTime.boxToDouble((double)1.0))).$minus(args.mu(), DenseVector$.MODULE$.s_dv_Op_Double_OpSub()), DenseVector$.MODULE$.dv_dv_Op_Double_OpMulScalar()), BroadcastedColumns$.MODULE$.broadcastInplaceOp2(DenseMatrix$.MODULE$.handholdCanMapRows(), DenseVector$.MODULE$.dv_dv_UpdateOp_Double_OpMulScalar(), DenseMatrix$.MODULE$.canTraverseCols()));
                object = args.fisher().$colon$eq(((ImmutableNumericOps)X.t(DenseMatrix$.MODULE$.canTranspose())).$times(hessianPlaceHolder, (UFunc.UImpl2)DenseMatrix$.MODULE$.implOpMulMatrix_DMD_DMD_eq_DMD()), DenseMatrix$.MODULE$.dm_dm_UpdateOp_Double_OpSet());
            }
            catch (MatrixSingularException matrixSingularException) {
                exploded = true;
                object = BoxedUnit.UNIT;
            }
            catch (NotConvergedException notConvergedException) {
                exploded = true;
                object = BoxedUnit.UNIT;
            }
        }
        DenseVector statistic = (DenseVector)((NumericOps)y.$times$colon$times(args.mu(), DenseVector$.MODULE$.dv_dv_Op_Double_OpMulScalar())).$plus(((ImmutableNumericOps)new package.InjectNumericOps(breeze.linalg.package$.MODULE$.InjectNumericOps((Object)BoxesRunTime.boxToDouble((double)1.0))).$minus(y, DenseVector$.MODULE$.s_dv_Op_Double_OpSub())).$times$colon$times(new package.InjectNumericOps(breeze.linalg.package$.MODULE$.InjectNumericOps((Object)BoxesRunTime.boxToDouble((double)1.0))).$minus(args.mu(), DenseVector$.MODULE$.s_dv_Op_Double_OpSub()), DenseVector$.MODULE$.dv_dv_Op_Double_OpMulScalar()), DenseVector$.MODULE$.canAddD());
        package.log$.MODULE$.inPlace((Object)statistic, UFunc$.MODULE$.canTransformValuesUFunc(DenseVector$.MODULE$.canTransformValues$mDc$sp(), (UFunc.UImpl)package.log$.logDoubleImpl$.MODULE$));
        double logLkhd = BoxesRunTime.unboxToDouble((Object)sum$.MODULE$.apply((Object)statistic, sum$.MODULE$.reduce_Double(DenseVector$.MODULE$.canIterateValues())));
        return new NewtonResult(args, logLkhd, iter, converged, exploded);
    }

    public int newtonIterations$default$6() {
        return 25;
    }

    public double newtonIterations$default$7() {
        return 1.0E-6;
    }

    public InternalRow makeStats(double beta, DenseMatrix<Object> fisher, double fullFitLogLkhd, double nullFitLogLkhd) {
        double oddsRatio = scala.math.package$.MODULE$.exp(beta);
        DenseMatrix covarianceMatrix = (DenseMatrix)inv$.MODULE$.apply(fisher, inv$.MODULE$.canInvUsingLU_Double((UFunc.UImpl)LU.primitive$.LU_DM_Impl_Double$.MODULE$));
        DenseVector variance = (DenseVector)diag$.MODULE$.apply((Object)covarianceMatrix, diag$.MODULE$.diagDMDVImpl());
        double standardError = scala.math.package$.MODULE$.sqrt(variance.apply$mcD$sp(-1));
        double halfWidth = this.zScore() * standardError;
        double[] waldConfidenceInterval = (double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(new double[]{beta - halfWidth, beta + halfWidth})).map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)x -> scala.math.package$.MODULE$.exp(x), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
        double chi2 = (double)2 * (fullFitLogLkhd - nullFitLogLkhd);
        boolean df = true;
        ChiSquaredDistribution chi2Dist = new ChiSquaredDistribution((double)df);
        double pValue = 1.0 - chi2Dist.cumulativeProbability(Math.abs(chi2));
        return InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)beta), BoxesRunTime.boxToDouble((double)oddsRatio), ArrayData$.MODULE$.toArrayData((Object)waldConfidenceInterval), BoxesRunTime.boxToDouble((double)pValue)}));
    }

    private LogisticRegressionGwas$() {
        MODULE$ = this;
        LazyLogging.$init$((LazyLogging)this);
        this.logitTests = CaseInsensitiveMap$.MODULE$.apply((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"lrt"), (Object)LikelihoodRatioTest$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"firth"), (Object)FirthTest$.MODULE$)})));
        this.zScore = new NormalDistribution().inverseCumulativeProbability(0.975);
    }
}

