/*
 * Decompiled with CFR 0.152.
 */
package io.projectglow.sql.expressions;

import io.projectglow.sql.expressions.VariantType;
import io.projectglow.sql.expressions.VariantType$Deletion$;
import io.projectglow.sql.expressions.VariantType$Insertion$;
import io.projectglow.sql.expressions.VariantType$SpanningDeletion$;
import io.projectglow.sql.expressions.VariantType$Transition$;
import io.projectglow.sql.expressions.VariantType$Transversion$;
import io.projectglow.sql.expressions.VariantType$Unknown$;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.ArrayData$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Product;

public final class VariantUtilExprs$ {
    public static VariantUtilExprs$ MODULE$;
    private final UTF8String star;

    static {
        new VariantUtilExprs$();
    }

    public ArrayData genotypeStates(ArrayData genotypes, int genotypesSize, int genotypesIdx) {
        ArrayData output = ArrayData$.MODULE$.allocateArrayData(IntegerType$.MODULE$.defaultSize(), (long)genotypes.numElements(), "");
        for (int i = 0; i < output.numElements(); ++i) {
            int j;
            ArrayData calls = genotypes.getStruct(i, genotypesSize).getArray(genotypesIdx);
            int sum = 0;
            for (j = 0; j < calls.numElements() && sum >= 0; ++j) {
                if (calls.getInt(j) >= 0) {
                    sum += calls.getInt(j);
                    continue;
                }
                sum = -1;
            }
            output.setInt(i, j == 0 ? -1 : sum);
        }
        return output;
    }

    public boolean isSnp(UTF8String refAllele, UTF8String altAllele) {
        if (refAllele.numChars() != altAllele.numChars()) {
            return false;
        }
        int nMismatches = 0;
        byte[] refBytes = refAllele.getBytes();
        byte[] altBytes = altAllele.getBytes();
        for (int i = 0; i < refBytes.length; ++i) {
            if (refBytes[i] == altBytes[i]) continue;
            ++nMismatches;
        }
        return nMismatches == 1;
    }

    public boolean containsTransition(UTF8String refAllele, UTF8String altAllele) {
        byte[] refBytes = refAllele.getBytes();
        byte[] altBytes = altAllele.getBytes();
        for (int i = 0; i < refBytes.length; ++i) {
            boolean transition;
            boolean bl = transition = refBytes[i] == 65 && altBytes[i] == 71 || refBytes[i] == 71 && altBytes[i] == 65 || refBytes[i] == 67 && altBytes[i] == 84 || refBytes[i] == 84 && altBytes[i] == 67;
            if (!transition) continue;
            return true;
        }
        return false;
    }

    public boolean containsTransversion(UTF8String refAllele, UTF8String altAllele) {
        byte[] refBytes = refAllele.getBytes();
        byte[] altBytes = altAllele.getBytes();
        for (int i = 0; i < refBytes.length; ++i) {
            boolean transversion;
            boolean bl = transversion = refBytes[i] == 65 && altBytes[i] == 67 || refBytes[i] == 65 && altBytes[i] == 84 || refBytes[i] == 67 && altBytes[i] == 65 || refBytes[i] == 67 && altBytes[i] == 71 || refBytes[i] == 71 && altBytes[i] == 67 || refBytes[i] == 71 && altBytes[i] == 84 || refBytes[i] == 84 && altBytes[i] == 65 || refBytes[i] == 84 && altBytes[i] == 71;
            if (!transversion) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isInsertion(UTF8String refAllele, UTF8String altAllele) {
        if (refAllele.numChars() >= altAllele.numChars()) return false;
        if (altAllele.numChars() < 2) return false;
        UTF8String uTF8String = refAllele.substring(0, 1);
        UTF8String uTF8String2 = altAllele.substring(0, 1);
        if (uTF8String == null) {
            if (uTF8String2 != null) {
                return false;
            }
        } else if (!uTF8String.equals(uTF8String2)) return false;
        if (!altAllele.endsWith(refAllele.substring(1, refAllele.numChars()))) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isDeletion(UTF8String refAllele, UTF8String altAllele) {
        if (refAllele.numChars() <= altAllele.numChars()) return false;
        if (refAllele.numChars() < 2) return false;
        UTF8String uTF8String = refAllele.substring(0, 1);
        UTF8String uTF8String2 = altAllele.substring(0, 1);
        if (uTF8String == null) {
            if (uTF8String2 != null) {
                return false;
            }
        } else if (!uTF8String.equals(uTF8String2)) return false;
        if (!refAllele.endsWith(altAllele.substring(1, altAllele.numChars()))) return false;
        return true;
    }

    private UTF8String star() {
        return this.star;
    }

    public VariantType variantType(UTF8String refAllele, UTF8String altAllele) {
        Product product;
        if (this.isSnp(refAllele, altAllele) && this.containsTransition(refAllele, altAllele)) {
            product = VariantType$Transition$.MODULE$;
        } else if (this.isSnp(refAllele, altAllele) && this.containsTransversion(refAllele, altAllele)) {
            product = VariantType$Transversion$.MODULE$;
        } else {
            UTF8String uTF8String = altAllele;
            UTF8String uTF8String2 = this.star();
            product = !(uTF8String != null ? !uTF8String.equals(uTF8String2) : uTF8String2 != null) ? VariantType$SpanningDeletion$.MODULE$ : (this.isInsertion(refAllele, altAllele) ? VariantType$Insertion$.MODULE$ : (this.isDeletion(refAllele, altAllele) ? VariantType$Deletion$.MODULE$ : VariantType$Unknown$.MODULE$));
        }
        return product;
    }

    private VariantUtilExprs$() {
        MODULE$ = this;
        this.star = UTF8String.fromString((String)"*");
    }
}

