/*
 * Decompiled with CFR 0.152.
 */
package io.projectglow.transformers;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import htsjdk.samtools.liftover.LiftOver;
import htsjdk.samtools.reference.ReferenceSequence;
import htsjdk.samtools.reference.ReferenceSequenceFile;
import htsjdk.samtools.reference.ReferenceSequenceFileFactory;
import htsjdk.samtools.util.Interval;
import htsjdk.samtools.util.StringUtil;
import htsjdk.variant.variantcontext.Allele;
import htsjdk.variant.variantcontext.Genotype;
import htsjdk.variant.variantcontext.GenotypeBuilder;
import htsjdk.variant.variantcontext.GenotypesContext;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.VariantContextBuilder;
import htsjdk.variant.vcf.VCFHeaderLineType;
import htsjdk.variant.vcf.VCFInfoHeaderLine;
import io.projectglow.common.GenotypeFields$;
import io.projectglow.common.GlowLogging;
import io.projectglow.common.VariantSchemas$;
import io.projectglow.vcf.InternalRowToVariantContextConverter$;
import io.projectglow.vcf.VCFSchemaInferrer$;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.apache.spark.sql.catalyst.expressions.BoundReference;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.MutableProjection;
import org.apache.spark.sql.catalyst.expressions.codegen.GenerateMutableProjection$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import picard.util.LiftoverUtils;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

public final class LiftOverVariantsTransformer$
implements GlowLogging {
    public static LiftOverVariantsTransformer$ MODULE$;
    private final String liftOverStatusColName;
    private final String successColName;
    private final String errorMessageColName;
    private final String conversionErrorMessage;
    private final String chainFileKey;
    private final String minMatchRatioKey;
    private final String referenceFileKey;
    private final StructField statusStructField;
    private final Literal statusStructFieldLiteral;
    private final Seq<VCFInfoHeaderLine> io$projectglow$transformers$LiftOverVariantsTransformer$$picardInfoHeaderLines;
    private final Seq<StructField> picardInfoStructFields;
    private final Seq<Literal> picardStructFieldLiterals;
    private Logger logger;
    private volatile boolean bitmap$0;

    static {
        new LiftOverVariantsTransformer$();
    }

    private Logger logger$lzycompute() {
        LiftOverVariantsTransformer$ liftOverVariantsTransformer$ = this;
        synchronized (liftOverVariantsTransformer$) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    public String liftOverStatusColName() {
        return this.liftOverStatusColName;
    }

    public String successColName() {
        return this.successColName;
    }

    public String errorMessageColName() {
        return this.errorMessageColName;
    }

    public String conversionErrorMessage() {
        return this.conversionErrorMessage;
    }

    private String chainFileKey() {
        return this.chainFileKey;
    }

    private String minMatchRatioKey() {
        return this.minMatchRatioKey;
    }

    private String referenceFileKey() {
        return this.referenceFileKey;
    }

    private StructField statusStructField() {
        return this.statusStructField;
    }

    private Literal statusStructFieldLiteral() {
        return this.statusStructFieldLiteral;
    }

    public Seq<VCFInfoHeaderLine> io$projectglow$transformers$LiftOverVariantsTransformer$$picardInfoHeaderLines() {
        return this.io$projectglow$transformers$LiftOverVariantsTransformer$$picardInfoHeaderLines;
    }

    private Seq<StructField> picardInfoStructFields() {
        return this.picardInfoStructFields;
    }

    private Seq<Literal> picardStructFieldLiterals() {
        return this.picardStructFieldLiterals;
    }

    public LiftOver getLiftOver(Map<String, String> options) {
        String chainFile = (String)options.getOrElse((Object)this.chainFileKey(), (Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalArgumentException("Must provide chain file from the reference sequence to the query sequence.");
        });
        return new LiftOver(new File(chainFile));
    }

    public double getMinMatchRatio(Map<String, String> options) {
        return BoxesRunTime.unboxToDouble((Object)options.get((Object)this.minMatchRatioKey()).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToDouble((double)LiftOverVariantsTransformer$.$anonfun$getMinMatchRatio$1(x$2))).getOrElse((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 0.95));
    }

    public Map<String, ReferenceSequence> getRefSeqMap(Map<String, String> options) {
        String referenceFile = (String)options.getOrElse((Object)this.referenceFileKey(), (Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalArgumentException("Must provide reference file for the query sequence.");
        });
        ReferenceSequenceFile refSeqFile = ReferenceSequenceFileFactory.getReferenceSequenceFile((File)new File(referenceFile));
        scala.collection.mutable.HashMap mmap = new scala.collection.mutable.HashMap();
        ReferenceSequence nextSeq = refSeqFile.nextSequence();
        while (nextSeq != null) {
            mmap.put((Object)nextSeq.getName(), (Object)nextSeq);
            nextSeq = refSeqFile.nextSequence();
        }
        return mmap.toMap(Predef$.MODULE$.$conforms());
    }

    public Tuple2<Option<VariantContext>, Option<String>> liftVariantContext(VariantContext inputVc, LiftOver liftOver, double minMatchRatio, Map<String, ReferenceSequence> refSeqMap, Seq<String> infoFieldsToSwap, Seq<String> formatFieldsToSwap) {
        Interval inputInterval = new Interval(inputVc.getContig(), inputVc.getStart(), inputVc.getEnd(), false, new StringBuilder(2).append(inputVc.getContig()).append(":").append(inputVc.getStart()).append("-").append(inputVc.getEnd()).toString());
        Option outputIntervalOpt = Option$.MODULE$.apply((Object)liftOver.liftOver(inputInterval, minMatchRatio));
        if (outputIntervalOpt.isEmpty()) {
            return new Tuple2((Object)None$.MODULE$, (Object)new Some((Object)"NoTarget"));
        }
        Interval outputInterval = (Interval)outputIntervalOpt.get();
        if (inputVc.getReference().length() != outputInterval.length()) {
            return new Tuple2((Object)None$.MODULE$, (Object)new Some((Object)"IndelStraddlesMultipleIntevals"));
        }
        Option refSeqOpt = refSeqMap.get((Object)outputInterval.getContig());
        if (refSeqOpt.isEmpty()) {
            return new Tuple2((Object)None$.MODULE$, (Object)new Some((Object)"NoTarget"));
        }
        ReferenceSequence refSeq = (ReferenceSequence)refSeqOpt.get();
        Option outputVcOpt = Option$.MODULE$.apply((Object)LiftoverUtils.liftVariant((VariantContext)inputVc, (Interval)outputInterval, (ReferenceSequence)refSeq, (boolean)false, (boolean)false));
        if (outputVcOpt.isEmpty()) {
            return new Tuple2((Object)None$.MODULE$, (Object)new Some((Object)"CannotLiftOver"));
        }
        VariantContext outputVc = (VariantContext)outputVcOpt.get();
        byte[] refStrBases = refSeq.getBases();
        String refStr = StringUtil.bytesToString((byte[])refStrBases, (int)(outputVc.getStart() - 1), (int)(outputVc.getEnd() - outputVc.getStart() + 1));
        if (!refStr.equalsIgnoreCase(outputVc.getReference().getBaseString())) {
            if (outputVc.isBiallelic() && outputVc.isSNP() && refStr.equalsIgnoreCase(outputVc.getAlternateAllele(0).getBaseString())) {
                VariantContext swappedArrayFields = this.swapRefAlt(outputVc, infoFieldsToSwap, formatFieldsToSwap);
                return new Tuple2((Object)new Some((Object)swappedArrayFields), (Object)None$.MODULE$);
            }
            String attemptedLocus = new StringBuilder(2).append(outputVc.getContig()).append(":").append(outputVc.getStart()).append("-").append(outputVc.getEnd()).toString();
            return new Tuple2((Object)None$.MODULE$, (Object)new Some((Object)new StringBuilder(36).append("MismatchedRefAllele").append(": ").append("AttemptedLocus").append(" ").append(attemptedLocus).toString()));
        }
        return new Tuple2((Object)new Some((Object)outputVc), (Object)None$.MODULE$);
    }

    public VariantContext swapRefAlt(VariantContext vc, Seq<String> infoFieldsToSwap, Seq<String> formatFieldsToSwap) {
        VariantContextBuilder vcb = new VariantContextBuilder(vc);
        vcb.attribute("SwappedAlleles", (Object)BoxesRunTime.boxToBoolean((boolean)true));
        vcb.alleles(new String[]{((Allele)vc.getAlleles().get(1)).getBaseString(), ((Allele)vc.getAlleles().get(0)).getBaseString()});
        HashMap alleleMap = new HashMap();
        alleleMap.put(vc.getAlleles().get(0), vcb.getAlleles().get(1));
        alleleMap.put(vc.getAlleles().get(1), vcb.getAlleles().get(0));
        ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(LiftoverUtils.DEFAULT_TAGS_TO_DROP).asScala()).foreach((Function1 & Serializable & scala.Serializable)k -> vcb.rmAttribute(k));
        ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(LiftoverUtils.DEFAULT_TAGS_TO_REVERSE).asScala()).foreach((Function1 & Serializable & scala.Serializable)k -> vc.hasAttribute(k) ? vcb.attribute(k, JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(vc.getAttributeAsDoubleList(k, 0.0)).asScala()).map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToDouble((double)LiftOverVariantsTransformer$.$anonfun$swapRefAlt$3(x$3)), Buffer$.MODULE$.canBuildFrom())).toList()).asJava()) : BoxedUnit.UNIT);
        infoFieldsToSwap.foreach((Function1 & Serializable & scala.Serializable)k -> {
            List arrList = vc.getAttributeAsList(k);
            Collections.reverse(arrList);
            return vcb.attribute(k, (Object)arrList);
        });
        GenotypesContext swappedGenotypes = GenotypesContext.create((int)vc.getGenotypes().size());
        for (int i = 0; i < vc.getGenotypes().size(); ++i) {
            BoxedUnit boxedUnit;
            BoxedUnit boxedUnit2;
            Genotype genotype = vc.getGenotypes().get(i);
            ArrayList<Object> swappedAlleles = new ArrayList<Object>();
            for (int j = 0; j < genotype.getAlleles().size(); ++j) {
                Allele allele = genotype.getAllele(j);
                boolean bl = allele.isNoCall() ? swappedAlleles.add(allele) : swappedAlleles.add(alleleMap.get(allele));
            }
            GenotypeBuilder gb = new GenotypeBuilder(genotype).alleles(swappedAlleles);
            if (genotype.hasAD()) {
                int[] ad = genotype.getAD();
                ArrayUtils.reverse((int[])ad);
                boxedUnit2 = gb.AD(ad);
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            if (genotype.hasPL()) {
                int[] pl = genotype.getPL();
                ArrayUtils.reverse((int[])pl);
                boxedUnit = gb.PL(pl);
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            formatFieldsToSwap.foreach((Function1 & Serializable & scala.Serializable)k -> {
                BoxedUnit boxedUnit;
                if (genotype.hasExtendedAttribute(k)) {
                    List arrList = (List)genotype.getExtendedAttribute(k);
                    Collections.reverse(arrList);
                    boxedUnit = gb.attribute(k, (Object)arrList);
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                return boxedUnit;
            });
            swappedGenotypes.add(gb.make());
        }
        return vcb.genotypes(swappedGenotypes).make();
    }

    public StructType getOutputSchema(StructType inputSchema) {
        return new StructType((StructField[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])inputSchema.fields())).$plus$plus(this.picardInfoStructFields(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class))))).$colon$plus((Object)this.statusStructField(), ClassTag$.MODULE$.apply(StructField.class)));
    }

    public MutableProjection makeMutableProjection(StructType inputSchema) {
        Seq passThroughExpressions = (Seq)((TraversableLike)inputSchema.zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            StructField f = (StructField)tuple2._1();
            int ord = tuple2._2$mcI$sp();
            BoundReference boundReference = new BoundReference(ord, f.dataType(), f.nullable());
            return boundReference;
        }, Seq$.MODULE$.canBuildFrom());
        return (MutableProjection)GenerateMutableProjection$.MODULE$.generate(((SeqLike)passThroughExpressions.$plus$plus(this.picardStructFieldLiterals(), Seq$.MODULE$.canBuildFrom())).$colon$plus((Object)this.statusStructFieldLiteral(), Seq$.MODULE$.canBuildFrom()));
    }

    public Seq<String> getArrayFields(Seq<StructField> fields) {
        return (Seq)fields.flatMap((Function1 & Serializable & scala.Serializable)f -> f.dataType() instanceof ArrayType ? Option$.MODULE$.option2Iterable((Option)new Some((Object)f.name())) : Option$.MODULE$.option2Iterable((Option)None$.MODULE$), Seq$.MODULE$.canBuildFrom());
    }

    public Seq<String> getAttributesToSwap(StructType variantSchema) {
        Seq infoFields = (Seq)variantSchema.flatMap((Function1 & Serializable & scala.Serializable)f -> {
            String name;
            return f.name().startsWith(VariantSchemas$.MODULE$.infoFieldPrefix()) ? (LiftoverUtils.DEFAULT_TAGS_TO_DROP.contains(name = f.name().substring(VariantSchemas$.MODULE$.infoFieldPrefix().length())) || LiftoverUtils.DEFAULT_TAGS_TO_REVERSE.contains(name) ? Option$.MODULE$.option2Iterable((Option)None$.MODULE$) : Option$.MODULE$.option2Iterable((Option)new Some((Object)f.copy(f.name().substring(VariantSchemas$.MODULE$.infoFieldPrefix().length()), f.copy$default$2(), f.copy$default$3(), f.copy$default$4())))) : Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
        }, Seq$.MODULE$.canBuildFrom());
        return this.getArrayFields((Seq<StructField>)infoFields);
    }

    public Seq<String> getExtendedAttributesToSwap(StructType variantSchema) {
        Option<StructType> genotypeSchemaOpt = InternalRowToVariantContextConverter$.MODULE$.getGenotypeSchema(variantSchema);
        if (genotypeSchemaOpt.isEmpty()) {
            return (Seq)Seq$.MODULE$.empty();
        }
        Seq formatFields = (Seq)((TraversableLike)genotypeSchemaOpt.get()).flatMap((Function1 & Serializable & scala.Serializable)f -> {
            String name = (String)GenotypeFields$.MODULE$.reverseAliases().getOrElse((Object)f.name(), (Function0 & Serializable & scala.Serializable)() -> f.name());
            return Genotype.PRIMARY_KEYS.contains(name) ? Option$.MODULE$.option2Iterable((Option)None$.MODULE$) : Option$.MODULE$.option2Iterable((Option)new Some((Object)f.copy(name, f.copy$default$2(), f.copy$default$3(), f.copy$default$4())));
        }, Seq$.MODULE$.canBuildFrom());
        return this.getArrayFields((Seq<StructField>)formatFields);
    }

    public static final /* synthetic */ double $anonfun$getMinMatchRatio$1(String x$2) {
        return new StringOps(Predef$.MODULE$.augmentString(x$2)).toDouble();
    }

    public static final /* synthetic */ double $anonfun$swapRefAlt$3(Double x$3) {
        return 1.0 - Predef$.MODULE$.Double2double(x$3);
    }

    private LiftOverVariantsTransformer$() {
        MODULE$ = this;
        LazyLogging.$init$((LazyLogging)this);
        this.liftOverStatusColName = "liftOverStatus";
        this.successColName = "success";
        this.errorMessageColName = "errorMessage";
        this.conversionErrorMessage = "Conversion failed";
        this.chainFileKey = "chainFile";
        this.minMatchRatioKey = "minMatchRatio";
        this.referenceFileKey = "referenceFile";
        this.statusStructField = new StructField(this.liftOverStatusColName(), (DataType)new StructType((StructField[])((Object[])new StructField[]{new StructField(this.successColName(), (DataType)BooleanType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField(this.errorMessageColName(), (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())})), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
        this.statusStructFieldLiteral = new Literal(null, this.statusStructField().dataType());
        this.io$projectglow$transformers$LiftOverVariantsTransformer$$picardInfoHeaderLines = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new VCFInfoHeaderLine[]{new VCFInfoHeaderLine("SwappedAlleles", 0, VCFHeaderLineType.Flag, "The REF and the ALT alleles have been swapped in liftover due to changes in the reference. It is possible that not all INFO annotations reflect this swap, and in the genotypes, only the GT, PL, and AD fields have been modified. You should check the TAGS_TO_REVERSE parameter that was used during the LiftOver to be sure."), new VCFInfoHeaderLine("ReverseComplementedAlleles", 0, VCFHeaderLineType.Flag, "The REF and the ALT alleles have been reverse complemented in liftover since the mapping from the previous reference to the current one was on the negative strand.")}));
        this.picardInfoStructFields = (Seq)this.io$projectglow$transformers$LiftOverVariantsTransformer$$picardInfoHeaderLines().map((Function1 & Serializable & scala.Serializable)headerLine -> VCFSchemaInferrer$.MODULE$.getInfoFieldStruct((VCFInfoHeaderLine)headerLine), Seq$.MODULE$.canBuildFrom());
        this.picardStructFieldLiterals = (Seq)this.picardInfoStructFields().map((Function1 & Serializable & scala.Serializable)f -> new Literal(null, f.dataType()), Seq$.MODULE$.canBuildFrom());
    }
}

