/*
 * Decompiled with CFR 0.152.
 */
package io.projectglow.transformers.normalizevariants;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import htsjdk.samtools.reference.ReferenceSequenceFile;
import io.projectglow.common.GlowLogging;
import io.projectglow.common.VariantSchemas$;
import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.catalyst.expressions.GenericInternalRow;
import org.apache.spark.sql.catalyst.util.ArrayData$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Array$;
import scala.Function1;
import scala.None$;
import scala.Predef$;
import scala.Some;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.StringOps$;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.CharRef;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;

public final class VariantNormalizer$
implements GlowLogging {
    public static VariantNormalizer$ MODULE$;
    private final int PAD_WINDOW_SIZE;
    private final String normalizationResultFieldName;
    private final String normalizationStatusFieldName;
    private final String changedFieldName;
    private final String errorMessageFieldName;
    private final StructField normalizationStatusStructField;
    private final StructType normalizationResultStructType;
    private Logger logger;
    private volatile boolean bitmap$0;

    static {
        new VariantNormalizer$();
    }

    private Logger logger$lzycompute() {
        VariantNormalizer$ variantNormalizer$ = this;
        synchronized (variantNormalizer$) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    public InternalRow normalizeVariant(String contigName, long start, long end, String refAllele, String[] altAlleles, ReferenceSequenceFile refGenomeIndexedFasta) {
        boolean flag = false;
        None$ errorMessage = None$.MODULE$;
        long newStart = start;
        String string = refAllele;
        String[] allAlleles = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])altAlleles)).$plus$colon((Object)string, ClassTag$.MODULE$.apply(String.class));
        int trimSize = 0;
        if (refAllele.isEmpty()) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("No REF or ALT alleles found.");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            errorMessage = new Some((Object)"No REF or ALT alleles found.");
        } else if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])altAlleles)).isEmpty()) {
            allAlleles[0] = (String)new StringOps(Predef$.MODULE$.augmentString(allAlleles[0])).take(1);
            flag = true;
        } else if (!this.isSNP(refAllele, altAlleles) || !this.isSymbolic(altAlleles)) {
            IntRef nTrimmedBasesBeforeNextPadding = IntRef.create((int)0);
            CharRef firstBaseFromRightInRefAllele = CharRef.create((char)StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(allAlleles[0]), allAlleles[0].length() - nTrimmedBasesBeforeNextPadding.elem - 1));
            while (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])allAlleles)).forall((Function1 & Serializable & scala.Serializable)a -> BoxesRunTime.boxToBoolean((boolean)VariantNormalizer$.$anonfun$normalizeVariant$1(nTrimmedBasesBeforeNextPadding, firstBaseFromRightInRefAllele, a)))) {
                ObjectRef padSeq = ObjectRef.create((Object)"");
                int nPadBases = 0;
                if (BoxesRunTime.unboxToInt((Object)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])allAlleles)).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.length()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())))).min((Ordering)Ordering.Int$.MODULE$)) == nTrimmedBasesBeforeNextPadding.elem + 1) {
                    if (newStart > 0L) {
                        nPadBases = (long)this.PAD_WINDOW_SIZE() <= newStart ? this.PAD_WINDOW_SIZE() : (int)newStart;
                        padSeq.elem = (String)new StringOps(Predef$.MODULE$.augmentString((String)padSeq.elem)).$plus$plus((GenTraversableOnce)new StringOps(Predef$.MODULE$.augmentString(refGenomeIndexedFasta.getSubsequenceAt(contigName, newStart - (long)nPadBases + 1L, newStart).getBaseString())), Predef$.MODULE$.StringCanBuildFrom());
                    } else {
                        --nTrimmedBasesBeforeNextPadding.elem;
                    }
                    allAlleles = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])allAlleles)).map((Function1 & Serializable & scala.Serializable)a -> (String)new StringOps(Predef$.MODULE$.augmentString((String)padSeq$1.elem)).$plus$plus((GenTraversableOnce)new StringOps(Predef$.MODULE$.augmentString((String)new StringOps(Predef$.MODULE$.augmentString(a)).dropRight(nTrimmedBasesBeforeNextPadding$1.elem + 1))), Predef$.MODULE$.StringCanBuildFrom()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
                    trimSize += nTrimmedBasesBeforeNextPadding.elem + 1;
                    newStart -= (long)nPadBases;
                    nTrimmedBasesBeforeNextPadding.elem = 0;
                } else {
                    ++nTrimmedBasesBeforeNextPadding.elem;
                }
                firstBaseFromRightInRefAllele.elem = StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(allAlleles[0]), allAlleles[0].length() - nTrimmedBasesBeforeNextPadding.elem - 1);
            }
            IntRef nLeftTrimBases = IntRef.create((int)0);
            CharRef firstBaseFromLeftInRefAllele = CharRef.create((char)StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(allAlleles[0]), nLeftTrimBases.elem));
            int minAlleleLength = BoxesRunTime.unboxToInt((Object)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])allAlleles)).map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3.length()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())))).min((Ordering)Ordering.Int$.MODULE$));
            while (nLeftTrimBases.elem < minAlleleLength - nTrimmedBasesBeforeNextPadding.elem - 1 && new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])allAlleles)).forall((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)VariantNormalizer$.$anonfun$normalizeVariant$5(nLeftTrimBases, firstBaseFromLeftInRefAllele, x$4)))) {
                ++nLeftTrimBases.elem;
                firstBaseFromLeftInRefAllele.elem = StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(allAlleles[0]), nLeftTrimBases.elem);
            }
            allAlleles = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])allAlleles)).map((Function1 & Serializable & scala.Serializable)a -> (String)new StringOps(Predef$.MODULE$.augmentString((String)new StringOps(Predef$.MODULE$.augmentString(a)).drop(nLeftTrimBases$1.elem))).dropRight(nTrimmedBasesBeforeNextPadding$1.elem), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
            newStart += (long)nLeftTrimBases.elem;
            if ((trimSize += nTrimmedBasesBeforeNextPadding.elem) != 0 || nLeftTrimBases.elem != 0) {
                flag = true;
            }
        }
        GenericInternalRow outputRow = new GenericInternalRow(5);
        if (errorMessage.isEmpty()) {
            outputRow.update(0, (Object)BoxesRunTime.boxToLong((long)newStart));
            outputRow.update(1, (Object)BoxesRunTime.boxToLong((long)(end - (long)trimSize)));
            outputRow.update(2, (Object)UTF8String.fromString((String)allAlleles[0]));
            outputRow.update(3, (Object)ArrayData$.MODULE$.toArrayData(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])allAlleles)).tail())).map((Function1 & Serializable & scala.Serializable)x$5 -> UTF8String.fromString((String)x$5), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(UTF8String.class)))));
        }
        outputRow.update(4, (Object)InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToBoolean((boolean)flag), errorMessage.map((Function1 & Serializable & scala.Serializable)x$1 -> UTF8String.fromString((String)x$1)).orNull(Predef$.MODULE$.$conforms())})));
        return outputRow;
    }

    public boolean isSNP(String refAllele, String[] altAlleles) {
        return refAllele.length() == 1 && new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])altAlleles)).forall((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)VariantNormalizer$.$anonfun$isSNP$1(x$6)));
    }

    public boolean isSymbolic(String[] altAlleles) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])altAlleles)).exists((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)x$7.matches(".*[<|>|*].*")));
    }

    private int PAD_WINDOW_SIZE() {
        return this.PAD_WINDOW_SIZE;
    }

    public String normalizationResultFieldName() {
        return this.normalizationResultFieldName;
    }

    public String normalizationStatusFieldName() {
        return this.normalizationStatusFieldName;
    }

    public String changedFieldName() {
        return this.changedFieldName;
    }

    public String errorMessageFieldName() {
        return this.errorMessageFieldName;
    }

    public StructField normalizationStatusStructField() {
        return this.normalizationStatusStructField;
    }

    public StructType normalizationResultStructType() {
        return this.normalizationResultStructType;
    }

    public static final /* synthetic */ boolean $anonfun$normalizeVariant$1(IntRef nTrimmedBasesBeforeNextPadding$1, CharRef firstBaseFromRightInRefAllele$1, String a) {
        return StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(a), a.length() - nTrimmedBasesBeforeNextPadding$1.elem - 1) == firstBaseFromRightInRefAllele$1.elem;
    }

    public static final /* synthetic */ boolean $anonfun$normalizeVariant$5(IntRef nLeftTrimBases$1, CharRef firstBaseFromLeftInRefAllele$1, String x$4) {
        return StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(x$4), nLeftTrimBases$1.elem) == firstBaseFromLeftInRefAllele$1.elem;
    }

    public static final /* synthetic */ boolean $anonfun$isSNP$1(String x$6) {
        return x$6.length() == 1;
    }

    private VariantNormalizer$() {
        MODULE$ = this;
        LazyLogging.$init$((LazyLogging)this);
        this.PAD_WINDOW_SIZE = 100;
        this.normalizationResultFieldName = "normalizationResult";
        this.normalizationStatusFieldName = "normalizationStatus";
        this.changedFieldName = "changed";
        this.errorMessageFieldName = "errorMessage";
        this.normalizationStatusStructField = new StructField(this.normalizationStatusFieldName(), (DataType)StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField(this.changedFieldName(), (DataType)BooleanType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField(this.errorMessageFieldName(), (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())}))), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
        this.normalizationResultStructType = StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{VariantSchemas$.MODULE$.startField(), VariantSchemas$.MODULE$.endField(), VariantSchemas$.MODULE$.refAlleleField(), VariantSchemas$.MODULE$.alternateAllelesField(), this.normalizationStatusStructField()})));
    }
}

