/*
 * Decompiled with CFR 0.152.
 */
package io.projectglow.transformers.pipe;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import io.projectglow.common.GlowLogging;
import io.projectglow.transformers.pipe.InputFormatter;
import io.projectglow.transformers.pipe.OutputFormatter;
import io.projectglow.transformers.pipe.PipeIterator;
import java.io.Serializable;
import org.apache.spark.SparkContext;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLUtils$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.storage.StorageLevel$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;

public final class Piper$
implements GlowLogging {
    public static Piper$ MODULE$;
    private final ListBuffer<RDD<?>> cachedRdds;
    private Logger logger;
    private volatile boolean bitmap$0;

    static {
        new Piper$();
    }

    private Logger logger$lzycompute() {
        Piper$ piper$ = this;
        synchronized (piper$) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    private ListBuffer<RDD<?>> cachedRdds() {
        return this.cachedRdds;
    }

    public void clearCache() {
        ListBuffer<RDD<?>> listBuffer = this.cachedRdds();
        synchronized (listBuffer) {
            Option option = SparkSession$.MODULE$.getActiveSession();
            if (None$.MODULE$.equals(option)) {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (option instanceof Some) {
                Some some = (Some)option;
                SparkSession spark = (SparkSession)some.value();
                this.cachedRdds().foreach((Function1 & Serializable & scala.Serializable)rdd -> {
                    SparkContext sparkContext = rdd.sparkContext();
                    SparkContext sparkContext2 = spark.sparkContext();
                    return !(sparkContext != null ? !sparkContext.equals(sparkContext2) : sparkContext2 != null) ? rdd.unpersist(rdd.unpersist$default$1()) : BoxedUnit.UNIT;
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError((Object)option);
            }
            this.cachedRdds().clear();
        }
    }

    public Dataset<Row> pipe(InputFormatter informatter, OutputFormatter outputformatter, Seq<String> cmd, Map<String, String> env, Dataset<Row> df) {
        RDD<InternalRow> rDD;
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Beginning pipe with cmd {}", new Object[]{cmd});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        RDD<InternalRow> rawRdd = df.queryExecution().toRdd();
        if (rawRdd.getNumPartitions() == 0) {
            BoxedUnit boxedUnit2;
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn("Not piping any rows, as the input DataFrame has zero partitions.");
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            rDD = SQLUtils$.MODULE$.createEmptyRDD(df.sparkSession(), SQLUtils$.MODULE$.createEmptyRDD$default$2());
        } else {
            rDD = rawRdd;
        }
        RDD<InternalRow> inputRdd = rDD;
        RDD schemaInternalRowRDD = inputRdd.mapPartitions((Function1 & Serializable & scala.Serializable)it -> it.isEmpty() ? package$.MODULE$.Iterator().empty() : new PipeIterator(cmd, env, (Iterator<InternalRow>)it, informatter, outputformatter), inputRdd.mapPartitions$default$2(), ClassTag$.MODULE$.Any()).persist(StorageLevel$.MODULE$.DISK_ONLY());
        ListBuffer<RDD<?>> listBuffer = this.cachedRdds();
        synchronized (listBuffer) {
            this.cachedRdds().append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RDD[]{schemaInternalRowRDD}));
        }
        StructType[] schemaSeq = (StructType[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])schemaInternalRowRDD.mapPartitions((Function1 & Serializable & scala.Serializable)it -> it.hasNext() ? package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructType[]{(StructType)it.next()})) : package$.MODULE$.Iterator().empty(), schemaInternalRowRDD.mapPartitions$default$2(), ClassTag$.MODULE$.apply(StructType.class)).collect())).distinct();
        if (schemaSeq.length != 1) {
            throw new IllegalStateException(new StringBuilder(43).append("Cannot infer schema: saw ").append(schemaSeq.length).append(" distinct schemas.").toString());
        }
        StructType schema = (StructType)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])schemaSeq)).head();
        RDD internalRowRDD = schemaInternalRowRDD.mapPartitions((Function1 & Serializable & scala.Serializable)it -> it.drop(1), schemaInternalRowRDD.mapPartitions$default$2(), ClassTag$.MODULE$.apply(InternalRow.class));
        return SQLUtils$.MODULE$.internalCreateDataFrame(df.sparkSession(), (RDD<InternalRow>)internalRowRDD, schema, false);
    }

    private Piper$() {
        MODULE$ = this;
        LazyLogging.$init$((LazyLogging)this);
        this.cachedRdds = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
    }
}

