/*
 * Decompiled with CFR 0.152.
 */
package io.projectglow.transformers.splitmultiallelics;

import com.google.common.annotations.VisibleForTesting;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import io.projectglow.common.GlowLogging;
import io.projectglow.common.VariantSchemas$;
import io.projectglow.transformers.splitmultiallelics.VariantSplitter$;
import io.projectglow.vcf.InternalRowToVariantContextConverter$;
import java.io.Serializable;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLUtils$;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.Option;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class VariantSplitter$
implements GlowLogging {
    public static VariantSplitter$ MODULE$;
    @VisibleForTesting
    private final String splitAlleleIdxFieldName;
    @VisibleForTesting
    private final String splitAllelesFieldName;
    private final String oldMultiallelicFieldName;
    private Logger logger;
    private volatile boolean bitmap$0;

    static {
        new VariantSplitter$();
    }

    private Logger logger$lzycompute() {
        VariantSplitter$ variantSplitter$ = this;
        synchronized (variantSplitter$) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    public Dataset<Row> splitVariants(Dataset<Row> variantDf) {
        BoxedUnit boxedUnit;
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])variantDf.schema().fieldNames())).contains((Object)"attributes")) {
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn("The variant splitting transformer does not split unflattened INFO fields within the attributes column.");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Dataset dfAfterAltAlleleSplit = variantDf.withColumn(VariantSchemas$.MODULE$.splitFromMultiAllelicField().name(), functions$.MODULE$.when(functions$.MODULE$.size(functions$.MODULE$.col(VariantSchemas$.MODULE$.alternateAllelesField().name())).$greater((Object)BoxesRunTime.boxToInteger((int)1)), (Object)functions$.MODULE$.lit((Object)BoxesRunTime.boxToBoolean((boolean)true))).otherwise((Object)functions$.MODULE$.lit((Object)BoxesRunTime.boxToBoolean((boolean)false)))).withColumn(new StringBuilder(0).append(VariantSchemas$.MODULE$.infoFieldPrefix()).append(this.oldMultiallelicFieldName()).toString(), functions$.MODULE$.when(functions$.MODULE$.col(VariantSchemas$.MODULE$.splitFromMultiAllelicField().name()), (Object)functions$.MODULE$.concat((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(VariantSchemas$.MODULE$.contigNameField().name()), functions$.MODULE$.lit((Object)":"), functions$.MODULE$.col(VariantSchemas$.MODULE$.startField().name()).$plus((Object)BoxesRunTime.boxToInteger((int)1)), functions$.MODULE$.lit((Object)":"), functions$.MODULE$.concat_ws("/", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(VariantSchemas$.MODULE$.refAlleleField().name()), functions$.MODULE$.col(VariantSchemas$.MODULE$.alternateAllelesField().name())}))}))).otherwise((Object)functions$.MODULE$.lit(null))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("*"), functions$.MODULE$.posexplode(functions$.MODULE$.col(VariantSchemas$.MODULE$.alternateAllelesField().name())).as((String[])((Object[])new String[]{this.splitAlleleIdxFieldName(), this.splitAllelesFieldName()}))}));
        Dataset<Row> dfAfterInfoSplit = this.splitInfoFields((Dataset<Row>)dfAfterAltAlleleSplit);
        return this.splitGenotypeFields(dfAfterInfoSplit).withColumn(VariantSchemas$.MODULE$.alternateAllelesField().name(), functions$.MODULE$.array((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.splitAllelesFieldName())}))).drop((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.splitAlleleIdxFieldName(), this.splitAllelesFieldName()}));
    }

    @VisibleForTesting
    public Dataset<Row> splitInfoFields(Dataset<Row> variantDf) {
        return (Dataset)((TraversableOnce)variantDf.schema().filter((Function1 & Serializable & scala.Serializable)field -> BoxesRunTime.boxToBoolean((boolean)VariantSplitter$.$anonfun$splitInfoFields$1(field)))).foldLeft(variantDf, (Function2 & Serializable & scala.Serializable)(df, field) -> df.withColumn(field.name(), functions$.MODULE$.when(functions$.MODULE$.col(VariantSchemas$.MODULE$.splitFromMultiAllelicField().name()).$amp$amp((Object)functions$.MODULE$.size(functions$.MODULE$.col(field.name())).$eq$eq$eq((Object)functions$.MODULE$.size(functions$.MODULE$.col(VariantSchemas$.MODULE$.alternateAllelesField().name())))), (Object)functions$.MODULE$.array((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.expr(new StringBuilder(2).append(field.name()).append("[").append(MODULE$.splitAlleleIdxFieldName()).append("]").toString())}))).otherwise((Object)functions$.MODULE$.col(field.name()))));
    }

    @VisibleForTesting
    public Dataset<Row> splitGenotypeFields(Dataset<Row> variantDf) {
        Dataset dataset;
        Option<StructType> gSchema = InternalRowToVariantContextConverter$.MODULE$.getGenotypeSchema(variantDf.schema());
        if (gSchema.isEmpty()) {
            dataset = variantDf;
        } else {
            Dataset withExtractedFields = ((Dataset)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((StructType)gSchema.get()).fields())).foldLeft(variantDf, (Function2 & Serializable & scala.Serializable)(df, field) -> df.withColumn(field.name(), functions$.MODULE$.expr(new StringBuilder(20).append("transform(").append(VariantSchemas$.MODULE$.genotypesFieldName()).append(", g -> g.").append(field.name()).append(")").toString())))).drop(VariantSchemas$.MODULE$.genotypesFieldName());
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
            public final class Io_projectglow_transformers_splitmultiallelics_VariantSplitter$$typecreator1$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Array"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$));
                }

                public Io_projectglow_transformers_splitmultiallelics_VariantSplitter$$typecreator1$1() {
                }
            }
            withExtractedFields.sqlContext().udf().register("likelihoodSplitUdf", (Function3 & Serializable & scala.Serializable)(numAlleles, ploidy, alleleIdx) -> VariantSplitter$.MODULE$.refAltColexOrderIdxArray(BoxesRunTime.unboxToInt((Object)numAlleles), BoxesRunTime.unboxToInt((Object)ploidy), BoxesRunTime.unboxToInt((Object)alleleIdx)), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Io_projectglow_transformers_splitmultiallelics_VariantSplitter$$typecreator1$1()), ((TypeTags)package$.MODULE$.universe()).TypeTag().Int(), ((TypeTags)package$.MODULE$.universe()).TypeTag().Int(), ((TypeTags)package$.MODULE$.universe()).TypeTag().Int());
            dataset = ((Dataset)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((StructType)gSchema.get()).fields())).foldLeft((Object)withExtractedFields, (Function2 & Serializable & scala.Serializable)(df, field) -> {
                StructField structField = field;
                Dataset dataset = SQLUtils$.MODULE$.structFieldsEqualExceptNullability(VariantSchemas$.MODULE$.genotypeLikelihoodsField(), structField) | SQLUtils$.MODULE$.structFieldsEqualExceptNullability(VariantSchemas$.MODULE$.phredLikelihoodsField(), structField) | SQLUtils$.MODULE$.structFieldsEqualExceptNullability(VariantSchemas$.MODULE$.posteriorProbabilitiesField(), structField) ? df.withColumn(structField.name(), functions$.MODULE$.when(functions$.MODULE$.col(VariantSchemas$.MODULE$.splitFromMultiAllelicField().name()), (Object)functions$.MODULE$.expr(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(868).append("transform(").append(structField.name()).append(", c ->\n                         |     filter(\n                         |        transform(\n                         |            c, (x, idx) ->\n                         |              if (\n                         |                  array_contains(\n                         |                      likelihoodSplitUdf(\n                         |                            size(").append(VariantSchemas$.MODULE$.alternateAllelesField().name()).append(") + 1,\n                         |                            size(").append(VariantSchemas$.MODULE$.callsField().name()).append("[0]),\n                         |                            ").append(MODULE$.splitAlleleIdxFieldName()).append(" + 1\n                         |                      ),\n                         |                      idx\n                         |                  ), x, null\n                         |              )\n                         |        ),\n                         |        x -> !isnull(x)\n                         |      )\n                         |   )").toString())).stripMargin())).otherwise((Object)functions$.MODULE$.col(structField.name()))) : (SQLUtils$.MODULE$.structFieldsEqualExceptNullability(VariantSchemas$.MODULE$.callsField(), structField) ? df.withColumn(structField.name(), functions$.MODULE$.when(functions$.MODULE$.col(VariantSchemas$.MODULE$.splitFromMultiAllelicField().name()), (Object)functions$.MODULE$.expr(new StringBuilder(12).append("transform(").append(structField.name()).append(", ").append(new StringBuilder(60).append("c -> transform(c, x -> if(x == 0, x, if(x == ").append(MODULE$.splitAlleleIdxFieldName()).append(" + 1, 1, -1))))").toString()).toString())).otherwise((Object)functions$.MODULE$.col(structField.name()))) : (structField.dataType() instanceof ArrayType ? df.withColumn(structField.name(), functions$.MODULE$.when(functions$.MODULE$.col(VariantSchemas$.MODULE$.splitFromMultiAllelicField().name()), (Object)functions$.MODULE$.expr(new StringBuilder(42).append("transform(").append(structField.name()).append(", c -> if(size(c) == size(").append(VariantSchemas$.MODULE$.alternateAllelesField().name()).append(") + 1,").append(new StringBuilder(29).append(" array(c[0], c[").append(MODULE$.splitAlleleIdxFieldName()).append(" + 1]), null))").toString()).toString())).otherwise((Object)functions$.MODULE$.col(structField.name()))) : df));
                return dataset;
            })).withColumn(VariantSchemas$.MODULE$.genotypesFieldName(), functions$.MODULE$.arrays_zip((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((StructType)gSchema.get()).fieldNames())).map((Function1 & Serializable & scala.Serializable)x$1 -> functions$.MODULE$.col(x$1), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Column.class)))))).drop((Seq)Predef$.MODULE$.wrapRefArray((Object[])((StructType)gSchema.get()).fieldNames()));
        }
        return dataset;
    }

    @VisibleForTesting
    public int[] refAltColexOrderIdxArray(int numAlleles, int ploidy, int altAlleleIdx) {
        int i;
        if (ploidy < 1) {
            throw new IllegalArgumentException("Ploidy must be at least 1.");
        }
        if (numAlleles < 2) {
            throw new IllegalArgumentException("Number of alleles must be at least 2 (one REF and at least one ALT).");
        }
        if (altAlleleIdx > numAlleles - 1 || altAlleleIdx < 1) {
            throw new IllegalArgumentException("Alternate allele index must be at least 1 and at most one less than number of alleles.");
        }
        int[] idxArray = new int[ploidy + 1];
        idxArray[0] = 0;
        idxArray[ploidy] = altAlleleIdx;
        for (i = 1; i < ploidy; ++i) {
            idxArray[ploidy - i] = idxArray[ploidy - i + 1] * (i + altAlleleIdx) / (i + 1);
        }
        for (i = 1; i <= ploidy; ++i) {
            idxArray[i] = idxArray[i] + idxArray[i - 1];
        }
        return idxArray;
    }

    public String splitAlleleIdxFieldName() {
        return this.splitAlleleIdxFieldName;
    }

    public String splitAllelesFieldName() {
        return this.splitAllelesFieldName;
    }

    private String oldMultiallelicFieldName() {
        return this.oldMultiallelicFieldName;
    }

    public static final /* synthetic */ boolean $anonfun$splitInfoFields$1(StructField field) {
        return field.name().startsWith(VariantSchemas$.MODULE$.infoFieldPrefix()) && field.dataType() instanceof ArrayType;
    }

    private VariantSplitter$() {
        MODULE$ = this;
        LazyLogging.$init$((LazyLogging)this);
        this.splitAlleleIdxFieldName = "splitAlleleIdx";
        this.splitAllelesFieldName = "splitAlleles";
        this.oldMultiallelicFieldName = "OLD_MULTIALLELIC";
    }
}

