/*
 * Decompiled with CFR 0.152.
 */
package io.projectglow.vcf;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import htsjdk.samtools.ValidationStringency;
import htsjdk.variant.vcf.VCFHeaderLine;
import io.projectglow.common.logging.HlsEventRecorder;
import io.projectglow.common.logging.HlsTagValues$;
import io.projectglow.common.logging.HlsUsageLogging;
import io.projectglow.common.logging.MetricDefinition;
import io.projectglow.common.logging.TagDefinition;
import io.projectglow.sql.BigFileDatasource$;
import io.projectglow.sql.util.SerializableConfiguration;
import io.projectglow.vcf.SampleIdInfo;
import io.projectglow.vcf.SampleIds;
import io.projectglow.vcf.VCFFileFormat$;
import io.projectglow.vcf.VCFFileWriter;
import io.projectglow.vcf.VCFHeaderUtils$;
import io.projectglow.vcf.VCFOptionParser$;
import io.projectglow.vcf.VCFWriterUtils$;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.spark.SparkException;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLUtils$;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.types.StructType;
import org.seqdoop.hadoop_bam.util.GlowBGZFOutputStream$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class BigVCFDatasource$
implements HlsEventRecorder {
    public static BigVCFDatasource$ MODULE$;
    private Logger logger;
    private volatile boolean bitmap$0;

    static {
        new BigVCFDatasource$();
    }

    @Override
    public void recordHlsEvent(String tag, Map<String, Object> options) {
        HlsEventRecorder.recordHlsEvent$(this, tag, options);
    }

    @Override
    public Map<String, Object> recordHlsEvent$default$2() {
        return HlsEventRecorder.recordHlsEvent$default$2$(this);
    }

    @Override
    public void recordHlsUsage(MetricDefinition metric, Map<TagDefinition, String> tags, String blob) {
        HlsUsageLogging.recordHlsUsage$(this, metric, tags, blob);
    }

    @Override
    public Map<TagDefinition, String> recordHlsUsage$default$2() {
        return HlsUsageLogging.recordHlsUsage$default$2$(this);
    }

    @Override
    public String recordHlsUsage$default$3() {
        return HlsUsageLogging.recordHlsUsage$default$3$(this);
    }

    @Override
    public String hlsJsonBuilder(Map<String, Object> options) {
        return HlsUsageLogging.hlsJsonBuilder$(this, options);
    }

    private Logger logger$lzycompute() {
        BigVCFDatasource$ bigVCFDatasource$ = this;
        synchronized (bigVCFDatasource$) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    public RDD<byte[]> serializeDataFrame(Map<String, String> options, Dataset<Row> data) {
        RDD<InternalRow> rDD;
        this.recordHlsEvent(HlsTagValues$.MODULE$.EVENT_BIGVCF_WRITE(), this.recordHlsEvent$default$2());
        VCFFileFormat$.MODULE$.requireWritableAsVCF(data.schema());
        StructType schema = data.schema();
        RDD<InternalRow> rawRdd = data.queryExecution().toRdd();
        if (rawRdd.getNumPartitions() == 0) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn("Writing VCF header only as the input DataFrame has zero partitions.");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            rDD = SQLUtils$.MODULE$.createEmptyRDD(data.sparkSession(), SQLUtils$.MODULE$.createEmptyRDD$default$2());
        } else {
            rDD = rawRdd;
        }
        RDD<InternalRow> inputRdd = rDD;
        int nParts = inputRdd.getNumPartitions();
        Configuration conf = VCFFileFormat$.MODULE$.hadoopConfWithBGZ(data.sparkSession().sparkContext().hadoopConfiguration());
        SerializableConfiguration serializableConf = new SerializableConfiguration(conf);
        int firstNonemptyPartition = new ArrayOps.ofBoolean(Predef$.MODULE$.booleanArrayOps((boolean[])inputRdd.mapPartitions((Function1 & Serializable & scala.Serializable)iter -> package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{iter.nonEmpty()})), inputRdd.mapPartitions$default$2(), ClassTag$.MODULE$.Boolean()).collect())).indexOf((Object)BoxesRunTime.boxToBoolean((boolean)true));
        if (firstNonemptyPartition == -1 && options.get((Object)VCFHeaderUtils$.MODULE$.VCF_HEADER_KEY()).forall((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)BigVCFDatasource$.$anonfun$serializeDataFrame$2(x$1)))) {
            throw new SparkException("Cannot infer header for empty VCF.");
        }
        Tuple2<Set<VCFHeaderLine>, SampleIdInfo> tuple2 = VCFHeaderUtils$.MODULE$.parseHeaderLinesAndSamples(options, (Option<String>)new Some((Object)VCFHeaderUtils$.MODULE$.INFER_HEADER()), schema, conf);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Set headerLineSet = (Set)tuple2._1();
        SampleIdInfo providedSampleIds = (SampleIdInfo)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)headerLineSet, (Object)providedSampleIds);
        Tuple2 tuple23 = tuple22;
        Set headerLineSet2 = (Set)tuple23._1();
        SampleIdInfo providedSampleIds2 = (SampleIdInfo)tuple23._2();
        SampleIdInfo sampleIdInfo = providedSampleIds2 instanceof SampleIds ? providedSampleIds2 : VCFWriterUtils$.MODULE$.inferSampleIdsIfPresent(data);
        ValidationStringency validationStringency = VCFOptionParser$.MODULE$.getValidationStringency(options);
        return inputRdd.mapPartitionsWithIndex((Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> BigVCFDatasource$.$anonfun$serializeDataFrame$3(serializableConf, options, nParts, firstNonemptyPartition, headerLineSet2, sampleIdInfo, validationStringency, schema, BoxesRunTime.unboxToInt((Object)x0$1), x1$1), inputRdd.mapPartitionsWithIndex$default$2(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)));
    }

    public static final /* synthetic */ boolean $anonfun$serializeDataFrame$2(String x$1) {
        String string = x$1;
        String string2 = VCFHeaderUtils$.MODULE$.INFER_HEADER();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ Iterator $anonfun$serializeDataFrame$3(SerializableConfiguration serializableConf$1, Map options$1, int nParts$1, int firstNonemptyPartition$1, Set headerLineSet$1, SampleIdInfo sampleIdInfo$1, ValidationStringency validationStringency$1, StructType schema$1, int x0$1, Iterator x1$1) {
        Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)x0$1), (Object)x1$1);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int idx = tuple2._1$mcI$sp();
        Iterator it = (Iterator)tuple2._2();
        Configuration conf = serializableConf$1.value();
        CompressionCodecFactory codec = new CompressionCodecFactory(conf);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        OutputStream outputStream = (OutputStream)Option$.MODULE$.apply((Object)codec.getCodec(new Path(BigFileDatasource$.MODULE$.checkPath((Map<String, String>)options$1)))).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.createOutputStream((OutputStream)baos)).getOrElse((Function0 & Serializable & scala.Serializable)() -> baos);
        GlowBGZFOutputStream$.MODULE$.setWriteEmptyBlockOnClose(outputStream, idx == nParts$1 - 1);
        int partitionWithHeader = firstNonemptyPartition$1 == -1 ? 0 : firstNonemptyPartition$1;
        VCFFileWriter writer = new VCFFileWriter((Set<VCFHeaderLine>)headerLineSet$1, sampleIdInfo$1, validationStringency$1, schema$1, conf, outputStream, idx == partitionWithHeader);
        it.foreach((Function1 & Serializable & scala.Serializable)row -> {
            writer.write(row);
            return BoxedUnit.UNIT;
        });
        writer.close();
        Iterator iterator = package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new byte[][]{baos.toByteArray()}));
        return iterator;
    }

    private BigVCFDatasource$() {
        MODULE$ = this;
        LazyLogging.$init$((LazyLogging)this);
        HlsUsageLogging.$init$(this);
        HlsEventRecorder.$init$(this);
    }
}

