/*
 * Decompiled with CFR 0.152.
 */
package io.projectglow.vcf;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import htsjdk.samtools.ValidationStringency;
import htsjdk.variant.variantcontext.Allele;
import htsjdk.variant.variantcontext.GenotypeBuilder;
import htsjdk.variant.variantcontext.GenotypesContext;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.VariantContextBuilder;
import htsjdk.variant.vcf.VCFCompoundHeaderLine;
import htsjdk.variant.vcf.VCFFormatHeaderLine;
import htsjdk.variant.vcf.VCFHeader;
import htsjdk.variant.vcf.VCFHeaderLine;
import htsjdk.variant.vcf.VCFInfoHeaderLine;
import io.projectglow.common.ConverterUtils$;
import io.projectglow.common.GenotypeFields$;
import io.projectglow.common.HasStringency;
import io.projectglow.common.VariantSchemas$;
import io.projectglow.vcf.AnnotationUtils$;
import io.projectglow.vcf.InternalRowToVariantContextConverter$;
import io.projectglow.vcf.VCFSchemaInferrer$;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import org.apache.spark.sql.SQLUtils$;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.MapData;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.GenTraversable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.HashSet$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\t=h\u0001\u0002\u001b6\u0001qB\u0001b\u0014\u0001\u0003\u0002\u0003\u0006I\u0001\u0015\u0005\t=\u0002\u0011\t\u0011)A\u0005?\"A1\u000f\u0001BC\u0002\u0013\u0005A\u000f\u0003\u0005|\u0001\t\u0005\t\u0015!\u0003v\u0011\u0015a\b\u0001\"\u0001~\u0011%\t9\u0001\u0001b\u0001\n\u0013\tI\u0001\u0003\u0005\u0002(\u0001\u0001\u000b\u0011BA\u0006\u0011%\tI\u0003\u0001b\u0001\n\u0013\tY\u0003\u0003\u0005\u00024\u0001\u0001\u000b\u0011BA\u0017\u0011%\t)\u0004\u0001b\u0001\n\u0013\t9\u0004\u0003\u0005\u0002F\u0001\u0001\u000b\u0011BA\u001d\u0011%\t9\u0005\u0001b\u0001\n\u0013\t9\u0004\u0003\u0005\u0002J\u0001\u0001\u000b\u0011BA\u001d\u0011%\tY\u0005\u0001b\u0001\n\u0013\ti\u0005\u0003\u0005\u0002h\u0001\u0001\u000b\u0011BA(\u0011%\tI\u0007\u0001b\u0001\n\u0013\ti\u0005\u0003\u0005\u0002l\u0001\u0001\u000b\u0011BA(\u0011%\ti\u0007\u0001b\u0001\n\u0003\ty\u0007\u0003\u0005\u0002x\u0001\u0001\u000b\u0011BA9\u0011\u001d\tI\b\u0001C\u0001\u0003wB!\"a!\u0001\u0011\u000b\u0007I\u0011BAC\u0011\u001d\t\t\u000b\u0001C\u0005\u0003GCq!!0\u0001\t\u0003\ty\fC\u0004\u0002F\u0002!I!a2\t\u000f\u0005}\u0007\u0001\"\u0003\u0002b\"9\u0011\u0011\u001e\u0001\u0005\n\u0005-\bbBAz\u0001\u0011%\u0011Q\u001f\u0005\b\u0003{\u0004A\u0011BA\u0000\u0011\u001d\u00119\u0001\u0001C\u0005\u0005\u0013AqA!\u0005\u0001\t\u0013\u0011\u0019\u0002C\u0004\u0003\u001c\u0001!IA!\b\t\u000f\t\u0015\u0002\u0001\"\u0003\u0003(!9!q\u0006\u0001\u0005\n\tE\u0002b\u0002B!\u0001\u0011%!1\t\u0005\b\u0005+\u0002A\u0011\u0002B,\u0011\u001d\u00119\u0007\u0001C\u0005\u0005SBqA!\u001d\u0001\t\u0013\u0011\u0019\bC\u0004\u0003|\u0001!IA! \t\u000f\t\u0015\u0005\u0001\"\u0003\u0003\b\"9!q\u0012\u0001\u0005\n\tE\u0005b\u0002BM\u0001\u0011%!1\u0014\u0005\b\u0005G\u0003A\u0011\u0002BS\u0011\u001d\u0011i\u000b\u0001C\u0005\u0005_CqAa.\u0001\t\u0013\u0011I\fC\u0004\u0003B\u0002!IAa1\t\u000f\t5\u0007\u0001\"\u0003\u0003P\u001e9!q[\u001b\t\u0002\tegA\u0002\u001b6\u0011\u0003\u0011Y\u000e\u0003\u0004}a\u0011\u0005!Q\u001c\u0005\b\u0005?\u0004D\u0011\u0001Bq\u0011%\u0011)\u000fMA\u0001\n\u0013\u00119O\u0001\u0013J]R,'O\\1m%><Hk\u001c,be&\fg\u000e^\"p]R,\u0007\u0010^\"p]Z,'\u000f^3s\u0015\t1t'A\u0002wG\u001aT!\u0001O\u001d\u0002\u0017A\u0014xN[3di\u001edwn\u001e\u0006\u0002u\u0005\u0011\u0011n\\\u0002\u0001'\u0015\u0001QhQ%M!\tq\u0014)D\u0001@\u0015\u0005\u0001\u0015!B:dC2\f\u0017B\u0001\"@\u0005\u0019\te.\u001f*fMB\u0011AiR\u0007\u0002\u000b*\u0011aiN\u0001\u0007G>lWn\u001c8\n\u0005!+%aC$m_^dunZ4j]\u001e\u0004\"\u0001\u0012&\n\u0005-+%!\u0004%bgN#(/\u001b8hK:\u001c\u0017\u0010\u0005\u0002?\u001b&\u0011aj\u0010\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\ne><8k\u00195f[\u0006\u0004\"!\u0015/\u000e\u0003IS!a\u0015+\u0002\u000bQL\b/Z:\u000b\u0005U3\u0016aA:rY*\u0011q\u000bW\u0001\u0006gB\f'o\u001b\u0006\u00033j\u000ba!\u00199bG\",'\"A.\u0002\u0007=\u0014x-\u0003\u0002^%\nQ1\u000b\u001e:vGR$\u0016\u0010]3\u0002\u001b!,\u0017\rZ3s\u0019&tWmU3u!\r\u0001wM\u001b\b\u0003C\u0016\u0004\"AY \u000e\u0003\rT!\u0001Z\u001e\u0002\rq\u0012xn\u001c;?\u0013\t1w(\u0001\u0004Qe\u0016$WMZ\u0005\u0003Q&\u00141aU3u\u0015\t1w\b\u0005\u0002lc6\tAN\u0003\u00027[*\u0011an\\\u0001\bm\u0006\u0014\u0018.\u00198u\u0015\u0005\u0001\u0018A\u00025ug*$7.\u0003\u0002sY\niak\u0011$IK\u0006$WM\u001d'j]\u0016\f!b\u001d;sS:<WM\\2z+\u0005)\bC\u0001<z\u001b\u00059(B\u0001=p\u0003!\u0019\u0018-\u001c;p_2\u001c\u0018B\u0001>x\u0005Q1\u0016\r\\5eCRLwN\\*ue&tw-\u001a8ds\u0006Y1\u000f\u001e:j]\u001e,gnY=!\u0003\u0019a\u0014N\\5u}Q9a0!\u0001\u0002\u0004\u0005\u0015\u0001CA@\u0001\u001b\u0005)\u0004\"B(\u0006\u0001\u0004\u0001\u0006\"\u00020\u0006\u0001\u0004y\u0006\"B:\u0006\u0001\u0004)\u0018aB1mY\u0016dWm]\u000b\u0003\u0003\u0017\u0001b!!\u0004\u0002\u0018\u0005mQBAA\b\u0015\u0011\t\t\"a\u0005\u0002\u000f5,H/\u00192mK*\u0019\u0011QC \u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002\u001a\u0005=!aC!se\u0006L()\u001e4gKJ\u0004B!!\b\u0002$5\u0011\u0011q\u0004\u0006\u0004\u0003Ci\u0017A\u0004<be&\fg\u000e^2p]R,\u0007\u0010^\u0005\u0005\u0003K\tyB\u0001\u0004BY2,G.Z\u0001\tC2dW\r\\3tA\u0005qq-\u001a8pif\u0004XmU2iK6\fWCAA\u0017!\u0011q\u0014q\u0006)\n\u0007\u0005ErH\u0001\u0004PaRLwN\\\u0001\u0010O\u0016tw\u000e^=qKN\u001b\u0007.Z7bA\u0005Y\u0012N\u001c4p\u0017\u0016L8\u000fU1sg\u0016$w+\u001b;i_V$\b*Z1eKJ,\"!!\u000f\u0011\r\u00055\u00111HA \u0013\u0011\ti$a\u0004\u0003\u000f!\u000b7\u000f[*fiB\u0019\u0001-!\u0011\n\u0007\u0005\r\u0013N\u0001\u0004TiJLgnZ\u0001\u001dS:4wnS3zgB\u000b'o]3e/&$\bn\\;u\u0011\u0016\fG-\u001a:!\u0003u1wN]7bi.+\u0017p\u001d)beN,GmV5uQ>,H\u000fS3bI\u0016\u0014\u0018A\b4pe6\fGoS3zgB\u000b'o]3e/&$\bn\\;u\u0011\u0016\fG-\u001a:!\u0003A18MR5fY\u0012\u001cHk\\%h]>\u0014X-\u0006\u0002\u0002PA1\u0011\u0011KA,\u00033j!!a\u0015\u000b\t\u0005U\u00131C\u0001\nS6lW\u000f^1cY\u0016L1\u0001[A*!\u0011\tY&!\u001a\u000e\u0005\u0005u#\u0002BA0\u0003C\nA\u0001\\1oO*\u0011\u00111M\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002D\u0005u\u0013!\u0005<d\r&,G\u000eZ:U_&;gn\u001c:fA\u0005ar-\u001a8pif\u0004XMR5fY\u0012\u001cx+\u001b;i_V$\b*Z1eKJ\u001c\u0018!H4f]>$\u0018\u0010]3GS\u0016dGm],ji\"|W\u000f\u001e%fC\u0012,'o\u001d\u0011\u0002\u0013Y\u001cg\rS3bI\u0016\u0014XCAA9!\rY\u00171O\u0005\u0004\u0003kb'!\u0003,D\r\"+\u0017\rZ3s\u0003)18M\u001a%fC\u0012,'\u000fI\u0001\tm\u0006d\u0017\u000eZ1uKR\u0011\u0011Q\u0010\t\u0004}\u0005}\u0014bAAA\u007f\t!QK\\5u\u0003%\u0019wN\u001c<feR,'/\u0006\u0002\u0002\bB9a(!#\u0002\u000e\u0006e\u0015bAAF\u007f\tIa)\u001e8di&|g.\r\t\u0005\u0003\u001f\u000b)*\u0004\u0002\u0002\u0012*\u0019\u00111\u0013+\u0002\u0011\r\fG/\u00197zgRLA!a&\u0002\u0012\nY\u0011J\u001c;fe:\fGNU8x!\u0015q\u0014qFAN!\u0011\ti\"!(\n\t\u0005}\u0015q\u0004\u0002\u000f-\u0006\u0014\u0018.\u00198u\u0007>tG/\u001a=u\u0003Ui\u0017m[3HK:|G/\u001f9f\u0007>tg/\u001a:uKJ$B!!*\u0002:B9a(!#\u0002(\u0006M\u0006\u0003BAU\u0003_k!!a+\u000b\t\u00055\u0016\u0011S\u0001\u0005kRLG.\u0003\u0003\u00022\u0006-&!C!se\u0006LH)\u0019;b!\u0011\ti\"!.\n\t\u0005]\u0016q\u0004\u0002\u0011\u000f\u0016tw\u000e^=qKN\u001cuN\u001c;fqRDa!a/\u0017\u0001\u0004\u0001\u0016aB4TG\",W.Y\u0001\bG>tg/\u001a:u)\u0011\tI*!1\t\u000f\u0005\rw\u00031\u0001\u0002\u000e\u0006\u0019!o\\<\u0002!U\u0004H-\u0019;f\u0007>tG/[4OC6,G\u0003CAe\u0003\u001f\f\u0019.!6\u0011\t\u0005u\u00111Z\u0005\u0005\u0003\u001b\fyBA\u000bWCJL\u0017M\u001c;D_:$X\r\u001f;Ck&dG-\u001a:\t\u000f\u0005E\u0007\u00041\u0001\u0002J\u0006\u0011ao\u0019\u0005\b\u0003\u0007D\u0002\u0019AAG\u0011\u001d\t9\u000e\u0007a\u0001\u00033\faa\u001c4gg\u0016$\bc\u0001 \u0002\\&\u0019\u0011Q\\ \u0003\u0007%sG/A\u0006va\u0012\fG/Z*uCJ$H\u0003CAe\u0003G\f)/a:\t\u000f\u0005E\u0017\u00041\u0001\u0002J\"9\u00111Y\rA\u0002\u00055\u0005bBAl3\u0001\u0007\u0011\u0011\\\u0001\nkB$\u0017\r^3F]\u0012$\u0002\"!3\u0002n\u0006=\u0018\u0011\u001f\u0005\b\u0003#T\u0002\u0019AAe\u0011\u001d\t\u0019M\u0007a\u0001\u0003\u001bCq!a6\u001b\u0001\u0004\tI.\u0001\u0006va\u0012\fG/Z)vC2$\u0002\"!3\u0002x\u0006e\u00181 \u0005\b\u0003#\\\u0002\u0019AAe\u0011\u001d\t\u0019m\u0007a\u0001\u0003\u001bCq!a6\u001c\u0001\u0004\tI.A\u0006va\u0012\fG/\u001a(b[\u0016\u001cH\u0003CAe\u0005\u0003\u0011\u0019A!\u0002\t\u000f\u0005EG\u00041\u0001\u0002J\"9\u00111\u0019\u000fA\u0002\u00055\u0005bBAl9\u0001\u0007\u0011\u0011\\\u0001\u0016kB$\u0017\r^3SK\u001a,'/\u001a8dK\u0006cG.\u001a7f)!\tIMa\u0003\u0003\u000e\t=\u0001bBAi;\u0001\u0007\u0011\u0011\u001a\u0005\b\u0003\u0007l\u0002\u0019AAG\u0011\u001d\t9.\ba\u0001\u00033\f\u0001#\u001e9eCR,\u0017\t\u001c;BY2,G.Z:\u0015\u0011\u0005%'Q\u0003B\f\u00053Aq!!5\u001f\u0001\u0004\tI\rC\u0004\u0002Dz\u0001\r!!$\t\u000f\u0005]g\u00041\u0001\u0002Z\u0006iQ\u000f\u001d3bi\u00164\u0015\u000e\u001c;feN$\u0002\"!3\u0003 \t\u0005\"1\u0005\u0005\b\u0003#|\u0002\u0019AAe\u0011\u001d\t\u0019m\ba\u0001\u0003\u001bCq!a6 \u0001\u0004\tI.\u0001\tva\u0012\fG/Z!uiJL'-\u001e;fgRA\u0011\u0011\u001aB\u0015\u0005W\u0011i\u0003C\u0004\u0002R\u0002\u0002\r!!3\t\u000f\u0005\r\u0007\u00051\u0001\u0002\u000e\"9\u0011q\u001b\u0011A\u0002\u0005e\u0017!F2sK\u0006$X-\u00118o_R\fG/[8o\u0003J\u0014\u0018-\u001f\u000b\u0007\u0005g\u0011ID!\u0010\u0011\u000by\u0012)$a\u0010\n\u0007\t]rHA\u0003BeJ\f\u0017\u0010\u0003\u0004\u0003<\u0005\u0002\r\u0001U\u0001\u0007g\u000eDW-\\1\t\u000f\t}\u0012\u00051\u0001\u0002(\u00069QM\u001a4fGR\u001c\u0018aD;qI\u0006$X-\u00138g_\u001aKW\r\u001c3\u0015\u0015\u0005%'Q\tB(\u0005#\u0012\u0019\u0006C\u0004\u0003H\t\u0002\rA!\u0013\u0002\u000b\u0019LW\r\u001c3\u0011\u0007E\u0013Y%C\u0002\u0003NI\u00131b\u0015;sk\u000e$h)[3mI\"9\u0011\u0011\u001b\u0012A\u0002\u0005%\u0007bBAbE\u0001\u0007\u0011Q\u0012\u0005\b\u0003/\u0014\u0003\u0019AAm\u00039)\b\u000fZ1uKN\u000bW\u000e\u001d7f\u0013\u0012$\u0002B!\u0017\u0003`\t\r$Q\r\t\u0005\u0003;\u0011Y&\u0003\u0003\u0003^\u0005}!aD$f]>$\u0018\u0010]3Ck&dG-\u001a:\t\u000f\t\u00054\u00051\u0001\u0003Z\u0005Aq-\u001a8pif\u0004X\rC\u0004\u0002D\u000e\u0002\r!!$\t\u000f\u0005]7\u00051\u0001\u0002Z\u0006qQ\u000f\u001d3bi\u0016<E\u000b\u00155bg\u0016$G\u0003\u0003B-\u0005W\u0012iGa\u001c\t\u000f\t\u0005D\u00051\u0001\u0003Z!9\u00111\u0019\u0013A\u0002\u00055\u0005bBAlI\u0001\u0007\u0011\u0011\\\u0001\u000ekB$\u0017\r^3H)\u000e\u000bG\u000e\\:\u0015\u0011\te#Q\u000fB<\u0005sBqA!\u0019&\u0001\u0004\u0011I\u0006C\u0004\u0002D\u0016\u0002\r!!$\t\u000f\u0005]W\u00051\u0001\u0002Z\u0006AQ\u000f\u001d3bi\u0016$\u0005\u000b\u0006\u0005\u0003Z\t}$\u0011\u0011BB\u0011\u001d\u0011\tG\na\u0001\u00053Bq!a1'\u0001\u0004\ti\tC\u0004\u0002X\u001a\u0002\r!!7\u0002\u001fU\u0004H-\u0019;f\u000fR3\u0015\u000e\u001c;feN$\u0002B!\u0017\u0003\n\n-%Q\u0012\u0005\b\u0005C:\u0003\u0019\u0001B-\u0011\u001d\t\u0019m\na\u0001\u0003\u001bCq!a6(\u0001\u0004\tI.\u0001\u0005va\u0012\fG/\u001a)M)!\u0011IFa%\u0003\u0016\n]\u0005b\u0002B1Q\u0001\u0007!\u0011\f\u0005\b\u0003\u0007D\u0003\u0019AAG\u0011\u001d\t9\u000e\u000ba\u0001\u00033\f\u0001\"\u001e9eCR,w\t\u0014\u000b\t\u00053\u0012iJa(\u0003\"\"9!\u0011M\u0015A\u0002\te\u0003bBAbS\u0001\u0007\u0011Q\u0012\u0005\b\u0003/L\u0003\u0019AAm\u0003!)\b\u000fZ1uK\u0006#E\u0003\u0003B-\u0005O\u0013IKa+\t\u000f\t\u0005$\u00061\u0001\u0003Z!9\u00111\u0019\u0016A\u0002\u00055\u0005bBAlU\u0001\u0007\u0011\u0011\\\u0001\tkB$\u0017\r^3H#RA!\u0011\fBY\u0005g\u0013)\fC\u0004\u0003b-\u0002\rA!\u0017\t\u000f\u0005\r7\u00061\u0001\u0002\u000e\"9\u0011q[\u0016A\u0002\u0005e\u0017!E;qI\u0006$Xm\u0014;iKJ4\u0015.\u001a7egRA!\u0011\fB^\u0005{\u0013y\fC\u0004\u0003b1\u0002\rA!\u0017\t\u000f\u0005\rG\u00061\u0001\u0002\u000e\"9\u0011q\u001b\u0017A\u0002\u0005e\u0017!E;qI\u0006$XMR8s[\u0006$h)[3mIRQ!\u0011\fBc\u0005\u000f\u0014IMa3\t\u000f\t\u001dS\u00061\u0001\u0003J!9!\u0011M\u0017A\u0002\te\u0003bBAb[\u0001\u0007\u0011Q\u0012\u0005\b\u0003/l\u0003\u0019AAm\u0003)\u0001\u0018M]:f\r&,G\u000e\u001a\u000b\b{\tE'1\u001bBk\u0011\u001d\u00119E\fa\u0001\u0005\u0013Bq!a1/\u0001\u0004\ti\tC\u0004\u0002X:\u0002\r!!7\u0002I%sG/\u001a:oC2\u0014vn\u001e+p-\u0006\u0014\u0018.\u00198u\u0007>tG/\u001a=u\u0007>tg/\u001a:uKJ\u0004\"a \u0019\u0014\u0007AjD\n\u0006\u0002\u0003Z\u0006\tr-\u001a;HK:|G/\u001f9f'\u000eDW-\\1\u0015\t\u00055\"1\u001d\u0005\u0006\u001fJ\u0002\r\u0001U\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0003jB!\u00111\fBv\u0013\u0011\u0011i/!\u0018\u0003\r=\u0013'.Z2u\u0001")
public class InternalRowToVariantContextConverter
implements HasStringency,
scala.Serializable {
    private Function1<InternalRow, Option<VariantContext>> converter;
    private final StructType rowSchema;
    private final ValidationStringency stringency;
    private final ArrayBuffer<Allele> alleles;
    private final Option<StructType> genotypeSchema;
    private final HashSet<String> infoKeysParsedWithoutHeader;
    private final HashSet<String> formatKeysParsedWithoutHeader;
    private final scala.collection.immutable.Set<String> vcFieldsToIgnore;
    private final scala.collection.immutable.Set<String> genotypeFieldsWithoutHeaders;
    private final VCFHeader vcfHeader;
    private Logger logger;
    private volatile byte bitmap$0;

    public static Option<StructType> getGenotypeSchema(StructType structType) {
        return InternalRowToVariantContextConverter$.MODULE$.getGenotypeSchema(structType);
    }

    @Override
    public void raiseValidationError(String warning, Throwable cause) {
        HasStringency.raiseValidationError$(this, warning, cause);
    }

    @Override
    public Throwable raiseValidationError$default$2() {
        return HasStringency.raiseValidationError$default$2$(this);
    }

    private Logger logger$lzycompute() {
        InternalRowToVariantContextConverter internalRowToVariantContextConverter = this;
        synchronized (internalRowToVariantContextConverter) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public ValidationStringency stringency() {
        return this.stringency;
    }

    private ArrayBuffer<Allele> alleles() {
        return this.alleles;
    }

    private Option<StructType> genotypeSchema() {
        return this.genotypeSchema;
    }

    private HashSet<String> infoKeysParsedWithoutHeader() {
        return this.infoKeysParsedWithoutHeader;
    }

    private HashSet<String> formatKeysParsedWithoutHeader() {
        return this.formatKeysParsedWithoutHeader;
    }

    private scala.collection.immutable.Set<String> vcFieldsToIgnore() {
        return this.vcFieldsToIgnore;
    }

    private scala.collection.immutable.Set<String> genotypeFieldsWithoutHeaders() {
        return this.genotypeFieldsWithoutHeaders;
    }

    public VCFHeader vcfHeader() {
        return this.vcfHeader;
    }

    public void validate() {
        ((IterableLike)this.rowSchema.filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)InternalRowToVariantContextConverter.$anonfun$validate$1(x$1)))).foreach((Function1 & Serializable & scala.Serializable)f -> {
            InternalRowToVariantContextConverter.$anonfun$validate$2(this, f);
            return BoxedUnit.UNIT;
        });
        this.genotypeSchema().foreach((Function1 & Serializable & scala.Serializable)schema -> {
            InternalRowToVariantContextConverter.$anonfun$validate$4(this, schema);
            return BoxedUnit.UNIT;
        });
    }

    private Function1<InternalRow, Option<VariantContext>> converter$lzycompute() {
        InternalRowToVariantContextConverter internalRowToVariantContextConverter = this;
        synchronized (internalRowToVariantContextConverter) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                StructField[] vcFields = this.rowSchema.fields();
                Function3[] fns = new Function3[vcFields.length];
                for (int idx = 0; idx < vcFields.length; ++idx) {
                    Function3 & Serializable & scala.Serializable intersect;
                    StructField structField = vcFields[idx];
                    if (SQLUtils$.MODULE$.structFieldsEqualExceptNullability(structField, VariantSchemas$.MODULE$.contigNameField())) {
                        intersect = (Function3 & Serializable & scala.Serializable)(vc, row, offset) -> this.updateContigName(vc, row, BoxesRunTime.unboxToInt((Object)offset));
                    } else if (SQLUtils$.MODULE$.structFieldsEqualExceptNullability(structField, VariantSchemas$.MODULE$.startField())) {
                        intersect = (Function3 & Serializable & scala.Serializable)(vc, row, offset) -> this.updateStart(vc, row, BoxesRunTime.unboxToInt((Object)offset));
                    } else if (SQLUtils$.MODULE$.structFieldsEqualExceptNullability(structField, VariantSchemas$.MODULE$.endField())) {
                        intersect = (Function3 & Serializable & scala.Serializable)(vc, row, offset) -> this.updateEnd(vc, row, BoxesRunTime.unboxToInt((Object)offset));
                    } else if (SQLUtils$.MODULE$.structFieldsEqualExceptNullability(structField, VariantSchemas$.MODULE$.namesField())) {
                        intersect = (Function3 & Serializable & scala.Serializable)(vc, row, offset) -> this.updateNames(vc, row, BoxesRunTime.unboxToInt((Object)offset));
                    } else if (SQLUtils$.MODULE$.structFieldsEqualExceptNullability(structField, VariantSchemas$.MODULE$.refAlleleField())) {
                        intersect = (Function3 & Serializable & scala.Serializable)(vc, row, offset) -> this.updateReferenceAllele(vc, row, BoxesRunTime.unboxToInt((Object)offset));
                    } else if (SQLUtils$.MODULE$.structFieldsEqualExceptNullability(structField, VariantSchemas$.MODULE$.alternateAllelesField())) {
                        intersect = (Function3 & Serializable & scala.Serializable)(vc, row, offset) -> this.updateAltAlleles(vc, row, BoxesRunTime.unboxToInt((Object)offset));
                    } else if (SQLUtils$.MODULE$.structFieldsEqualExceptNullability(structField, VariantSchemas$.MODULE$.qualField())) {
                        intersect = (Function3 & Serializable & scala.Serializable)(vc, row, offset) -> this.updateQual(vc, row, BoxesRunTime.unboxToInt((Object)offset));
                    } else if (SQLUtils$.MODULE$.structFieldsEqualExceptNullability(structField, VariantSchemas$.MODULE$.filtersField())) {
                        intersect = (Function3 & Serializable & scala.Serializable)(vc, row, offset) -> this.updateFilters(vc, row, BoxesRunTime.unboxToInt((Object)offset));
                    } else if (SQLUtils$.MODULE$.structFieldsEqualExceptNullability(structField, VariantSchemas$.MODULE$.attributesField())) {
                        intersect = (Function3 & Serializable & scala.Serializable)(vc, row, offset) -> this.updateAttributes(vc, row, BoxesRunTime.unboxToInt((Object)offset));
                    } else if (structField.name().startsWith(VariantSchemas$.MODULE$.infoFieldPrefix())) {
                        intersect = (Function3 & Serializable & scala.Serializable)(vc, row, i) -> this.updateInfoField(structField, vc, row, BoxesRunTime.unboxToInt((Object)i));
                    } else if (this.vcFieldsToIgnore().contains((Object)structField.name())) {
                        intersect = (Function3 & Serializable & scala.Serializable)(vc, x$2, x$3) -> vc;
                    } else {
                        BoxedUnit boxedUnit;
                        if (this.logger().underlying().isInfoEnabled()) {
                            this.logger().underlying().info(new java.lang.StringBuilder(71).append("Field ").append(structField).append(" is present in data schema but does not have a ").append("VCF representation").toString());
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        intersect = (Function3 & Serializable & scala.Serializable)(vc, x$4, x$5) -> vc;
                    }
                    fns[idx] = intersect;
                }
                int genotypeIdx = this.rowSchema.indexWhere((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)InternalRowToVariantContextConverter.$anonfun$converter$13(x$6)));
                Function1<ArrayData, GenotypesContext> genotypeBuilder = genotypeIdx > -1 ? this.makeGenotypeConverter((StructType)this.genotypeSchema().get()) : null;
                this.converter = (Function1 & Serializable & scala.Serializable)row -> {
                    Option option;
                    VariantContextBuilder builder = new VariantContextBuilder();
                    builder.source("Unknown");
                    for (int i = 0; i < fns.length; ++i) {
                        Object object = !row.isNullAt(i) ? fns[i].apply((Object)builder, row, (Object)BoxesRunTime.boxToInteger((int)i)) : BoxedUnit.UNIT;
                    }
                    builder.alleles((Collection)JavaConverters$.MODULE$.bufferAsJavaListConverter(this.alleles()).asJava());
                    Object object = genotypeIdx > -1 ? builder.genotypes((GenotypesContext)genotypeBuilder.apply((Object)row.getArray(genotypeIdx))) : BoxedUnit.UNIT;
                    try {
                        option = Option$.MODULE$.apply((Object)builder.make());
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2 = throwable;
                        Option option2 = NonFatal$.MODULE$.unapply(throwable2);
                        if (option2.isEmpty()) {
                            throw throwable;
                        }
                        Throwable ex = (Throwable)option2.get();
                        this.raiseValidationError(new java.lang.StringBuilder(33).append("Could not build variant context: ").append(ex.getMessage()).toString(), this.raiseValidationError$default$2());
                        None$ none$ = None$.MODULE$;
                        option = none$;
                    }
                    return option;
                };
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        this.vcFieldsToIgnore = null;
        return this.converter;
    }

    private Function1<InternalRow, Option<VariantContext>> converter() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.converter$lzycompute() : this.converter;
    }

    private Function1<ArrayData, GenotypesContext> makeGenotypeConverter(StructType gSchema) {
        StructField[] gtFields = gSchema.fields();
        Function3[] fns = new Function3[gtFields.length];
        for (int idx = 0; idx < gtFields.length; ++idx) {
            StructField structField = gtFields[idx];
            Function3 & Serializable & scala.Serializable intersect = SQLUtils$.MODULE$.structFieldsEqualExceptNullability(structField, VariantSchemas$.MODULE$.sampleIdField()) ? (Function3 & Serializable & scala.Serializable)(genotype, row, offset) -> this.updateSampleId(genotype, row, BoxesRunTime.unboxToInt((Object)offset)) : (SQLUtils$.MODULE$.structFieldsEqualExceptNullability(structField, VariantSchemas$.MODULE$.phasedField()) ? (Function3 & Serializable & scala.Serializable)(genotype, row, offset) -> this.updateGTPhased(genotype, row, BoxesRunTime.unboxToInt((Object)offset)) : (SQLUtils$.MODULE$.structFieldsEqualExceptNullability(structField, VariantSchemas$.MODULE$.callsField()) ? (Function3 & Serializable & scala.Serializable)(genotype, row, offset) -> this.updateGTCalls(genotype, row, BoxesRunTime.unboxToInt((Object)offset)) : (SQLUtils$.MODULE$.structFieldsEqualExceptNullability(structField, VariantSchemas$.MODULE$.depthField()) ? (Function3 & Serializable & scala.Serializable)(genotype, row, offset) -> this.updateDP(genotype, row, BoxesRunTime.unboxToInt((Object)offset)) : (SQLUtils$.MODULE$.structFieldsEqualExceptNullability(structField, VariantSchemas$.MODULE$.genotypeFiltersField()) ? (Function3 & Serializable & scala.Serializable)(genotype, row, offset) -> this.updateGTFilters(genotype, row, BoxesRunTime.unboxToInt((Object)offset)) : (SQLUtils$.MODULE$.structFieldsEqualExceptNullability(structField, VariantSchemas$.MODULE$.genotypeLikelihoodsField()) ? (Function3 & Serializable & scala.Serializable)(genotype, row, offset) -> this.updateGL(genotype, row, BoxesRunTime.unboxToInt((Object)offset)) : (SQLUtils$.MODULE$.structFieldsEqualExceptNullability(structField, VariantSchemas$.MODULE$.conditionalQualityField()) ? (Function3 & Serializable & scala.Serializable)(genotype, row, offset) -> this.updateGQ(genotype, row, BoxesRunTime.unboxToInt((Object)offset)) : (SQLUtils$.MODULE$.structFieldsEqualExceptNullability(structField, VariantSchemas$.MODULE$.phredLikelihoodsField()) ? (Function3 & Serializable & scala.Serializable)(genotype, row, offset) -> this.updatePL(genotype, row, BoxesRunTime.unboxToInt((Object)offset)) : (SQLUtils$.MODULE$.structFieldsEqualExceptNullability(structField, VariantSchemas$.MODULE$.alleleDepthsField()) ? (Function3 & Serializable & scala.Serializable)(genotype, row, offset) -> this.updateAD(genotype, row, BoxesRunTime.unboxToInt((Object)offset)) : (SQLUtils$.MODULE$.structFieldsEqualExceptNullability(structField, VariantSchemas$.MODULE$.otherFieldsField()) ? (Function3 & Serializable & scala.Serializable)(genotype, row, offset) -> this.updateOtherFields(genotype, row, BoxesRunTime.unboxToInt((Object)offset)) : (Function3 & Serializable & scala.Serializable)(gb, row, i) -> this.updateFormatField(structField, gb, row, BoxesRunTime.unboxToInt((Object)i)))))))))));
            fns[idx] = intersect;
        }
        return (Function1 & Serializable & scala.Serializable)array -> {
            GenotypesContext genotypesContext;
            if (array == null) {
                genotypesContext = GenotypesContext.NO_GENOTYPES;
            } else {
                void var3_3;
                GenotypesContext ctx = GenotypesContext.create((int)array.numElements());
                for (int i = 0; i < array.numElements(); ++i) {
                    GenotypeBuilder builder = new GenotypeBuilder("");
                    InternalRow row = array.getStruct(i, gtFields.length);
                    for (int j = 0; j < fns.length; ++j) {
                        Object object = !row.isNullAt(j) ? fns[j].apply((Object)builder, (Object)row, (Object)BoxesRunTime.boxToInteger((int)j)) : BoxedUnit.UNIT;
                    }
                    ctx.add(builder.make());
                }
                genotypesContext = var3_3;
            }
            return genotypesContext;
        };
    }

    public Option<VariantContext> convert(InternalRow row) {
        this.alleles().clear();
        return (Option)this.converter().apply((Object)row);
    }

    private VariantContextBuilder updateContigName(VariantContextBuilder vc, InternalRow row, int offset) {
        return vc.chr(row.getString(offset));
    }

    private VariantContextBuilder updateStart(VariantContextBuilder vc, InternalRow row, int offset) {
        return vc.start(row.getLong(offset) + 1L);
    }

    private VariantContextBuilder updateEnd(VariantContextBuilder vc, InternalRow row, int offset) {
        return vc.stop(row.getLong(offset));
    }

    private VariantContextBuilder updateQual(VariantContextBuilder vc, InternalRow row, int offset) {
        return vc.log10PError(row.getDouble(offset) / (double)-10);
    }

    private VariantContextBuilder updateNames(VariantContextBuilder vc, InternalRow row, int offset) {
        Seq<String> names = ConverterUtils$.MODULE$.arrayDataToStringList(row.getArray(offset));
        String str = names.isEmpty() ? "." : names.mkString(";");
        return vc.id(str);
    }

    private VariantContextBuilder updateReferenceAllele(VariantContextBuilder vc, InternalRow row, int offset) {
        this.alleles().prepend((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Allele[]{Allele.create((byte[])row.getString(offset).getBytes(), (boolean)true)}));
        return vc;
    }

    private VariantContextBuilder updateAltAlleles(VariantContextBuilder vc, InternalRow row, int offset) {
        Seq<String> alts = ConverterUtils$.MODULE$.arrayDataToStringList(row.getArray(offset));
        this.alleles().appendAll((TraversableOnce)alts.map((Function1 & Serializable & scala.Serializable)a -> Allele.create((byte[])a.getBytes(), (boolean)false), Seq$.MODULE$.canBuildFrom()));
        return vc;
    }

    private VariantContextBuilder updateFilters(VariantContextBuilder vc, InternalRow row, int offset) {
        VariantContextBuilder variantContextBuilder;
        Seq<String> filters = ConverterUtils$.MODULE$.arrayDataToStringList(row.getArray(offset));
        if (filters.isEmpty()) {
            variantContextBuilder = vc.unfiltered();
        } else {
            Seq<String> seq = filters;
            GenTraversable genTraversable = Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"PASS"}));
            variantContextBuilder = !(seq != null ? !seq.equals((Object)genTraversable) : genTraversable != null) ? vc.passFilters() : vc.filters((String[])filters.toArray(ClassTag$.MODULE$.apply(String.class)));
        }
        return variantContextBuilder;
    }

    private VariantContextBuilder updateAttributes(VariantContextBuilder vc, InternalRow row, int offset) {
        MapData attrs = row.getMap(offset);
        Seq<String> keys = ConverterUtils$.MODULE$.arrayDataToStringList(attrs.keyArray());
        Seq<String> values = ConverterUtils$.MODULE$.arrayDataToStringList(attrs.valueArray());
        for (int i = 0; i < keys.size(); ++i) {
            Object object;
            VCFFormatHeaderLine headerLine = this.vcfHeader().getFormatHeaderLine((String)keys.apply(i));
            if (headerLine == null && !this.infoKeysParsedWithoutHeader().contains(keys.apply(i))) {
                this.raiseValidationError(new java.lang.StringBuilder(53).append("INFO field ").append(keys.apply(i)).append(" does not have a matching VCF header line.").toString(), this.raiseValidationError$default$2());
                object = BoxesRunTime.boxToBoolean((boolean)this.infoKeysParsedWithoutHeader().add(keys.apply(i)));
            } else {
                object = BoxedUnit.UNIT;
            }
            vc.attribute((String)keys.apply(i), new StringOps(Predef$.MODULE$.augmentString((String)values.apply(i))).nonEmpty() ? values.apply(i) : ".");
        }
        return vc;
    }

    private String[] createAnnotationArray(StructType schema, ArrayData effects) {
        String[] annotations = new String[effects.numElements()];
        for (int i = 0; i < annotations.length; ++i) {
            StringBuilder strBuilder = new StringBuilder();
            InternalRow effect = effects.getStruct(i, schema.size());
            for (int j = 0; j < schema.size(); ++j) {
                BoxedUnit boxedUnit;
                if (!effect.isNullAt(j)) {
                    Object object;
                    ArrayType arrayType;
                    DataType dataType;
                    DataType dataType2 = schema.fields()[j].dataType();
                    if (dataType2 instanceof ArrayType && StringType$.MODULE$.equals(dataType = (arrayType = (ArrayType)dataType2).elementType())) {
                        object = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(effect.getArray(j).toObjectArray((DataType)StringType$.MODULE$))).mkString(AnnotationUtils$.MODULE$.arrayDelimiter());
                    } else if (dataType2 instanceof StructType) {
                        Seq seq;
                        StructType schema2 = (StructType)dataType2;
                        DataType dataType3 = ((StructField)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])schema2.fields())).head()).dataType();
                        if (IntegerType$.MODULE$.equals(dataType3)) {
                            seq = (Seq)effect.getStruct(j, schema2.size()).toSeq(schema2).filterNot((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)InternalRowToVariantContextConverter.$anonfun$createAnnotationArray$1(x$7)));
                        } else if (StringType$.MODULE$.equals(dataType3)) {
                            seq = (Seq)effect.getStruct(j, schema2.size()).toSeq(schema2).filterNot((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)InternalRowToVariantContextConverter.$anonfun$createAnnotationArray$2(x$8)));
                        } else {
                            throw new MatchError((Object)dataType3);
                        }
                        Seq arr = seq;
                        object = arr.mkString(AnnotationUtils$.MODULE$.structDelimiter());
                    } else if (IntegerType$.MODULE$.equals(dataType2)) {
                        object = BoxesRunTime.boxToInteger((int)effect.getInt(j));
                    } else if (StringType$.MODULE$.equals(dataType2)) {
                        object = effect.getUTF8String(j);
                    } else {
                        throw new MatchError((Object)dataType2);
                    }
                    Integer strEffect = object;
                    boxedUnit = strBuilder.append((Object)strEffect);
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                Object object = j < schema.size() - 1 ? strBuilder.append(AnnotationUtils$.MODULE$.annotationDelimiter()) : BoxedUnit.UNIT;
            }
            annotations[i] = strBuilder.toString();
        }
        return annotations;
    }

    private VariantContextBuilder updateInfoField(StructField field, VariantContextBuilder vc, InternalRow row, int offset) {
        ArrayType arrayType;
        DataType dataType = field.dataType();
        BooleanType$ booleanType$ = BooleanType$.MODULE$;
        if (!(dataType != null ? !dataType.equals(booleanType$) : booleanType$ != null) && !row.getBoolean(offset)) {
            return vc;
        }
        String realName = new StringOps(Predef$.MODULE$.augmentString(field.name())).stripPrefix(VariantSchemas$.MODULE$.infoFieldPrefix());
        DataType dataType2 = field.dataType();
        String[] stringArray = dataType2 instanceof ArrayType && (arrayType = (ArrayType)dataType2).elementType() instanceof StructType ? this.createAnnotationArray((StructType)arrayType.elementType(), row.getArray(offset)) : this.parseField(field, row, offset);
        return vc.attribute(realName, (Object)stringArray);
    }

    private GenotypeBuilder updateSampleId(GenotypeBuilder genotype, InternalRow row, int offset) {
        return genotype.name(row.getString(offset));
    }

    private GenotypeBuilder updateGTPhased(GenotypeBuilder genotype, InternalRow row, int offset) {
        boolean phased = row.getBoolean(offset);
        genotype.phased(phased);
        return genotype;
    }

    private GenotypeBuilder updateGTCalls(GenotypeBuilder genotype, InternalRow row, int offset) {
        int[] calls = row.getArray(offset).toIntArray();
        ArrayList<Allele> gtAlleles = new ArrayList<Allele>(calls.length);
        for (int callIdx = 0; callIdx < calls.length; ++callIdx) {
            int alleleIdx = calls[callIdx];
            Allele allele = alleleIdx == -1 ? Allele.NO_CALL : (Allele)this.alleles().apply(alleleIdx);
            gtAlleles.add(allele);
        }
        genotype.alleles(gtAlleles);
        return genotype;
    }

    private GenotypeBuilder updateDP(GenotypeBuilder genotype, InternalRow row, int offset) {
        return genotype.DP(row.getInt(offset));
    }

    private GenotypeBuilder updateGTFilters(GenotypeBuilder genotype, InternalRow row, int offset) {
        Seq<String> filters = ConverterUtils$.MODULE$.arrayDataToStringList(row.getArray(offset));
        return genotype.filter(filters.mkString(";"));
    }

    private GenotypeBuilder updatePL(GenotypeBuilder genotype, InternalRow row, int offset) {
        genotype.PL(row.getArray(offset).toIntArray());
        return genotype;
    }

    private GenotypeBuilder updateGL(GenotypeBuilder genotype, InternalRow row, int offset) {
        genotype.PL(row.getArray(offset).toDoubleArray());
        return genotype;
    }

    private GenotypeBuilder updateAD(GenotypeBuilder genotype, InternalRow row, int offset) {
        return genotype.AD(row.getArray(offset).toIntArray());
    }

    private GenotypeBuilder updateGQ(GenotypeBuilder genotype, InternalRow row, int offset) {
        return genotype.GQ(row.getInt(offset));
    }

    private GenotypeBuilder updateOtherFields(GenotypeBuilder genotype, InternalRow row, int offset) {
        MapData attrs = row.getMap(offset);
        Seq<String> keys = ConverterUtils$.MODULE$.arrayDataToStringList(attrs.keyArray());
        Seq<String> values = ConverterUtils$.MODULE$.arrayDataToStringList(attrs.valueArray());
        for (int i = 0; i < keys.size(); ++i) {
            Object object;
            VCFInfoHeaderLine headerLine = this.vcfHeader().getInfoHeaderLine((String)keys.apply(i));
            if (headerLine == null && !this.formatKeysParsedWithoutHeader().contains(keys.apply(i))) {
                this.raiseValidationError(new java.lang.StringBuilder(56).append("Genotype field ").append(keys.apply(i)).append(" does not have a matching ").append("VCF header line").toString(), this.raiseValidationError$default$2());
                object = BoxesRunTime.boxToBoolean((boolean)this.formatKeysParsedWithoutHeader().add(keys.apply(i)));
            } else {
                object = BoxedUnit.UNIT;
            }
            genotype.attribute((String)keys.apply(i), values.apply(i));
        }
        return genotype;
    }

    private GenotypeBuilder updateFormatField(StructField field, GenotypeBuilder genotype, InternalRow row, int offset) {
        Object object;
        String realName = (String)GenotypeFields$.MODULE$.reverseAliases().getOrElse((Object)field.name(), (Function0 & Serializable & scala.Serializable)() -> field.name());
        VCFFormatHeaderLine headerLine = this.vcfHeader().getFormatHeaderLine(realName);
        if (headerLine == null && !this.formatKeysParsedWithoutHeader().contains((Object)field.name())) {
            this.raiseValidationError(new java.lang.StringBuilder(56).append("Genotype field ").append(field.name()).append(" does not have a matching ").append("VCF header line").toString(), this.raiseValidationError$default$2());
            object = BoxesRunTime.boxToBoolean((boolean)this.formatKeysParsedWithoutHeader().add((Object)field.name()));
        } else {
            object = BoxedUnit.UNIT;
        }
        return genotype.attribute(realName, this.parseField(field, row, offset));
    }

    /*
     * Unable to fully structure code
     */
    private Object parseField(StructField field, InternalRow row, int offset) {
        block4: {
            block3: {
                var7_4 = false;
                var8_5 = null;
                var9_6 = field.dataType();
                if (!StringType$.MODULE$.equals(var9_6)) break block3;
                var5_7 = row.getString(offset);
                break block4;
            }
            if (!(var9_6 instanceof ArrayType)) ** GOTO lbl-1000
            var7_4 = true;
            var8_5 = (ArrayType)var9_6;
            var10_8 = var8_5.elementType();
            if (StringType$.MODULE$.equals(var10_8)) {
                arrayData = row.getArray(offset);
                arr = new ArrayList<String>(arrayData.numElements());
                for (i = 0; i < arrayData.numElements(); ++i) {
                    arr.add(arrayData.getUTF8String(i).toString());
                }
                var5_7 = arr;
            } else lbl-1000:
            // 2 sources

            {
                var5_7 = var7_4 != false ? new ArrayList<Object>(Arrays.asList(row.getArray(offset).toObjectArray(var8_5.elementType()))) : row.get(offset, var9_6);
            }
        }
        var14_13 = value = var5_7;
        var4_14 = var14_13 == null ? "." : ("".equals(var14_13) ? "." : value);
        return var4_14;
    }

    public static final /* synthetic */ boolean $anonfun$validate$1(StructField x$1) {
        return x$1.name().startsWith(VariantSchemas$.MODULE$.infoFieldPrefix());
    }

    public static final /* synthetic */ void $anonfun$validate$2(InternalRowToVariantContextConverter $this, StructField f) {
        block1: {
            VCFInfoHeaderLine headerLine;
            block0: {
                headerLine = $this.vcfHeader().getInfoHeaderLine(new StringOps(Predef$.MODULE$.augmentString(f.name())).stripPrefix(VariantSchemas$.MODULE$.infoFieldPrefix()));
                if (headerLine != null) break block0;
                $this.raiseValidationError(new java.lang.StringBuilder(48).append("Column ").append(f.name()).append(" does not have a matching VCF header line").toString(), $this.raiseValidationError$default$2());
                break block1;
            }
            if (VCFSchemaInferrer$.MODULE$.typesForHeader((VCFCompoundHeaderLine)headerLine).exists((Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToBoolean((boolean)SQLUtils$.MODULE$.dataTypesEqualExceptNullability(t, f.dataType())))) break block1;
            $this.raiseValidationError(new java.lang.StringBuilder(82).append("Column ").append(f.name()).append(" has a VCF header line with the same ID, but ").append("the types are not compatible. ").append(new java.lang.StringBuilder(25).append("Header type: ").append(headerLine.getType()).append(",").append(headerLine.getCountType()).append(" SQL type: ").append(f.dataType()).toString()).toString(), $this.raiseValidationError$default$2());
        }
    }

    public static final /* synthetic */ boolean $anonfun$validate$5(InternalRowToVariantContextConverter $this, StructField f) {
        return !$this.genotypeFieldsWithoutHeaders().contains((Object)f.name());
    }

    public static final /* synthetic */ void $anonfun$validate$6(InternalRowToVariantContextConverter $this, StructField f) {
        block1: {
            VCFFormatHeaderLine headerLine;
            block0: {
                String realName = (String)GenotypeFields$.MODULE$.reverseAliases().getOrElse((Object)f.name(), (Function0 & Serializable & scala.Serializable)() -> f.name());
                headerLine = $this.vcfHeader().getFormatHeaderLine(realName);
                if (headerLine != null) break block0;
                $this.raiseValidationError(new java.lang.StringBuilder(56).append("Genotype field ").append(f.name()).append(" does not have a matching VCF header ").append("line").toString(), $this.raiseValidationError$default$2());
                break block1;
            }
            if (VCFSchemaInferrer$.MODULE$.typesForHeader((VCFCompoundHeaderLine)headerLine).exists((Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToBoolean((boolean)SQLUtils$.MODULE$.dataTypesEqualExceptNullability(t, f.dataType())))) break block1;
            $this.raiseValidationError(new java.lang.StringBuilder(90).append("Genotype field ").append(f.name()).append(" has a VCF header line with the ").append("same ID, but the types are not compatible. ").append(new java.lang.StringBuilder(15).append("Header type: ").append(headerLine.getType()).append(",").append(headerLine.getCountType()).append(" ").toString()).append(new java.lang.StringBuilder(10).append("SQL type: ").append(f.dataType()).toString()).toString(), $this.raiseValidationError$default$2());
        }
    }

    public static final /* synthetic */ void $anonfun$validate$4(InternalRowToVariantContextConverter $this, StructType schema) {
        ((IterableLike)schema.filter((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)InternalRowToVariantContextConverter.$anonfun$validate$5($this, f)))).foreach((Function1 & Serializable & scala.Serializable)f -> {
            InternalRowToVariantContextConverter.$anonfun$validate$6($this, f);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$converter$13(StructField x$6) {
        String string = x$6.name();
        String string2 = VariantSchemas$.MODULE$.genotypesFieldName();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$createAnnotationArray$1(Object x$7) {
        return x$7 == null;
    }

    public static final /* synthetic */ boolean $anonfun$createAnnotationArray$2(Object x$8) {
        return x$8 == null;
    }

    public InternalRowToVariantContextConverter(StructType rowSchema, scala.collection.immutable.Set<VCFHeaderLine> headerLineSet, ValidationStringency stringency) {
        this.rowSchema = rowSchema;
        this.stringency = stringency;
        LazyLogging.$init$((LazyLogging)this);
        HasStringency.$init$(this);
        this.alleles = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.genotypeSchema = InternalRowToVariantContextConverter$.MODULE$.getGenotypeSchema(rowSchema);
        this.infoKeysParsedWithoutHeader = HashSet$.MODULE$.empty();
        this.formatKeysParsedWithoutHeader = HashSet$.MODULE$.empty();
        this.vcFieldsToIgnore = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{VariantSchemas$.MODULE$.splitFromMultiAllelicField().name(), VariantSchemas$.MODULE$.genotypesFieldName()}));
        this.genotypeFieldsWithoutHeaders = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"sampleId", "otherFields"}));
        this.vcfHeader = new VCFHeader((Set)JavaConverters$.MODULE$.setAsJavaSetConverter(headerLineSet).asJava());
    }
}

