/*
 * Decompiled with CFR 0.152.
 */
package io.projectglow.vcf;

import com.google.common.annotations.VisibleForTesting;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import htsjdk.samtools.util.OverlapDetector;
import htsjdk.tribble.index.Block;
import htsjdk.tribble.index.tabix.TabixIndex;
import io.projectglow.common.GlowLogging;
import io.projectglow.common.SimpleInterval;
import io.projectglow.common.WithUtils$;
import io.projectglow.vcf.FilterContig;
import io.projectglow.vcf.FilterInterval;
import io.projectglow.vcf.ParsedFilterResult;
import io.projectglow.vcf.VCFFileFormat$;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Paths;
import java.util.concurrent.locks.Lock;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.sql.execution.datasources.PartitionedFile;
import org.apache.spark.sql.sources.And;
import org.apache.spark.sql.sources.EqualTo;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.sources.GreaterThan;
import org.apache.spark.sql.sources.GreaterThanOrEqual;
import org.apache.spark.sql.sources.LessThan;
import org.apache.spark.sql.sources.LessThanOrEqual;
import org.apache.spark.sql.sources.Or;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

public final class TabixIndexHelper$
implements GlowLogging {
    public static TabixIndexHelper$ MODULE$;
    private Logger logger;
    private volatile boolean bitmap$0;

    static {
        new TabixIndexHelper$();
    }

    private Logger logger$lzycompute() {
        TabixIndexHelper$ tabixIndexHelper$ = this;
        synchronized (tabixIndexHelper$) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @VisibleForTesting
    public ParsedFilterResult parseFilter(Seq<Filter> filters) {
        BooleanRef paramsOK = BooleanRef.create((boolean)true);
        FilterContig contig = new FilterContig("");
        FilterInterval startInterval = new FilterInterval(1L, Integer.MAX_VALUE);
        FilterInterval endInterval = new FilterInterval(1L, Integer.MAX_VALUE);
        filters.withFilter((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)TabixIndexHelper$.$anonfun$parseFilter$1(paramsOK, contig, startInterval, x))).foreach((Function1 & Serializable & scala.Serializable)x -> {
            void var5_23;
            boolean bl = false;
            EqualTo equalTo = null;
            Filter filter = x;
            if (filter instanceof And) {
                And and = (And)filter;
                Filter left = and.left();
                Filter right = and.right();
                if (left != null) {
                    Filter filter2 = left;
                    if (right != null) {
                        Filter filter3 = right;
                        ParsedFilterResult parsedLeftRight = MODULE$.parseFilter((Seq<Filter>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Filter[]{filter2, filter3}))));
                        contig.actionAnd(parsedLeftRight.contig());
                        startInterval.actionAnd(parsedLeftRight.startInterval());
                        FilterInterval filterInterval = endInterval.actionAnd(parsedLeftRight.endInterval());
                        return var5_23;
                    }
                }
            }
            if (filter instanceof Or) {
                Or or = (Or)filter;
                Filter left = or.left();
                Filter right = or.right();
                if (left != null) {
                    Filter filter4 = left;
                    if (right != null) {
                        Filter filter5 = right;
                        ParsedFilterResult parsedLeft = MODULE$.parseFilter((Seq<Filter>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Filter[]{filter4}))));
                        ParsedFilterResult parsedRight = MODULE$.parseFilter((Seq<Filter>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Filter[]{filter5}))));
                        FilterInterval orInterval = MODULE$.getSmallestQueryInterval(parsedLeft.startInterval(), parsedLeft.endInterval()).actionOr(MODULE$.getSmallestQueryInterval(parsedRight.startInterval(), parsedRight.endInterval()));
                        contig.actionAnd(parsedLeft.contig().actionOr(parsedRight.contig()));
                        startInterval.actionAnd(orInterval);
                        FilterInterval filterInterval = endInterval.actionAnd(orInterval);
                        return var5_23;
                    }
                }
            }
            if (filter instanceof EqualTo) {
                bl = true;
                equalTo = (EqualTo)filter;
                String string = equalTo.attribute();
                Object value = equalTo.value();
                if ("contigName".equals(string) && value instanceof String) {
                    String string2 = (String)value;
                    FilterContig filterContig = contig.actionAnd(new FilterContig(string2));
                    return var5_23;
                }
            }
            if (bl) {
                String columnName = equalTo.attribute();
                Object value = equalTo.value();
                if (columnName != null) {
                    String string = columnName;
                    if (value instanceof Long) {
                        Object object;
                        long l = BoxesRunTime.unboxToLong((Object)value);
                        String string3 = string;
                        String string4 = "start";
                        if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                            if (l < 0L || l > Integer.MAX_VALUE) {
                                paramsOK$1.elem = false;
                                object = BoxedUnit.UNIT;
                            } else {
                                object = startInterval.actionAnd(new FilterInterval(l + 1L, l + 1L));
                            }
                        } else {
                            String string5 = string;
                            String string6 = "end";
                            if (!(string5 != null ? !string5.equals(string6) : string6 != null)) {
                                if (l < 1L || l > Integer.MAX_VALUE) {
                                    paramsOK$1.elem = false;
                                    object = BoxedUnit.UNIT;
                                } else {
                                    object = endInterval.actionAnd(new FilterInterval(l, l));
                                }
                            } else {
                                object = BoxedUnit.UNIT;
                            }
                        }
                        BoxedUnit boxedUnit = object;
                        return var5_23;
                    }
                }
            }
            if (filter instanceof GreaterThan) {
                GreaterThan greaterThan = (GreaterThan)filter;
                String columnName = greaterThan.attribute();
                Object value = greaterThan.value();
                if (columnName != null) {
                    String string = columnName;
                    if (value instanceof Long) {
                        Object object;
                        long l = BoxesRunTime.unboxToLong((Object)value);
                        String string7 = string;
                        String string8 = "start";
                        if (!(string7 != null ? !string7.equals(string8) : string8 != null)) {
                            if (l < -1L || l > Integer.MAX_VALUE) {
                                paramsOK$1.elem = false;
                                object = BoxedUnit.UNIT;
                            } else {
                                object = startInterval.actionAnd(new FilterInterval(l + 2L, Integer.MAX_VALUE));
                            }
                        } else {
                            String string9 = string;
                            String string10 = "end";
                            if (!(string9 != null ? !string9.equals(string10) : string10 != null)) {
                                if (l < 0L || l > Integer.MAX_VALUE) {
                                    paramsOK$1.elem = false;
                                    object = BoxedUnit.UNIT;
                                } else {
                                    object = endInterval.actionAnd(new FilterInterval(l + 1L, Integer.MAX_VALUE));
                                }
                            } else {
                                object = BoxedUnit.UNIT;
                            }
                        }
                        BoxedUnit boxedUnit = object;
                        return var5_23;
                    }
                }
            }
            if (filter instanceof GreaterThanOrEqual) {
                GreaterThanOrEqual greaterThanOrEqual = (GreaterThanOrEqual)filter;
                String columnName = greaterThanOrEqual.attribute();
                Object value = greaterThanOrEqual.value();
                if (columnName != null) {
                    String string = columnName;
                    if (value instanceof Long) {
                        Object object;
                        long l = BoxesRunTime.unboxToLong((Object)value);
                        String string11 = string;
                        String string12 = "start";
                        if (!(string11 != null ? !string11.equals(string12) : string12 != null)) {
                            if (l < 0L || l > Integer.MAX_VALUE) {
                                paramsOK$1.elem = false;
                                object = BoxedUnit.UNIT;
                            } else {
                                object = startInterval.actionAnd(new FilterInterval(l + 1L, Integer.MAX_VALUE));
                            }
                        } else {
                            String string13 = string;
                            String string14 = "end";
                            if (!(string13 != null ? !string13.equals(string14) : string14 != null)) {
                                if (l < 1L || l > Integer.MAX_VALUE) {
                                    paramsOK$1.elem = false;
                                    object = BoxedUnit.UNIT;
                                } else {
                                    object = endInterval.actionAnd(new FilterInterval(l, Integer.MAX_VALUE));
                                }
                            } else {
                                object = BoxedUnit.UNIT;
                            }
                        }
                        BoxedUnit boxedUnit = object;
                        return var5_23;
                    }
                }
            }
            if (filter instanceof LessThan) {
                LessThan lessThan = (LessThan)filter;
                String columnName = lessThan.attribute();
                Object value = lessThan.value();
                if (columnName != null) {
                    String string = columnName;
                    if (value instanceof Long) {
                        Object object;
                        long l = BoxesRunTime.unboxToLong((Object)value);
                        String string15 = string;
                        String string16 = "start";
                        if (!(string15 != null ? !string15.equals(string16) : string16 != null)) {
                            if (l < 1L || l > Integer.MAX_VALUE) {
                                paramsOK$1.elem = false;
                                object = BoxedUnit.UNIT;
                            } else {
                                object = startInterval.actionAnd(new FilterInterval(1L, l));
                            }
                        } else {
                            String string17 = string;
                            String string18 = "end";
                            if (!(string17 != null ? !string17.equals(string18) : string18 != null)) {
                                if (l < 2L || l > Integer.MAX_VALUE) {
                                    paramsOK$1.elem = false;
                                    object = BoxedUnit.UNIT;
                                } else {
                                    object = endInterval.actionAnd(new FilterInterval(1L, l - 1L));
                                }
                            } else {
                                object = BoxedUnit.UNIT;
                            }
                        }
                        BoxedUnit boxedUnit = object;
                        return var5_23;
                    }
                }
            }
            if (filter instanceof LessThanOrEqual) {
                LessThanOrEqual lessThanOrEqual = (LessThanOrEqual)filter;
                String columnName = lessThanOrEqual.attribute();
                Object value = lessThanOrEqual.value();
                if (columnName != null) {
                    String string = columnName;
                    if (value instanceof Long) {
                        Object object;
                        long l = BoxesRunTime.unboxToLong((Object)value);
                        String string19 = string;
                        String string20 = "start";
                        if (!(string19 != null ? !string19.equals(string20) : string20 != null)) {
                            if (l < 0L || l > Integer.MAX_VALUE) {
                                paramsOK$1.elem = false;
                                object = BoxedUnit.UNIT;
                            } else {
                                object = startInterval.actionAnd(new FilterInterval(1L, l + 1L));
                            }
                        } else {
                            String string21 = string;
                            String string22 = "end";
                            if (!(string21 != null ? !string21.equals(string22) : string22 != null)) {
                                if (l < 1L || l > Integer.MAX_VALUE) {
                                    paramsOK$1.elem = false;
                                    object = BoxedUnit.UNIT;
                                } else {
                                    object = endInterval.actionAnd(new FilterInterval(1L, l));
                                }
                            } else {
                                object = BoxedUnit.UNIT;
                            }
                        }
                        BoxedUnit boxedUnit = object;
                        return var5_23;
                    }
                }
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return var5_23;
        });
        return !paramsOK.elem ? new ParsedFilterResult(new FilterContig(""), new FilterInterval(1L, Integer.MAX_VALUE), new FilterInterval(1L, Integer.MAX_VALUE)) : new ParsedFilterResult(contig, startInterval, endInterval);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @VisibleForTesting
    public FilterInterval getSmallestQueryInterval(FilterInterval startInterval, FilterInterval endInterval) {
        FilterInterval filterInterval;
        Tuple2 tuple2 = new Tuple2(startInterval.getSimpleInterval(), endInterval.getSimpleInterval());
        if (tuple2 == null) return new FilterInterval(2L, 1L);
        Option option = (Option)tuple2._1();
        Option option2 = (Option)tuple2._2();
        if (!(option instanceof Some)) return new FilterInterval(2L, 1L);
        Some some = (Some)option;
        SimpleInterval si = (SimpleInterval)some.value();
        if (!(option2 instanceof Some)) return new FilterInterval(2L, 1L);
        Some some2 = (Some)option2;
        SimpleInterval ei = (SimpleInterval)some2.value();
        SimpleInterval smallestQueryInterval = null;
        if (si.getStart() > ei.getEnd()) {
            filterInterval = new FilterInterval(2L, 1L);
            return filterInterval;
        } else {
            smallestQueryInterval = si.overlaps(ei) ? si.intersect(ei) : new SimpleInterval("", ei.getStart(), ei.getStart());
            filterInterval = new FilterInterval(smallestQueryInterval.getStart(), smallestQueryInterval.getEnd());
        }
        return filterInterval;
    }

    /*
     * Unable to fully structure code
     */
    public Option<SimpleInterval> makeFilteredInterval(Seq<Filter> filters, boolean useFilterParser, boolean useIndex) {
        block6: {
            block5: {
                if (!useFilterParser) break block5;
                parsedFilterResult = this.parseFilter(filters);
                var6_5 = new Tuple2(parsedFilterResult.contig().getContigName(), this.getSmallestQueryInterval(parsedFilterResult.startInterval(), parsedFilterResult.endInterval()).getSimpleInterval());
                if (var6_5 == null) ** GOTO lbl-1000
                var7_6 = (Option)var6_5._1();
                var8_7 = (Option)var6_5._2();
                if (!(var7_6 instanceof Some)) ** GOTO lbl-1000
                var9_8 = (Some)var7_6;
                c = (String)var9_8.value();
                if (var8_7 instanceof Some) {
                    var11_10 = (Some)var8_7;
                    i = (SimpleInterval)var11_10.value();
                    var4_12 = Option$.MODULE$.apply((Object)new SimpleInterval(c, i.getStart(), i.getEnd()));
                } else lbl-1000:
                // 3 sources

                {
                    var4_12 = None$.MODULE$;
                }
                v0 = var4_12;
                break block6;
            }
            if (useIndex) {
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info("Error: Filter parser is deactivated while requesting index use.");
                    v1 = BoxedUnit.UNIT;
                } else {
                    v1 = BoxedUnit.UNIT;
                }
                throw new IllegalArgumentException();
            }
            v0 = Option$.MODULE$.apply((Object)new SimpleInterval("", 1, 0x7FFFFFFF));
        }
        return v0;
    }

    public Option<Tuple2<Object, Object>> getFileRangeToRead(FileSystem hadoopFs, PartitionedFile file, Configuration conf, boolean hasFilter, boolean useIndex, Option<SimpleInterval> filteredSimpleInterval) {
        None$ none$;
        if (file.filePath().endsWith(VCFFileFormat$.MODULE$.INDEX_SUFFIX())) {
            return None$.MODULE$;
        }
        Path path = new Path(file.filePath());
        Path indexFile = new Path(new StringBuilder(0).append(file.filePath()).append(VCFFileFormat$.MODULE$.INDEX_SUFFIX()).toString());
        boolean isGzip = VCFFileFormat$.MODULE$.isGzip(file, conf);
        Option<SimpleInterval> option = filteredSimpleInterval;
        if (option instanceof Some) {
            Object object;
            Some some = (Some)option;
            SimpleInterval interval = (SimpleInterval)some.value();
            if (isGzip && file.start() == 0L) {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info("Reading gzip file from beginning to end");
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                long fileLength = hadoopFs.getFileStatus(path).getLen();
                object = new Some((Object)new Tuple2.mcJJ.sp(0L, fileLength));
            } else if (isGzip) {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info("Skipping gzip file because task starts in the middle of the file");
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                object = None$.MODULE$;
            } else if (!hasFilter) {
                object = new Some((Object)new Tuple2.mcJJ.sp(file.start(), file.start() + file.length()));
            } else if (!useIndex) {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info("Tabix index use disabled by the user...");
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                object = new Some((Object)new Tuple2.mcJJ.sp(file.start(), file.start() + file.length()));
            } else if (!VCFFileFormat$.MODULE$.isValidBGZ(path, conf)) {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info("The file is not bgzipped... not using tabix index...");
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                object = new Some((Object)new Tuple2.mcJJ.sp(file.start(), file.start() + file.length()));
            } else if (interval.getContig().isEmpty()) {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info("More than one chromosome or chromosome number not provided in the filter... will not use tabix index...");
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                object = new Some((Object)new Tuple2.mcJJ.sp(file.start(), file.start() + file.length()));
            } else if (!hadoopFs.exists(indexFile)) {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info("Did not find tabix index file ...");
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                object = new Some((Object)new Tuple2.mcJJ.sp(file.start(), file.start() + file.length()));
            } else {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info("Found tabix index file {} for VCF file {}", new Object[]{indexFile, file.filePath()});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                String localIdxPath = this.downloadTabixIfNecessary(hadoopFs, indexFile);
                File localIdxFile = new File(localIdxPath);
                TabixIndex tabixIdx = new TabixIndex(localIdxFile);
                List offsetList = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(tabixIdx.getBlocks(interval.getContig(), interval.getStart(), interval.getEnd())).asScala()).toList();
                if (offsetList.isEmpty()) {
                    object = None$.MODULE$;
                } else {
                    BooleanRef fileContainsBlockStart = BooleanRef.create((boolean)false);
                    Tuple2.mcJJ.sp sp2 = new Tuple2.mcJJ.sp(((Block)offsetList.apply(0)).getStartPosition() >> 16, ((Block)offsetList.apply(0)).getEndPosition() >> 16);
                    if (sp2 == null) {
                        throw new MatchError((Object)sp2);
                    }
                    long firstStart = sp2._1$mcJ$sp();
                    long firstEnd = sp2._2$mcJ$sp();
                    Tuple2.mcJJ.sp sp3 = new Tuple2.mcJJ.sp(firstStart, firstEnd);
                    Tuple2.mcJJ.sp sp4 = sp3;
                    long firstStart2 = sp4._1$mcJ$sp();
                    long firstEnd2 = sp4._2$mcJ$sp();
                    Tuple2 tuple2 = (Tuple2)offsetList.foldLeft((Object)new Tuple2.mcJJ.sp(firstStart2, firstEnd2), (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
                        Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
                        if (tuple2 == null) throw new MatchError((Object)tuple2);
                        Tuple2 tuple22 = (Tuple2)tuple2._1();
                        Block o = (Block)tuple2._2();
                        if (tuple22 == null) throw new MatchError((Object)tuple2);
                        long aStart = tuple22._1$mcJ$sp();
                        long aEnd = tuple22._2$mcJ$sp();
                        long bStart = o.getStartPosition() >> 16;
                        long bEnd = o.getEndPosition() >> 16;
                        if (fileContainsBlockStart$1.elem) return new Tuple2.mcJJ.sp(Math.min(aStart, bStart), Math.max(aEnd, bEnd));
                        fileContainsBlockStart$1.elem = file.start() <= bStart && file.start() + file.length() >= bStart;
                        return new Tuple2.mcJJ.sp(Math.min(aStart, bStart), Math.max(aEnd, bEnd));
                    });
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    long minOverBlocks = tuple2._1$mcJ$sp();
                    long maxOverBlocks = tuple2._2$mcJ$sp();
                    Tuple2.mcJJ.sp sp5 = new Tuple2.mcJJ.sp(minOverBlocks, maxOverBlocks);
                    Tuple2.mcJJ.sp sp6 = sp5;
                    long minOverBlocks2 = sp6._1$mcJ$sp();
                    long maxOverBlocks2 = sp6._2$mcJ$sp();
                    long blockRangeStart = Math.max(file.start(), minOverBlocks2);
                    long blockRangeEnd = Math.min(file.start() + file.length(), maxOverBlocks2);
                    object = blockRangeStart <= blockRangeEnd && fileContainsBlockStart.elem ? new Some((Object)new Tuple2.mcJJ.sp(blockRangeStart, Math.min(file.start() + file.length(), blockRangeEnd + 65535L))) : None$.MODULE$;
                }
            }
            none$ = object;
        } else if (None$.MODULE$.equals(option)) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Filter parser indicates no rows satisfy the filters... no need to use tabix Index...");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            none$ = None$.MODULE$;
        } else {
            throw new MatchError(option);
        }
        return none$;
    }

    private String downloadTabixIfNecessary(FileSystem hadoopFs, Path path) {
        File localDir = Paths.get(System.getProperty("java.io.tmpdir"), new String[0]).resolve("tabix_indices").toFile();
        localDir.mkdirs();
        String localPath = new StringBuilder(1).append(localDir).append("/").append(new StringOps(Predef$.MODULE$.augmentString(path.getName())).replaceAllLiterally("/", "__")).toString();
        WithUtils$.MODULE$.withLock((Lock)VCFFileFormat$.MODULE$.idxLock().get((Object)path), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            block0: {
                if (new File(localPath).exists()) break block0;
                Path myPath = new Path(localPath);
                hadoopFs.copyToLocalFile(path, myPath);
            }
        });
        return localPath;
    }

    public Option<OverlapDetector<SimpleInterval>> toOverlapDetector(SimpleInterval simpleInterval) {
        return !simpleInterval.getContig().isEmpty() ? new Some((Object)OverlapDetector.create((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)simpleInterval, (List)Nil$.MODULE$)).asJava()))) : None$.MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$parseFilter$1(BooleanRef paramsOK$1, FilterContig contig$1, FilterInterval startInterval$1, Filter x) {
        return paramsOK$1.elem && contig$1.isDefined() && startInterval$1.isDefined() && startInterval$1.isDefined();
    }

    private TabixIndexHelper$() {
        MODULE$ = this;
        LazyLogging.$init$((LazyLogging)this);
    }
}

