/*
 * Decompiled with CFR 0.152.
 */
package io.projectglow.vcf;

import com.google.common.util.concurrent.Striped;
import htsjdk.samtools.util.BlockCompressedInputStream;
import htsjdk.tribble.readers.AsciiLineReader;
import htsjdk.tribble.readers.AsciiLineReaderIterator;
import htsjdk.tribble.readers.LineIterator;
import htsjdk.tribble.readers.PositionalBufferedStream;
import htsjdk.variant.vcf.VCFCodec;
import htsjdk.variant.vcf.VCFHeader;
import io.projectglow.common.VariantSchemas$;
import io.projectglow.common.WithUtils$;
import io.projectglow.sql.util.BGZFCodec;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.util.concurrent.locks.Lock;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.compress.CodecPool;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.hadoop.io.compress.Decompressor;
import org.apache.spark.sql.SQLUtils$;
import org.apache.spark.sql.execution.datasources.PartitionedFile;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.seqdoop.hadoop_bam.util.BGZFEnhancedGzipCodec;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class VCFFileFormat$ {
    public static VCFFileFormat$ MODULE$;
    private final Striped<Lock> idxLock;
    private final String INDEX_SUFFIX;

    static {
        new VCFFileFormat$();
    }

    public Tuple2<VCFHeader, VCFCodec> createVCFCodec(String path, Configuration conf) {
        Path hPath = new Path(path);
        FileSystem fs = hPath.getFileSystem(conf);
        return (Tuple2)WithUtils$.MODULE$.withCloseable(fs.open(hPath), (Function1 & Serializable & scala.Serializable)is -> {
            PositionalBufferedStream positionalBufferedStream;
            CompressionCodec compressionCodec = new CompressionCodecFactory(conf).getCodec(hPath);
            if (compressionCodec != null) {
                Decompressor decompressor = CodecPool.getDecompressor((CompressionCodec)compressionCodec);
                positionalBufferedStream = compressionCodec.createInputStream((InputStream)is, decompressor);
            } else {
                positionalBufferedStream = new PositionalBufferedStream((InputStream)is);
            }
            PositionalBufferedStream wrappedStream = positionalBufferedStream;
            return (Tuple2)WithUtils$.MODULE$.withCloseable(wrappedStream, (Function1 & Serializable & scala.Serializable)ws -> {
                VCFCodec vcfCodec = new VCFCodec();
                AsciiLineReaderIterator reader = new AsciiLineReaderIterator(AsciiLineReader.from((InputStream)ws));
                Object header = vcfCodec.readActualHeader((LineIterator)reader);
                return new Tuple2((Object)((VCFHeader)header), (Object)vcfCodec);
            });
        });
    }

    /*
     * WARNING - void declaration
     */
    public Configuration hadoopConfWithBGZ(Configuration conf) {
        void var2_2;
        Configuration toReturn = new Configuration(conf);
        Seq bgzCodecs = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{BGZFCodec.class.getCanonicalName(), BGZFEnhancedGzipCodec.class.getCanonicalName()}));
        String[] codecs = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])toReturn.get("io.compression.codecs", "").split(","))).filter((Function1 & Serializable & scala.Serializable)codec -> BoxesRunTime.boxToBoolean((boolean)VCFFileFormat$.$anonfun$hadoopConfWithBGZ$1(bgzCodecs, codec))))).$plus$plus((GenTraversableOnce)bgzCodecs, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        toReturn.set("io.compression.codecs", new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])codecs)).mkString(","));
        return var2_2;
    }

    public Striped<Lock> idxLock() {
        return this.idxLock;
    }

    public String INDEX_SUFFIX() {
        return this.INDEX_SUFFIX;
    }

    public boolean isValidBGZ(Path path, Configuration conf) {
        FileSystem fs = path.getFileSystem(conf);
        return BoxesRunTime.unboxToBoolean(WithUtils$.MODULE$.withCloseable(fs.open(path), (Function1 & Serializable & scala.Serializable)is -> BoxesRunTime.boxToBoolean((boolean)VCFFileFormat$.$anonfun$isValidBGZ$1(is))));
    }

    public boolean isGzip(PartitionedFile split, Configuration conf) {
        Path path = new Path(split.filePath());
        CompressionCodec compressionCodec = new CompressionCodecFactory(this.hadoopConfWithBGZ(conf)).getCodec(path);
        return compressionCodec instanceof BGZFEnhancedGzipCodec ? !this.isValidBGZ(path, conf) : false;
    }

    public void requireWritableAsVCF(StructType schema) {
        Seq baseRequiredFields = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{VariantSchemas$.MODULE$.contigNameField(), VariantSchemas$.MODULE$.startField(), VariantSchemas$.MODULE$.refAlleleField(), VariantSchemas$.MODULE$.endField()}));
        Seq requiredFields = schema.exists((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)VCFFileFormat$.$anonfun$requireWritableAsVCF$1(x$11))) ? (Seq)baseRequiredFields.$colon$plus((Object)VariantSchemas$.MODULE$.alternateAllelesField(), Seq$.MODULE$.canBuildFrom()) : baseRequiredFields;
        Seq missingFields = (Seq)requiredFields.filter((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)VCFFileFormat$.$anonfun$requireWritableAsVCF$2(schema, f)));
        if (missingFields.nonEmpty()) {
            throw SQLUtils$.MODULE$.newAnalysisException(new StringBuilder(46).append("Cannot write as VCF. Missing required fields: ").append(requiredFields).toString());
        }
    }

    public static final /* synthetic */ boolean $anonfun$hadoopConfWithBGZ$1(Seq bgzCodecs$1, String codec) {
        return new StringOps(Predef$.MODULE$.augmentString(codec)).nonEmpty() && !bgzCodecs$1.contains((Object)codec);
    }

    public static final /* synthetic */ boolean $anonfun$isValidBGZ$1(FSDataInputStream is) {
        BufferedInputStream buffered = new BufferedInputStream((InputStream)is);
        return BlockCompressedInputStream.isValidFile((InputStream)buffered);
    }

    public static final /* synthetic */ boolean $anonfun$requireWritableAsVCF$1(StructField x$11) {
        String string = x$11.name();
        String string2 = VariantSchemas$.MODULE$.genotypesFieldName();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$requireWritableAsVCF$2(StructType schema$1, StructField f) {
        return !schema$1.exists((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)SQLUtils$.MODULE$.structFieldsEqualExceptNullability(x$12, f)));
    }

    private VCFFileFormat$() {
        MODULE$ = this;
        this.idxLock = Striped.lock((int)100);
        this.INDEX_SUFFIX = ".tbi";
    }
}

