/*
 * Decompiled with CFR 0.152.
 */
package io.projectglow.vcf;

import com.google.common.annotations.VisibleForTesting;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import htsjdk.tribble.readers.LineIterator;
import htsjdk.variant.vcf.VCFCodec;
import htsjdk.variant.vcf.VCFCompoundHeaderLine;
import htsjdk.variant.vcf.VCFContigHeaderLine;
import htsjdk.variant.vcf.VCFFilterHeaderLine;
import htsjdk.variant.vcf.VCFHeader;
import htsjdk.variant.vcf.VCFHeaderLine;
import htsjdk.variant.vcf.VCFIDHeaderLine;
import io.projectglow.common.GlowLogging;
import io.projectglow.sql.util.SerializableConfiguration;
import io.projectglow.vcf.InferSampleIds$;
import io.projectglow.vcf.LineIteratorImpl;
import io.projectglow.vcf.SampleIdInfo;
import io.projectglow.vcf.SampleIds;
import io.projectglow.vcf.VCFFileFormat$;
import io.projectglow.vcf.VCFMetadataLoader$;
import io.projectglow.vcf.VCFSchemaInferrer$;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer$;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.util.control.NonFatal$;

public final class VCFHeaderUtils$
implements GlowLogging {
    public static VCFHeaderUtils$ MODULE$;
    private final String VCF_HEADER_KEY;
    private final String INFER_HEADER;
    private Logger logger;
    private volatile boolean bitmap$0;

    static {
        new VCFHeaderUtils$();
    }

    private Logger logger$lzycompute() {
        VCFHeaderUtils$ vCFHeaderUtils$ = this;
        synchronized (vCFHeaderUtils$) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    public String VCF_HEADER_KEY() {
        return this.VCF_HEADER_KEY;
    }

    public String INFER_HEADER() {
        return this.INFER_HEADER;
    }

    public VCFHeader parseHeaderFromString(String s) {
        VCFHeader vCFHeader;
        StringReader stringReader = new StringReader(s);
        LineIteratorImpl lineIterator = new LineIteratorImpl((Iterator<String>)((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter((java.util.Iterator)IOUtils.lineIterator((Reader)stringReader)).asScala()));
        VCFCodec codec = new VCFCodec();
        try {
            vCFHeader = (VCFHeader)codec.readActualHeader((LineIterator)lineIterator);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                throw new IllegalArgumentException(new StringBuilder(29).append("Unable to parse VCF header \n").append(s).append("\n").append(e).toString());
            }
            throw throwable;
        }
        return vCFHeader;
    }

    private boolean isCustomHeader(String content) {
        return content.trim().startsWith("#");
    }

    @VisibleForTesting
    public Tuple2<Set<VCFHeaderLine>, SampleIdInfo> parseHeaderLinesAndSamples(Map<String, String> options, Option<String> defaultHeader, StructType schema, Configuration conf) {
        Tuple2 tuple2;
        Predef$.MODULE$.require(options.contains((Object)this.VCF_HEADER_KEY()) || defaultHeader.isDefined(), (Function0 & Serializable & scala.Serializable)() -> "Must specify a method to determine VCF header");
        String string = (String)options.getOrElse((Object)this.VCF_HEADER_KEY(), (Function0 & Serializable & scala.Serializable)() -> (String)defaultHeader.get());
        String string2 = this.INFER_HEADER();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Inferring header for VCF writer");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            Set headerLines = VCFSchemaInferrer$.MODULE$.headerLinesFromSchema(schema).toSet();
            tuple2 = new Tuple2((Object)headerLines, (Object)InferSampleIds$.MODULE$);
        } else if (this.isCustomHeader(string)) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Using provided string as VCF header");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            VCFHeader header = this.parseHeaderFromString(string);
            tuple2 = new Tuple2((Object)((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(header.getMetaDataInInputOrder()).asScala()).toSet(), (Object)new SampleIds((Seq<String>)((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(header.getGenotypeSamples()).asScala())));
        } else {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Attempting to parse VCF header from path {}", new Object[]{string});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            VCFHeader header = VCFMetadataLoader$.MODULE$.readVcfHeader(conf, string);
            tuple2 = new Tuple2((Object)((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(header.getMetaDataInInputOrder()).asScala()).toSet(), (Object)new SampleIds((Seq<String>)((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(header.getGenotypeSamples()).asScala())));
        }
        return tuple2;
    }

    public RDD<VCFHeader> createHeaderRDD(SparkSession spark, Seq<String> files) {
        SerializableConfiguration serializableConf = new SerializableConfiguration(spark.sessionState().newHadoopConf());
        return spark.sparkContext().parallelize(files, spark.sparkContext().parallelize$default$2(), ClassTag$.MODULE$.apply(String.class)).flatMap((Function1 & Serializable & scala.Serializable)path -> {
            Iterable iterable;
            if (path.endsWith(VCFFileFormat$.MODULE$.INDEX_SUFFIX())) {
                iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
            } else {
                VCFHeader header;
                Tuple2<VCFHeader, VCFCodec> tuple2 = VCFFileFormat$.MODULE$.createVCFCodec((String)path, serializableConf.value());
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                VCFHeader vCFHeader = header = (VCFHeader)tuple2._1();
                VCFHeader header2 = vCFHeader;
                iterable = Option$.MODULE$.option2Iterable((Option)new Some((Object)header2));
            }
            return iterable;
        }, ClassTag$.MODULE$.apply(VCFHeader.class));
    }

    public Seq<VCFHeaderLine> getUniqueHeaderLines(RDD<VCFHeader> headers, boolean getNonSchemaHeaderLines) {
        return Predef$.MODULE$.wrapRefArray((Object[])RDD$.MODULE$.rddToPairRDDFunctions(RDD$.MODULE$.rddToPairRDDFunctions(headers.flatMap((Function1 & Serializable & scala.Serializable)header -> {
            Iterable schemaHeaderLines = (Iterable)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(header.getInfoHeaderLines()).asScala()).$plus$plus((GenTraversableOnce)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(header.getFormatHeaderLines()).asScala(), Iterable$.MODULE$.canBuildFrom());
            Seq nonSchemaHeaderLines = getNonSchemaHeaderLines ? (Seq)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(header.getContigLines()).asScala()).$plus$plus((GenTraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(header.getFilterLines()).asScala(), Buffer$.MODULE$.canBuildFrom()) : (Seq)Seq$.MODULE$.empty();
            return (Iterable)schemaHeaderLines.$plus$plus((GenTraversableOnce)nonSchemaHeaderLines, Iterable$.MODULE$.canBuildFrom());
        }, ClassTag$.MODULE$.apply(VCFHeaderLine.class)).keyBy((Function1 & Serializable & scala.Serializable)line -> new Tuple2((Object)line.getClass().getName(), (Object)((VCFIDHeaderLine)line).getID())), ClassTag$.MODULE$.apply(Tuple2.class), ClassTag$.MODULE$.apply(VCFHeaderLine.class), Ordering$.MODULE$.Tuple2((Ordering)Ordering.String$.MODULE$, (Ordering)Ordering.String$.MODULE$)).reduceByKey((Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            VCFHeaderLine line1;
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null) {
                VCFHeaderLine line12 = (VCFHeaderLine)tuple2._1();
                VCFHeaderLine line2 = (VCFHeaderLine)tuple2._2();
                if (line12 instanceof VCFCompoundHeaderLine) {
                    VCFCompoundHeaderLine vCFCompoundHeaderLine = (VCFCompoundHeaderLine)line12;
                    if (line2 instanceof VCFCompoundHeaderLine) {
                        VCFCompoundHeaderLine vCFCompoundHeaderLine2 = (VCFCompoundHeaderLine)line2;
                        if (!vCFCompoundHeaderLine.equalsExcludingDescription(vCFCompoundHeaderLine2)) throw new IllegalArgumentException(new StringBuilder(43).append("Found incompatible compound header lines: ").append(vCFCompoundHeaderLine).append(" ").append(new StringBuilder(70).append("and ").append(vCFCompoundHeaderLine2).append(". Header lines with the same ID must have the same count and type.").toString()).toString());
                        return vCFCompoundHeaderLine;
                    }
                }
            }
            if (tuple2 != null) {
                VCFHeaderLine line13 = (VCFHeaderLine)tuple2._1();
                VCFHeaderLine line2 = (VCFHeaderLine)tuple2._2();
                if (line13 instanceof VCFContigHeaderLine) {
                    VCFContigHeaderLine vCFContigHeaderLine = (VCFContigHeaderLine)line13;
                    if (line2 instanceof VCFContigHeaderLine) {
                        VCFContigHeaderLine vCFContigHeaderLine2 = (VCFContigHeaderLine)line2;
                        if (vCFContigHeaderLine.getSAMSequenceRecord().getSequenceLength() != vCFContigHeaderLine2.getSAMSequenceRecord().getSequenceLength()) throw new IllegalArgumentException(new StringBuilder(41).append("Found incompatible contig header lines: ").append(vCFContigHeaderLine).append(" ").append(new StringBuilder(62).append("and ").append(vCFContigHeaderLine2).append(". Header lines with the same ID must have the same length.").toString()).toString());
                        return vCFContigHeaderLine;
                    }
                }
            }
            if (tuple2 != null && (line1 = (VCFHeaderLine)tuple2._1()) instanceof VCFFilterHeaderLine) {
                VCFFilterHeaderLine vCFFilterHeaderLine = (VCFFilterHeaderLine)line1;
                if (tuple2._2() instanceof VCFFilterHeaderLine) {
                    return vCFFilterHeaderLine;
                }
            }
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            VCFHeaderLine line14 = (VCFHeaderLine)tuple2._1();
            throw new IllegalArgumentException(new StringBuilder(39).append("Collected unexpected header line type: ").append(line14.getClass().getName()).toString());
        }), ClassTag$.MODULE$.apply(Tuple2.class), ClassTag$.MODULE$.apply(VCFHeaderLine.class), Ordering$.MODULE$.Tuple2((Ordering)Ordering.String$.MODULE$, (Ordering)Ordering.String$.MODULE$)).values().collect());
    }

    public Seq<VCFHeaderLine> readHeaderLines(SparkSession spark, Seq<String> files, boolean getNonSchemaHeaderLines) {
        return this.getUniqueHeaderLines(this.createHeaderRDD(spark, files), getNonSchemaHeaderLines);
    }

    private VCFHeaderUtils$() {
        MODULE$ = this;
        LazyLogging.$init$((LazyLogging)this);
        this.VCF_HEADER_KEY = "vcfHeader";
        this.INFER_HEADER = "infer";
    }
}

