/*
 * Decompiled with CFR 0.152.
 */
package io.projectglow.vcf;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import htsjdk.variant.vcf.VCFHeaderLine;
import io.projectglow.common.GlowLogging;
import io.projectglow.transformers.pipe.InputFormatter;
import io.projectglow.vcf.InternalRowToVariantContextConverter;
import io.projectglow.vcf.SampleIdInfo;
import io.projectglow.vcf.VCFStreamWriter;
import java.io.OutputStream;
import org.apache.spark.sql.catalyst.InternalRow;
import scala.Function1;
import scala.Serializable;
import scala.collection.JavaConverters$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001%4A!\u0004\b\u0001+!A!\u0006\u0001B\u0001B\u0003%1\u0006\u0003\u00050\u0001\t\u0005\t\u0015!\u00031\u0011\u0015\u0019\u0004\u0001\"\u00015\u0011%A\u0004\u00011AA\u0002\u0013%\u0011\bC\u0005>\u0001\u0001\u0007\t\u0019!C\u0005}!IA\t\u0001a\u0001\u0002\u0003\u0006KA\u000f\u0005\n\u000b\u0002\u0001\r\u00111A\u0005\n\u0019C\u0011B\u0014\u0001A\u0002\u0003\u0007I\u0011B(\t\u0013E\u0003\u0001\u0019!A!B\u00139\u0005\"\u0002*\u0001\t\u0003\u001a\u0006\"B+\u0001\t\u00032\u0006\"B4\u0001\t\u0003B'!\u0005,D\r&s\u0007/\u001e;G_Jl\u0017\r\u001e;fe*\u0011q\u0002E\u0001\u0004m\u000e4'BA\t\u0013\u0003-\u0001(o\u001c6fGR<Gn\\<\u000b\u0003M\t!![8\u0004\u0001M!\u0001A\u0006\u000f%!\t9\"$D\u0001\u0019\u0015\u0005I\u0012!B:dC2\f\u0017BA\u000e\u0019\u0005\u0019\te.\u001f*fMB\u0011QDI\u0007\u0002=)\u0011q\u0004I\u0001\u0005a&\u0004XM\u0003\u0002\"!\u0005aAO]1og\u001a|'/\\3sg&\u00111E\b\u0002\u000f\u0013:\u0004X\u000f\u001e$pe6\fG\u000f^3s!\t)\u0003&D\u0001'\u0015\t9\u0003#\u0001\u0004d_6lwN\\\u0005\u0003S\u0019\u00121b\u00127po2{wmZ5oO\u0006I1m\u001c8wKJ$XM\u001d\t\u0003Y5j\u0011AD\u0005\u0003]9\u0011A%\u00138uKJt\u0017\r\u001c*poR{g+\u0019:jC:$8i\u001c8uKb$8i\u001c8wKJ$XM]\u0001\rg\u0006l\u0007\u000f\\3JI&sgm\u001c\t\u0003YEJ!A\r\b\u0003\u0019M\u000bW\u000e\u001d7f\u0013\u0012LeNZ8\u0002\rqJg.\u001b;?)\r)dg\u000e\t\u0003Y\u0001AQAK\u0002A\u0002-BQaL\u0002A\u0002A\naa\u001e:ji\u0016\u0014X#\u0001\u001e\u0011\u00051Z\u0014B\u0001\u001f\u000f\u0005=16IR*ue\u0016\fWn\u0016:ji\u0016\u0014\u0018AC<sSR,'o\u0018\u0013fcR\u0011qH\u0011\t\u0003/\u0001K!!\u0011\r\u0003\tUs\u0017\u000e\u001e\u0005\b\u0007\u0016\t\t\u00111\u0001;\u0003\rAH%M\u0001\boJLG/\u001a:!\u0003\u0019\u0019HO]3b[V\tq\t\u0005\u0002I\u00196\t\u0011J\u0003\u0002\u0014\u0015*\t1*\u0001\u0003kCZ\f\u0017BA'J\u00051yU\u000f\u001e9viN#(/Z1n\u0003)\u0019HO]3b[~#S-\u001d\u000b\u0003\u007fACqa\u0011\u0005\u0002\u0002\u0003\u0007q)A\u0004tiJ,\u0017-\u001c\u0011\u0002\t%t\u0017\u000e\u001e\u000b\u0003\u007fQCQ!\u0012\u0006A\u0002\u001d\u000bQa\u001e:ji\u0016$\"aP,\t\u000ba[\u0001\u0019A-\u0002\rI,7m\u001c:e!\tQV-D\u0001\\\u0015\taV,\u0001\u0005dCR\fG._:u\u0015\tqv,A\u0002tc2T!\u0001Y1\u0002\u000bM\u0004\u0018M]6\u000b\u0005\t\u001c\u0017AB1qC\u000eDWMC\u0001e\u0003\ry'oZ\u0005\u0003Mn\u00131\"\u00138uKJt\u0017\r\u001c*po\u0006)1\r\\8tKR\tq\b")
public class VCFInputFormatter
implements InputFormatter,
GlowLogging {
    private final InternalRowToVariantContextConverter converter;
    private final SampleIdInfo sampleIdInfo;
    private VCFStreamWriter writer;
    private OutputStream stream;
    private Logger logger;
    private volatile boolean bitmap$0;

    private Logger logger$lzycompute() {
        VCFInputFormatter vCFInputFormatter = this;
        synchronized (vCFInputFormatter) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    private VCFStreamWriter writer() {
        return this.writer;
    }

    private void writer_$eq(VCFStreamWriter x$1) {
        this.writer = x$1;
    }

    private OutputStream stream() {
        return this.stream;
    }

    private void stream_$eq(OutputStream x$1) {
        this.stream = x$1;
    }

    @Override
    public void init(OutputStream stream) {
        this.stream_$eq(stream);
        this.writer_$eq(new VCFStreamWriter(stream, (Set<VCFHeaderLine>)((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(this.converter.vcfHeader().getMetaDataInInputOrder()).asScala()).toSet(), this.sampleIdInfo, true));
    }

    @Override
    public void write(InternalRow record) {
        VCFStreamWriter vCFStreamWriter = this.writer();
        this.converter.convert(record).foreach((Function1 & java.io.Serializable & Serializable)vc -> {
            vCFStreamWriter.write(vc);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public void close() {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Closing VCF input formatter");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        this.writer().close();
    }

    public VCFInputFormatter(InternalRowToVariantContextConverter converter, SampleIdInfo sampleIdInfo) {
        this.converter = converter;
        this.sampleIdInfo = sampleIdInfo;
        LazyLogging.$init$((LazyLogging)this);
    }
}

