/*
 * Decompiled with CFR 0.152.
 */
package io.projectglow.vcf;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import htsjdk.samtools.util.Locatable;
import htsjdk.samtools.util.OverlapDetector;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.vcf.VCFCodec;
import io.projectglow.common.GlowLogging;
import io.projectglow.common.SimpleInterval;
import io.projectglow.vcf.AbstractVCFIterator;
import io.projectglow.vcf.TabixIndexHelper$;
import java.util.NoSuchElementException;
import org.apache.hadoop.io.Text;
import scala.Predef$;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001i4Qa\u0004\t\u0001!YA\u0001\"\t\u0001\u0003\u0002\u0003\u0006Ia\t\u0005\ty\u0001\u0011\t\u0011)A\u0005{!Aa\t\u0001B\u0001B\u0003%q\tC\u0003K\u0001\u0011\u00051\nC\u0005Q\u0001\u0001\u0007\t\u0019!C\u0005#\"I\u0001\f\u0001a\u0001\u0002\u0004%I!\u0017\u0005\nA\u0002\u0001\r\u0011!Q!\nICq!\u0019\u0001C\u0002\u0013%!\r\u0003\u0004l\u0001\u0001\u0006Ia\u0019\u0005\u0006Y\u0002!\t%\u001c\u0005\u0006c\u0002!\tE\u001d\u0005\u0006g\u0002!IA\u001d\u0005\u0006i\u0002!I!\u001e\u0005\u0006q\u0002!\t!\u001f\u0002\f-\u000e3\u0015\n^3sCR|'O\u0003\u0002\u0012%\u0005\u0019ao\u00194\u000b\u0005M!\u0012a\u00039s_*,7\r^4m_^T\u0011!F\u0001\u0003S>\u001c2\u0001A\f\u001c!\tA\u0012$D\u0001\u0011\u0013\tQ\u0002CA\nBEN$(/Y2u-\u000e3\u0015\n^3sCR|'\u000f\u0005\u0002\u001d?5\tQD\u0003\u0002\u001f%\u000511m\\7n_:L!\u0001I\u000f\u0003\u0017\u001dcwn\u001e'pO\u001eLgnZ\u0001\u000bY&tWMU3bI\u0016\u00148\u0001\u0001\t\u0004I9\ndBA\u0013,\u001d\t1\u0013&D\u0001(\u0015\tA#%\u0001\u0004=e>|GOP\u0005\u0002U\u0005)1oY1mC&\u0011A&L\u0001\ba\u0006\u001c7.Y4f\u0015\u0005Q\u0013BA\u00181\u0005!IE/\u001a:bi>\u0014(B\u0001\u0017.!\t\u0011$(D\u00014\u0015\t)BG\u0003\u00026m\u00051\u0001.\u00193p_BT!a\u000e\u001d\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005I\u0014aA8sO&\u00111h\r\u0002\u0005)\u0016DH/A\u0003d_\u0012,7\r\u0005\u0002?\t6\tqH\u0003\u0002\u0012\u0001*\u0011\u0011IQ\u0001\bm\u0006\u0014\u0018.\u00198u\u0015\u0005\u0019\u0015A\u00025ug*$7.\u0003\u0002F\u007f\tAak\u0011$D_\u0012,7-\u0001\fgS2$XM]3e'&l\u0007\u000f\\3J]R,'O^1m!\ta\u0002*\u0003\u0002J;\tq1+[7qY\u0016Le\u000e^3sm\u0006d\u0017A\u0002\u001fj]&$h\b\u0006\u0003M\u001b:{\u0005C\u0001\r\u0001\u0011\u0015\tC\u00011\u0001$\u0011\u0015aD\u00011\u0001>\u0011\u00151E\u00011\u0001H\u0003\u0019qW\r\u001f;W\u0007V\t!\u000b\u0005\u0002T-6\tAK\u0003\u0002V\u0001\u0006qa/\u0019:jC:$8m\u001c8uKb$\u0018BA,U\u000591\u0016M]5b]R\u001cuN\u001c;fqR\f!B\\3yiZ\u001bu\fJ3r)\tQf\f\u0005\u0002\\96\tQ&\u0003\u0002^[\t!QK\\5u\u0011\u001dyf!!AA\u0002I\u000b1\u0001\u001f\u00132\u0003\u001dqW\r\u001f;W\u0007\u0002\nqb\u001c<fe2\f\u0007\u000fR3uK\u000e$xN]\u000b\u0002GB\u0019A-[$\u000e\u0003\u0015T!AZ4\u0002\tU$\u0018\u000e\u001c\u0006\u0003Q\n\u000b\u0001b]1ni>|Gn]\u0005\u0003U\u0016\u0014qb\u0014<fe2\f\u0007\u000fR3uK\u000e$xN]\u0001\u0011_Z,'\u000f\\1q\t\u0016$Xm\u0019;pe\u0002\nq\u0001[1t\u001d\u0016DH/F\u0001o!\tYv.\u0003\u0002q[\t9!i\\8mK\u0006t\u0017\u0001\u00028fqR$\u0012AU\u0001\u000bM&tGMT3yiZ\u001b\u0015\u0001C8wKJd\u0017\r]:\u0015\u000594\b\"B<\u000e\u0001\u0004\u0011\u0016A\u0001<d\u0003!9W\r^\"pI\u0016\u001cW#A\u001f")
public class VCFIterator
extends AbstractVCFIterator
implements GlowLogging {
    private final Iterator<Text> lineReader;
    private final VCFCodec codec;
    private final SimpleInterval filteredSimpleInterval;
    private VariantContext nextVC;
    private final OverlapDetector<SimpleInterval> overlapDetector;
    private Logger logger;
    private volatile boolean bitmap$0;

    private Logger logger$lzycompute() {
        VCFIterator vCFIterator = this;
        synchronized (vCFIterator) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    private VariantContext nextVC() {
        return this.nextVC;
    }

    private void nextVC_$eq(VariantContext x$1) {
        this.nextVC = x$1;
    }

    private OverlapDetector<SimpleInterval> overlapDetector() {
        return this.overlapDetector;
    }

    public boolean hasNext() {
        return this.nextVC() != null;
    }

    /*
     * WARNING - void declaration
     */
    public VariantContext next() {
        void var1_1;
        if (this.nextVC() == null) {
            throw new NoSuchElementException("Called next on empty iterator");
        }
        VariantContext retVC = this.nextVC();
        this.nextVC_$eq(this.findNextVC());
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private VariantContext findNextVC() {
        void var1_1;
        VariantContext nextFilteredVC = null;
        while (this.lineReader.hasNext() && nextFilteredVC == null) {
            VariantContext nextUnfilteredVC = this.parseLine(((Text)this.lineReader.next()).toString());
            if (nextUnfilteredVC == null || !this.overlaps(nextUnfilteredVC)) continue;
            nextFilteredVC = nextUnfilteredVC;
        }
        return var1_1;
    }

    private boolean overlaps(VariantContext vc) {
        boolean bl;
        if (this.filteredSimpleInterval.getContig().isEmpty()) {
            bl = true;
        } else {
            SimpleInterval vcInterval = new SimpleInterval(vc.getContig(), vc.getStart(), vc.getEnd());
            bl = this.overlapDetector().overlapsAny((Locatable)vcInterval);
        }
        return bl;
    }

    public VCFCodec getCodec() {
        return this.codec;
    }

    public VCFIterator(Iterator<Text> lineReader, VCFCodec codec, SimpleInterval filteredSimpleInterval) {
        this.lineReader = lineReader;
        this.codec = codec;
        this.filteredSimpleInterval = filteredSimpleInterval;
        super(codec);
        LazyLogging.$init$((LazyLogging)this);
        this.overlapDetector = (OverlapDetector)TabixIndexHelper$.MODULE$.toOverlapDetector(filteredSimpleInterval).orNull(Predef$.MODULE$.$conforms());
        this.nextVC_$eq(this.findNextVC());
    }
}

