/*
 * Decompiled with CFR 0.152.
 */
package io.projectglow.vcf;

import htsjdk.variant.vcf.VCFCompoundHeaderLine;
import htsjdk.variant.vcf.VCFFormatHeaderLine;
import htsjdk.variant.vcf.VCFHeader;
import htsjdk.variant.vcf.VCFHeaderLine;
import htsjdk.variant.vcf.VCFHeaderLineCount;
import htsjdk.variant.vcf.VCFHeaderLineType;
import htsjdk.variant.vcf.VCFInfoHeaderLine;
import io.projectglow.common.GenotypeFields$;
import io.projectglow.common.VariantSchemas$;
import io.projectglow.vcf.AnnotationUtils$;
import io.projectglow.vcf.VCFRowHeaderLines$;
import java.io.Serializable;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.MapType$;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.MetadataBuilder;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

public final class VCFSchemaInferrer$ {
    public static VCFSchemaInferrer$ MODULE$;
    private final Map<String, Function1<String, Seq<DataType>>> particularSchemas;
    private final String VCF_HEADER_COUNT_KEY;
    private final String VCF_HEADER_DESCRIPTION_KEY;

    static {
        new VCFSchemaInferrer$();
    }

    public StructField getInfoFieldStruct(VCFInfoHeaderLine headerLine) {
        String x$1 = new StringBuilder(0).append(VariantSchemas$.MODULE$.infoFieldPrefix()).append(headerLine.getID()).toString();
        DataType x$2 = (DataType)this.typesForHeader((VCFCompoundHeaderLine)headerLine).head();
        Metadata x$3 = this.metadataForLine((VCFCompoundHeaderLine)headerLine);
        boolean x$4 = StructField$.MODULE$.apply$default$3();
        return new StructField(x$1, x$2, x$4, x$3);
    }

    public StructType inferSchema(boolean includeSampleIds, boolean flattenInfoFields, Seq<VCFInfoHeaderLine> infoHeaders, Seq<VCFFormatHeaderLine> formatHeaders) {
        Seq<VCFInfoHeaderLine> validatedInfoHeaders = this.validateHeaders(infoHeaders);
        StructType withInfoFields = flattenInfoFields ? (StructType)validatedInfoHeaders.foldLeft((Object)VariantSchemas$.MODULE$.vcfBaseSchema(), (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            StructType schema = (StructType)tuple2._1();
            VCFInfoHeaderLine line = (VCFInfoHeaderLine)tuple2._2();
            StructField field = MODULE$.getInfoFieldStruct(line);
            StructType structType = schema.add(field);
            return structType;
        }) : VariantSchemas$.MODULE$.vcfBaseSchema().add(new StructField("attributes", (DataType)MapType$.MODULE$.apply((DataType)StringType$.MODULE$, (DataType)StringType$.MODULE$), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()));
        StructType genotypeStruct = this.inferGenotypeSchema(includeSampleIds, formatHeaders);
        return withInfoFields.add(new StructField("genotypes", (DataType)ArrayType$.MODULE$.apply((DataType)genotypeStruct), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()));
    }

    public StructType inferGenotypeSchema(boolean includeSampleIds, Seq<VCFFormatHeaderLine> formatHeaders) {
        ObjectRef genotypeStruct = ObjectRef.create((Object)StructType$.MODULE$.apply((Seq)Seq$.MODULE$.empty()));
        if (includeSampleIds) {
            genotypeStruct.elem = ((StructType)genotypeStruct.elem).add(VariantSchemas$.MODULE$.sampleIdField());
        }
        Seq<VCFFormatHeaderLine> validatedFormatHeaders = this.validateHeaders(formatHeaders);
        validatedFormatHeaders.foreach((Function1 & Serializable & scala.Serializable)line -> {
            VCFSchemaInferrer$.$anonfun$inferGenotypeSchema$1(genotypeStruct, line);
            return BoxedUnit.UNIT;
        });
        return (StructType)genotypeStruct.elem;
    }

    public StructType inferSchema(boolean includeSampleIds, boolean flattenInfoFields, VCFHeader header) {
        return this.inferSchema(includeSampleIds, flattenInfoFields, (Seq<VCFInfoHeaderLine>)((TraversableOnce)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(header.getInfoHeaderLines()).asScala()).toSeq(), (Seq<VCFFormatHeaderLine>)((TraversableOnce)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(header.getFormatHeaderLines()).asScala()).toSeq());
    }

    public Seq<VCFHeaderLine> headerLinesFromSchema(StructType schema) {
        Seq seq;
        Seq infoLines = (Seq)((TraversableLike)schema.filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)VCFSchemaInferrer$.$anonfun$headerLinesFromSchema$1(x$1)))).map((Function1 & Serializable & scala.Serializable)field -> {
            String name = new StringOps(Predef$.MODULE$.augmentString(field.name())).stripPrefix(VariantSchemas$.MODULE$.infoFieldPrefix());
            VCFHeaderLineType vcfType = MODULE$.vcfDataType(field.dataType());
            Tuple2<VCFHeaderLineCount, Option<Object>> tuple2 = MODULE$.vcfHeaderLineCount((StructField)field);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            VCFHeaderLineCount countType = (VCFHeaderLineCount)tuple2._1();
            Option count = (Option)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)countType, (Object)count);
            Tuple2 tuple23 = tuple22;
            VCFHeaderLineCount countType2 = (VCFHeaderLineCount)tuple23._1();
            Option count2 = (Option)tuple23._2();
            String description = MODULE$.vcfHeaderLineDescription((StructField)field);
            return MODULE$.makeHeaderLine(name, vcfType, countType2, (Option<Object>)count2, description, false);
        }, Seq$.MODULE$.canBuildFrom());
        if (schema.exists((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)VCFSchemaInferrer$.$anonfun$headerLinesFromSchema$3(x$3)))) {
            StructType gSchema = (StructType)((ArrayType)((StructField)schema.find((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)VCFSchemaInferrer$.$anonfun$headerLinesFromSchema$4(x$4))).get()).dataType()).elementType();
            seq = (Seq)((SeqLike)gSchema.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Iterable iterable;
                StructField structField = x0$1;
                if (((SetLike)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{VariantSchemas$.MODULE$.otherFieldsField().name(), VariantSchemas$.MODULE$.sampleIdField().name()}))).contains((Object)structField.name())) {
                    iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                } else if (MODULE$.getSpecialHeaderLine(structField.name()).isDefined()) {
                    iterable = Option$.MODULE$.option2Iterable(MODULE$.getSpecialHeaderLine(structField.name()));
                } else {
                    String name = (String)GenotypeFields$.MODULE$.reverseAliases().getOrElse((Object)structField.name(), (Function0 & Serializable & scala.Serializable)() -> structField.name());
                    VCFHeaderLineType vcfType = MODULE$.vcfDataType(structField.dataType());
                    Tuple2<VCFHeaderLineCount, Option<Object>> tuple2 = MODULE$.vcfHeaderLineCount(structField);
                    if (tuple2 == null) {
                        throw new MatchError(tuple2);
                    }
                    VCFHeaderLineCount countType = (VCFHeaderLineCount)tuple2._1();
                    Option count = (Option)tuple2._2();
                    Tuple2 tuple22 = new Tuple2((Object)countType, (Object)count);
                    Tuple2 tuple23 = tuple22;
                    VCFHeaderLineCount countType2 = (VCFHeaderLineCount)tuple23._1();
                    Option count2 = (Option)tuple23._2();
                    String description = MODULE$.vcfHeaderLineDescription(structField);
                    iterable = Option$.MODULE$.option2Iterable((Option)new Some((Object)MODULE$.makeHeaderLine(name, vcfType, countType2, (Option<Object>)count2, description, true)));
                }
                return iterable;
            }, Seq$.MODULE$.canBuildFrom())).distinct();
        } else {
            seq = (Seq)Seq$.MODULE$.empty();
        }
        Seq formatLines = seq;
        return (Seq)infoLines.$plus$plus((GenTraversableOnce)formatLines, Seq$.MODULE$.canBuildFrom());
    }

    public Seq<DataType> typesForHeader(VCFCompoundHeaderLine line) {
        StringType$ stringType$;
        if (this.particularSchemas().contains((Object)line.getID())) {
            return (Seq)((Function1)this.particularSchemas().apply((Object)line.getID())).apply((Object)line.getDescription());
        }
        VCFHeaderLineType vCFHeaderLineType = line.getType();
        if (VCFHeaderLineType.Character.equals(vCFHeaderLineType)) {
            stringType$ = StringType$.MODULE$;
        } else if (VCFHeaderLineType.String.equals(vCFHeaderLineType)) {
            stringType$ = StringType$.MODULE$;
        } else if (VCFHeaderLineType.Float.equals(vCFHeaderLineType)) {
            stringType$ = DoubleType$.MODULE$;
        } else if (VCFHeaderLineType.Integer.equals(vCFHeaderLineType)) {
            stringType$ = IntegerType$.MODULE$;
        } else if (VCFHeaderLineType.Flag.equals(vCFHeaderLineType)) {
            stringType$ = BooleanType$.MODULE$;
        } else {
            throw new MatchError((Object)vCFHeaderLineType);
        }
        StringType$ primitiveType = stringType$;
        return line.isFixedCount() && line.getCount() <= 1 ? (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AtomicType[]{primitiveType})) : (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ArrayType[]{ArrayType$.MODULE$.apply((DataType)primitiveType)}));
    }

    private Option<VCFHeaderLine> getSpecialHeaderLine(String fieldName) {
        return ((SetLike)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{VariantSchemas$.MODULE$.callsField().name(), VariantSchemas$.MODULE$.phasedField().name()}))).contains((Object)fieldName) ? new Some((Object)VCFRowHeaderLines$.MODULE$.genotype()) : None$.MODULE$;
    }

    private VCFHeaderLineType vcfDataType(DataType dt) {
        VCFHeaderLineType vCFHeaderLineType;
        block7: {
            DataType dataType;
            while (true) {
                DataType innerType;
                boolean bl = false;
                ArrayType arrayType = null;
                dataType = dt;
                if (StringType$.MODULE$.equals(dataType)) {
                    vCFHeaderLineType = VCFHeaderLineType.String;
                    break block7;
                }
                if (DoubleType$.MODULE$.equals(dataType)) {
                    vCFHeaderLineType = VCFHeaderLineType.Float;
                    break block7;
                }
                if (IntegerType$.MODULE$.equals(dataType)) {
                    vCFHeaderLineType = VCFHeaderLineType.Integer;
                    break block7;
                }
                if (BooleanType$.MODULE$.equals(dataType)) {
                    vCFHeaderLineType = VCFHeaderLineType.Flag;
                    break block7;
                }
                if (dataType instanceof ArrayType) {
                    bl = true;
                    arrayType = (ArrayType)dataType;
                    if (arrayType.elementType() instanceof StructType) {
                        vCFHeaderLineType = VCFHeaderLineType.String;
                        break block7;
                    }
                }
                if (!bl) break;
                dt = innerType = arrayType.elementType();
            }
            throw new MatchError((Object)dataType);
        }
        return vCFHeaderLineType;
    }

    private Tuple2<VCFHeaderLineCount, Option<Object>> vcfHeaderLineCount(StructField field) {
        Tuple2 tuple2;
        if (field.metadata().contains(this.VCF_HEADER_COUNT_KEY())) {
            String countStr = field.metadata().getString(this.VCF_HEADER_COUNT_KEY());
            tuple2 = NumberUtils.isDigits((String)countStr) ? new Tuple2((Object)VCFHeaderLineCount.INTEGER, (Object)new Some((Object)BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(countStr)).toInt()))) : new Tuple2((Object)VCFHeaderLineCount.valueOf((String)field.metadata().getString(this.VCF_HEADER_COUNT_KEY())), (Object)None$.MODULE$);
        } else if (field.dataType() instanceof ArrayType) {
            tuple2 = new Tuple2((Object)VCFHeaderLineCount.UNBOUNDED, (Object)None$.MODULE$);
        } else {
            DataType dataType = field.dataType();
            BooleanType$ booleanType$ = BooleanType$.MODULE$;
            tuple2 = !(dataType != null ? !dataType.equals(booleanType$) : booleanType$ != null) ? new Tuple2((Object)VCFHeaderLineCount.INTEGER, (Object)new Some((Object)BoxesRunTime.boxToInteger((int)0))) : new Tuple2((Object)VCFHeaderLineCount.INTEGER, (Object)new Some((Object)BoxesRunTime.boxToInteger((int)1)));
        }
        return tuple2;
    }

    private String vcfHeaderLineDescription(StructField field) {
        return field.metadata().contains(this.VCF_HEADER_DESCRIPTION_KEY()) ? field.metadata().getString(this.VCF_HEADER_DESCRIPTION_KEY()) : "";
    }

    private Metadata metadataForLine(VCFCompoundHeaderLine line) {
        VCFHeaderLineCount vCFHeaderLineCount = line.getCountType();
        VCFHeaderLineCount vCFHeaderLineCount2 = VCFHeaderLineCount.INTEGER;
        String numberStr = !(vCFHeaderLineCount != null ? !vCFHeaderLineCount.equals(vCFHeaderLineCount2) : vCFHeaderLineCount2 != null) ? ((Object)BoxesRunTime.boxToInteger((int)line.getCount())).toString() : line.getCountType().name();
        return new MetadataBuilder().putString(this.VCF_HEADER_COUNT_KEY(), numberStr).putString(this.VCF_HEADER_DESCRIPTION_KEY(), line.getDescription()).build();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private VCFCompoundHeaderLine makeHeaderLine(String name, VCFHeaderLineType vcfType, VCFHeaderLineCount countType, Option<Object> count, String description, boolean isFormat) {
        Tuple2 tuple2 = new Tuple2((Object)countType, (Object)BoxesRunTime.boxToBoolean((boolean)isFormat));
        if (tuple2 != null) {
            VCFHeaderLineCount vCFHeaderLineCount = (VCFHeaderLineCount)tuple2._1();
            boolean bl = tuple2._2$mcZ$sp();
            if (VCFHeaderLineCount.INTEGER.equals(vCFHeaderLineCount) && bl) {
                return new VCFFormatHeaderLine(name, BoxesRunTime.unboxToInt((Object)count.get()), vcfType, description);
            }
        }
        if (tuple2 != null) {
            VCFHeaderLineCount vCFHeaderLineCount = (VCFHeaderLineCount)tuple2._1();
            boolean bl = tuple2._2$mcZ$sp();
            if (VCFHeaderLineCount.INTEGER.equals(vCFHeaderLineCount) && !bl) {
                return new VCFInfoHeaderLine(name, BoxesRunTime.unboxToInt((Object)count.get()), vcfType, description);
            }
        }
        if (tuple2 != null) {
            VCFHeaderLineCount cntType = (VCFHeaderLineCount)tuple2._1();
            boolean bl = tuple2._2$mcZ$sp();
            if (bl) {
                return new VCFFormatHeaderLine(name, cntType, vcfType, description);
            }
        }
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        VCFHeaderLineCount cntType = (VCFHeaderLineCount)tuple2._1();
        boolean bl = tuple2._2$mcZ$sp();
        if (false != bl) throw new MatchError((Object)tuple2);
        return new VCFInfoHeaderLine(name, cntType, vcfType, description);
    }

    private <A extends VCFCompoundHeaderLine> Seq<A> validateHeaders(Seq<A> headers) {
        return ((TraversableOnce)headers.groupBy((Function1 & Serializable & scala.Serializable)line -> line.getID()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Seq lines;
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String id = (String)tuple2._1();
                lines = (Seq)tuple2._2();
                if (!((IterableLike)lines.tail()).forall((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)x$6.equalsExcludingDescription((VCFCompoundHeaderLine)lines.head())))) {
                    throw new IllegalArgumentException(new StringBuilder(46).append("VCF headers with id ").append(id).append(" have incompatible schemas").toString());
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
            VCFCompoundHeaderLine vCFCompoundHeaderLine = (VCFCompoundHeaderLine)lines.head();
            return vCFCompoundHeaderLine;
        }, Iterable$.MODULE$.canBuildFrom())).toSeq();
    }

    private Seq<DataType> getGtSchema(String description) {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DataType[]{VariantSchemas$.MODULE$.phasedField().dataType(), VariantSchemas$.MODULE$.callsField().dataType()}));
    }

    private Seq<DataType> getAnnotationSchema(String description) {
        String[] fieldNames = ((String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])description.split(":"))).last()).replace("'", "").split(AnnotationUtils$.MODULE$.annotationDelimiterRegex());
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ArrayType[]{ArrayType$.MODULE$.apply((DataType)new StructType((StructField[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fieldNames)).map((Function1 & Serializable & scala.Serializable)f -> {
            String safeFieldName = f.replace(" ", "").replace(".", "_");
            DataType dataType = (DataType)AnnotationUtils$.MODULE$.allFieldsToSchema().apply((Object)safeFieldName);
            return new StructField(safeFieldName, dataType, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class)))))}));
    }

    private Map<String, Function1<String, Seq<DataType>>> particularSchemas() {
        return this.particularSchemas;
    }

    public String VCF_HEADER_COUNT_KEY() {
        return this.VCF_HEADER_COUNT_KEY;
    }

    public String VCF_HEADER_DESCRIPTION_KEY() {
        return this.VCF_HEADER_DESCRIPTION_KEY;
    }

    public static final /* synthetic */ void $anonfun$inferGenotypeSchema$4(ObjectRef genotypeStruct$1, Metadata metadata$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String n = (String)tuple2._1();
        DataType t = (DataType)tuple2._2();
        String x$1 = n;
        DataType x$2 = t;
        Metadata x$3 = metadata$1;
        boolean x$4 = StructField$.MODULE$.apply$default$3();
        genotypeStruct$1.elem = ((StructType)genotypeStruct$1.elem).add(new StructField(x$1, x$2, x$4, x$3));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$inferGenotypeSchema$1(ObjectRef genotypeStruct$1, VCFFormatHeaderLine line) {
        Seq names = (Seq)GenotypeFields$.MODULE$.aliases().getOrElse((Object)line.getID(), (Function0 & Serializable & scala.Serializable)() -> (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{line.getID()})));
        Seq<DataType> types = MODULE$.typesForHeader((VCFCompoundHeaderLine)line);
        Predef$.MODULE$.require(names.size() == types.size(), (Function0 & Serializable & scala.Serializable)() -> "Must have same number of header line struct names and types");
        Metadata metadata = MODULE$.metadataForLine((VCFCompoundHeaderLine)line);
        ((IterableLike)names.zip(types, Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            VCFSchemaInferrer$.$anonfun$inferGenotypeSchema$4(genotypeStruct$1, metadata, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$headerLinesFromSchema$1(StructField x$1) {
        return x$1.name().startsWith(VariantSchemas$.MODULE$.infoFieldPrefix());
    }

    public static final /* synthetic */ boolean $anonfun$headerLinesFromSchema$3(StructField x$3) {
        String string = x$3.name();
        String string2 = VariantSchemas$.MODULE$.genotypesFieldName();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$headerLinesFromSchema$4(StructField x$4) {
        String string = x$4.name();
        String string2 = VariantSchemas$.MODULE$.genotypesFieldName();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private VCFSchemaInferrer$() {
        MODULE$ = this;
        this.particularSchemas = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"GT"), (Function1 & Serializable & scala.Serializable)description -> MODULE$.getGtSchema((String)description)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"CSQ"), (Function1 & Serializable & scala.Serializable)description -> MODULE$.getAnnotationSchema((String)description)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ANN"), (Function1 & Serializable & scala.Serializable)description -> MODULE$.getAnnotationSchema((String)description))}));
        this.VCF_HEADER_COUNT_KEY = "vcf_header_count";
        this.VCF_HEADER_DESCRIPTION_KEY = "vcf_header_description";
    }
}

