/*
 * Decompiled with CFR 0.152.
 */
package io.projectglow.vcf;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import htsjdk.variant.variantcontext.Genotype;
import htsjdk.variant.variantcontext.GenotypeBuilder;
import htsjdk.variant.variantcontext.GenotypesContext;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.VariantContextBuilder;
import htsjdk.variant.variantcontext.writer.Options;
import htsjdk.variant.variantcontext.writer.VariantContextWriter;
import htsjdk.variant.variantcontext.writer.VariantContextWriterBuilder;
import htsjdk.variant.vcf.VCFHeader;
import htsjdk.variant.vcf.VCFHeaderLine;
import io.projectglow.common.GlowLogging;
import io.projectglow.vcf.InferSampleIds$;
import io.projectglow.vcf.SampleIdInfo;
import io.projectglow.vcf.SampleIds;
import io.projectglow.vcf.VCFWriterUtils$;
import java.io.Closeable;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import scala.Function1;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005%c\u0001\u0002\f\u0018\u0001yA\u0001\u0002\u000f\u0001\u0003\u0002\u0003\u0006I!\u000f\u0005\ty\u0001\u0011\t\u0011)A\u0005{!A\u0011\u000b\u0001B\u0001B\u0003%!\u000b\u0003\u0005W\u0001\t\u0005\t\u0015!\u0003X\u0011\u0015Q\u0006\u0001\"\u0001\\\u0011%\t\u0007\u00011AA\u0002\u0013\u0005!\rC\u0005g\u0001\u0001\u0007\t\u0019!C\u0001O\"IQ\u000e\u0001a\u0001\u0002\u0003\u0006Ka\u0019\u0005\n]\u0002\u0001\r\u00111A\u0005\u0002=D\u0011\"\u001f\u0001A\u0002\u0003\u0007I\u0011\u0001>\t\u0013q\u0004\u0001\u0019!A!B\u0013\u0001\b\"C?\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u007f\u0011)y\b\u00011AA\u0002\u0013\u0005\u0011\u0011\u0001\u0005\u000b\u0003\u000b\u0001\u0001\u0019!A!B\u00139\u0006\"CA\u0004\u0001\t\u0007I\u0011BA\u0005\u0011!\tI\u0002\u0001Q\u0001\n\u0005-\u0001bBA\u000e\u0001\u0011\u0005\u0011Q\u0004\u0005\b\u0003W\u0001A\u0011AA\u0017\u0011\u001d\t\t\u0004\u0001C\u0001\u0003gAq!a\u000e\u0001\t\u0003\tI\u0004C\u0004\u0002F\u0001!\t%a\u0012\u0003\u001fY\u001bei\u0015;sK\u0006lwK]5uKJT!\u0001G\r\u0002\u0007Y\u001cgM\u0003\u0002\u001b7\u0005Y\u0001O]8kK\u000e$x\r\\8x\u0015\u0005a\u0012AA5p\u0007\u0001\u0019R\u0001A\u0010(YI\u0002\"\u0001I\u0013\u000e\u0003\u0005R!AI\u0012\u0002\t1\fgn\u001a\u0006\u0002I\u0005!!.\u0019<b\u0013\t1\u0013E\u0001\u0004PE*,7\r\u001e\t\u0003Q)j\u0011!\u000b\u0006\u00039\rJ!aK\u0015\u0003\u0013\rcwn]3bE2,\u0007CA\u00171\u001b\u0005q#BA\u0018\u001a\u0003\u0019\u0019w.\\7p]&\u0011\u0011G\f\u0002\f\u000f2|w\u000fT8hO&tw\r\u0005\u00024m5\tAGC\u00016\u0003\u0015\u00198-\u00197b\u0013\t9DG\u0001\u0007TKJL\u0017\r\\5{C\ndW-\u0001\u0004tiJ,\u0017-\u001c\t\u0003QiJ!aO\u0015\u0003\u0019=+H\u000f];u'R\u0014X-Y7\u0002\u001b!,\u0017\rZ3s\u0019&tWmU3u!\rqT\t\u0013\b\u0003\u007f\r\u0003\"\u0001\u0011\u001b\u000e\u0003\u0005S!AQ\u000f\u0002\rq\u0012xn\u001c;?\u0013\t!E'\u0001\u0004Qe\u0016$WMZ\u0005\u0003\r\u001e\u00131aU3u\u0015\t!E\u0007\u0005\u0002J\u001f6\t!J\u0003\u0002\u0019\u0017*\u0011A*T\u0001\bm\u0006\u0014\u0018.\u00198u\u0015\u0005q\u0015A\u00025ug*$7.\u0003\u0002Q\u0015\niak\u0011$IK\u0006$WM\u001d'j]\u0016\fAb]1na2,\u0017\nZ%oM>\u0004\"a\u0015+\u000e\u0003]I!!V\f\u0003\u0019M\u000bW\u000e\u001d7f\u0013\u0012LeNZ8\u0002\u0017]\u0014\u0018\u000e^3IK\u0006$WM\u001d\t\u0003gaK!!\u0017\u001b\u0003\u000f\t{w\u000e\\3b]\u00061A(\u001b8jiz\"R\u0001X/_?\u0002\u0004\"a\u0015\u0001\t\u000ba*\u0001\u0019A\u001d\t\u000bq*\u0001\u0019A\u001f\t\u000bE+\u0001\u0019\u0001*\t\u000bY+\u0001\u0019A,\u0002\r!,\u0017\rZ3s+\u0005\u0019\u0007CA%e\u0013\t)'JA\u0005W\u0007\u001aCU-\u00193fe\u0006Q\u0001.Z1eKJ|F%Z9\u0015\u0005!\\\u0007CA\u001aj\u0013\tQGG\u0001\u0003V]&$\bb\u00027\b\u0003\u0003\u0005\raY\u0001\u0004q\u0012\n\u0014a\u00025fC\u0012,'\u000fI\u0001\u0010Q\u0016\fG-\u001a:TC6\u0004H.Z*fiV\t\u0001\u000fE\u0002riZl\u0011A\u001d\u0006\u0003g\u000e\nA!\u001e;jY&\u0011QO\u001d\u0002\b\u0011\u0006\u001c\bnU3u!\tqt/\u0003\u0002y\u000f\n11\u000b\u001e:j]\u001e\f1\u0003[3bI\u0016\u00148+Y7qY\u0016\u001cV\r^0%KF$\"\u0001[>\t\u000f1T\u0011\u0011!a\u0001a\u0006\u0001\u0002.Z1eKJ\u001c\u0016-\u001c9mKN+G\u000fI\u0001\u0011e\u0016\u0004H.Y2f'\u0006l\u0007\u000f\\3JIN,\u0012aV\u0001\u0015e\u0016\u0004H.Y2f'\u0006l\u0007\u000f\\3JIN|F%Z9\u0015\u0007!\f\u0019\u0001C\u0004m\u001b\u0005\u0005\t\u0019A,\u0002#I,\u0007\u000f\\1dKN\u000bW\u000e\u001d7f\u0013\u0012\u001c\b%\u0001\u0004xe&$XM]\u000b\u0003\u0003\u0017\u0001B!!\u0004\u0002\u00165\u0011\u0011q\u0002\u0006\u0005\u0003\u000f\t\tBC\u0002\u0002\u0014-\u000baB^1sS\u0006tGoY8oi\u0016DH/\u0003\u0003\u0002\u0018\u0005=!\u0001\u0006,be&\fg\u000e^\"p]R,\u0007\u0010^,sSR,'/A\u0004xe&$XM\u001d\u0011\u0002\u0013M,G\u000fS3bI\u0016\u0014Hc\u00015\u0002 !9\u0011\u0011E\tA\u0002\u0005\r\u0012!\u0003<d\u0005VLG\u000eZ3s!\u0011\t)#a\n\u000e\u0005\u0005E\u0011\u0002BA\u0015\u0003#\u0011QCV1sS\u0006tGoQ8oi\u0016DHOQ;jY\u0012,'/A\fsKBd\u0017mY3NSN\u001c\u0018N\\4TC6\u0004H.Z%egR!\u00111EA\u0018\u0011\u001d\t\tC\u0005a\u0001\u0003G\tac\u00195fG.LeNZ3se\u0016$7+Y7qY\u0016LEm\u001d\u000b\u0005\u0003G\t)\u0004C\u0004\u0002\"M\u0001\r!a\t\u0002\u000b]\u0014\u0018\u000e^3\u0015\u0007!\fY\u0004C\u0004\u0002>Q\u0001\r!a\u0010\u0002\u0005Y\u001c\u0007\u0003BA\u0013\u0003\u0003JA!a\u0011\u0002\u0012\tqa+\u0019:jC:$8i\u001c8uKb$\u0018!B2m_N,G#\u00015")
public class VCFStreamWriter
implements Closeable,
GlowLogging,
scala.Serializable {
    private final scala.collection.immutable.Set<VCFHeaderLine> headerLineSet;
    private final SampleIdInfo sampleIdInfo;
    private final boolean writeHeader;
    private VCFHeader header;
    private HashSet<String> headerSampleSet;
    private boolean replaceSampleIds;
    private final VariantContextWriter writer;
    private Logger logger;
    private volatile boolean bitmap$0;

    private Logger logger$lzycompute() {
        VCFStreamWriter vCFStreamWriter = this;
        synchronized (vCFStreamWriter) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    public VCFHeader header() {
        return this.header;
    }

    public void header_$eq(VCFHeader x$1) {
        this.header = x$1;
    }

    public HashSet<String> headerSampleSet() {
        return this.headerSampleSet;
    }

    public void headerSampleSet_$eq(HashSet<String> x$1) {
        this.headerSampleSet = x$1;
    }

    public boolean replaceSampleIds() {
        return this.replaceSampleIds;
    }

    public void replaceSampleIds_$eq(boolean x$1) {
        this.replaceSampleIds = x$1;
    }

    private VariantContextWriter writer() {
        return this.writer;
    }

    public void setHeader(VariantContextBuilder vcBuilder) {
        Seq seq;
        SampleIdInfo sampleIdInfo = this.sampleIdInfo;
        InferSampleIds$ inferSampleIds$ = InferSampleIds$.MODULE$;
        if (!(sampleIdInfo != null ? !sampleIdInfo.equals(inferSampleIds$) : inferSampleIds$ != null)) {
            Buffer vcSamples = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter((List)vcBuilder.getGenotypes()).asScala()).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getSampleName(), Buffer$.MODULE$.canBuildFrom());
            int numTotalSamples = vcSamples.length();
            int numPresentSamples = vcSamples.count((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)VCFStreamWriter.$anonfun$setHeader$2(x$2)));
            if (numPresentSamples > 0) {
                if (numPresentSamples < numTotalSamples) {
                    VCFWriterUtils$.MODULE$.throwMixedSamplesFailure();
                }
                this.replaceSampleIds_$eq(false);
                seq = (Seq)vcSamples.sorted((Ordering)Ordering.String$.MODULE$);
            } else {
                this.replaceSampleIds_$eq(true);
                seq = InferSampleIds$.MODULE$.fromNumberMissing(numTotalSamples);
            }
        } else {
            this.replaceSampleIds_$eq(false);
            seq = ((SampleIds)this.sampleIdInfo).sortedSampleIds();
        }
        Seq sampleIds = seq;
        List javaSampleIds = (List)JavaConverters$.MODULE$.seqAsJavaListConverter(sampleIds).asJava();
        this.headerSampleSet_$eq(new HashSet<String>(javaSampleIds));
        this.header_$eq(new VCFHeader((Set)JavaConverters$.MODULE$.setAsJavaSetConverter(this.headerLineSet).asJava(), javaSampleIds));
    }

    public VariantContextBuilder replaceMissingSampleIds(VariantContextBuilder vcBuilder) {
        GenotypesContext oldGts = vcBuilder.getGenotypes();
        ArrayList<Genotype> newGts = new ArrayList<Genotype>(oldGts.size());
        for (int i = 0; i < oldGts.size(); ++i) {
            Genotype oldGt = oldGts.get(i);
            Genotype newGt = oldGt.getSampleName().isEmpty() && i < this.header().getGenotypeSamples().size() ? new GenotypeBuilder(oldGt).name((String)this.header().getGenotypeSamples().get(i)).make() : oldGt;
            newGts.add(newGt);
        }
        return vcBuilder.genotypes(newGts);
    }

    public VariantContextBuilder checkInferredSampleIds(VariantContextBuilder vcBuilder) {
        block0: {
            if (((Object)vcBuilder.getGenotypes().getSampleNames()).equals(this.headerSampleSet())) break block0;
            VCFWriterUtils$.MODULE$.throwSampleInferenceFailure();
        }
        return vcBuilder;
    }

    public void write(VariantContext vc) {
        VariantContextBuilder vcBuilder = VCFWriterUtils$.MODULE$.convertVcAttributesToStrings(vc);
        if (this.header() == null) {
            this.setHeader(vcBuilder);
            if (this.writeHeader) {
                this.writer().writeHeader(this.header());
            } else {
                this.writer().setHeader(this.header());
            }
        }
        VariantContextBuilder replacedVcBuilder = this.replaceSampleIds() ? this.replaceMissingSampleIds(vcBuilder) : vcBuilder;
        SampleIdInfo sampleIdInfo = this.sampleIdInfo;
        InferSampleIds$ inferSampleIds$ = InferSampleIds$.MODULE$;
        VariantContextBuilder checkedVcBuilder = !(sampleIdInfo != null ? !sampleIdInfo.equals(inferSampleIds$) : inferSampleIds$ != null) ? this.checkInferredSampleIds(replacedVcBuilder) : replacedVcBuilder;
        this.writer().add(checkedVcBuilder.make());
    }

    @Override
    public void close() {
        block5: {
            if (this.header() == null && this.writeHeader) {
                SampleIdInfo sampleIdInfo = this.sampleIdInfo;
                InferSampleIds$ inferSampleIds$ = InferSampleIds$.MODULE$;
                if (!(sampleIdInfo != null ? !sampleIdInfo.equals(inferSampleIds$) : inferSampleIds$ != null)) {
                    throw new IllegalStateException("Cannot infer header for empty partition; we suggest calling coalesce or repartition to remove empty partitions.");
                }
                Seq<String> sampleIds = ((SampleIds)this.sampleIdInfo).sortedSampleIds();
                this.header_$eq(new VCFHeader((Set)JavaConverters$.MODULE$.setAsJavaSetConverter(this.headerLineSet).asJava(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter(sampleIds).asJava()));
                this.writer().writeHeader(this.header());
            }
            try {
                this.writer().close();
            }
            catch (Throwable e) {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isWarnEnabled()) {
                    this.logger().underlying().warn(new StringBuilder(24).append("Could not close writer: ").append(e.getMessage()).toString());
                    boxedUnit = BoxedUnit.UNIT;
                    break block5;
                }
                boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$setHeader$2(String x$2) {
        return !x$2.isEmpty();
    }

    public VCFStreamWriter(OutputStream stream, scala.collection.immutable.Set<VCFHeaderLine> headerLineSet, SampleIdInfo sampleIdInfo, boolean writeHeader) {
        this.headerLineSet = headerLineSet;
        this.sampleIdInfo = sampleIdInfo;
        this.writeHeader = writeHeader;
        LazyLogging.$init$((LazyLogging)this);
        this.writer = new VariantContextWriterBuilder().clearOptions().setOutputStream(stream).setOption(Options.ALLOW_MISSING_FIELDS_IN_HEADER).setOption(Options.WRITE_FULL_FORMAT_FIELD).build();
    }
}

