/*
 * Decompiled with CFR 0.152.
 */
package io.projectglow.vcf;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.VariantContextBuilder;
import io.projectglow.common.GlowLogging;
import io.projectglow.vcf.InferSampleIds$;
import io.projectglow.vcf.SampleIdInfo;
import io.projectglow.vcf.SampleIds;
import io.projectglow.vcf.VariantContextToInternalRowConverter$;
import java.io.Serializable;
import java.util.Map;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class VCFWriterUtils$
implements GlowLogging {
    public static VCFWriterUtils$ MODULE$;
    private Logger logger;
    private volatile boolean bitmap$0;

    static {
        new VCFWriterUtils$();
    }

    private Logger logger$lzycompute() {
        VCFWriterUtils$ vCFWriterUtils$ = this;
        synchronized (vCFWriterUtils$) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    public void throwMixedSamplesFailure() {
        throw new IllegalArgumentException("Cannot mix missing and non-missing sample IDs.");
    }

    public void throwSampleInferenceFailure() {
        throw new IllegalArgumentException("Cannot infer sample ids because they are not the same in every row.");
    }

    public SampleIdInfo inferSampleIdsIfPresent(Dataset<Row> data) {
        BoxedUnit boxedUnit;
        String[] distinctSampleIds;
        int numPresentSampleIds;
        Option genotypeSchemaOpt = data.schema().find((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)VCFWriterUtils$.$anonfun$inferSampleIdsIfPresent$1(x$1))).map((Function1 & Serializable & scala.Serializable)x$2 -> (StructType)((ArrayType)x$2.dataType()).elementType());
        if (genotypeSchemaOpt.isEmpty()) {
            BoxedUnit boxedUnit2;
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("No genotypes column, no sample IDs will be inferred.");
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            return new SampleIds((Seq<String>)((Seq)Seq$.MODULE$.empty()));
        }
        StructType genotypeSchema = (StructType)genotypeSchemaOpt.get();
        boolean hasSampleIdsColumn = genotypeSchema.exists((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)VCFWriterUtils$.$anonfun$inferSampleIdsIfPresent$3(x$3)));
        if (hasSampleIdsColumn && (numPresentSampleIds = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])(distinctSampleIds = (String[])data.selectExpr((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"explode(genotypes.sampleId)"})).distinct().as(data.sparkSession().implicits().newStringEncoder()).collect()))).count((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)VCFWriterUtils$.$anonfun$inferSampleIdsIfPresent$4(x$4)))) > 0) {
            if (numPresentSampleIds < distinctSampleIds.length) {
                this.throwMixedSamplesFailure();
            }
            return new SampleIds((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])distinctSampleIds));
        }
        int[] numGenotypesPerRow = (int[])data.selectExpr((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"size(genotypes)"})).distinct().as(data.sparkSession().implicits().newIntEncoder()).collect();
        if (numGenotypesPerRow.length > 1) {
            throw new IllegalArgumentException("Rows contain varying number of missing samples; cannot infer sample IDs.");
        }
        if (this.logger().underlying().isWarnEnabled()) {
            this.logger().underlying().warn("Detected missing sample IDs, inferring sample IDs.");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return InferSampleIds$.MODULE$;
    }

    public boolean sampleIsMissing(String s) {
        return s == null || s.isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    public VariantContextBuilder convertVcAttributesToStrings(VariantContext vc) {
        void var2_2;
        VariantContextBuilder vcBuilder = new VariantContextBuilder(vc);
        for (Map.Entry entry : vc.getAttributes().entrySet()) {
            vcBuilder.attribute((String)entry.getKey(), (Object)VariantContextToInternalRowConverter$.MODULE$.parseObjectAsString(entry.getValue()));
        }
        return var2_2;
    }

    public static final /* synthetic */ boolean $anonfun$inferSampleIdsIfPresent$1(StructField x$1) {
        String string = x$1.name();
        String string2 = "genotypes";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$inferSampleIdsIfPresent$3(StructField x$3) {
        String string = x$3.name();
        String string2 = "sampleId";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$inferSampleIdsIfPresent$4(String x$4) {
        return !MODULE$.sampleIsMissing(x$4);
    }

    private VCFWriterUtils$() {
        MODULE$ = this;
        LazyLogging.$init$((LazyLogging)this);
    }
}

