/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql;

import java.io.Serializable;
import org.apache.spark.TaskContext;
import org.apache.spark.TaskContext$;
import org.apache.spark.ml.linalg.MatrixUDT;
import org.apache.spark.ml.linalg.VectorUDT;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSessionExtensions;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.AnyDataType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class SQLUtils$ {
    public static SQLUtils$ MODULE$;

    static {
        new SQLUtils$();
    }

    public void verifyHasFields(StructType schema, Seq<StructField> fields) {
        fields.foreach((Function1 & Serializable & scala.Serializable)field -> {
            SQLUtils$.$anonfun$verifyHasFields$1(schema, field);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean structFieldsEqualExceptNullability(StructField f1, StructField f2) {
        String string = f1.name();
        String string2 = f2.name();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        DataType dataType = f1.dataType().asNullable();
        DataType dataType2 = f2.dataType().asNullable();
        if (dataType == null) {
            if (dataType2 == null) return true;
            return false;
        } else {
            if (!dataType.equals(dataType2)) return false;
            return true;
        }
    }

    public boolean dataTypesEqualExceptNullability(DataType dt1, DataType dt2) {
        DataType dataType = dt1.asNullable();
        DataType dataType2 = dt2.asNullable();
        return !(dataType != null ? !dataType.equals(dataType2) : dataType2 != null);
    }

    public Dataset<Row> internalCreateDataFrame(SparkSession sess, RDD<InternalRow> catalystRows, StructType schema, boolean isStreaming) {
        return sess.internalCreateDataFrame(catalystRows, schema, isStreaming);
    }

    public void setTaskContext(TaskContext context) {
        TaskContext$.MODULE$.setTaskContext(context);
    }

    public MatrixUDT newMatrixUDT() {
        return new MatrixUDT();
    }

    public VectorUDT newVectorUDT() {
        return new VectorUDT();
    }

    public AnalysisException newAnalysisException(String msg) {
        return new AnalysisException(msg, AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public AbstractDataType anyDataType() {
        return AnyDataType$.MODULE$;
    }

    public SparkSessionExtensions getSessionExtensions(SparkSession session) {
        return session.extensions();
    }

    public RDD<InternalRow> createEmptyRDD(SparkSession sess, int numPartitions) {
        return sess.sparkContext().parallelize((Seq)Seq$.MODULE$.empty(), numPartitions, ClassTag$.MODULE$.apply(InternalRow.class));
    }

    public int createEmptyRDD$default$2() {
        return 1;
    }

    public static final /* synthetic */ boolean $anonfun$verifyHasFields$2(StructField field$1, StructField x$1) {
        String string = x$1.name();
        String string2 = field$1.name();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$verifyHasFields$1(StructType schema$1, StructField field) {
        StructField[] candidateFields = (StructField[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])schema$1.fields())).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)SQLUtils$.$anonfun$verifyHasFields$2(field, x$1)));
        if (candidateFields.length != 1) {
            throw new IllegalArgumentException(new StringBuilder(62).append("Schema must have exactly one field called ").append(field.name()).append(". Current schema is ").append(schema$1).toString());
        }
        StructField schemaField = (StructField)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])candidateFields)).head();
        if (!MODULE$.structFieldsEqualExceptNullability(schemaField, field)) {
            throw new IllegalArgumentException(new StringBuilder(25).append("Schema must have a field ").append(field).toString());
        }
    }

    private SQLUtils$() {
        MODULE$ = this;
    }
}

