/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.csv;

import java.io.Serializable;
import org.apache.spark.SparkException;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.GenericInternalRow;
import org.apache.spark.sql.catalyst.util.BadRecordException;
import org.apache.spark.sql.catalyst.util.DropMalformedMode$;
import org.apache.spark.sql.catalyst.util.FailFastMode$;
import org.apache.spark.sql.catalyst.util.ParseMode;
import org.apache.spark.sql.catalyst.util.PermissiveMode$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;

@ScalaSignature(bytes="\u0006\u0001\u0005Eb\u0001B\t\u0013\u0001\u0005B\u0001\"\u000b\u0001\u0003\u0002\u0003\u0006IA\u000b\u0005\t\u0015\u0002\u0011\t\u0011)A\u0005\u0017\"A\u0011\u000b\u0001B\u0001B\u0003%!\u000b\u0003\u0005Y\u0001\t\u0005\t\u0015!\u0003Z\u0011\u0015\t\u0007\u0001\"\u0001c\u0011\u001dI\u0007A1A\u0005\n)Da!\u001d\u0001!\u0002\u0013Y\u0007b\u0002:\u0001\u0005\u0004%Ia\u001d\u0005\u0007i\u0002\u0001\u000b\u0011\u0002*\t\u000fU\u0004!\u0019!C\u0005m\"1Q\u0010\u0001Q\u0001\n]DqA \u0001C\u0002\u0013%a\u000f\u0003\u0004\u0000\u0001\u0001\u0006Ia\u001e\u0005\n\u0003\u0003\u0001!\u0019!C\u0005\u0003\u0007A\u0001\"!\t\u0001A\u0003%\u0011Q\u0001\u0005\b\u0003G\u0001A\u0011AA\u0013\u0005ai\u0015N\\5nC24\u0015-\u001b7ve\u0016\u001c\u0016MZ3QCJ\u001cXM\u001d\u0006\u0003'Q\t1aY:w\u0015\t)b#A\u0006eCR\f7o\\;sG\u0016\u001c(BA\f\u0019\u0003%)\u00070Z2vi&|gN\u0003\u0002\u001a5\u0005\u00191/\u001d7\u000b\u0005ma\u0012!B:qCJ\\'BA\u000f\u001f\u0003\u0019\t\u0007/Y2iK*\tq$A\u0002pe\u001e\u001c\u0001!\u0006\u0002#_M\u0011\u0001a\t\t\u0003I\u001dj\u0011!\n\u0006\u0002M\u0005)1oY1mC&\u0011\u0001&\n\u0002\u0007\u0003:L(+\u001a4\u0002\u0013I\fw\u000fU1sg\u0016\u0014\b\u0003\u0002\u0013,[aJ!\u0001L\u0013\u0003\u0013\u0019+hn\u0019;j_:\f\u0004C\u0001\u00180\u0019\u0001!Q\u0001\r\u0001C\u0002E\u0012!!\u0013(\u0012\u0005I*\u0004C\u0001\u00134\u0013\t!TEA\u0004O_RD\u0017N\\4\u0011\u0005\u00112\u0014BA\u001c&\u0005\r\te.\u001f\t\u0004s\u0005#eB\u0001\u001e@\u001d\tYd(D\u0001=\u0015\ti\u0004%\u0001\u0004=e>|GOP\u0005\u0002M%\u0011\u0001)J\u0001\ba\u0006\u001c7.Y4f\u0013\t\u00115IA\u0002TKFT!\u0001Q\u0013\u0011\u0005\u0015CU\"\u0001$\u000b\u0005\u001dC\u0012\u0001C2bi\u0006d\u0017p\u001d;\n\u0005%3%aC%oi\u0016\u0014h.\u00197S_^\fA!\\8eKB\u0011AjT\u0007\u0002\u001b*\u0011aJR\u0001\u0005kRLG.\u0003\u0002Q\u001b\nI\u0001+\u0019:tK6{G-Z\u0001\u0007g\u000eDW-\\1\u0011\u0005M3V\"\u0001+\u000b\u0005UC\u0012!\u0002;za\u0016\u001c\u0018BA,U\u0005)\u0019FO];diRK\b/Z\u0001\u001aG>dW/\u001c8OC6,wJZ\"peJ,\b\u000f\u001e*fG>\u0014H\r\u0005\u0002[=:\u00111\f\u0018\t\u0003w\u0015J!!X\u0013\u0002\rA\u0013X\rZ3g\u0013\ty\u0006M\u0001\u0004TiJLgn\u001a\u0006\u0003;\u0016\na\u0001P5oSRtD#B2fM\u001eD\u0007c\u00013\u0001[5\t!\u0003C\u0003*\u000b\u0001\u0007!\u0006C\u0003K\u000b\u0001\u00071\nC\u0003R\u000b\u0001\u0007!\u000bC\u0003Y\u000b\u0001\u0007\u0011,A\td_J\u0014X\u000f\u001d;GS\u0016dG-\u00138eKb,\u0012a\u001b\t\u0004I1t\u0017BA7&\u0005\u0019y\u0005\u000f^5p]B\u0011Ae\\\u0005\u0003a\u0016\u00121!\u00138u\u0003I\u0019wN\u001d:vaR4\u0015.\u001a7e\u0013:$W\r\u001f\u0011\u0002\u0019\u0005\u001cG/^1m'\u000eDW-\\1\u0016\u0003I\u000bQ\"Y2uk\u0006d7k\u00195f[\u0006\u0004\u0013!\u0003:fgVdGOU8x+\u00059\bC\u0001=|\u001b\u0005I(B\u0001>G\u0003-)\u0007\u0010\u001d:fgNLwN\\:\n\u0005qL(AE$f]\u0016\u0014\u0018nY%oi\u0016\u0014h.\u00197S_^\f!B]3tk2$(k\\<!\u0003)qW\u000f\u001c7SKN,H\u000e^\u0001\f]VdGNU3tk2$\b%A\u0006u_J+7/\u001e7u%><XCAA\u0003!!!\u0013qAA\u0006\u0003\u001b!\u0015bAA\u0005K\tIa)\u001e8di&|gN\r\t\u0004I1$\u0005#\u0002\u0013\u0002\u0010\u0005M\u0011bAA\tK\tIa)\u001e8di&|g\u000e\r\t\u0005\u0003+\ti\"\u0004\u0002\u0002\u0018)\u0019Q+!\u0007\u000b\u0007\u0005m!$\u0001\u0004v]N\fg-Z\u0005\u0005\u0003?\t9B\u0001\u0006V)\u001aC4\u000b\u001e:j]\u001e\fA\u0002^8SKN,H\u000e\u001e*po\u0002\nQ\u0001]1sg\u0016$B!a\n\u0002.A!\u0011(!\u000bE\u0013\r\tYc\u0011\u0002\t\u0013R,'/\u0019;pe\"1\u0011q\u0006\tA\u00025\nQ!\u001b8qkR\u0004")
public class MinimalFailureSafeParser<IN> {
    private final Function1<IN, Seq<InternalRow>> rawParser;
    private final ParseMode mode;
    private final StructType schema;
    private final String columnNameOfCorruptRecord;
    private final Option<Object> corruptFieldIndex;
    private final StructType actualSchema;
    private final GenericInternalRow resultRow;
    private final GenericInternalRow nullResult;
    private final Function2<Option<InternalRow>, Function0<UTF8String>, InternalRow> toResultRow;

    private Option<Object> corruptFieldIndex() {
        return this.corruptFieldIndex;
    }

    private StructType actualSchema() {
        return this.actualSchema;
    }

    private GenericInternalRow resultRow() {
        return this.resultRow;
    }

    private GenericInternalRow nullResult() {
        return this.nullResult;
    }

    private Function2<Option<InternalRow>, Function0<UTF8String>, InternalRow> toResultRow() {
        return this.toResultRow;
    }

    public Iterator<InternalRow> parse(IN input) {
        Iterator iterator;
        try {
            iterator = ((IterableLike)this.rawParser.apply(input)).toIterator().map((Function1 & Serializable & scala.Serializable)row -> (InternalRow)this.toResultRow().apply((Object)new Some(row), (Function0 & Serializable & scala.Serializable)() -> null));
        }
        catch (BadRecordException e) {
            Iterator iterator2;
            ParseMode parseMode = this.mode;
            if (PermissiveMode$.MODULE$.equals(parseMode)) {
                iterator2 = package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new InternalRow[]{(InternalRow)this.toResultRow().apply(e.partialResult().apply(), (Object)e.record())}));
            } else if (DropMalformedMode$.MODULE$.equals(parseMode)) {
                iterator2 = package$.MODULE$.Iterator().empty();
            } else {
                if (FailFastMode$.MODULE$.equals(parseMode)) {
                    throw new SparkException(new StringBuilder(50).append("Malformed records are detected in record parsing. ").append(new StringBuilder(13).append("Parse Mode: ").append(FailFastMode$.MODULE$.name()).append(".").toString()).toString(), e.cause());
                }
                throw new MatchError((Object)parseMode);
            }
            iterator = iterator2;
        }
        return iterator;
    }

    public static final /* synthetic */ boolean $anonfun$actualSchema$1(MinimalFailureSafeParser $this, StructField x$3) {
        String string = x$3.name();
        String string2 = $this.columnNameOfCorruptRecord;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public MinimalFailureSafeParser(Function1<IN, Seq<InternalRow>> rawParser, ParseMode mode, StructType schema, String columnNameOfCorruptRecord) {
        this.rawParser = rawParser;
        this.mode = mode;
        this.schema = schema;
        this.columnNameOfCorruptRecord = columnNameOfCorruptRecord;
        this.corruptFieldIndex = schema.getFieldIndex(columnNameOfCorruptRecord);
        this.actualSchema = StructType$.MODULE$.apply((Seq)schema.filterNot((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)MinimalFailureSafeParser.$anonfun$actualSchema$1(this, x$3))));
        this.resultRow = new GenericInternalRow(schema.length());
        this.nullResult = new GenericInternalRow(schema.length());
        this.toResultRow = this.corruptFieldIndex().isDefined() ? (Function2 & Serializable & scala.Serializable)(row, badRecord) -> {
            IntRef i = IntRef.create((int)0);
            while (i.elem < this.actualSchema().length()) {
                StructField from = this.actualSchema().apply(i.elem);
                this.resultRow().update($this.schema.fieldIndex(from.name()), row.map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.get(i$1.elem, from.dataType())).orNull(Predef$.MODULE$.$conforms()));
                ++i.elem;
            }
            this.resultRow().update(BoxesRunTime.unboxToInt((Object)this.corruptFieldIndex().get()), badRecord.apply());
            return this.resultRow();
        } : (Function2 & Serializable & scala.Serializable)(row, x$5) -> (InternalRow)row.getOrElse((Function0 & Serializable & scala.Serializable)() -> this.nullResult());
    }
}

