/*
 * Decompiled with CFR 0.152.
 */
package reactor.kafka.sender;

import java.util.function.Function;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.kafka.sender.SenderOptions;
import reactor.kafka.sender.SenderRecord;
import reactor.kafka.sender.SenderResult;
import reactor.kafka.sender.internals.KafkaSender;
import reactor.kafka.sender.internals.ProducerFactory;

public interface Sender<K, V> {
    public static <K, V> Sender<K, V> create(SenderOptions<K, V> options) {
        return new KafkaSender<K, V>(ProducerFactory.INSTANCE, options);
    }

    public <T> Flux<SenderResult<T>> send(Publisher<SenderRecord<K, V, T>> var1, boolean var2);

    public Mono<Void> send(Publisher<ProducerRecord<K, V>> var1);

    public <T> Mono<T> doOnProducer(Function<Producer<K, V>, ? extends T> var1);

    public void close();
}

